unit Dlistdb;

interface

uses WinTypes, WinProcs, Classes, Graphics, Forms, Controls, Buttons,
  StdCtrls;

type
  TdlgSelectDB = class(TForm)
    cmdOK: TBitBtn;
    cmdCancel: TBitBtn;
    lstDbList: TListBox;
    procedure FormCreate(Sender: TObject);
    procedure cmdOKClick(Sender: TObject);
    procedure lstDbListDblClick(Sender: TObject);
    procedure cmdCancelClick(Sender: TObject);
    procedure FormActivate(Sender: TObject);
  private
    { Private declarations }
    FModified: Boolean;
    FSelection: integer;
    procedure SetSelection(Value: integer);
  public
    { Public declarations }
    procedure Init(Value: TStrings);
    property Modified: Boolean read FModified;
    property Selection: integer read FSelection write setSelection;
  end;

var
  dlgSelectDB: TdlgSelectDB;

implementation

{$R *.DFM}

procedure TdlgSelectDB.Init(Value: TStrings);
begin
  lstDbList.Items.Assign(Value);
end;

procedure TdlgSelectDB.setSelection(Value: integer);
begin
  FSelection := Value;
  lstDBList.ItemIndex := FSelection;
end;

procedure TdlgSelectDB.FormCreate(Sender: TObject);
begin
  FSelection := -1;
end;

procedure TdlgSelectDB.cmdOKClick(Sender: TObject);
begin
  FSelection := lstDbList.ItemIndex;
  FModified := true;
  close;
end;

procedure TdlgSelectDB.lstDbListDblClick(Sender: TObject);
begin
  cmdOKClick(Sender);
end;

procedure TdlgSelectDB.cmdCancelClick(Sender: TObject);
begin
  close;
end;

procedure TdlgSelectDB.FormActivate(Sender: TObject);
begin
  FModified := False;
end;

end.
