
(*
   (c) 1993,94 Arbor Software Corporation. All Rights Reserved.
   Unpublished -- rights reserved under the copyright laws of the United
   States.  USE OF A COPYRIGHT NOTICE IS PRECAUTIONARY ONLY AND DOES NOT
   IMPLY PUBLICATION OR DISCLOSURE.

   This software is distributed as an example only, and is not warrantied
   in any way by Arbor Software Corporation.  Use (whole or partial) of
   this software is at the sole discretion and liability of the user.  Arbor
   Software disclaims all liability (express or implied) in connection with
   the use of this example.

                           RESTRICTED RIGHTS LEGEND
   Use, duplication, or disclosure by the Government is subject to restrictions
   as set forth in subparagraph (c)(1)(ii) of the Rights in Technical Data and
   Computer Software clause at DFARS 252.227-7013.


                          Arbor Software Corporation
                   3211 Scott Blvd., Santa Clara, CA 95054
*)



      {*********************************************************\
      *                                                         *
      *   ESSAPI.H - Essbase API Header Include File.           *
      *                                                         *
      *   Copyright (C) 1993,94 Arbor Software Corporation.     *
      *   All Rights Reserved.                                  *
      *                                                         *
      *   for Essbase Release 3.0                               *
      *                                                         *
      \*********************************************************}

      {*********************************************************\
      *                                                         *
      *   ESSAPI32.PAS - Encapsulation of ESSBASE.H for use       *
      *                With Delphi 2.x                          *
      *                                                         *
      *   Copyright  1997 Decision Support Technology, Inc.    *
      *   All rights reserved.                                  *
      *                                                         *
      *   Written by Dick Chase                                 *
      *                                                         *
      *   Last Modified:                                        *
      *      2/5/97 - initial development                      *
      *                                                         *
      \*********************************************************}

unit Essapi32;

interface


(********************** API CONSTANT DEFINITIONS *********************)

const

(*
   General Constants
*)


  ESS_API_VERSION     =   $00040000;   { Essbase API Version 4.0 }

  ESS_TRUE            =    1;       (* Boolean TRUE *)
  ESS_FALSE           =    0;       (* Boolean FALSE *)

  ESS_NULL            =   nil;    (* NULL pointer *)

  ESS_INVALID_HINST   =   nil;    (* Invalid instance handle *)
  ESS_INVALID_HCTX    =   nil;    (* Invalid context handle *)


(*
   Maximum String Lengths (Including Terminating Null)
*)
{subtracting 1 from original in essapi.h. original includes space for
null terminator, but pascal adds space for terminator in dealing with
pstrings}
  ESS_USERNAMELEN        = 30{31};      (* Max length of a user/group name *)
  ESS_PASSWORDLEN        = 100{101};     (* Max length of a password string *)
  ESS_SVRNAMELEN         = 30{31};      (* Max length of a server name *)
  ESS_APPNAMELEN         = 8{9};       (* Max length of an application name *)
  ESS_DBNAMELEN          = 8{9};       (* Max length of a database name *)
  ESS_OBJNAMELEN         = 8{9};       (* Max length of a file object name *)
  ESS_MBRNAMELEN         = 80 {81};      (* Max length of a member name *)
  ESS_FTRNAMELEN         = 30{31};      (* Max length of a filter name *)
  ESS_ALIASNAMELEN       = 30{31};      (* Max length of an alias table name *)
  ESS_PATHLEN            = 120{121};     (* Max length of a path name *)
  ESS_LINELEN            = 255{256};     (* Max length of a report line *)
  ESS_DESCLEN            = 79{80};      (* Max length of an application or
                                            database description *)

(*
   Function Return Status Constant
*)

  ESS_STS_NOERR          = 0;       (* API function normal return value *)
  ESS_STS_CANCEL         = 1;       (* operation cancelled return value *)
  ESS_STS_OBSOLETE       = 2;       (* operation obsolete (esscmd)*)


(*
   Constants for Error Level -
   used by Level argument in message handling callback function.
*)

  ESS_LEVEL_INFO         = 2;       (* Message is for information only *)
  ESS_LEVEL_WARNING      = 3;       (* Warning message *)
  ESS_LEVEL_ERROR        = 4;       (* Error message *)
  ESS_LEVEL_SERIOUS      = 7;       (* Serious error message *)
  ESS_LEVEL_FATAL        = 8;       (* Fatal error message *)


(*
   Option Flags for EssAutoLogin Function.
*)

  AUTO_DEFAULT           = 0;       (* Default option *)
  AUTO_NODIALOG          = 1;       (* Don't display login dialog *)
  AUTO_NOSELECT          = 2;       (* Don't allow selection of app/db *)

(*
   Options for data level on export
*)

  ESS_DATA_ALL           = 1;       (* All data *)
  ESS_DATA_LEVEL0        = 2;       (* Blocks with level 0 data *)
  ESS_DATA_INPUT         = 3;       (* Blocks marked as input blocks *)


(*
   Options for Local/Remote File Loading -
   Used by Location Argument to Various File Functions.
*)

  ESS_FILE_CLIENT        = 0;       (* Flag to indicate local file *)
  ESS_FILE_SERVER        = 1;       (* Flag to indicate remote file *)


(*
   Constants for User/Group Type Flag -
   Used for Type field in ESS_USERINFO_T and ESS_GROUPINFO_T structures.
*)

  ESS_TYPE_NONE          = 0;       (* Not a valid user/group *)
  ESS_TYPE_USER          = 1;       (* User *)
  ESS_TYPE_GROUP         = 2;       (* Group *)


(*
   Constants for Database Type -
   Used by EssCreateDatabase function.
*)

  ESS_DBTYPE_NORMAL      = 0;       (* normal database *)
  ESS_DBTYPE_CURRENCY    = 1;       (* currency database *)


(*
   Constants for Object Type -
   Used by Object Functions.
*)

  ESS_OBJTYPE_NONE        = $00000000;  (* Not an Object *)
  ESS_OBJTYPE_OUTLINE     = $00000001;  (* Outline File Object *)
  ESS_OBJTYPE_CALCSCRIPT  = $00000002;  (* Calc Script File Object *)
  ESS_OBJTYPE_REPORT      = $00000004;  (* Report Specification File Object *)
  ESS_OBJTYPE_RULES       = $00000008;  (* Rules File Object *)
  ESS_OBJTYPE_ALIAS       = $00000010;  (* Alias File Object *)
  ESS_OBJTYPE_STRUCTURE   = $00000020;  (* Structure File Object *)
  ESS_OBJTYPE_ASCBACKUP   = $00000040;  (* ASCII Backup File Data Object *)
  ESS_OBJTYPE_BINBACKUP   = $00000080;  (* Binary Backup File Data Object *)
  ESS_OBJTYPE_EXCEL       = $00000100;  (* Excel Worksheet File Data Object *)
  ESS_OBJTYPE_LOTUS2      = $00000200;  (* 1-2-3 2.x Worksheet File Object *)
  ESS_OBJTYPE_LOTUS3      = $00000400;  (* 1-2-3 3.x Worksheet File Object *)
  ESS_OBJTYPE_TEXT        = $00000800;  (* Text File Data Object *)

  ESS_OBJTYPE_LOTUS4      = $00008000;  (* 1-2-3 4.x Worksheet File Object *)

  ESS_OBJTYPE_WIZARD      = $00010000;

  ESS_OBJTYPE_MAX         = $00020000;  (* maximum single object type value *)


   (* combined object types *)

  ESS_OBJTYPE_BACKUP      = ESS_OBJTYPE_ASCBACKUP +
                                ESS_OBJTYPE_BINBACKUP;

  ESS_OBJTYPE_WORKSHEET   = ESS_OBJTYPE_EXCEL +
                                ESS_OBJTYPE_LOTUS2 +
                                ESS_OBJTYPE_LOTUS3 +
                                ESS_OBJTYPE_LOTUS4;

  ESS_OBJTYPE_DATA        = ESS_OBJTYPE_BACKUP +
                                ESS_OBJTYPE_WORKSHEET +
                                ESS_OBJTYPE_TEXT;

  ESS_OBJTYPE_ALL         = (2 * ESS_OBJTYPE_MAX) - 1;


(*
   Security Access Levels & Privileges
   (for variables of type ESS_ACCESS_T).
*)

  ESS_PRIV_NONE           = $0000;  (* no privilege *)
  ESS_PRIV_READ           = $0001;  (* read data *)
  ESS_PRIV_WRITE          = $0002;  (* write data *)
  ESS_PRIV_CALC           = $0004;  (* calculate data *)
  ESS_PRIV_DBLOAD         = $0010;  (* load/unload databases *)
  ESS_PRIV_DBDESIGN       = $0020;  (* design databases *)
  ESS_PRIV_DBCREATE       = $0040;  (* create/delete/edit databases *)
  ESS_PRIV_APPLOAD        = $0100;  (* load/unload applications *)
  ESS_PRIV_APPDESIGN      = $0200;  (* design applications *)
  ESS_PRIV_APPCREATE      = $0400;  (* create/delete/edit applications *)
  ESS_PRIV_USERCREATE     = $1000;  (* create/delete/edit users *)

   (* Predefined Security Access Levels *)

  ESS_ACCESS_NONE         = ESS_PRIV_NONE;
  ESS_ACCESS_READ         = ESS_PRIV_READ + ESS_PRIV_APPLOAD +
                                   ESS_PRIV_DBLOAD;
  ESS_ACCESS_WRITE        = ESS_PRIV_WRITE + ESS_ACCESS_READ;
  ESS_ACCESS_CALC         = ESS_PRIV_CALC + ESS_ACCESS_WRITE;
  ESS_ACCESS_DBDESIGN     = ESS_PRIV_DBDESIGN + ESS_ACCESS_CALC;
  ESS_ACCESS_DBCREATE     = ESS_PRIV_DBCREATE + ESS_ACCESS_DBDESIGN;
  ESS_ACCESS_APPDESIGN    = ESS_PRIV_APPDESIGN + ESS_ACCESS_DBCREATE;
  ESS_ACCESS_APPCREATE    = ESS_PRIV_APPCREATE + ESS_ACCESS_APPDESIGN;

  ESS_ACCESS_DBALL        = $00ff;  (* full database access *)
  ESS_ACCESS_APPALL       = $0fff;  (* full application/database access *)
  ESS_ACCESS_SUPER        = $ffff;  (* supervisor (unrestricted access) *)


(*
   Constants for State Field of Process State Structure
   (ESS_PROCSTATE_T).
*)

  ESS_STATE_DONE          = 0;       (* No process, or process complete *)
  ESS_STATE_INPROGRESS    = 1;       (* Async process is in progress *)
  ESS_STATE_FINALSTAGE    = 5;       (* Process at final stage,
                                           no cancel allowed *)


(*
   Constants for DbReqType field of Database Request Info Structure
   (ESS_DBREQINFO_T).
*)

  ESS_DBREQTYPE_DATLOAD   = 0;      (* Data load *)
  ESS_DBREQTYPE_CALC      = 1;      (* Calculation *)
  ESS_DBREQTYPE_OTLUPD    = 2;      (* Outline update *)


(*
   Constants for DbReqFlags bit field of Database Request Info Structure
   (ESS_DBREQINFO_T).
*)

  ESS_DBREQFLAG_CALCDEF   = $00000001;   (* Used default calc script *)
  ESS_DBREQFLAG_CALCSCR   = $00000002;   (* Used custom calc script *)

(*
   Constants for Status field of Application/Database Info
   Structures (ESS_APPINFO_T & ESS_DBINFO_T).
*)

  ESS_STATUS_NOTLOADED    = 0;       (* Application/database not loaded *)
  ESS_STATUS_LOADING      = 1;       (* Application/database is loading *)
  ESS_STATUS_LOADED       = 2;       (* Application/database loaded *)
  ESS_STATUS_UNLOADING    = 3;       (* Application/database is unloading *)


(*
   Constants for Data field of Database Info Structure
   (ESS_DBINFO_T).
*)

  ESS_DBDATA_NONE         = 0;       (* database has no data *)
  ESS_DBDATA_LOADNOCALC   = 1;       (* data loaded without calc *)
  ESS_DBDATA_CLEAN        = 2;       (* data is calculated *)


(*
   Number of elements for DbReqInfoAry field of Database Info Structure
   (ESS_DBINFO_T).
*)

  ESS_DBREQNUM            = 3;
(*
   Constants for IndexType field of Database Statistics Structure
   (ESS_DBSTATS_T).
*)

  ESS_INDEXTYPE_ARRAY     = 0;
  ESS_INDEXTYPE_AVL       = 1;


(*
   Constants for UnaryCalc field of the Member Information
   Structure (ESS_MBRINFO_T).
*)

  ESS_UCALC_ADD           = 0;
  ESS_UCALC_SUB           = 1;
  ESS_UCALC_MULT          = 2;
  ESS_UCALC_DIV           = 3;
  ESS_UCALC_PERCENT       = 4;
  ESS_UCALC_NOOP          = 5;


(*
   TagType - No tag value.
*)

  ESS_TTYPE_NONE          = 0;
  ESS_TTYPE_CCATEGORY     = 1;       (* Accounts - currency category tag *)
  ESS_TTYPE_CNAME         = 2;       (* Country  - currency name tag *)
  ESS_TTYPE_CTIME         = 3;       (* Time - currency TIME tag *)
  ESS_TTYPE_CTYPE         = 4;       (* Type - currency TYPE tag *)
  ESS_TTYPE_CPARTITION    = 5;       (* Currency Partition tag *)


(*
   Constants for Status Field of Member Information Structure.
   (ESS_MBRINFO_T)
*)

  ESS_MBRSTS_NOTSET   = 0;       (* Normal member *)
  ESS_MBRSTS_NEVER    = $0001;  (* Never allow sharing of data *)
  ESS_MBRSTS_LABEL    = $0002;  (* Label only - never has any data *)
  ESS_MBRSTS_REFER    = $0004;  (* Member refers to another member with
                                       the same name *)
  ESS_MBRSTS_REFNME   = $0008;  (* Member refers to another member with
                                       a different name *)
  ESS_MBRSTS_SHARE    = $0010;  (* Single parent-child case (implicit
                                       share) *)
  ESS_MBRSTS_REFERRED = $8000;  (* Member declared as actual member and *)
                                    (* has been referred by other refer     *)
                                    (* shared member *)
                                    (* Notes:                               *)
                                    (*   This high order bit will be set    *)
                                    (*   whenever a member referred by other*)
                                    (*   members.                           *)

(*
   Constants for MbrTagType field of Member Information Structure.

   Notes:
        The high 2 bits are used for masking data value for operations:
        BALFIRST, BALLAST, PERCENT, AVERAGE (these operations are mutually
        exclusive)
*)

  ESS_ATYPE_MASKNON       = $0000;  (* don't mask on zero/missing values *)
  ESS_ATYPE_MASKMISSG     = $4000;  (* mask on missing value *)
  ESS_ATYPE_MASKZERO      = $8000;  (* mask on zero value *)
  ESS_ATYPE_MASKBOTH      = $C000;  (* mask on both zero/missing values *)
  ESS_ATYPE_BALFIRST      = $0001;  (* Account type - Balance FIRST *)
  ESS_ATYPE_BALLAST       = $0002;  (* Balance LAST *)
  ESS_ATYPE_PERCENT       = $0004;  (* Two Pass Calc (old define) *)
  ESS_ATYPE_TWOPASS       = $0004;  (* Two Pass Calc *)
  ESS_ATYPE_AVERAGE       = $0008;  (* Average *)
  ESS_ATYPE_UNITS         = $0010;  (* Unit *)
  ESS_ATYPE_DETAILONLY    = $0020;  (* Details Only *)
  ESS_ATYPE_EXPENSE       = $0040;  (* Expense *)


(*
   Constants for Database State Structure (ESS_DBSTATE_T).
*)

  ESS_DIMTYPE_DENSE       = 0;       (* Dense dimension type *)
  ESS_DIMTYPE_SPARSE      = 1;       (* Sparse dimension type *)

  ESS_CRCTYPE_DIV         = 0;       (* cval=(val*ForeignRate)/LocalRate *)
  ESS_CRCTYPE_MULT        = 1;       (* cval=(val*LocalRate)/ForeignRate *)

  ESS_CRDB_MAXDIMNUM      = 4;       (* Maximum dimension number for a *)
                                        (* currency database *)

(*
   Minimum and maximum page sizes
 *)
  ESS_INDEXPAGEMIN_SIZE   = 1024;    (* Minimal index page size   *)
  ESS_INDEXPAGEMAX_SIZE   = 8192;    (* Maximum index page size   *)

(*
   Minimum index cache size
 *)
  ESS_INDEXCACHEMIN_SIZE  = 1048576; (* Minimal index cache size  *)

(*
   Constants for ErrType Field of Member Error Structure
   (ESS_MBRERR_T).
*)

  ESS_MBRERR_BADDIM       = 3301;       (* Member in bad col for dimension *)
  ESS_MBRERR_BADGEN       = 3302;       (* Member in bad col for generation *)
  ESS_MBRERR_UNKNOWN      = 3303;       (* Member not found in database *)
  ESS_MBRERR_BADACCESS    = 3304;       (* Insufficient access to store data *)
  ESS_MBRERR_BADSYNTAX    = 3305;       (* Incorrect syntax for member *)
  ESS_MBRERR_BADALIAS     = 3306;     (* Alias already in use *)
  ESS_MBRERR_DIFFPARENT   = 3307;     (* Different parent for member *)
  ESS_MBRERR_NOPARENT     = 3331;     (* No parent for child member *)
  ESS_MBRERR_DIFFDIM      = 3308;     (* Different dimension for member *)
  ESS_MBRERR_NOLEVELZERO  = 3309;     (* Level zero required *)
  ESS_MBRERR_NOPREVLEVEL  = 3310;     (* Level zero required *)
  ESS_MBRERR_NOMBRALIAS   = 3311;     (* Member required *)
  ESS_MBRERR_NOMBRATTR    = 3312;     (* Member required *)
  ESS_MBRERR_NOMBRFORM    = 3313;     (* Member required *)
  ESS_MBRERR_ALIASISMBR   = 3314;     (* Alias name is member name *)
  ESS_MBRERR_NOATTRCHG    = 3315;     (* Change Attribute = FALSE *)
  ESS_MBRERR_NOFORMCHG    = 3316;     (* Change Formula = FALSE *)
  ESS_MBRERR_ADDMBRERR    = 3317;     (* Error adding member *)
  ESS_MBRERR_MOVEMBRERR   = 3318;     (* Error moveing member *)
  ESS_MBRERR_ALIASADDERR  = 3319;     (* Error adding alias *)
  ESS_MBRERR_ATTRADDERR   = 3320;     (* Error adding attribute *)
  ESS_MBRERR_USERATTRADDERR  = 3321;  (* Error adding user attribute *)
  ESS_MBRERR_FORMADDERR   = 3322;     (* Error adding formula *)
  ESS_MBRERR_CURNAMEADDERR   = 3323;  (* Error adding currency name *)
  ESS_MBRERR_CURCATADDERR    = 3324;  (* Error adding currency category *)
  ESS_MBRERR_COLIGNORED   = 3325;     (* Column Ignored - error in hdr *)
  ESS_MBRERR_MBRREQ       = 3326;     (* Match Mbr # or P/C required *)
  ESS_MBRERR_CTRYDIMREQ   = 3327;     (* Country Dim Type required *)
  ESS_MBRERR_ACCTDIMREQ   = 3328;     (* Account Dim Type required *)
  ESS_MBRERR_BADCOMBO     = 3329;     (* Illegal Member/Parent Combination *)
  ESS_MBRERR_DIFFGEN      = 3330;     (* Different generation for member *)
(* 3331 used above *)
  ESS_MBRERR_BADMBRNAME   = 3332;     (* Mbr name used in record as alias *)


(*********************** API TYPE DEFINITIONS ************************)

(*
   Standard C Language Types
*)

type

{from windows.pas
  UCHAR = Byte;
  PUCHAR = ^Byte;
  SHORT = Smallint;
  UINT = Integer;
  PUINT = ^UINT;
  ULONG = Longint;
  PULONG = ^ULONG;
  PLongint = ^Longint;
  PInteger = ^Integer;
}

  ESS_CHAR_T = char;
  ESS_SHORT_T = SmallInt;
  ESS_LONG_T = longInt;
  ESS_UCHAR_T = Byte;
  ESS_USHORT_T = word; {SmallInt?}
  ESS_ULONG_T = Cardinal;
  ESS_FLOAT_T = Real;
  ESS_DOUBLE_T = double;
{ original
typedef char            ESS_CHAR_T;
typedef short           ESS_SHORT_T;
typedef long            ESS_LONG_T;
typedef unsigned char   ESS_UCHAR_T;
typedef unsigned short  ESS_USHORT_T;
typedef unsigned long   ESS_ULONG_T;
typedef float           ESS_FLOAT_T;
typedef double          ESS_DOUBLE_T;
}

(*
   Essbase Special Defined Types
*)
  ESS_BOOL_T = Boolean;     (* boolean *)
  ESS_STR_T = pchar;     (* string (i.e. char array) *)
  ESS_VOID_T = pointer;  (*   void *)
  ESS_BYTE_T = byte;     (* byte *)
  ESS_WORD_T = word;     (* word *)
  ESS_DATA_T = Byte;     (* data buffer (huge) *)
  ESS_SIZE_T = Cardinal;     (* size of a memory block *)
  ESS_TIME_T = Cardinal;
{ original
typedef unsigned char   ESS_BOOL_T;     /* boolean */
typedef char            *ESS_STR_T;     /* string (i.e. char array) */
typedef void            ESS_VOID_T;     /* void */
typedef unsigned char   ESS_BYTE_T;     /* byte */
typedef unsigned short  ESS_WORD_T;     /* word */
typedef unsigned char   ESS_DATA_T;     /* data buffer (huge) */
typedef unsigned long   ESS_SIZE_T;     /* size of a memory block */
typedef unsigned long   ESS_TIME_T;     /* time stamp */
}
  ESS_HINST_T = smallint;    (* API instance handle *) {was long}
  ESS_HCTX_T = LongInt;     (* API context handle *)
  ESS_ACCESS_T = Word;   (* security access level *)
  ESS_OBJTYPE_T = Longint;  (* file object type *)
  ESS_LOGINID_T = LongInt;  (* user login identification tag *)
{ original
#ifndef ESS_USE_INSTHDL
typedef void *          ESS_HINST_T;    /* API instance handle */
typedef void *          ESS_HCTX_T;     /* API context handle */
#else
typedef short           ESS_HINST_T;    /* API instance handle */
typedef short           ESS_HCTX_T;     /* API context handle */
#endif
typedef unsigned short  ESS_ACCESS_T;   /* security access level */
typedef unsigned long   ESS_OBJTYPE_T;  /* file object type */
typedef unsigned long   ESS_LOGINID_T;  /* user login identification tag */
}

(*
   Pointer Types - Pointers to each of the above
*)
ESS_PCHAR_T     = ^ESS_CHAR_T;
ESS_PSHORT_T    = ^ESS_SHORT_T;
ESS_PLONG_T     = ^ESS_LONG_T;
ESS_PUCHAR_T    = ^ESS_UCHAR_T;
ESS_PUSHORT_T   = ^ESS_USHORT_T;
ESS_PULONG_T    = ^ESS_ULONG_T;
ESS_PFLOAT_T    = ^ESS_FLOAT_T;
ESS_PDOUBLE_T   = ^ESS_DOUBLE_T;
ESS_PBOOL_T     = ^ESS_BOOL_T;
ESS_PSTR_T      = ^ESS_STR_T;
ESS_PVOID_T     = ^ESS_VOID_T;
ESS_PBYTE_T     = ^ESS_BYTE_T;
ESS_PWORD_T     = ^ESS_WORD_T;
ESS_PDATA_T     = ^ESS_DATA_T;
ESS_PSIZE_T     = ^ESS_SIZE_T;
ESS_PTIME_T     = ^ESS_TIME_T;
ESS_PHINST_T    = ^ESS_HINST_T;
ESS_PHCTX_T     = ^ESS_HCTX_T;
ESS_PACCESS_T   = ^ESS_ACCESS_T;
ESS_POBJTYPE_T  = ^ESS_OBJTYPE_T;
ESS_PLOGINID_T  = ^ESS_LOGINID_T;
{ original
typedef ESS_CHAR_T      *ESS_PCHAR_T;
typedef ESS_SHORT_T     *ESS_PSHORT_T;
typedef ESS_LONG_T      *ESS_PLONG_T;
typedef ESS_UCHAR_T     *ESS_PUCHAR_T;
typedef ESS_USHORT_T    *ESS_PUSHORT_T;
typedef ESS_ULONG_T     *ESS_PULONG_T;
typedef ESS_FLOAT_T     *ESS_PFLOAT_T;
typedef ESS_DOUBLE_T    *ESS_PDOUBLE_T;
typedef ESS_BOOL_T      *ESS_PBOOL_T;
typedef ESS_STR_T       *ESS_PSTR_T;
typedef ESS_VOID_T      *ESS_PVOID_T;
typedef ESS_BYTE_T      *ESS_PBYTE_T;
typedef ESS_WORD_T      *ESS_PWORD_T;
typedef ESS_DATA_T      ESS_HUGE *ESS_PDATA_T;
typedef ESS_SIZE_T      *ESS_PSIZE_T;
typedef ESS_HINST_T     *ESS_PHINST_T;
typedef ESS_HCTX_T      *ESS_PHCTX_T;
typedef ESS_ACCESS_T    *ESS_PACCESS_T;
typedef ESS_OBJTYPE_T   *ESS_POBJTYPE_T;
typedef ESS_LOGINID_T   *ESS_PLOGINID_T;
}

(*
   Pointers to Pointers
*)

  ESS_PPSTR_T = ^ESS_PSTR_T;
  ESS_PPVOID_T = ^ESS_PVOID_T;
  ESS_PPBYTE_T = ^ESS_PBYTE_T;
  ESS_PPWORD_T = ^ESS_PWORD_T;
  ESS_PPDATA_T = ^ESS_PDATA_T;


(*
   Other Useful Data Types
*)

ESS_STS_T = LongInt;      (* return value from API functions *)
ESS_DATE_T = Word;     (* date stamp *)

ESS_DIMNUM_T = LongInt;   (* dimension number *)
ESS_MEMNUM_T = LongInt;   (* member number *)
ESS_PFUNC_T = function: ESS_STS_T of object;

{original
typedef long            ESS_STS_T;      /* return value from API functions */
typedef unsigned short  ESS_DATE_T;     /* date stamp */

typedef unsigned long   ESS_DIMNUM_T;   /* dimension number */
typedef unsigned long   ESS_MEMNUM_T;   /* member number */

#ifdef WIN32
typedef ESS_STS_T (*ESS_PFUNC_T)();            /* function pointer (Win32) */
#else
#ifdef _WINDOWS
typedef ESS_STS_T (FAR PASCAL *ESS_PFUNC_T)(); /* function pointer (Windows) */
#else
typedef ESS_STS_T (*ESS_PFUNC_T)();            /* function pointer (other) */
#endif
#endif
}

ESS_USERNAME_T = array [0..ESS_USERNAMELEN] of char;  (* user name *)
ESS_PASSWORD_T = array [0..ESS_PASSWORDLEN] of char;  (* password *)
ESS_SVRNAME_T = array [0..ESS_SVRNAMELEN] of char;    (* server name *)
ESS_APPNAME_T = array [0..ESS_APPNAMELEN] of char;    (* application name *)
ESS_DBNAME_T = array [0..ESS_DBNAMELEN] of char;      (* database name *)
ESS_OBJNAME_T = array [0..ESS_OBJNAMELEN] of char;    (* object name *)
ESS_MBRNAME_T = array [0..ESS_MBRNAMELEN] of char;    (* member name *)
ESS_FTRNAME_T = array [0..ESS_FTRNAMELEN] of char;    (* filter name *)
ESS_ALIASNAME_T = array [0..ESS_ALIASNAMELEN] of char;(* alias table name *)
ESS_PATH_T = array [0..ESS_PATHLEN] of char;          (* file path name *)
ESS_DESC_T = array [0..ESS_DESCLEN] of char;          (* app/database description *)

ESS_PUSERNAME_T = ^ESS_USERNAME_T;
ESS_PSVRNAME_T = ^ESS_SVRNAME_T;
ESS_PAPPNAME_T = ^ESS_APPNAME_T;
ESS_PDBNAME_T = ^ESS_DBNAME_T;
ESS_POBJNAME_T = ^ESS_OBJNAME_T;
ESS_PMBRNAME_T = ^ESS_MBRNAME_T;
ESS_PFTRNAME_T = ^ESS_FTRNAME_T;
ESS_PALIASNAME_T = ^ESS_ALIASNAME_T;

ESS_PPUSERNAME_T = ^ESS_PUSERNAME_T;
ESS_PPSVRNAME_T = ^ESS_PSVRNAME_T;
ESS_PPAPPNAME_T = ^ESS_PAPPNAME_T;
ESS_PPDBNAME_T = ^ESS_PDBNAME_T;
ESS_PPOBJNAME_T = ^ESS_POBJNAME_T;
ESS_PPMBRNAME_T = ^ESS_PMBRNAME_T;
ESS_PPFTRNAME_T = ^ESS_PFTRNAME_T;
ESS_PPALIASNAME_T = ^ESS_PALIASNAME_T;



(*********************** API MACRO DEFINITIONS ***********************)

(*
   Function Declaration Macro
*)
{ don't need this - function declared as "FOO function(params): returntype" 
#ifdef WIN32
#define ESS_FUNC_M      ESS_STS_T               /* for Win32 */
#else
#ifdef _WINDOWS
  ESS_FUNC_M      ESS_STS_T FAR PASCAL    (* for Windows & Windows NT *)
#else
  ESS_FUNC_M      ESS_STS_T               (* for other platforms *)
#endif
}


(********************** API STRUCTURE DEFINITIONS ********************)

(*
   ESS_INIT_T, ESS_PINIT_T
   API Initialization Structure
*)

ESS_INIT_T = Record
   Version:      ESS_ULONG_T;  (* This should be set to ESS_API_VERSION *)
   UserContext:  ESS_PVOID_T;  (* void pointer to user's message context *)
   MaxHandles:   ESS_USHORT_T; (* max number of context handles required *)
   MaxBuffer:    ESS_SIZE_T;   (* max size of buffer that can be allocated *)
   LocalPath:    ESS_STR_T;    (* local path to use for file operations *)
   MessageFile:  ESS_STR_T;    (* full path name of message database file *)
   AllocFunc:    ESS_PFUNC_T;  (* user-defined memory allocation function *)
   ReallocFunc:  ESS_PFUNC_T;  (* user-defined memory reallocation function *)
   FreeFunc:     ESS_PFUNC_T;  (* user-defined memory free function *)
   MessageFunc:  ESS_PFUNC_T;  (* user-defined message callback function *)
   HelpFile:     ESS_STR_T;    (* user-defined help file path *)
   Ess_System:   ESS_ULONG_T;  (* reserved for internal use *)
end;
ESS_PINIT_T = ^ESS_INIT_T;



(*
   ESS_APPDB_T, ESS_PAPPDB_T, ESS_PPAPPDB_T
   Application/Database List Structure
*)

ess_appdb_t = record
   AppName:  ESS_APPNAME_T;               (* application name *)
   DbName:   ESS_DBNAME_T;                (* database name *)
end;
ESS_PAPPDB_T = ^ESS_APPDB_T;
ESS_PPAPPDB_T = ^ESS_PAPPDB_T;



(*
   ESS_APPSTATE_T, ESS_PAPPSTATE_T, ESS_PPAPPSTATE_T
   Application State Structure
*)

ess_appstate_t = record
  Description:  ESS_DESC_T;            (* application description field *)
  Loadable:     ESS_BOOL_T;            (* allow application to be loaded *)
  Autoload:     ESS_BOOL_T;            (* automatically load on startup *)
  Access:       ESS_ACCESS_T;          (* default access level *)
  Connects:     ESS_BOOL_T;            (* allow connects flag *)
  Commands:     ESS_BOOL_T;            (* allow commands flag *)
  Updates:      ESS_BOOL_T;            (* allow updates flag *)
  Security:     ESS_BOOL_T;            (* enable application security *)
  LockTimeout:  ESS_ULONG_T;           (* lock timeout period *)
end;
ESS_PAPPSTATE_T = ^ESS_APPSTATE_T;
ESS_PPAPPSTATE_T = ^ESS_PAPPSTATE_T;



(*
   ESS_APPINFO_T, ESS_PAPPINFO_T, ESS_PPAPPINFO_T
   Application Info Structure (GET only)
*)

ess_appinfo_t = record
  Name:        ESS_APPNAME_T;       (* application name *)
  Server:      ESS_SVRNAME_T;       (* network server name *)
  Status:      ESS_USHORT_T;        (* application load status *)
  nConnects:   ESS_USHORT_T;        (* number of users connected *)
  ElapsedAppTime: ESS_TIME_T;        (* elapsed application time *)
  nDbs:        ESS_USHORT_T;        (* number of databases in this app *)
  DbNames:     array [0..0] of ESS_DBNAME_T;        (* list of database names *)
{original
   ESS_DBNAME_T  DbNames[1];            /* list of database names */
}
end;
ESS_PAPPINFO_T = ^ESS_APPINFO_T;
ESS_PPAPPINFO_T = ^ESS_PAPPINFO_T;


(*
   ESS_APPINFOEX_T, ESS_PAPPINFOEX_T, ESS_PPAPPINFOEX_T
   Application Info Extended Structure (GET only)
*)

ess_appinfoex_t = record

   Name:           ESS_APPNAME_T;     (* application name *)
   Server:         ESS_SVRNAME_T;     (* network server name *)
   Status:         ESS_USHORT_T;      (* application load status *)
   nConnects:      ESS_USHORT_T;      (* number of users connected *)
   ElapsedAppTime: ESS_TIME_T;        (* elapsed application time *)

end;
ESS_PAPPINFOEX_T = ^ESS_APPINFOEX_T;
ESS_PPAPPINFOEX_T = ^ESS_PAPPINFOEX_T;


(*
   ESS_DBSTATE_T, ESS_PDBSTATE_T, ESS_PPDBSTATE_T
   Database State Structure
*)

ess_dbstate_t = record
  Description:       ESS_DESC_T;      (* database description field *)
  Loadable:          ESS_BOOL_T;      (* allow database to be loaded *)
  Autoload:          ESS_BOOL_T;      (* automatically load on startup *)
  Access:            ESS_ACCESS_T;    (* default access level *)
  IndexType:         ESS_SHORT_T;     (* db index type - array or tree *)
  MaxMem:            ESS_ULONG_T;     (* max memory for uncompressed blocks *)
  MaxCompMem:        ESS_ULONG_T;     (* max memory for compressed blocks *)
  CalcNoAggMissing:  ESS_BOOL_T;      (* Don't aggregate if all children *)
                                      (* are missing *)
  CalcNoAvgMissing:  ESS_BOOL_T;      (* Don't average on missing value *)
  CalcTwoPass:       ESS_BOOL_T;      (* Perform two pass calc when *)
                                      (* running "calc all;" *)
  CalcCreateBlock:   ESS_BOOL_T;      (* Create a sparse data block on *)
                                      (* constant assignment calc equation *)
  CrDbName:          ESS_DBNAME_T;    (* currency database name *)
  CrTypeMember:      ESS_MBRNAME_T;   (* currency conversion type member *)
  CrConvType:        ESS_USHORT_T;    (* currency conversion type *)
  MaxMemInde:        ESS_ULONG_T;     (* maximum index memory *)
  IndexPageSize:     ESS_ULONG_T;     (* index page size *)
  DataCompress:      ESS_BOOL_T;      (* Optional compression flag *)
end;
ESS_PDBSTATE_T = ^ESS_DBSTATE_T;
ESS_PPDBSTATE_T = ^ESS_PDBSTATE_T;


(*
   ESS_TIMERECORD_T, ESS_PTIMERECORD_T
   Time Record
*)
ess_timerecord_t = record
   TimeValue: ESS_TIME_T;   (* Time value in seconds after 1/1/70 *)
   Seconds:   ESS_USHORT_T; (* Seconds after the minute [0-61] *)
   Minutes:   ESS_USHORT_T; (* Minutes after the hour [0-59] *)
   Hours:     ESS_USHORT_T; (* Hours since midnight [0-23] *)
   Day:       ESS_USHORT_T; (* Day of the month [1-31] *)
   Month:     ESS_USHORT_T; (* Months since January [0-11], January = 0 *)
   Year:      ESS_USHORT_T; (* Years since 1900 *)
   Weekday:   ESS_USHORT_T; (* Days since Sunday [0-6], Sunday = 0 *)
end;
ESS_PTIMERECORD_T = ^ESS_TIMERECORD_T;



(*
   ESS_DBREQINFO_T, ESS_PDBREQINFO_T
   Database Request Info Structure (GET only)
*)

ess_dbreqinfo_t = record

   DbReqType: ESS_ULONG_T;            (* Type of database request *)
   User: ESS_USERNAME_T;              (* User name *)
   StartTimeRec: ESS_TIMERECORD_T;    (* Request start time record *)
   EndTimeRec: ESS_TIMERECORD_T;      (* Request end time record *)
   DbReqFlags: ESS_ULONG_T;           (* Bit map of informational flags *)

end;
ESS_PDBREQINFO_T = ^ESS_DBREQINFO_T;



(*
   ESS_DBINFO_T, ESS_PDBINFO_T, ESS_PPDBINFO_T
   Database Info Structure (GET only)
*)

ess_dbinfo_t = record
  AppName:      ESS_APPNAME_T;         (* application name *)
  Name:         ESS_DBNAME_T;          (* database name *)
  DbType:       ESS_USHORT_T;          (* database Type *)
  Status:       ESS_USHORT_T;          (* database load status *)
  nConnects:    ESS_USHORT_T;          (* number of users connected *)
  nLocks:       ESS_USHORT_T;          (* number of exclusive block locks *)
  nDims:        ESS_ULONG_T;           (* number of dimensions in db *)
  Data:         ESS_USHORT_T;          (* data loaded flag *)
  Country:      ESS_MBRNAME_T;         (* currency country dimension member *)
  Time:         ESS_MBRNAME_T;         (* currency time dimension member *)
  Category:     ESS_MBRNAME_T;         (* currency category dimension member*)
  CurType:      ESS_MBRNAME_T;         (* currency type dimension member *)
  CrPartition:  ESS_MBRNAME_T;         (* currency partition member *)
  ElapsedDbTime:  ESS_TIME_T;          (* elapsed database time *)
  DataCacheSize:  ESS_ULONG_T;         (* run-time size of the Data cache *)
  IndexCacheSize: ESS_ULONG_T;         (* run-time size of the Index cache *)
  IndexPageSize:  ESS_ULONG_T;         (* run-time size of an Index Page *)
  DbReqInfoAry:   array [0..ESS_DBREQNUM] of ESS_DBREQINFO_T;
                                       (* database request information *)
end;
ESS_PDBINFO_T = ^ESS_DBINFO_T;
ESS_PPDBINFO_T = ^ESS_PDBINFO_T;



(*
   ESS_DIMSTATS_T, ESS_PDIMSTATS_T
   Database Dimension Statistics Structure
*)

ess_dimstats_t = record
  DimName: ESS_MBRNAME_T;         (* dimension name *)
  DimType: ESS_USHORT_T;          (* dimension type *)
  DeclaredDimSize: ESS_ULONG_T;   (* declared dimension size *)
  ActualDimSize: ESS_ULONG_T;     (* actual dimension size *)
end;
ESS_PDIMSTATS_T = ^ESS_DIMSTATS_T;



(*
   ESS_DBSTATS_T, ESS_PDBSTATS_T, ESS_PPDBSTATS_T
   Database Statistics Structure
*)

ess_dbstats_t = record
  IndexType:               ESS_USHORT_T;        (* structure index type *)
  nDims:                   ESS_ULONG_T;         (* number of dimensions *)
  DeclaredBlockSize:       ESS_ULONG_T;         (* declared block size *)
  ActualBlockSize:         ESS_ULONG_T;         (* actual block size *)
  DeclaredMaxBlocks:       ESS_DOUBLE_T;        (* declared max # of blocks *)
  ActualMaxBlocks:         ESS_DOUBLE_T;        (* actual max # of blocks *)
  NonMissingLeafBlocks:    ESS_DOUBLE_T;        (* # of non-missing leaf blks*)
  NonMissingNonLeafBlocks: ESS_DOUBLE_T;        (* # of non-missing non-leaf *)
                                                (* blocks *)
  NonMissingBlocks:        ESS_DOUBLE_T;        (* # of non-missing blocks *)
  PagedOutBlocks:          ESS_DOUBLE_T;        (* # of paged out blocks *)
  PagedInBlocks:           ESS_DOUBLE_T;        (* # of paged in blocks *)
  InMemCompBlocks:         ESS_DOUBLE_T;        (* # of in memory compressed *)
                                                (* blocks *)
  TotalBlocks:             ESS_DOUBLE_T;        (* # of blocks *)
  NonExclusiveLockCount:   ESS_DOUBLE_T;        (* # of non-exclusive locks *)
  ExclusiveLockCount:      ESS_DOUBLE_T;        (* # of exclusive locks *)
  TotMemPagedInBlocks:     ESS_DOUBLE_T;        (* total memory used for *)
                                                (* paged in blocks *)
  TotMemBlocks:            ESS_DOUBLE_T;        (* total memory for all *)
                                                (* blocks *)
  TotMemIndex:             ESS_DOUBLE_T;        (* total memory used for *)
                                                (* indexing *)
  TotMemInMemCompBlocks:   ESS_DOUBLE_T;        (* total memory used for in *)
                                                (* memory compressing *)
  BlockDensity:            ESS_DOUBLE_T;        (* average block density *)
  SparseDensity:           ESS_DOUBLE_T;        (* average sparse density *)
  CompressionRatio:        ESS_DOUBLE_T;         (* block compression ratio *)
  DimStatsAry:             array[0..0] of ESS_DIMSTATS_T;(* dimension info array *)
                                                (* note: this is a dynamic *)
                                                (* array with nDims elements *)
end;
ESS_PDBSTATS_T = ^ESS_DBSTATS_T;
ESS_PPDBSTATS_T = ^ESS_PDBSTATS_T;



(*
   ESS_DIMENSIONINFO_T, ESS_PDIMENSIONINFO_T, ESS_PPDIMENSIONINFO_T
   Database Dimension Information Structure
*)

ess_dimensioninfo_t = record

   DimName:         ESS_MBRNAME_T;  (* The dimension name *)
   DimNumber:       ESS_DIMNUM_T;   (* Dimension number of the member *)
   DimType:         ESS_USHORT_T;   (* dimension type *)
                                    (* either ESS_DIMTYPE_DENSE or *)
                                    (*        ESS_DIMTYPE_SPARSE   *)
   DimTag:          ESS_USHORT_T;   (* dimension tag type *)
                                    (*    one of ESS_TTYPE_xxx *)
   DeclaredDimSize: ESS_ULONG_T;    (* declared dimension size *)
   ActualDimSize:   ESS_ULONG_T;    (* actual dimension size *)

   Description:     ESS_DESC_T;     (* Reserved -- not supported now *)

end;
ESS_PDIMENSIONINFO_T = ^ESS_DIMENSIONINFO_T;
ESS_PPDIMENSIONINFO_T = ^ESS_PDIMENSIONINFO_T;



(*
   ESS_MEMBERINFO_T, ESS_PMEMBERINFO_T, ESS_PPMEMBERINFO_T
   Database Member Information Structure
*)

ess_memberinfo_t = record
  MbrName:        ESS_MBRNAME_T; (* The member name *)
  MbrNumber:      ESS_MEMNUM_T;  (* Member number, starting from bottom left *)
  DimName:        ESS_MBRNAME_T; (* The member's dimension name *)
  DimNumber:      ESS_DIMNUM_T;  (* Dimension number of the member *)
  Status:         ESS_USHORT_T;  (* Member status: defined in ESS_MBRSTS_xxx *)
  Level:          ESS_SHORT_T;   (* Member level number *)
  Generation:     ESS_SHORT_T;   (* Member generation number *)
  UnaryCalc:      ESS_SHORT_T;   (* Default rollup for this member*)
                                 (* Defined in ESS_UCAL_xxx *)
  MbrTagType:     ESS_USHORT_T;  (* A 16 bit mask for mbr's tagged types *)
                                 (* masks are defined in ESS_ATYPE_xxx   *)
  CurrConvert:    ESS_BOOL_T;    (* Currency conversion (ESS_TRUE/ESS_FALSE) *)
  CrMbrName:      ESS_MBRNAME_T; (* Name of the tagged currency DB member *)
                                 (* FOR TIME     -- tagged Time Member *)
                                 (* FOR COUNTRY  -- tagged currency Member *)
                                 (* FOR ACCOUNTS -- tagged category Member *)
  Description:    ESS_DESC_T;    (* Member description *)
  ParentMbrName:  ESS_MBRNAME_T; (* Parent member name *)
  ChildMbrName:   ESS_MBRNAME_T; (* First child member name *)
  PrevMbrName:    ESS_MBRNAME_T; (* Previous sibling member name *)
  NextMbrName:    ESS_MBRNAME_T; (* Next sibling member name *)
end;
ESS_PMEMBERINFO_T = ^ESS_MEMBERINFO_T;
ESS_PPMEMBERINFO_T = ^ESS_PMEMBERINFO_T;



(*
   ESS_PROCSTATE_T, ESS_PPROCSTATE_T
   Server Process State Structure
*)

ess_procstate_t = record
  Action:     ESS_USHORT_T;     (* current process action (not used) *)
  State:      ESS_USHORT_T;     (* current process state *)
  Reserved1:  ESS_USHORT_T;     (* reserved for future use *)
  Reserved2:  ESS_ULONG_T;      (* reserved for future use *)
  Reserved3:  ESS_ULONG_T;      (* reserved for future use *)
end;
ESS_PPROCSTATE_T = ^ESS_PROCSTATE_T;



(*
   ESS_USERINFO_T, ESS_PUSERINFO_T, ESS_PPUSERINFO_T,
   ESS_GROUPINFO_T, ESS_PGROUPINFO_T, ESS_PPGROUPINFO_T
   Structure for User/Group Information
*)

ess_userinfo_t = record
  Name:        ESS_USERNAME_T;  (* user/group name *)
  AppName:     ESS_APPNAME_T;   (* connected application *)
  DbName:      ESS_DBNAME_T;    (* connected database *)
  Login:       ESS_BOOL_T;      (* login flag (user only) *)
  InfoType:    ESS_USHORT_T;    (* user/group flag *)
  Access:      ESS_ACCESS_T;    (* user's own access level *)
  MaxAccess:   ESS_ACCESS_T;    (* user's highest access level *)
  Expiration:  ESS_DATE_T;      (* password expiration date (user only) *)
  LastLogin:   ESS_TIME_T;      (* date and time of last successful login *)
  DbConnectTime:  ESS_TIME_T;   (* date and time of db connection *)
  FailCount:   ESS_USHORT_T;    (* failed login attempts since last login *)
  LoginId:     ESS_LOGINID_T;   (* user login identification tag *)
end;
ESS_PUSERINFO_T = ^ESS_USERINFO_T;
ESS_PPUSERINFO_T = ^ESS_PUSERINFO_T;
ESS_GROUPINFO_T = ESS_USERINFO_T;
ESS_PGROUPINFO_T = ^ESS_GROUPINFO_T;
ESS_PPGROUPINFO_T = ESS_PGROUPINFO_T;



(*
   ESS_USERAPP_T, ESS_PUSERAPP_T, ESS_PPUSERAPP_T,
   ESS_GROUPAPP_T, ESS_PGROUPAPP_T, ESS_PPGROUPAPP_T
   Structure for User/Group Application Information
*)

ess_userapp_t = record
  UserName:   ESS_USERNAME_T;  (* user/group name *)
  AppName:    ESS_APPNAME_T;   (* connected application *)
  Access:     ESS_ACCESS_T;    (* user's own application access level *)
  MaxAccess:  ESS_ACCESS_T;    (* user's highest application access level *)
end;
ESS_PUSERAPP_T = ^ESS_USERAPP_T;
ESS_PPUSERAPP_T = ^ESS_PUSERAPP_T;
ESS_GROUPAPP_T = ESS_USERAPP_T;
ESS_PGROUPAPP_T = ^ESS_GROUPAPP_T;
ESS_PPGROUPAPP_T = ^ESS_PGROUPAPP_T;



(*
   ESS_USERDB_T, ESS_PUSERDB_T, ESS_PPUSERDB_T,
   ESS_GROUPDB_T, ESS_PGROUPDB_T, ESS_PPGROUPDB_T;
   Structure for User/Group Database Information
*)

ess_userdb_t = record
  UserName: ESS_USERNAME_T;   (* user/group name *)
  AppName: ESS_APPNAME_T;     (* application name *)
  DbName: ESS_DBNAME_T;       (* database name *)
  Access: ESS_ACCESS_T;       (* user's own database access level *)
  MaxAccess: ESS_ACCESS_T;    (* user's highest database access level *)
  FilterName: ESS_FTRNAME_T;  (* database filter set (if any) *)
end;
ESS_PUSERDB_T = ^ESS_USERDB_T;
ESS_PPUSERDB_T = ^ESS_PUSERDB_T;
ESS_GROUPDB_T = ESS_USERDB_T;
ESS_PGROUPDB_T = ^ESS_GROUPDB_T;
ESS_PPGROUPDB_T = ^ESS_PGROUPDB_T;



(*
   ESS_LOCKINFO_T, ESS_PLOCKINFO_T, ESS_PPLOCKINFO_T,
   Structure for User Lock Information
*)

ess_lockinfo_t = record
  UserName: ESS_USERNAME_T;  (* user/group name *)
  nLocks: ESS_USHORT_T;      (* number of block locks held *)
  Time: ESS_TIME_T;          (* maximum time held (in seconds) *)
  LoginId: ESS_LOGINID_T;    (* user login identification tag *)
end;
ESS_PLOCKINFO_T = ^ESS_LOCKINFO_T;
ESS_PPLOCKINFO_T = ^ESS_PLOCKINFO_T;



(*
   ESS_GLOBAL_T, ESS_PGLOBAL_T, ESS_PPGLOBAL_T
   Structure for Global Security Parameters.
*)

ess_global_t = record
  Security:  ESS_BOOL_T;       (* global security status (enabled/disabled) *)
  Logins:    ESS_BOOL_T;       (* global login status (enabled/disabled) *)
  Access:    ESS_ACCESS_T;     (* global default access level *)
  Validity:  ESS_USHORT_T;     (* global password validity (in days) *)
  Currency:  ESS_BOOL_T;       (* global currency enabled flag *)
  PwMin:     ESS_USHORT_T;     (* global minimum password length *)
  InactivityTime: ESS_TIME_T;   (* global auto-logout time (in seconds) *)
  InactivityCheck: ESS_TIME_T;  (* global auto-logout checking interval (sec) *)
end;
ESS_PGLOBAL_T = ^ESS_GLOBAL_T;
ESS_PPGLOBAL_T = ^ESS_PGLOBAL_T;



(*
   ESS_OBJINFO_T, ESS_POBJINFO_T, ESS_PPOBJINFO_T
   Structure for File Object Information.
*)

ess_objinfo_t = record
  Name:         ESS_OBJNAME_T;    (* object name *)
  ObjType:      ESS_OBJTYPE_T;    (* object type *)
  AppName:      ESS_APPNAME_T;    (* application name *)
  DbName:       ESS_DBNAME_T;     (* database name *)
  FileSize:     ESS_ULONG_T;      (* allocated object file size (in bytes) *)
  Locked:       ESS_BOOL_T;       (* flag to indicate object is locked *)
  User:         ESS_USERNAME_T;   (* name of user who has object locked *)
  TimeStamp:    ESS_TIME_T;       (* date & time object was locked *)
  TimeModified: ESS_TIMERECORD_T; (* date & time object was last modified *)
end;
ESS_POBJINFO_T = ^ESS_OBJINFO_T;
ESS_PPOBJINFO_T = ^ESS_POBJINFO_T;



(*
   ESS_RATEINFO_T, ESS_PRATEINFO_T, ESS_PPRATEINFO_T
   Currency Partition Rate Info Structure -
   Used by EssGetCurrencyRateInfo() function
*)

ess_rateinfo_t = record
  MbrName: ESS_MBRNAME_T;  (* Currency partition *)
                           (* member name *)
  RateMbr: array [0..ESS_CRDB_MAXDIMNUM] of ESS_MBRNAME_T;
    (* Array of rate member names *)
end;
ESS_PRATEINFO_T = ^ESS_RATEINFO_T;
ESS_PPRATEINFO_T = ^ESS_PRATEINFO_T;



(*
   ESS_MBRALT_T, ESS_PMBRALT_T, ESS_PPMBRALT_T
   Member/Alias List Structure
*)

ess_mbralt_t = record
  MbrName: ESS_MBRNAME_T;               (* Member name *)
  AltName: ESS_MBRNAME_T;               (* Alias name *)
end;
ESS_PMBRALT_T = ^ESS_MBRALT_T;
ESS_PPMBRALT_T = ^ESS_PMBRALT_T;



(*
   ESS_MBRUSER_T, ESS_PMBRUSER_T
   External Data Source (e.g. SQL) User Information Structure -
   Used by EssImport() and EssBuildDimension()
*)

ess_mbruser_t = record
  User: ESS_STR_T;              (* external data source user name *)
  Password: ESS_STR_T;          (* external data source password *)
end;
ESS_PMBRUSER_T = ^ESS_MBRUSER_T;



(*
   ESS_MBRERR_T, ESS_PMBRERR_T
   Structure for Linked List of Member Errors -
   Used by EssImport() and EssBuildDimension()
*)

ESS_PMBRERR_T = ^ESS_MBRERR_T;
ESS_PPMBRERR_T = ^ESS_PMBRERR_T;
ess_mbrerr_t = record
 pNext: ESS_PMBRERR_T;   (* pointer to next structure in list *)
 ErrType: ESS_USHORT_T;  (* type of error *)
 Name: ESS_STR_T;        (* outline member name *)
 RecordFile: ESS_STR_T;  (* file record containing error *)
end;



(*
   ESS_OBJDEF_T, ESS_POBJDEF_T
   Object Definition Structure for summary object information -
   Used by EssImport() and EssBuildDimension()
*)

ess_objdef_t = record
 hCtx: ESS_HCTX_T;         (* object context handle *)
 ObjType: ESS_OBJTYPE_T;   (* object type *)
 AppName: ESS_STR_T;       (* application name *)
 DbName: ESS_STR_T;        (* database name *)
 FileName: ESS_STR_T;      (* object file name *)
end;
ESS_POBJDEF_T = ^ESS_OBJDEF_T;



(********************* API FUNCTION DECLARATIONS *********************)

(*
   Initialization & Login Functions
*)
function EssInit(pInitStruct: ESS_PINIT_T; phInstance: ESS_PHINST_T): ESS_STS_T; cdecl;
function EssTerm(hInstance: ESS_HINST_T): ESS_STS_T; cdecl;
function EssGetAPIVersion (version: ESS_PULONG_T): ESS_STS_T; stdcall;
function EssLogin(hInstance: ESS_HINST_T; Server, UserName, Password: ESS_STR_T;
                              pDbCount: ESS_PUSHORT_T; ppDbList: ESS_PPAPPDB_T;
                              phCtx: ESS_PHCTX_T): ESS_STS_T; stdcall;
function EssAutoLogin (hinstance: ESS_HINST_T;
                       Server, UserName, Password, AppName, DbName: ESS_STR_T;
                       Options: ESS_USHORT_T; pAccess: ESS_PACCESS_T;
                       phCtx: ESS_PHCTX_T): ESS_STS_T; stdcall;
function EssLogout (hCtx: ESS_HCTX_T): ESS_STS_T; stdcall;
function EssLogoutUser (hCtx: ESS_HCTX_T; LoginID: ESS_LOGINID_T): ESS_STS_T; stdcall;
function EssCreateLocalContext (hInstance: ESS_HINST_T; UserName,
                              Password: ESS_STR_T;
                              phCtx: ESS_PHCTX_T): ESS_STS_T; stdcall;
function EssDeleteLocalContext (hCtx: ESS_HCTX_T): ESS_STS_T; stdcall;
function EssGetVersion (hCtx: ESS_HCTX_T;
                        pRelease, pVersion, pRevision: ESS_PUSHORT_T): ESS_STS_T; stdcall;
function EssShutdownServer(hInstance: ESS_HINST_T; Server, UserName, Password: ESS_STR_T): ESS_STR_T; stdcall;


(*
   Application Functions
*)
function EssGetActive(hCtx: ESS_HCTX_T; pAppName, pDbName: ESS_PSTR_T;
                        pAccess: ESS_PACCESS_T): ESS_STS_T; stdcall;
function EssSetActive(hCtx: ESS_HCTX_T; AppName, DbName: ESS_STR_T;
                       pAccess: ESS_PACCESS_T): ESS_STS_T; stdcall;
function EssClearActive(hCtx: ESS_HCTX_T): ESS_STS_T; stdcall;
function EssListApplications(hCtx: ESS_HCTX_T; pCount: ESS_PUSHORT_T;
                               ppAppList: ESS_PPAPPNAME_T): ESS_STS_T; stdcall;
function EssCreateApplication(hCtx: ESS_HCTX_T; AppName: ESS_STR_T): ESS_STS_T; stdcall;
function EssDeleteApplication(hCtx: ESS_HCTX_T; AppName: ESS_STR_T): ESS_STS_T; stdcall;
function EssRenameApplication(hCtx: ESS_HCTX_T; OldName, NewName: ESS_STR_T): ESS_STS_T; stdcall;
function EssCopyApplication(hCtx, hSrcCtx: ESS_HCTX_T;
                            SrcApp, DestApp: ESS_STR_T): ESS_STS_T; stdcall;
function EssGetApplicationState(hCtx: ESS_HCTX_T; AppName: ESS_STR_T;
                                ppAppState: ESS_PPAPPSTATE_T): ESS_STS_T; stdcall;
function EssSetApplicationState(hCtx: ESS_HCTX_T; AppName: ESS_STR_T;
                                pAppState: ESS_PAPPSTATE_T): ESS_STS_T; stdcall;
function EssGetApplicationInfo(hCtx: ESS_HCTX_T; AppName: ESS_STR_T;
                               ppAppInfo: ESS_PPAPPINFO_T): ESS_STS_T; stdcall;
function EssGetApplicationInfoEx(hCtx: ESS_HCTX_T; AppName: ESS_STR_T;
                               pusCount: ESS_PUSHORT_T; ppAppInfoEx: ESS_PPAPPINFOEX_T): ESS_STS_T; stdcall;
function EssLoadApplication(hCtx: ESS_HCTX_T; AppName: ESS_STR_T): ESS_STS_T; stdcall;
function EssUnloadApplication(hCtx: ESS_HCTX_T; AppName: ESS_STR_T): ESS_STS_T; stdcall;


(*
   Database Functions
*)
function EssListDatabases(hCtx: ESS_HCTX_T; AppName: ESS_STR_T;
                          pCount: ESS_PUSHORT_T;
                          ppDbList: ESS_PPAPPDB_T): ESS_STS_T; stdcall;
function EssListCurrencyDatabases(hCtx: ESS_HCTX_T; AppName: ESS_STR_T;
                          pCount: ESS_PUSHORT_T;
                          ppDbList: ESS_PPAPPDB_T): ESS_STS_T; stdcall;
function EssCreateDatabase(hCtx: ESS_HCTX_T; AppName, DbName: ESS_STR_T;
                           DbType: ESS_USHORT_T): ESS_STS_T; stdcall;
function EssDeleteDatabase(hCtx: ESS_HCTX_T;
                           AppName, DbName: ESS_STR_T): ESS_STS_T; stdcall;
function EssRenameDatabase(hCtx: ESS_HCTX_T;
                           AppName, OldName, NewName: ESS_STR_T): ESS_STS_T; stdcall;
function EssCopyDatabase(hCtx, hSrcCtx: ESS_HCTX_T;
                         SrcApp, DestApp, SrcDb, DestDb: ESS_STR_T): ESS_STS_T; stdcall;
function EssGetDatabaseState(hCtx: ESS_HCTX_T; AppName, DbName: ESS_STR_T;
                             ppDbState: ESS_PPDBSTATE_T): ESS_STS_T; stdcall;
function EssSetDatabaseState(hCtx: ESS_HCTX_T; AppName, DbName: ESS_STR_T;
                             pDbState: ESS_PDBSTATE_T): ESS_STS_T; stdcall;
function EssGetDatabaseInfo(hCtx: ESS_HCTX_T; AppName, DbName: ESS_STR_T;
                            ppDbInfo: ESS_PPDBINFO_T): ESS_STS_T; stdcall;
function EssGetDatabaseInfoEx(hCtx: ESS_HCTX_T; AppName, DbName: ESS_STR_T;
                            pusCount: ESS_PUSHORT_T; ppDbInfo: ESS_PPDBINFO_T): ESS_STS_T; stdcall;
function EssGetDatabaseStats(hCtx: ESS_HCTX_T; AppName, DbName: ESS_STR_T;
                             ppDbStats: ESS_PPDBSTATS_T): ESS_STS_T; stdcall;
function EssGetDatabaseNote(hCtx: ESS_HCTX_T; AppName, DbName: ESS_STR_T;
                            pDbNote: ESS_PSTR_T): ESS_STS_T; stdcall;
function EssSetDatabaseNote(hCtx: ESS_HCTX_T; AppName, DbName: ESS_STR_T;
                            DbNote: ESS_STR_T): ESS_STS_T; stdcall;
function EssLoadDatabase(hCtx: ESS_HCTX_T; AppName, DbName: ESS_STR_T): ESS_STS_T; stdcall;
function EssUnloadDatabase(hCtx: ESS_HCTX_T; AppName, DbName: ESS_STR_T): ESS_STS_T; stdcall;
function EssClearDatabase(hCtx: ESS_HCTX_T): ESS_STS_T; stdcall;
function EssCommitDatabase(hCtx: ESS_HCTX_T): ESS_STS_T; stdcall;
function EssGetCurrencyRateInfo(hCtx: ESS_HCTX_T; pCount: ESS_PLONG_T;
                                ppRateInfo: ESS_PPRATEINFO_T): ESS_STS_T; stdcall;


(*
   Database Member Functions
*)
function EssQueryDatabaseMembers(hCtx: ESS_HCTX_T; Query: ESS_STR_T): ESS_STS_T; stdcall;
function EssCheckMemberName(hCtx: ESS_HCTX_T; MbrName: ESS_STR_T;
                             pValid: ESS_PBOOL_T): ESS_STS_T; stdcall;
function EssGetMemberInfo(hCtx: ESS_HCTX_T; MbrName: ESS_STR_T;
                           ppMbrInfo: ESS_PPMEMBERINFO_T): ESS_STS_T; stdcall;
function EssGetMemberCalc(hCtx: ESS_HCTX_T; MbrName: ESS_STR_T;
                           pCalcStr, pLastCalcStr: ESS_PSTR_T): ESS_STS_T; stdcall;
function EssBuildDimension(hCtx: ESS_HCTX_T; RulesObj, DataObj: ESS_POBJDEF_T;
                            MbrUser: ESS_PMBRUSER_T;
                            ErrorName: ESS_STR_T): ESS_STS_T; stdcall;
function EssGetDimensionInfo(hCtx: ESS_HCTX_T; mbrName: ESS_STR_T;
                            pDims: ESS_PULONG_T; ppDimInfo: ESS_PPDIMENSIONINFO_T): ESS_STS_T; stdcall;

(*
   Reporting/Updating/Calculation Functions
*)
function EssReport(hCtx: ESS_HCTX_T; Output, Lock: ESS_BOOL_T;
                   RptSpec: ESS_STR_T): ESS_STS_T; stdcall;
function EssBeginReport(hCtx: ESS_HCTX_T; Output, Lock: ESS_BOOL_T): ESS_STS_T; stdcall;
function EssEndReport(hCtx: ESS_HCTX_T): ESS_STS_T; stdcall;
function EssUpdate(hCtx: ESS_HCTX_T; Output, Lock: ESS_BOOL_T;
                   UpdtSpec: ESS_STR_T): ESS_STS_T; stdcall;
function EssBeginUpdate(hCtx: ESS_HCTX_T; Output, Lock: ESS_BOOL_T): ESS_STS_T; stdcall;
function EssEndUpdate(hCtx: ESS_HCTX_T): ESS_STS_T; stdcall;
function EssSendString(hCtx: ESS_HCTX_T; Text: ESS_STR_T): ESS_STS_T; stdcall;
function EssGetString(hCtx: ESS_HCTX_T; pText: ESS_PSTR_T): ESS_STS_T; stdcall;
function EssCalc(hCtx: ESS_HCTX_T; Calculate: ESS_BOOL_T;
                 CalcScript: ESS_STR_T): ESS_STS_T; stdcall;
{ original from essapi.h - differs from documentation, doc has additional
 CalcSript parameter. Assuming that essapi.h is correct as is is consistent
 with other 'begin' functions}
function EssBeginCalc(hCtx: ESS_HCTX_T; Calculate: ESS_BOOL_T): ESS_STS_T; stdcall;
function EssEndCalc(hCtx: ESS_HCTX_T): ESS_STS_T; stdcall;
function EssDefaultCalc(hCtx: ESS_HCTX_T): ESS_STS_T; stdcall;
function EssGetDefaultCalc(hCtx: ESS_HCTX_T; pCalcScript: ESS_PSTR_T): ESS_STS_T; stdcall;
function EssSetDefaultCalc(hCtx: ESS_HCTX_T; CalcSript: ESS_STR_T): ESS_STS_T; stdcall;


(*
   File Functions
*)
function EssReportFile(hDestCtx, hSrcCtx: ESS_HCTX_T;
                       AppName, DbName, FileName: ESS_STR_T;
                       Output, Lock: ESS_BOOL_T): ESS_STS_T; stdcall;
function EssUpdateFile(hDestCtx, hSrcCtx: ESS_HCTX_T;
                       AppName, DbName, FileName: ESS_STR_T;
                       Store, Unlock: ESS_BOOL_T): ESS_STS_T; stdcall;
function EssCalcFile(hDestCtx, hSrcCtx: ESS_HCTX_T;
                       AppName, DbName, FileName: ESS_STR_T;
                       Calculate: ESS_BOOL_T): ESS_STS_T; stdcall;
function EssSetDefaultCalcFile(hDestCtx, hSrcCtx: ESS_HCTX_T;
                       AppName, DbName, FileName: ESS_STR_T): ESS_STS_T; stdcall;
function EssArchive(hCtx: ESS_HCTX_T; AppName, DbName, ObjectName: ESS_STR_T;
                    Data: ESS_BOOL_T): ESS_STS_T; stdcall;
function EssRestore(hCtx: ESS_HCTX_T; AppName, DbName, ObjectName: ESS_STR_T;
                    Data: ESS_BOOL_T): ESS_STS_T; stdcall;
function EssArchiveBegin(hCtx: ESS_HCTX_T; AppName, DbName, FileName: ESS_STR_T): ESS_STS_T; stdcall;
function EssArchiveEnd(hCtx: ESS_HCTX_T; AppName, DbName: ESS_STR_T): ESS_STS_T; stdcall;
function EssValidateDB(hCtx: ESS_HCTX_T; DbName, FileName: ESS_STR_T): ESS_STS_T; stdcall;
function EssImport(hCtx: ESS_HCTX_T; pRules, pData: ESS_POBJDEF_T;
                   ppMbrErr: ESS_PPMBRERR_T; pMbrUser: ESS_PMBRUSER_T;
                   AbortOnError: ESS_USHORT_T): ESS_STS_T; stdcall;
function EssExport(hCtx: ESS_HCTX_T; AppName, DbName, PathName: ESS_STR_T;
                   Level, Columns: ESS_SHORT_T): ESS_STS_T; stdcall;

(*
   Object Functions
*)
function EssGetLocalPath(hCtx: ESS_HCTX_T; ObjType: ESS_OBJTYPE_T;
                   AppName, DbName, ObjName: ESS_STR_T; Create: ESS_BOOL_T;
                   pPath: ESS_PSTR_T): ESS_STS_T; stdcall;
function EssGetObjectInfo(hCtx: ESS_HCTX_T; ObjType: ESS_OBJTYPE_T;
                   AppName, DbName, ObjName: ESS_STR_T;
                   ppObject: ESS_PPOBJINFO_T): ESS_STS_T; stdcall;
function EssListObjects(hCtx: ESS_HCTX_T; ObjType: ESS_OBJTYPE_T;
                   AppName, DbName: ESS_STR_T; pCount: ESS_PUSHORT_T;
                   ppObjList: ESS_PPOBJINFO_T): ESS_STS_T; stdcall;
function EssGetObject(hCtx: ESS_HCTX_T; ObjType: ESS_OBJTYPE_T;
                   AppName, DbName, ObjName, LocalName: ESS_STR_T;
                   Lock: ESS_BOOL_T): ESS_STS_T; stdcall;
function EssPutObject(hCtx: ESS_HCTX_T; ObjType: ESS_OBJTYPE_T;
                   AppName, DbName, ObjName, LocalName: ESS_STR_T;
                   Unlock: ESS_BOOL_T): ESS_STS_T; stdcall;
function EssLockObject(hCtx: ESS_HCTX_T; ObjType: ESS_OBJTYPE_T;
                   AppName, DbName, ObjName: ESS_STR_T): ESS_STS_T; stdcall;
function EssUnlockObject(hCtx: ESS_HCTX_T; ObjType: ESS_OBJTYPE_T;
                   AppName, DbName, ObjName: ESS_STR_T): ESS_STS_T; stdcall;
function EssCreateObject(hCtx: ESS_HCTX_T; ObjType: ESS_OBJTYPE_T;
                   AppName, DbName, ObjName: ESS_STR_T): ESS_STS_T; stdcall;
function EssDeleteObject(hCtx: ESS_HCTX_T; ObjType: ESS_OBJTYPE_T;
                   AppName, DbName, ObjName: ESS_STR_T): ESS_STS_T; stdcall;
function EssRenameObject(hCtx: ESS_HCTX_T; ObjType: ESS_OBJTYPE_T;
                   AppName, DbName, OldName, NewName: ESS_STR_T): ESS_STS_T; stdcall;
function EssCopyObject(hCtx: ESS_HCTX_T; ESS_HCTX_T, ObjType: ESS_OBJTYPE_T;
                   SrcApp, DestApp,SrcDb, DestDb, SrcObj, DestObj: ESS_STR_T): ESS_STS_T; stdcall;


(*
   Alias Table Functions

function EssLoadAlias(hCtx: ESS_HCTX_T; ESS_STR_T, ESS_STR_T): ESS_STS_T;
function EssRemoveAlias(hCtx: ESS_HCTX_T; ESS_STR_T): ESS_STS_T;
function EssListAliases(hCtx: ESS_HCTX_T; ESS_PUSHORT_T, ESS_PPALIASNAME_T): ESS_STS_T;
function EssSetAlias(hCtx: ESS_HCTX_T; ESS_STR_T): ESS_STS_T;
function EssGetAlias(hCtx: ESS_HCTX_T; ESS_PSTR_T): ESS_STS_T;
function EssDisplayAlias(hCtx: ESS_HCTX_T; ESS_STR_T, ESS_PUSHORT_T,
                            ESS_PPMBRALT_T): ESS_STS_T;
function EssClearAliases(hCtx: ESS_HCTX_T): ESS_STS_T;


(*
   User Administration Functions

function EssListUsers(hCtx: ESS_HCTX_T; ESS_STR_T, ESS_STR_T, ESS_PUSHORT_T,
                              ESS_PPUSERINFO_T): ESS_STS_T;
function EssCreateUser(hCtx: ESS_HCTX_T; ESS_STR_T, ESS_STR_T): ESS_STS_T;
function EssDeleteUser(hCtx: ESS_HCTX_T; ESS_STR_T): ESS_STS_T;
function EssRenameUser(hCtx: ESS_HCTX_T; ESS_STR_T, ESS_STR_T): ESS_STS_T;
function EssGetUser(hCtx: ESS_HCTX_T; ESS_STR_T, ESS_PPUSERINFO_T): ESS_STS_T;
function EssSetUser(hCtx: ESS_HCTX_T; ESS_PUSERINFO_T): ESS_STS_T;
function EssSetPassword(hCtx: ESS_HCTX_T; ESS_STR_T, ESS_STR_T): ESS_STS_T;
function EssListConnections(hCtx: ESS_HCTX_T; ESS_PUSHORT_T, ESS_PPUSERINFO_T): ESS_STS_T;
function EssListLocks(hCtx: ESS_HCTX_T; ESS_STR_T, ESS_STR_T, ESS_PUSHORT_T,
                              ESS_PPLOCKINFO_T): ESS_STS_T;
function EssRemoveLocks(hCtx: ESS_HCTX_T; ESS_STR_T, ESS_STR_T, ESS_LOGINID_T): ESS_STS_T;
function EssGetApplicationAccess(hCtx: ESS_HCTX_T; ESS_STR_T, ESS_STR_T,
                              ESS_PUSHORT_T, ESS_PPUSERAPP_T): ESS_STS_T;
function EssSetApplicationAccess(hCtx: ESS_HCTX_T; ESS_USHORT_T, ESS_PUSERAPP_T): ESS_STS_T;
function EssGetDatabaseAccess(hCtx: ESS_HCTX_T; ESS_STR_T, ESS_STR_T, ESS_STR_T,
                              ESS_PUSHORT_T, ESS_PPUSERDB_T): ESS_STS_T;
function EssSetDatabaseAccess(hCtx: ESS_HCTX_T; ESS_USHORT_T, ESS_PUSERDB_T): ESS_STS_T;
function EssGetCalcList(hCtx: ESS_HCTX_T; ESS_STR_T, ESS_STR_T, ESS_STR_T,
                              ESS_PBOOL_T, ESS_PUSHORT_T, ESS_PPOBJNAME_T): ESS_STS_T;
function EssSetCalcList(hCtx: ESS_HCTX_T; ESS_STR_T, ESS_STR_T, ESS_STR_T,
                              ESS_BOOL_T, ESS_USHORT_T, ESS_POBJNAME_T): ESS_STS_T;

(*
   Group Administration Functions

function EssListGroups(hCtx: ESS_HCTX_T; ESS_STR_T, ESS_STR_T, ESS_PUSHORT_T,
                              ESS_PPGROUPINFO_T): ESS_STS_T;
function EssCreateGroup(hCtx: ESS_HCTX_T; ESS_STR_T): ESS_STS_T;
     EssDeleteGroup     EssDeleteUser
     EssRenameGroup     EssRenameUser
     EssGetGroup        EssGetUser
     EssSetGroup        EssSetUser
function EssGetGroupList(hCtx: ESS_HCTX_T; ESS_STR_T, ESS_PUSHORT_T,
                              ESS_PPUSERNAME_T): ESS_STS_T;
function EssSetGroupList(hCtx: ESS_HCTX_T; ESS_STR_T, ESS_USHORT_T,
                              ESS_PUSERNAME_T): ESS_STS_T;
function EssAddToGroup(hCtx: ESS_HCTX_T; ESS_STR_T, ESS_STR_T): ESS_STS_T;
function EssDeleteFromGroup(hCtx: ESS_HCTX_T; ESS_STR_T, ESS_STR_T): ESS_STS_T;


(*
   Security Filter Functions

function EssListFilters(hCtx: ESS_HCTX_T; ESS_STR_T, ESS_STR_T, ESS_PUSHORT_T,
                              ESS_PPFTRNAME_T): ESS_STS_T;
function EssGetFilter(hCtx: ESS_HCTX_T; ESS_STR_T, ESS_STR_T, ESS_STR_T,
                              ESS_PBOOL_T, ESS_PACCESS_T): ESS_STS_T;
function EssGetFilterRow(hCtx: ESS_HCTX_T; ESS_PSTR_T, ESS_PACCESS_T): ESS_STS_T;
function EssSetFilter(hCtx: ESS_HCTX_T; ESS_STR_T, ESS_STR_T, ESS_STR_T,
                              ESS_BOOL_T, ESS_ACCESS_T): ESS_STS_T;
function EssSetFilterRow(hCtx: ESS_HCTX_T; ESS_STR_T, ESS_ACCESS_T): ESS_STS_T;
function EssGetFilterList(hCtx: ESS_HCTX_T; ESS_STR_T, ESS_STR_T, ESS_STR_T,
                              ESS_PUSHORT_T, ESS_PPUSERNAME_T): ESS_STS_T;
function EssSetFilterList(hCtx: ESS_HCTX_T; ESS_STR_T, ESS_STR_T, ESS_STR_T,
                              ESS_USHORT_T, ESS_PUSERNAME_T): ESS_STS_T;
function EssDeleteFilter(hCtx: ESS_HCTX_T; ESS_STR_T, ESS_STR_T, ESS_STR_T): ESS_STS_T;
function EssRenameFilter(hCtx: ESS_HCTX_T; ESS_STR_T, ESS_STR_T, ESS_STR_T,
                              ESS_STR_T): ESS_STS_T;
function EssCopyFilter(hCtx: ESS_HCTX_T; ESS_HCTX_T, ESS_STR_T, ESS_STR_T,
                              ESS_STR_T, ESS_STR_T, ESS_STR_T, ESS_STR_T): ESS_STS_T;
function EssVerifyFilter(hCtx: ESS_HCTX_T; ESS_STR_T, ESS_STR_T): ESS_STS_T;
function EssVerifyFilterRow(hCtx: ESS_HCTX_T; ESS_STR_T): ESS_STS_T;

*)
(*
   Miscellaneous Functions
*)

function EssGetProcessState(hCtx: ESS_HCTX_T;
                            pProcState: ESS_PPROCSTATE_T): ESS_STS_T; stdcall;
function EssCancelProcess(hCtx: ESS_HCTX_T): ESS_STS_T; stdcall;
function EssGetLogFile(hCtx: ESS_HCTX_T; AppName: ESS_STR_T;
                       TimeStamp: ESS_TIME_T; LocalName: ESS_STR_T): ESS_STS_T; stdcall;
function EssDeleteLogFile(hCtx: ESS_HCTX_T; AppName: ESS_STR_T): ESS_STS_T; stdcall;
function EssGetGlobalState(hCtx: ESS_HCTX_T;
                           ppGlobalState: ESS_PPGLOBAL_T): ESS_STS_T; stdcall;
function EssSetGlobalState(hCtx: ESS_HCTX_T;
                           pGlobalState: ESS_PGLOBAL_T): ESS_STS_T; stdcall;


(*
   Memory Allocation Functions
*)

function EssAlloc(hInstance: ESS_HINST_T; Size: ESS_SIZE_T;
                  ppBlock: ESS_PPVOID_T): ESS_STS_T; stdcall;
function EssRealloc(hInstance: ESS_HINST_T; Size: ESS_SIZE_T;
                    ppBlock: ESS_PPVOID_T): ESS_STS_T; stdcall;
function EssFree(hInstance: ESS_HINST_T; ppBlock: ESS_PVOID_T): ESS_STS_T; stdcall;
function EssFreeMbrErr(hCtx: ESS_HCTX_T; ppMbrErr: ESS_PMBRERR_T): ESS_STS_T; stdcall;

(*
#include "essxlat.h"
*)

const
  essapin = 'ESSAPIN.DLL';

implementation

{ Externals from essapin.dll }

{Initialization & Login Functions}
function EssInit; External essapin name 'EssInit';
function EssTerm; External essapin name 'EssTerm';
function EssGetAPIVersion; External essapin name 'EssGetAPIVersion';
function EssLogin; External essapin name 'EssLogin';
function EssAutoLogin; External essapin name 'EssAutoLogin';
function EssLogout; External essapin name 'EssLogout';
function EssLogoutUser; External essapin name 'EssLogoutUser';
function EssCreateLocalContext; External essapin name 'EssCreateLocalContext';
function EssDeleteLocalContext; External essapin name 'EssDeleteLocalContext';
function EssGetVersion; External essapin name 'EssGetVersion';
function EssShutdownServer; External essapin name 'EssShutdownServer';

(*
   Application Functions
*)

function EssGetActive; External essapin name 'EssGetActive';
function EssSetActive; External essapin name 'EssSetActive';
function EssClearActive; External essapin name 'EssClearActive';
function EssListApplications; External essapin name 'EssListApplications';
function EssCreateApplication; External essapin name 'EssCreateApplication';
function EssDeleteApplication; External essapin name 'EssDeleteApplication';
function EssRenameApplication; External essapin name 'EssRenameApplication';
function EssCopyApplication; External essapin name 'EssCopyApplication';
function EssGetApplicationState; External essapin name 'EssGetApplicationState';
function EssSetApplicationState; External essapin name 'EssSetApplicationState';
function EssGetApplicationInfo; External essapin name 'EssGetApplicationInfo';
function EssGetApplicationInfoEx; External essapin name 'EssGetApplicationInfoEx';
function EssLoadApplication; External essapin name 'EssLoadApplication';
function EssUnloadApplication; External essapin name 'EssUnloadApplication';

(*
   Database Functions
*)

function EssListDatabases; External essapin name 'EssListDatabases';
function EssListCurrencyDatabases; External essapin name 'EssListCurrencyDatabases';
function EssCreateDatabase; External essapin name 'EssCreateDatabase';
function EssDeleteDatabase; External essapin name 'EssDeleteDatabase';
function EssRenameDatabase; External essapin name 'EssRenameDatabase';
function EssCopyDatabase; External essapin name 'EssCopyDatabase';
function EssGetDatabaseState; External essapin name 'EssGetDatabaseState';
function EssSetDatabaseState; External essapin name 'EssSetDatabaseState';
function EssGetDatabaseInfo; External essapin name 'EssGetDatabaseInfo';
function EssGetDatabaseInfoEx; External essapin name 'EssGetDatabaseInfoEx';
function EssGetDatabaseStats; External essapin name 'EssGetDatabaseStats';
function EssGetDatabaseNote; External essapin name 'EssGetDatabaseNote';
function EssSetDatabaseNote; External essapin name 'EssSetDatabaseNote';
function EssLoadDatabase; External essapin name 'EssLoadDatabase';
function EssUnloadDatabase; External essapin name 'EssUnloadDatabase';
function EssClearDatabase; External essapin name 'EssClearDatabase';
function EssCommitDatabase; External essapin name 'EssCommitDatabase';
function EssGetCurrencyRateInfo; External essapin name 'EssGetCurrencyRateInfo';

(*
   Database Member Functions
*)

function EssQueryDatabaseMembers; External essapin name 'EssQueryDatabaseMembers';
function EssCheckMemberName; External essapin name 'EssCheckMemberName';
function EssGetMemberInfo; External essapin name 'EssGetMemberInfo';
function EssGetMemberCalc; External essapin name 'EssGetMemberCalc';
function EssBuildDimension; External essapin name 'EssBuildDimension';
function EssGetDimensionInfo; External essapin name 'EssGetDimensionInfo';

(*
   Reporting/Updating/Calculation Functions
*)

function EssReport; External essapin name 'EssReport';
function EssBeginReport; External essapin name 'EssBeginReport';
function EssEndReport; External essapin name 'EssEndReport';
function EssUpdate; External essapin name 'EssUpdate';
function EssBeginUpdate; External essapin name 'EssBeginUpdate';
function EssEndUpdate; External essapin name 'EssEndUpdate';
function EssSendString; External essapin name 'EssSendString';
function EssGetString; External essapin name 'EssGetString';
function EssCalc; External essapin name 'EssCalc';
function EssBeginCalc; External essapin name 'EssBeginCalc';
function EssEndCalc; External essapin name 'EssEndCalc';
function EssDefaultCalc; External essapin name 'EssDefaultCalc';
function EssGetDefaultCalc; External essapin name 'EssGetDefaultCalc';
function EssSetDefaultCalc; External essapin name 'EssSetDefaultCalc';

(*
   File Functions
*)

function EssReportFile; External essapin name 'EssReportFile';
function EssUpdateFile; External essapin name 'EssUpdateFile';
function EssCalcFile; External essapin name 'EssCalcFile';
function EssSetDefaultCalcFile; External essapin name 'EssSetDefaultCalcFile';
function EssArchive; External essapin name 'EssArchive';
function EssRestore; External essapin name 'EssRestore';
function EssArchiveBegin; External essapin name 'EssArchiveBegin';
function EssArchiveEnd; External essapin name 'EssArchiveEnd';
function EssValidateDB; External essapin name 'EssValidateDB';
function EssImport; External essapin name 'EssImport';
function EssExport; External essapin name 'EssExport';

(*
   Object functions
*)

function EssGetLocalPath; External essapin name 'EssGetLocalPath';
function EssGetObjectInfo; External essapin name 'EssGetObjectInfo';
function EssListObjects; External essapin name 'EssListObjects';
function EssGetObject; External essapin name 'EssGetObject';
function EssPutObject; External essapin name 'EssPutObject';
function EssLockObject; External essapin name 'EssLockObject';
function EssUnlockObject; External essapin name 'EssUnlockObject';
function EssCreateObject; External essapin name 'EssCreateObject';
function EssDeleteObject; External essapin name 'EssDeleteObject';
function EssRenameObject; External essapin name 'EssRenameObject';
function EssCopyObject; External essapin name 'EssCopyObject';

(*
   Miscellaneous Functions
*)

function EssGetProcessState; External essapin name 'EssGetProcessState';
function EssCancelProcess; External essapin name 'EssCancelProcess';
function EssGetLogFile; External essapin name 'EssGetLogFile';
function EssDeleteLogFile; External essapin name 'EssDeleteLogFile';
function EssGetGlobalState; External essapin name 'EssGetGlobalState';
function EssSetGlobalState; External essapin name 'EssSetGlobalState';

(*
   Memory Allocation Functions
*)

function EssAlloc; External essapin name 'EssAlloc';
function EssRealloc; External essapin name 'EssRealloc';
function EssFree; External essapin name 'EssFree';
function EssFreeMbrErr; External essapin name 'EssFreeMbrErr';

end.
