unit Esslist;

{$I+}
{ $ DEFINE USEMEGA}

interface

uses SysUtils, WinTypes, WinProcs, Messages, Classes,
     Forms, Controls;

type
{Errors}
  EEssErr = Class(Exception);


{******************************************************************************}
{TEssList - an abstract class for custom lists}
{******************************************************************************}
  TEssList = class(TPersistent)
  private
    FList: TList;
  protected
    procedure Clear; virtual;
    procedure Add(Item: TObject); virtual;
    function Get(Index: Integer): TObject;
    procedure Put(Index: Integer; Item: TObject);
  public
    constructor Create;
    destructor Destroy; override;
    procedure Insert(Index: integer; Item: TObject); virtual;
    function Count: Integer;
    procedure Delete(index: integer);
    procedure Pack;
  end;

{******************************************************************************}
{TEsbList - an abstract class for custom lists that need to be stored}
{******************************************************************************
  TEsbListComponent = Class(TComponent)
  private
    FList: TList;
  protected
    procedure Clear; virtual;
    procedure Add(Item: TObject); virtual;
    procedure Insert(Index: integer; Item: TObject); virtual;
    function Get(Index: Integer): TObject;
    procedure Put(Index: Integer; Item: TObject);
  public
    constructor Create(AOwner: TComponent); override;
    destructor Destroy; override;
    function Count: Integer;
    procedure Delete(index: integer);
    procedure Pack;
  end;
}

{Procedures}

implementation

{******************************************************************************}
{TEssList -  Base class for member and dimension lists
{******************************************************************************}
constructor TEssList.Create;
begin
  FList := TList.Create;
end;

destructor TEssList.Destroy;
begin
  Clear;
  FList.Free;
  FList := nil;
  inherited Destroy;
end;

procedure TEssList.Clear;
begin
  FList.Clear;
end;

function TEssList.Count: Integer;
begin
  Result := FList.Count;
end;

procedure TEssList.Add(Item: TObject);
begin
  FList.Add(Item);
end;

function TEssList.Get(Index: Integer): TObject;
begin
  Result := nil;
  if (Index < 0) or (Index >= FList.Count) then
    raise EEssErr.Create('Index out of bounds');
  Result := FList[Index];
end;

procedure TEssList.Put(Index: Integer; Item: TObject);
begin
  if (Index < 0) or (Index >= FList.Count) then
    raise EEssErr.Create('Index out of bounds');
  FList[Index] := Item;
end;

procedure TEssList.Delete(index: integer);
begin
  FList.Delete(index);
end;

procedure TEssList.Insert(Index: integer; Item: TObject);
begin
  FList.Insert(Index, Item);
end;

procedure TEssList.Pack;
begin
  FList.Pack;
end;

{******************************************************************************}
{TEssListComponent -  Base class for member and dimension lists that need to be stored
{******************************************************************************
constructor TEssListComponent.Create(AOwner: TComponent);
begin
  inherited Create(AOwner);
  FList := TList.Create;
end;

destructor TEssListComponent.Destroy;
begin
  FList.Free;
  FList := nil;
  inherited Destroy;
end;

procedure TEssListComponent.Clear;
begin
  FList.Clear;
end;

function TEssListComponent.Count: Integer;
begin
  Result := FList.Count;
end;

procedure TEssListComponent.Add(Item: TObject);
begin
  FList.Add(Item);
end;

procedure TEssListComponent.Insert(Index: integer; Item: TObject);
begin
  FList.Insert(Index, Item);
end;

function TEssListComponent.Get(Index: Integer): TObject;
begin
  Result := nil;
  if (Index < 0) or (Index >= FList.Count) then
    raise EEsbErr.Create('Index out of bounds');
  Result := FList[Index];
end;

procedure TEssListComponent.Put(Index: Integer; Item: TObject);
begin
  if (Index < 0) or (Index >= FList.Count) then
    raise EEsbErr.Create('Index out of bounds');
  FList[Index] := Item;
end;

procedure TEssListComponent.Delete(index: integer);
begin
  FList.Delete(index);
end;

procedure TEssListComponent.Pack;
begin
  FList.Pack;
end;
}

end.
