unit Essoutline;

interface

uses essapi32, SysUtils, WinTypes, WinProcs, Messages, Classes,
     Forms, Controls, Outline, StdCtrls, Graphics, Grids, Menus,
     Essapi32Connection, Esslist, DsgnIntf, ExtCtrls, Tabs,
     dialogs, Buttons;

type

  TEssMemberDisplay = (mdMember, mdAlias);

  TEssOutline = class(TCustomOutLine)
  private
    FEssDataSource: TEssDataSource;
    FmemberDisplay: TEssMemberDisplay;
    function getConnection: TEssDBConnection;
    function GetMemberName(Index: LongInt): string;
    procedure setConnection(NewConnection: TEssDBConnection);
    procedure setDisplayLabel(MDisplay: TEssMemberDisplay);
    procedure doLabels;
  protected
    procedure Expand(Index: LongInt); override;
    procedure Connect(Sender: TObject); virtual;
    procedure Disconnect(Sender: TObject); virtual;
  public
    constructor Create(AOwner: TComponent); override;
    destructor Destroy; override;
    procedure FillChildren(Index: LongInt);
    property MemberName[Index: LongInt]: string read getMemberName;
  published
    property Connection: TEssDBConnection read getConnection write setConnection;
    property DisplayLabel: TEssMemberDisplay read FMemberDisplay write setDisplayLabel;
{    property Lines;}
    property OutlineStyle;
    property OnExpand;
    property OnCollapse;
    property Options;
    property Style;
    property ItemHeight;
    property OnDrawItem;
    property Align;
    property Enabled;
    property Font;
    property Color;
    property ParentColor;
    property ParentCtl3D;
    property Ctl3D;
    property TabOrder;
    property TabStop;
    property Visible;
    property OnClick;
    property DragMode;
    property DragCursor;
    property OnDragDrop;
    property OnDragOver;
    property OnEndDrag;
    property OnEnter;
    property OnExit;
    property OnMouseDown;
    property OnMouseMove;
    property OnMouseUp;
    property OnDblClick;
    property OnKeyDown;
    property OnKeyPress;
    property OnKeyUp;
    property BorderStyle;
{    property ItemSeparator;}
    property PicturePlus;
    property PictureMinus;
    property PictureOpen;
    property PictureClosed;
    property PictureLeaf;
    property ParentFont;
    property ParentShowHint;
    property ShowHint;
    property PopupMenu;
    property ScrollBars;
  end;

{
procedure Register;
}
implementation

constructor TEssOutline.Create(AOwner: TComponent);
begin
  inherited Create(AOwner);
  FMemberDisplay := mdMember;
  FEssDataSource := TEssDataSource.Create(Self);
  FEssDataSource.OnConnect := Connect;
  FEssDataSource.OnDisconnect := Disconnect;
end;

destructor TEssOutline.Destroy;
begin
  clear;
  inherited Destroy;
end;

function TEssOutline.getConnection: TEssDBConnection;
begin
  Result := FEssDataSource.Connection;
end;

procedure TEssOutline.setConnection(NewConnection: TEssDBConnection);
begin
  if NewConnection = FEssDataSource.Connection then
    exit;
  Disconnect(nil);
  FEssDataSource.Connection := NewConnection;
  if (FEssDataSource.Connection <> nil)
    and FEssDataSource.Connection.Connected then
    Connect(nil);
end;

procedure TEssOutline.Connect(Sender: TObject);
var
  i, x: integer;
  Idx: LongInt;

begin

  if FEssDataSource.Connection = nil then
    exit;

  with FEssDataSource.Connection do begin

    {make sure we're connected to a specific database, not just the server}
    if not Connected then
      exit;

    Screen.Cursor := crHourglass;
    try
      for i := 0 to Database.DimCount - 1 do begin
        case FMemberDisplay of
          mdMember: Idx := AddChildObject(0, Database.Dimensions[i].Name, Database.Dimensions[i]);
          mdAlias: Idx := AddChildObject(0, Database.Dimensions[i].Alias, Database.Dimensions[i]);
        end;
        with Database.Dimensions[i] do begin
          for x := 0 to MbrCount - 1 do begin
            if Members[x].Name <> Name then
              case FMemberDisplay of
               mdMember: AddChildObject(Idx,Members[x].Name, Members[x]);
               mdAlias: AddChildObject(Idx,Members[x].Alias, Members[x]);
              end;
          end;
        end;
      end;
    finally
      Screen.Cursor := crDefault;
    end;

  end;

end;

procedure TEssOutline.Disconnect(Sender: TObject);
begin
  Clear;
end;

procedure TEssOutline.doLabels;
var
  idx: Longint;
begin
  {note: in outline items is 1 based}
  for idx := 1 to  ItemCount do
    case FMemberDisplay of
      mdMember: Items[idx].Text := TEssMemberBase(Items[idx].Data).Name;
      mdAlias: Items[idx].Text := TEssMemberBase(Items[idx].Data).Alias;
    end;
end;

procedure TEssOutline.setDisplayLabel(MDisplay: TEssMemberDisplay);
begin
  if MDisplay = FMemberDisplay then
    exit;
  FMemberDisplay := MDisplay;
  doLabels;
end;

function TEssOutline.GetMemberName(Index: LongInt): string;
begin
  Result := '';
  if Items[Index].Data <> nil then
    Result := TEssMemberBase(Items[Index].Data).Name;
end;

procedure TEssOutline.FillChildren(Index: LongInt);
var
  i, x: integer;
  idx: Longint;
  ThisMember: TEssMemberBase;
  exists: Longint;
begin
  if (Index <= 0) or (Index > ItemCount) then
    exit;
  if Items[Index].Data <> nil then
    if not (TObject(Items[Index].Data) is TEssMemberBase) then
      {dimesion children are populated at start}
      exit;
  Screen.Cursor := crHourglass;
  try
    ThisMember := TEssMemberBase(Items[Index].Data);
    with ThisMember do begin
      for i := 0 to mbrCount - 1 do begin
        case FMemberDisplay of
          mdMember: idx := GetTextItem(Members[i].Name);
          mdAlias: idx := GetTextItem(Members[i].Alias);
        end;
        if members[i].HasChildren and (members[i].Name <> Name) then begin
          for x := 0 to members[i].MbrCount - 1 do begin
            with members[i] do begin
              if Members[x].Name <> Name then
                case FMemberDisplay of
                  mdMember: exists := GetTextItem(Members[x].Name);
                  mdAlias: exists := GetTextItem(Members[x].Alias);
                end;
              if Exists  = 0 then
                case FMemberDisplay of
                  mdMember: AddChildObject(idx,Members[x].Name, Members[x]);
                  mdAlias: AddChildObject(idx,Members[x].Alias, Members[x]);
                end;
            end;
          end;
        end;
      end;
    end;

  finally
    Screen.Cursor := crDefault;
  end;

end;

procedure TEssOutline.Expand(Index: LongInt);
begin
  inherited Expand(Index);
  FillChildren(Index);
end;

end.

