unit Essreg;

interface

uses SysUtils, Classes, Graphics, Controls, Forms, DsgnIntf,
     Dialogs;


procedure Register;

implementation

uses  Essapi32Connection,
      EssOutline;

{ TEssSvrConnectionProperty }

type
  TEssSvrConnectionProperty = class(TComponentProperty)
  public
    procedure GetValues(Proc: TGetStrProc); override;
  end;

procedure TEssSvrConnectionProperty.GetValues(Proc: TGetStrProc);
var
  Linked: Boolean;
  I, J: Integer;
  Component: TComponent;
begin
  for I := 0 to Designer.Form.ComponentCount - 1 do
  begin
    Component := Designer.Form.Components[I];
    if (Component is TEssSvrConnection) and (Component.Name <> '') then
    begin
      Proc(Component.Name);
    end;
  end;
end;

{ TEsbDBConnectionProperty }

type
  TEssDBConnectionProperty = class(TComponentProperty)
  public
    procedure GetValues(Proc: TGetStrProc); override;
  end;

procedure TEssDBConnectionProperty.GetValues(Proc: TGetStrProc);
var
  Linked: Boolean;
  I, J: Integer;
  Component: TComponent;
begin
  for I := 0 to Designer.Form.ComponentCount - 1 do
  begin
    Component := Designer.Form.Components[I];
    if (Component is TEssDBConnection) and (Component.Name <> '') then
    begin
      Proc(Component.Name);
    end;
  end;
end;

{ TEssStringProperty }

type
  TEssStringProperty = class(TStringProperty)
  public
    function GetAttributes: TPropertyAttributes; override;
    procedure GetValueList(List: TStrings); virtual; abstract;
    procedure GetValues(Proc: TGetStrProc); override;
  end;

function TEssStringProperty.GetAttributes: TPropertyAttributes;
begin
  Result := [paValueList, paSortList, paMultiSelect];
end;

procedure TEssStringProperty.GetValues(Proc: TGetStrProc);
var
  I: Integer;
  Values: TStringList;
  Component: TComponent;
begin
  Values := TStringList.Create;
  try
    GetValueList(Values);
    for I := 0 to Values.Count - 1 do begin
{      for X := 0 to Designer.Form.ComponentCount - 1 do begin
        Component := Designer.Form.Components[X];
        if (Component is TEsbSliceBtn) and (Component.Name <> '') then
          if (Component as TEsbSliceBtn).Dimension <> Values[i] then
}
            Proc(Values[I]);
    end;
  finally
    Values.Free;
  end;
end;

procedure Register;
begin

  RegisterComponents('EssBase', [TEssSvrConnection,
                                 TEssDBConnection,
                                 TEssOutline]);

{
  RegisterPropertyEditor(TypeInfo(TEsbReport),
                         TEsbDataSet,
                         'Script',
                         TRptScriptPropertyEditor);

  RegisterPropertyEditor(TypeInfo(string),
                         TEsbSliceBtn,
                         'Dimension',
                         TEsbSliceDimProperty);

  RegisterPropertyEditor(TypeInfo(string),
                         TEsbSliceBtn,
                         'Member',
                         TSliceMbrPropertyEditor);
}
end;

end.
