{******************************************************************************}
{* Project:                                                                   *}
{* Unit:        dcfileio                                                      *}
{* Description: Misc Winapi calls                     *}
{*                                                                            *}
{* 1996,1997, Richard L. Chase, All Rights Reserved                          *}
{*                                                                            *}
{******************************************************************************}
unit dcfileio;

interface

uses Windows, SysUtils, Classes, Menus;

type

  TFileMenuItem = class(TMenuItem)
  private
    FFileName: string;
    FFileIndex: integer;
    procedure SetFileIndex(NewIndex: integer);
  public
    constructor CreateFileItem(AOwner: TComponent; FileName: string; Index: integer);
    property FileName: string read FFileName;
    property FileIndex: integer read FFileIndex write SetFileIndex;
  end;

function GetProperFileName(const FileName: String): String;

implementation

constructor TFileMenuItem.CreateFileItem(AOwner: TComponent; FileName: string; Index: integer);
begin
  inherited Create(AOwner);
  FFileName := GetProperFileName(FileName);
  FileIndex := Index;
end;

procedure TFileMenuItem.SetFileIndex(NewIndex: integer);
begin
  FFileIndex := NewIndex;
  Caption := '&' + IntToStr(FFileIndex) + ' ' + FFileName;
end;

function GetProperFileName(const FileName: String): String;
var
  Handle: THandle;
  FindData: TWin32FindData;
begin
  Result := FileName;

  Handle := FindFirstFile(PChar(FileName), FindData);
  if (Handle <> INVALID_HANDLE_VALUE) then
    begin
      Windows.FindClose(Handle);
      Result := ExtractFilePath(FileName) + FindData.cFileName;
    end;
end;

end.
