unit dmultisave;

interface

uses Windows, SysUtils, Classes, Graphics, Forms, Controls, StdCtrls, 
  Buttons, ExtCtrls;

type

  TMultiSaveResult = (srYes, srYesAll, srNo, srNoAll, srCancel);

  TdlgMultiSave = class(TForm)
    cmdCancel: TButton;
    lblMessage: TLabel;
    cmdYes: TButton;
    cmdYessAll: TButton;
    cmdNo: TButton;
    cmdNoAll: TButton;
    procedure FormCreate(Sender: TObject);
    procedure cmdYesClick(Sender: TObject);
    procedure cmdYessAllClick(Sender: TObject);
    procedure cmdNoClick(Sender: TObject);
    procedure cmdNoAllClick(Sender: TObject);
    procedure cmdCancelClick(Sender: TObject);
  private
    FResult: TMultiSaveResult;
    function getMessage: string;
    procedure setMessage(Value: string);
  public
    property SaveResult: TMultiSaveResult read fResult;
    property DisplayMessage: string read getMessage write setMessage;
  end;

var
  dlgMultiSave: TdlgMultiSave;

implementation

{$R *.DFM}

function TdlgMultiSave.getMessage: string;
begin
  Result := lblMessage.Caption;
end;

procedure TdlgMultiSave.setMessage(Value: string);
begin
  lblMessage.Caption := Value;
end;

procedure TdlgMultiSave.FormCreate(Sender: TObject);
begin
  FResult := srCancel;
end;

procedure TdlgMultiSave.cmdYesClick(Sender: TObject);
begin
  FResult := srYes;
  close;
end;

procedure TdlgMultiSave.cmdYessAllClick(Sender: TObject);
begin
  FResult := srYesAll;
  close;
end;

procedure TdlgMultiSave.cmdNoClick(Sender: TObject);
begin
  FResult := srNo;
  close;
end;

procedure TdlgMultiSave.cmdNoAllClick(Sender: TObject);
begin
  FResult := srNoAll;
  close;
end;

procedure TdlgMultiSave.cmdCancelClick(Sender: TObject);
begin
  Close;
end;

end.
