unit doptions95;

interface

uses
  SysUtils, Windows, Messages, Classes, Graphics, Controls,
  StdCtrls, ExtCtrls, Forms, ComCtrls, javaeditdefs, Shellapi,
  Dialogs, dclstview, Clipbrd, Menus, dMultiSave;

type
  TdlgOptions95 = class(TForm)
    pgcProjectOptions: TPageControl;
    tsDocuments: TTabSheet;
    ilstLarge: TImageList;
    ilstSmall: TImageList;
    tbcDisplay: TTabControl;
    pnlDisplay: TPanel;
    rgpDisplay: TRadioGroup;
    lvDocuments: TDCListView;
    mnpDocument: TPopupMenu;
    mnpDocumentOpen: TMenuItem;
    mnpDocumentDelete: TMenuItem;
    mnpDocumentCut: TMenuItem;
    mnpDocumentCopy: TMenuItem;
    mnpDocumentPaste: TMenuItem;
    N1: TMenuItem;
    mnpCompile: TMenuItem;
    pnlButtonsBottom: TPanel;
    pnlButtonsRight: TPanel;
    cmdOK: TButton;
    pnlName: TPanel;
    edtProjectName: TEdit;
    Label1: TLabel;
    mnpBrowse: TMenuItem;
    mnpAdd: TMenuItem;
    tsCompiler: TTabSheet;
    Label5: TLabel;
    edtDirectory: TEdit;
    Label3: TLabel;
    edtClassPath: TEdit;
    Bevel1: TBevel;
    chkShowWarn: TCheckBox;
    chkOptimize: TCheckBox;
    chkDebugInfo: TCheckBox;
    chkVerbose: TCheckBox;
    procedure FormCreate(Sender: TObject);
    procedure cmdOKClick(Sender: TObject);
    procedure rgpDisplayClick(Sender: TObject);
    procedure FormDestroy(Sender: TObject);
    procedure lvDocumentsFileDrop(Files: TStrings; X, Y: Integer);
    procedure tbcDisplayChange(Sender: TObject);
    procedure lvDocumentsDblClick(Sender: TObject);
    procedure mnpDocumentPopup(Sender: TObject);
    procedure mnpDocumentOpenClick(Sender: TObject);
    procedure doDelete(Sender: TObject);
    procedure doCopy(Sender: TObject);
    procedure doCut(Sender: TObject);
    procedure doPaste(Sender: TObject);
    procedure lvDocumentsKeyUp(Sender: TObject; var Key: Word;
      Shift: TShiftState);
    procedure mnpAddClick(Sender: TObject);
    procedure FormActivate(Sender: TObject);
    procedure lvDocumentsEdited(Sender: TObject; Item: TListItem;
      var S: string);
    procedure mnpCompileClick(Sender: TObject);
    procedure mnpBrowseClick(Sender: TObject);
    procedure FormClose(Sender: TObject; var Action: TCloseAction);
    procedure edtProjectNameChange(Sender: TObject);
  private
    FLoadingProject: Boolean;
    FProject: TProject;
    FJavaList: TStringList;
    FHTMLList: TStringList;
    FTextList: TStringList;
    FOtherList: TStringList;
    procedure setProject(NewProject: TProject);
    procedure InitDocLists;
    procedure DocNameChange(Sender: TObject);
  public
    function isSelection: Boolean;
    procedure DisplayDocs;
    procedure SaveOptions;
    property Project: TProject write setProject;
  end;

var
  dlgOptions95: TdlgOptions95;

implementation

{$R *.DFM}
{$R JEBMPS95.RES}

uses fmain;

const
  itBitmap: TResType = Controls.rtBitmap; // Reference for duplicate identifier

procedure TdlgOptions95.InitDocLists;
begin
  FJavaList.Clear;
  FHTMLList.Clear;
  FTextList.Clear;
  FOtherList.Clear;
  if FProject = nil then
    exit;
  FProject.GetDocList(FJavaList, dtJava);
  FProject.GetDocList(FHtmlList, dtHtml);
  FProject.GetDocList(FTextList, dtText);
  FProject.GetDocList(FOtherList, dtOther);
end;

procedure TdlgOptions95.setProject(NewProject: TProject);
begin
  FLoadingProject := True;
  try
  if FProject <> nil then
    FProject.OnDocNameChange := nil;
  FProject := NewProject;
  edtProjectName.Enabled := (FProject <> nil);
  edtClassPath.Enabled := (FProject <> nil);
  edtDirectory.Enabled := (FProject <> nil);
  chkShowWarn.Enabled := (FProject <> nil);
  chkOptimize.Enabled := (FProject <> nil);
  chkVerbose.Enabled := (FProject <> nil);
  chkDebugInfo.Enabled := (FProject <> nil);
  if FProject = nil then begin
    edtProjectName.Text := '';
    edtClassPath.Text := '';
    edtDirectory.Text := '';
    chkShowWarn.Checked := False;
    chkOptimize.Checked := False;
    chkVerbose.Checked := False;
    chkDebugInfo.Checked := False;
    exit;
  end
  else begin
    FProject.OnDocNameChange := DocNameChange;
    edtProjectName.Text := FProject.Name;
    {Get Compiler Options}
    edtClassPath.Text := FProject.ClassPath;
    edtDirectory.Text := FProject.OutputPath;
    chkShowWarn.Checked := (pos('-nowarn',FProject.CompileOptions) = 0);
    chkOptimize.Checked := (pos('-O',FProject.CompileOptions) > 0);
    chkVerbose.Checked := (pos('-verbose',FProject.CompileOptions) > 0);
    chkDebugInfo.Checked := (pos('-g',FProject.CompileOptions) > 0);
  end;
  {get Documents}
  DisplayDocs;
  finally
    FLoadingProject := False;
  end;
end;

procedure TdlgOptions95.DocNameChange(Sender: TObject);
begin
  DisplayDocs;
end;

procedure TdlgOptions95.DisplayDocs;
var
  NewItem : TListItem;

  procedure LoadFileInfo(Item: TListItem);
  var
    tmpDocument: TDocument;
    fHandle: THandle;
  begin
    tmpDocument := FProject.Retrieve(NewItem.Caption);
    Item.SubItems.Add(tmpDocument.FilePath);
    fHandle := FileOpen(tmpDocument.FilePath + tmpDocument.FileName, fmOpenRead);
    if fHandle > - 1 then
      try
        NewItem.SubItems.Add(DateTimeToStr(FileDateToDateTime(FileGetDate(fHandle))));
{        NewItem.SubItems.Add('Size');}
      finally
        FileClose(fHandle);
      end;
  end;

  procedure LoadJava;
  var
    i: integer;
  begin
    for i := 0 to FJavaList.Count - 1 do begin
      NewItem := lvDocuments.Items.Add;
      NewItem.Caption := FJavaList[i];
      LoadFileInfo(NewItem);
      if i = 0 then
         NewItem.ImageIndex := 1
      else NewItem.ImageIndex := 1;
    end;
  end;

  procedure LoadHtml;
  var
    i: integer;
  begin
    for i := 0 to FHtmlList.Count - 1 do begin
      NewItem := lvDocuments.Items.Add;
      NewItem.Caption := FHtmlList[i];
      LoadFileInfo(NewItem);
      NewItem.ImageIndex := 2;
    end;
  end;

  procedure LoadText;
  var
    i: integer;
  begin
    for i := 0 to FTextList.Count - 1 do begin
      NewItem := lvDocuments.Items.Add;
      NewItem.Caption := FTextList[i];
      LoadFileInfo(NewItem);
      NewItem.ImageIndex := 3;
    end;
  end;

  procedure LoadOther;
  var
    i: integer;
  begin
    for i := 0 to FOtherList.Count - 1 do begin
      NewItem := lvDocuments.Items.Add;
      NewItem.Caption := FOtherList[i];
      LoadFileInfo(NewItem);
      NewItem.ImageIndex := 4;
    end;
  end;

begin

  lvDocuments.Items.Clear;
  InitDocLists;
  case tbcDisplay.TabIndex of
    0: begin
       {All}
       LoadJava;
       LoadHtml;
       LoadText;
       LoadOther;
       end;
    1: LoadJava;
    2: LoadHtml;
    3: LoadText;
    4: LoadOther;
  end;
  lvDocuments.Refresh;

end;

procedure TdlgOptions95.FormCreate(Sender: TObject);
begin
  {Load the Bitmaps}
  FLoadingProject := False;
  ilstLarge.ResourceLoad(itBitmap, 'JE_BMPLGDOC', clPurple);
  ilstSmall.ResourceLoad(itBitmap, 'JE_BMPSMDOC', clPurple);
  FJavaList := TStringList.Create;
  FHTMLList := TStringList.Create;
  FTextList := TStringList.Create;
  FOtherList := TStringList.Create;
  edtClassPath.Text := '';
  edtDirectory.Text := '';
  chkShowWarn.Checked := False;
  chkOptimize.Checked := False;
  chkVerbose.Checked := False;
  chkDebugInfo.Checked := False;
end;

procedure TdlgOptions95.cmdOKClick(Sender: TObject);
begin
  SaveOptions;
  close;
end;

procedure TdlgOptions95.SaveOptions;
var
  NewOptions: String;
begin

  if (FProject = nil) or FLoadingProject then
    exit;

  FProject.Name := Trim(edtProjectName.Text);
  FProject.ClassPath := Trim(edtClassPath.Text);
  FProject.OutputPath := Trim(edtDirectory.Text);

  NewOptions := '';
  if not chkShowWarn.Checked then
    NewOptions := ' -nowarn';
  if chkOptimize.Checked then
    NewOptions := NewOptions + ' -O';
  if chkVerbose.Checked then
    NewOptions := NewOptions + ' -verbose';
  if chkDebugInfo.Checked then
    NewOptions := NewOptions + ' -g';

  FProject.CompileOptions := NewOptions;

end;

procedure TdlgOptions95.rgpDisplayClick(Sender: TObject);
begin
  case rgpDisplay.ItemIndex of
    0: lvDocuments.ViewStyle := vsIcon;
    1: lvDocuments.ViewStyle := vsList;
    2: lvDocuments.ViewStyle := vsReport;
  end;
end;

procedure TdlgOptions95.FormDestroy(Sender: TObject);
begin
  FJavaList.Free;
  FHTMLList.Free;
  FTextList.Free;
  FOtherList.Free;
end;

procedure TdlgOptions95.lvDocumentsFileDrop(Files: TStrings; X, Y: Integer);
var
  i: integer;
begin
  if FProject = nil then
    frmMain.NewProject(Self);
  for i := 0 to Files.Count - 1 do
    FProject.AddLoad(Files[i]);
  DisplayDocs;
end;

procedure TdlgOptions95.tbcDisplayChange(Sender: TObject);
begin
  DisplayDocs;
end;

procedure TdlgOptions95.lvDocumentsDblClick(Sender: TObject);
var
  i: integer;
  DocName: string;
begin

  for i := 0 to lvDocuments.Items.Count - 1 do begin
    if lvDocuments.Items[i].Selected then begin
      DocName := lvDocuments.Items[i].caption;
      break;
    end;
  end;

  if length(DocName) >0 then begin
    frmMain.OpenProjectFile(DocName);
  end;

end;

function TdlgOptions95.isSelection: Boolean;
var
  i: integer;
begin
  Result := False;
  for i := 0 to lvDocuments.Items.Count - 1 do begin
    if lvDocuments.Items[i].Selected then begin
      mnpCompile.Enabled := TypeFromExtension(ExtractFileExt(lvDocuments.Items[i].Caption)) = dtJava;
      mnpBrowse.Enabled := TypeFromExtension(ExtractFileExt(lvDocuments.Items[i].Caption)) = dtHtml;
      Result := True;
      break;
    end;
  end;
end;

procedure TdlgOptions95.mnpDocumentPopup(Sender: TObject);
var
  i: integer;
  ItemSelected: Boolean;
begin

  mnpCompile.Enabled := False;
  mnpBrowse.Enabled := False;
  ItemSelected := isSelection;
  if ItemSelected then
    for i := 0 to lvDocuments.Items.Count - 1 do begin
      if lvDocuments.Items[i].Selected then begin
        mnpCompile.Enabled := TypeFromExtension(ExtractFileExt(lvDocuments.Items[i].Caption)) = dtJava;
        mnpBrowse.Enabled := TypeFromExtension(ExtractFileExt(lvDocuments.Items[i].Caption)) = dtHtml;
        break;
      end;
    end;

  mnpDocumentOpen.Enabled := ItemSelected;
  mnpDocumentDelete.Enabled := ItemSelected;
  mnpBrowse.Visible := mnpBrowse.Enabled;
  mnpCompile.Visible := mnpCompile.Enabled;

  mnpDocumentCut.Enabled := ItemSelected;
  mnpDocumentCopy.Enabled := ItemSelected;

  mnpDocumentPaste.Enabled :=  Clipboard.HasFormat(CF_TEXT)
                               and FileExists(Clipboard.AsText);

end;

procedure TdlgOptions95.mnpDocumentOpenClick(Sender: TObject);
var
  i: integer;
begin

  for i := 0 to lvDocuments.Items.Count - 1 do begin
    if lvDocuments.Items[i].Selected then
      frmMain.OpenProjectFile(lvDocuments.Items[i].caption);
  end;

end;

procedure TdlgOptions95.doDelete(Sender: TObject);
var
  i: integer;
begin
  for i := 0 to lvDocuments.Items.Count - 1 do begin
    if lvDocuments.Items[i].Selected then begin
      frmMain.CloseProjectFile(lvDocuments.Items[i].caption);
      FProject.Remove(lvDocuments.Items[i].caption);
    end;
  end;
  DisplayDocs;
end;

procedure TdlgOptions95.doCopy(Sender: TObject);
var
  i: integer;
begin
  for i := 0 to lvDocuments.Items.Count - 1 do begin
    if lvDocuments.Items[i].Selected then begin
      frmMain.CloseProjectFile(lvDocuments.Items[i].caption);
      Clipboard.SetTextBuf(PChar(FProject.DocumentFileName(lvDocuments.Items[i].caption)));
      break;
    end;
  end;
end;

procedure TdlgOptions95.doCut(Sender: TObject);
var
  i: integer;
begin
  for i := 0 to lvDocuments.Items.Count - 1 do begin
    if lvDocuments.Items[i].Selected then begin
      frmMain.CloseProjectFile(lvDocuments.Items[i].caption);
      Clipboard.SetTextBuf(PChar(FProject.DocumentFileName(lvDocuments.Items[i].caption)));
      FProject.Remove(lvDocuments.Items[i].caption);
      break;
    end;
  end;
  DisplayDocs;
end;

procedure TdlgOptions95.doPaste(Sender: TObject);
begin
  if Clipboard.HasFormat(CF_TEXT) then
    if FileExists(Clipboard.AsText) then
      FProject.AddLoad(Clipboard.AsText);
  DisplayDocs;
end;

procedure TdlgOptions95.lvDocumentsKeyUp(Sender: TObject; var Key: Word;
  Shift: TShiftState);
begin
  if Key = VK_DELETE then begin
    doDelete(Sender);
    DisplayDocs;
  end;
end;

procedure TdlgOptions95.mnpAddClick(Sender: TObject);
begin
  if tbcDisplay.TabIndex > 0 then
    frmMain.dlgOpen.FilterIndex := tbcDisplay.TabIndex;
  frmMain.mnuProjectAddDocClick(self);
end;

procedure TdlgOptions95.FormActivate(Sender: TObject);
begin
  DisplayDocs;
end;

procedure TdlgOptions95.lvDocumentsEdited(Sender: TObject; Item: TListItem;
  var S: string);
var
  tmpDocument: TDocument;
begin
  try
    tmpDocument := FProject.RenameDoc(Item.Caption, S);
  except
    begin
      S := Item.Caption;
      raise;
    end;
  end;
  S := tmpDocument.FileName;
end;

procedure TdlgOptions95.mnpCompileClick(Sender: TObject);
var
  i: integer;
begin

  for i := 0 to lvDocuments.Items.Count - 1 do begin
    if lvDocuments.Items[i].Selected then
      Break;
  end;
  frmMain.Compile(lvDocuments.Items[i].caption);

end;

procedure TdlgOptions95.mnpBrowseClick(Sender: TObject);
var
  i: integer;
begin
  for i := 0 to lvDocuments.Items.Count - 1 do begin
    if lvDocuments.Items[i].Selected then
      Break;
  end;
  frmMain.LoadInBrowser(lvDocuments.Items[i].caption);
end;

procedure TdlgOptions95.FormClose(Sender: TObject; var Action: TCloseAction);
begin
  SaveOptions;
  Action := caFree;
  frmMain.OptionDlgOpen := False;
end;

procedure TdlgOptions95.edtProjectNameChange(Sender: TObject);
begin
  SaveOptions;
end;

end.
