unit drunjava;

interface

uses Windows, SysUtils, Classes, Graphics, Forms, Controls, StdCtrls, 
  Buttons, ExtCtrls, JavaEditDefs;

type
  TdlgRunJava = class(TForm)
    cmdOK: TButton;
    cmdCancel: TButton;
    Bevel1: TBevel;
    Label1: TLabel;
    edtCommandLine: TEdit;
    procedure cmdOKClick(Sender: TObject);
    procedure cmdCancelClick(Sender: TObject);
  private
    { Private declarations }
  public
    { Public declarations }
  end;

var
  dlgRunJava: TdlgRunJava;

implementation

{$R *.DFM}

uses fMain;

procedure TdlgRunJava.cmdOKClick(Sender: TObject);
var
  StartupInfo: TStartupInfo;
  ProcessInfo: TProcessInformation;
  retval: Boolean;
  CommandLine: string;

begin

  if length(edtCommandLine.Text) = 0 then
    exit;

  FillChar(StartupInfo, SizeOf(TStartupInfo), 0);

  with StartupInfo do
  begin
    cb := SizeOf(TStartupInfo);
    dwFlags := STARTF_USESHOWWINDOW or STARTF_FORCEONFEEDBACK;
    wShowWindow := SW_SHOWNORMAL;
  end;

  CommandLine := '"' + PATH_JAVA + '" ' + edtCommandLine.Text;

  retval := CreateProcess(nil,                                {Application}
                       PChar(CommandLine),                    {Command Line}
                       nil,                                   {Process Security Attributes}
                       nil,                                   {Thread secuity attributes}
                       False,                                 {Inherit Hendles}
                       NORMAL_PRIORITY_CLASS or CREATE_NEW_CONSOLE,                 {Creation Flags}
                       nil,                                   {Environment}
                       nil,                                   {Current Directory}
                       StartupInfo,                           {Startup info}
                       ProcessInfo);                          {Process Info}

  if retval then begin
    with ProcessInfo do begin
      WaitForInputIdle(hProcess, INFINITE);
      CloseHandle(hThread);
      CloseHandle(hProcess);
    end;
  end else begin
    frmMain.StatusBar.SimpleText := 'Couldn''t start java interpreter.';
    messageBeep(0);
  end;
  Close;
end;

procedure TdlgRunJava.cmdCancelClick(Sender: TObject);
begin
  Close;
end;

end.
