{******************************************************************************}
{* Project:     JavaEdit                                                      *}
{* Unit:        dSettings                                                     *}
{* Description: Dialog for changing application sattings for Java Editor      *}
{*                                                                            *}
{* 1996, Richard L. Chase, All Rights Reserved                               *}
{*                                                                            *}
{* Types:                                                                     *}
{*    None                                                                    *}
{*                                                                            *}
{* Forms:                                                                     *}
{*    TdlgSettings - Straightforward app settings dialog -uses pages.         *}
{*       Sets Display font for documents, location of Java Compiler           *}
{*                                                                            *}
{* Procedures:                                                                *}
{*    None                                                                    *}
{*                                                                            *}
{* Functions:                                                                 *}
{*    None                                                                    *}
{*                                                                            *}
{******************************************************************************}
unit dsettings;

interface

uses
  SysUtils, Windows, Messages, Classes, Graphics, Controls,
  StdCtrls, ExtCtrls, Forms, ComCtrls, Spin, Dialogs, javaeditdefs, Buttons;

type
  TdlgSettings = class(TForm)
    cmdOK: TButton;
    cmdCancel: TButton;
    cmdHelp: TButton;
    PageControl: TPageControl;
    tsDisplay: TTabSheet;
    tsSettings: TTabSheet;
    cmbFontName: TComboBox;
    pnlSample: TPanel;
    Label1: TLabel;
    Label2: TLabel;
    spnFontSize: TSpinEdit;
    edtJavac: TEdit;
    cmdBrowseJavac: TButton;
    Label4: TLabel;
    dlgOpen: TOpenDialog;
    Label3: TLabel;
    edtBrowser: TEdit;
    cmdBrowseBrowser: TButton;
    spnTabSet: TSpinEdit;
    Label5: TLabel;
    cmdDefaultBrowser: TButton;
    chkDDE: TCheckBox;
    dlgColor: TColorDialog;
    cmdColorWindow: TSpeedButton;
    cmdColorFont: TSpeedButton;
    chkAutoIndent: TCheckBox;
    chkDocTabs: TCheckBox;
    procedure FormCreate(Sender: TObject);
    procedure cmbFontNameChange(Sender: TObject);
    procedure spnFontSizeChange(Sender: TObject);
    procedure FormCloseQuery(Sender: TObject; var CanClose: Boolean);
    procedure cmdBrowseJavacClick(Sender: TObject);
    procedure cmdOKClick(Sender: TObject);
    procedure cmdBrowseBrowserClick(Sender: TObject);
    procedure cmdDefaultBrowserClick(Sender: TObject);
    procedure cmdColorWindowClick(Sender: TObject);
    procedure cmdColorFontClick(Sender: TObject);
  end;

var
  dlgSettings: TdlgSettings;

implementation

{$R *.DFM}

uses fmain;

procedure TdlgSettings.FormCreate(Sender: TObject);
begin
  cmbFontName.Sorted := True;
  cmbFontName.Items := Screen.Fonts;
  cmbFontName.ItemIndex := cmbFontName.Items.IndexOf(frmMain.Font.Name);
  spnFontSize.Value := frmMain.Font.Size;
  edtJavac.Text := PATH_JAVAC;
  edtBrowser.Text := PATH_BROWSER;
  spnTabSet.Value := TABSET;
  pnlSample.Color := EDITCOLOR;
  pnlSample.Font.Color := frmMain.Font.Color;
  chkDDE.Checked := USEDDE;
  chkAutoIndent.Checked := AUTOINDENT;
  {
  chkWin95.Checked := USEWIN95;
  }
  chkDocTabs.Checked := DOCTABS;
end;

procedure TdlgSettings.cmbFontNameChange(Sender: TObject);
begin
  pnlSample.Font.Name := cmbFontName.Items[cmbFontName.ItemIndex];
end;

procedure TdlgSettings.spnFontSizeChange(Sender: TObject);
begin
  pnlSample.Font.Size := spnFontSize.Value;
end;

procedure TdlgSettings.FormCloseQuery(Sender: TObject;
  var CanClose: Boolean);
begin
  if (length(edtJavac.Text) > 0) and (not FileExists(edtJavac.Text)) then
    CanClose := False;
end;

procedure TdlgSettings.cmdBrowseJavacClick(Sender: TObject);
begin
  dlgOpen.FileName := 'javac.exe';
  dlgOpen.Filter := 'java compiler|javac.exe|All files|*.*';
  if dlgOpen.Execute then
    edtJavac.Text := dlgOpen.FileName;
end;

procedure TdlgSettings.cmdOKClick(Sender: TObject);
begin
{ Don't need anymore. Determining OS at startup
  if USEWIN95 <> chkWin95.Checked then begin
    frmMain.CloseProjectEditor;
  end;
  }
  frmMain.Font.Name := cmbFontName.Items[cmbFontName.ItemIndex];
  frmMain.Font.Size := spnFontSize.Value;
  frmMain.Font.Color := pnlSample.Font.Color;
  if (length(edtJavaC.Text) > 0) and FileExists(edtJavaC.Text) then begin
    PATH_JAVAC := edtJavac.Text;
    PATH_JAVA := copy(PATH_JAVAC,0,length(PATH_JAVAC) - length(EXE_JAVAC)) + EXE_JAVA;
    if not FileExists(PATH_JAVA) then
      PATH_JAVA := '';
  end
  else begin
    PATH_JavaC := '';
    PATH_JAVA := '';
  end;
  if (length(edtBrowser.Text) > 0) and FileExists(edtBrowser.Text) then
    PATH_BROWSER := edtBrowser.Text
  else PATH_BROWSER := '';
  TABSET := spnTabSet.Value;
  EDITCOLOR := pnlSample.Color;
  USEDDE := chkDDE.Checked;
  AUTOINDENT := chkAutoIndent.Checked;
  {
  USEWIN95 := chkWin95.Checked;
  }
  DOCTABS := chkDocTabs.Checked;
  ModalResult := mrOK;
end;

procedure TdlgSettings.cmdBrowseBrowserClick(Sender: TObject);
begin
  dlgOpen.FileName := '*.exe';
  dlgOpen.Filter := 'Application|*.exe|All files|*.*';
  if dlgOpen.Execute then
    edtBrowser.Text := dlgOpen.FileName;
end;

procedure TdlgSettings.cmdDefaultBrowserClick(Sender: TObject);
begin
  frmMain.GetBrowser;
  edtBrowser.Text := PATH_BROWSER;
end;

procedure TdlgSettings.cmdColorWindowClick(Sender: TObject);
begin
  dlgColor.Color := pnlSample.Color;
  if dlgColor.Execute then begin
    pnlSample.Color := dlgColor.Color;
  end;
end;

procedure TdlgSettings.cmdColorFontClick(Sender: TObject);
begin
  dlgColor.Color := pnlSample.Font.Color;
  if dlgColor.Execute then begin
    pnlSample.Font.Color := dlgColor.Color;
  end;
end;

end.
