{******************************************************************************}
{* Project:     JavaEdit                                                      *}
{* Unit:        fmain                                                         *}
{* Description: The main window for the app                                   *}
{*                                                                            *}
{* 1996,1997, Richard L. Chase, All Rights Reserved                               *}
{*                                                                            *}
{* Types:                                                                     *}
{*    None                                                                    *}
{*                                                                            *}
{* Forms:                                                                     *}
{*    TfrmMain - MDI form containing document views. Most document activities *}
{*      are handled by the child windows rather than here. This just calls    *}
{*      the apropriate child methods. Many components lige dialogs are on     *}
{*      this form, 'cause it's silly to create new instances with each child. *}
{*                                                                            *}
{* Procedures:                                                                *}
{*    None                                                                    *}
{*                                                                            *}
{* Functions:                                                                 *}
{*    None                                                                    *}
{*                                                                            *}
{******************************************************************************}
unit fmain;

interface

uses Windows, SysUtils, Classes, Graphics, Forms, Controls, Menus,
  StdCtrls, Dialogs, Buttons, Messages, ExtCtrls, ComCtrls,
  Clipbrd, Registry, DdeMan, FileCtrl, javaeditdefs, dosprocess, ShellApi,
  dMultiSave, printers;

type
  TfrmMain = class(TForm)
    mnuMain: TMainMenu;
    mnuFile: TMenuItem;
    mnuFileNew: TMenuItem;
    mnuFileOpenDoc: TMenuItem;
    mnuFileClose: TMenuItem;
    mnuWindow: TMenuItem;
    mnuHelp: TMenuItem;
    N1: TMenuItem;
    mnuFileExit: TMenuItem;
    mnuWindowCascade: TMenuItem;
    mnuWindowTile: TMenuItem;
    mnuWindowArrange: TMenuItem;
    mnuHelpAbout: TMenuItem;
    dlgOpen: TOpenDialog;
    mnuFileSave: TMenuItem;
    mnuFileSaveAs: TMenuItem;
    mnuEdit: TMenuItem;
    mnuEditCut: TMenuItem;
    mnuEditCopy: TMenuItem;
    mnuEditPaste: TMenuItem;
    mnuWindowMinimize: TMenuItem;
    SpeedPanel: TPanel;
    cmdOpen: TSpeedButton;
    cmdExit: TSpeedButton;
    StatusBar: TStatusBar;
    cmdSaveProject: TSpeedButton;
    dlgSave: TSaveDialog;
    cmdNew: TSpeedButton;
    dlgFind: TFindDialog;
    dlgReplace: TReplaceDialog;
    mnuEditUndo: TMenuItem;
    N2: TMenuItem;
    mnuSearch: TMenuItem;
    mnuSearchFind: TMenuItem;
    mnuSearchFindNext: TMenuItem;
    mnuSearchReplace: TMenuItem;
    mnuFileSaveAll: TMenuItem;
    mnuFilePrint: TMenuItem;
    N3: TMenuItem;
    mnuEditDelete: TMenuItem;
    mnpFileNew: TPopupMenu;
    mnpFileNewJava: TMenuItem;
    mnpFileNewHtml: TMenuItem;
    mnpFileNewText: TMenuItem;
    mnpFileNewOther: TMenuItem;
    mnuFileNewJava: TMenuItem;
    mnuFileNewHtml: TMenuItem;
    mnuFileNewText: TMenuItem;
    mnuFileNewOther: TMenuItem;
    cmdOpenProject: TSpeedButton;
    cmdNewProject: TSpeedButton;
    mnuFileNewProject: TMenuItem;
    N5: TMenuItem;
    mnuFileSaveProjectAs: TMenuItem;
    mnuFileCloseAll: TMenuItem;
    mnuRun: TMenuItem;
    mnuRunCompileDocument: TMenuItem;
    mnuRunLoadBrowser: TMenuItem;
    mnuRunAppletViewer: TMenuItem;
    mnuRunJava: TMenuItem;
    mnuFileConfigure: TMenuItem;
    N10: TMenuItem;
    mnuFileOpenProject: TMenuItem;
    mnuProject: TMenuItem;
    mnuProjectViewProjectManager: TMenuItem;
    N4: TMenuItem;
    DdeClientConv: TDdeClientConv;
    cmdConfigure: TSpeedButton;
    mnuFileReopen: TMenuItem;
    tcWindows: TTabControl;
    N7: TMenuItem;
    mnuProjectAddDoc: TMenuItem;
    mnuProjectRemoveDoc: TMenuItem;
    mnuProjectAddAllDoc: TMenuItem;
    N6: TMenuItem;
    mnuProjectAddActiveDoc: TMenuItem;
    N8: TMenuItem;
    mnuSearchGotoLine: TMenuItem;
    procedure FormCreate(Sender: TObject);
    procedure mnuWindowCascadeClick(Sender: TObject);
    procedure UpdateMenuItems(Sender: TObject);
    procedure mnuWindowTileClick(Sender: TObject);
    procedure mnuWindowArrangeClick(Sender: TObject);
    procedure CloseDoc(Sender: TObject);
    procedure OpenDocClick(Sender: TObject);
    procedure ExitApp(Sender: TObject);
    procedure SaveDoc(Sender: TObject);
    procedure SaveDocAs(Sender: TObject);
    procedure EditCut(Sender: TObject);
    procedure EditCopy(Sender: TObject);
    procedure EditPaste(Sender: TObject);
    procedure mnuWindowMinimizeClick(Sender: TObject);
    procedure FormDestroy(Sender: TObject);
    procedure SaveProjectClick(Sender: TObject);
    procedure SearchFind(Sender: TObject);
    procedure SearchFindNext(Sender: TObject);
    procedure SearchReplace(Sender: TObject);
    procedure EditUndo(Sender: TObject);
    procedure dlgFindFind(Sender: TObject);
    procedure dlgReplaceReplace(Sender: TObject);
    procedure mnuEditDeleteClick(Sender: TObject);
    procedure Configure(Sender: TObject);
    procedure mnuFileNewClick(Sender: TObject);
    procedure cmdNewClick(Sender: TObject);
    procedure mnuHelpAboutClick(Sender: TObject);
    procedure cmdCompileClick(Sender: TObject);
    procedure mnuFilePrintClick(Sender: TObject);
    procedure NewProject(Sender: TObject);
    procedure mnuProjectViewProjectManagerClick(Sender: TObject);
    procedure cmdOpenProjectClick(Sender: TObject);
    procedure mnuFileSaveProjectAsClick(Sender: TObject);
    procedure mnuFileCloseAllClick(Sender: TObject);
    procedure mnuRunLoadBrowserClick(Sender: TObject);
    procedure mnuRunJavaClick(Sender: TObject);
    procedure DdeClientConvClose(Sender: TObject);
    procedure FormShow(Sender: TObject);
    procedure dlgReplaceFind(Sender: TObject);
    procedure FormClose(Sender: TObject; var Action: TCloseAction);
    procedure mnuFileReopenDocClick(Sender: TObject);
    procedure mnuFileReopenProjClick(Sender: TObject);
    procedure tcWindowsChange(Sender: TObject);
    procedure mnuProjectAddDocClick(Sender: TObject);
    procedure mnuProjectRemoveDocClick(Sender: TObject);
    procedure mnuProjectAddAllDocClick(Sender: TObject);
    procedure mnuProjectClick(Sender: TObject);
    procedure mnuProjectAddActiveDocClick(Sender: TObject);
    procedure FormCloseQuery(Sender: TObject; var CanClose: Boolean);
    procedure mnuSearchGotoLineClick(Sender: TObject);
  private
    FDocTypes: TDocTypeList;
    FProject: TProject;
    FLastChild: integer;
    FLastFileType: integer;
    FOptionDlgOpen: Boolean;
    FLastX: integer;
    FLastY: integer;
    FLastWindowState: TWindowState;
    FLastProjects: TStringList;
    FLastDocs: TStringList;
    FdlgPrint: TPrintDialog;
    DocTabsChanging: Boolean;
    function CloseProject: Boolean;
    function getDocForm(DocName: string): Integer;
    function SaveChildren: TMultiSaveResult;
    function SaveProject: Boolean;
    function SaveProjectAs: Boolean;
    procedure WMDROPFILES(var Message: TWMDropFiles); message WM_DROPFILES;
    procedure CloseAllDocs;
    procedure doIni(Direction: TDirection);
    procedure FileDropped(Files: Tstrings; X, Y: Integer);
    procedure NewDoc(DocType: TDocumentType);
    procedure SaveIni;
    procedure SetOptionDlgOpen(Value: Boolean);
    procedure SetReopenList;
    procedure ShowHint(Sender: TObject);
  public
    function DocAlreadyOpen(FileName: string): Integer;
    function doSaveDocDialog(DocType: TDocumentType): Boolean;
    function doSaveProjectDialog: Boolean;
    function doOpenDoc: Boolean;
    function GetBrowser: boolean;
    procedure ActivateFileTab;
    procedure Compile(DocName: string);
    procedure GoToLine(Line: integer; FileName: string);
    procedure CloseProjectFile(DocName: string);
    procedure CloseProjectEditor;
    procedure LoadInBrowser(DocName: string);
    procedure OpenProjectFile(DocName: string);
    procedure RemoveFileTab(WinName: string);
    procedure SetDocList(FileName: string);
    procedure SetProjList(FileName: string);
    procedure UpdateFileTab(OldName, NewName: string);
    property DocTypeList: TDocTypeList read FDocTypes;
    property OptionDlgOpen: Boolean read FOptionDlgOpen write SetOptionDlgOpen;
    property Project: TProject read FProject;
    property dlgPrint: TPrintDialog read FdlgPrint;
  end;

var
  frmMain: TfrmMain;

implementation

{$R *.DFM}

uses dcfileio,
     cedit,
     cedit95,
     dsettings,
     dAbout,
     dOptions,
     dOptions95,
     drunjava,
     dgotoln;

var
  cOptions95: TdlgOptions95;
  cOptions: TdlgOptions;

function IsWin95Shell: boolean;
var
  foobar: TOSVersionInfo;
begin
{
    dwOSVersionInfoSize: DWORD;
    dwMajorVersion: DWORD;
    dwMinorVersion: DWORD;
    dwBuildNumber: DWORD;
    dwPlatformId: DWORD;
}
 result := false;
 foobar.dwOSVersionInfoSize := sizeof(TOSVERSIONINFO);
 if GetVersionEx(foobar) then
    result := foobar.dwmajorversion >=4;
end;

function TfrmMain.getDocForm(DocName: string): Integer;
var
  i: integer;
begin
  Result := -1;
  if USEWIN95 then
    for i := 0 to MDIChildCount - 1 do begin
      if MDIChildren[I] is TcwEdit95 then
        if (MDIChildren[I] as TcwEdit95).DocName = DocName then begin
          Result := i;
          break;
        end;
    end
  else
    for i := 0 to MDIChildCount - 1 do begin
      if MDIChildren[I] is TcwEdit then
        if (MDIChildren[I] as TcwEdit).DocName = DocName then begin
          Result := i;
          break;
        end;
    end;

end;

procedure TfrmMain.LoadInBrowser(DocName: string);
var
  DocFormID: integer;
begin
  OpenProjectFile(DocName);
  DocFormID := getDocForm(DocName);
  if USEWIN95 then begin
    if (DocFormID >= 0) and (MDIChildren[DocFormID] is TcwEdit95) then
        (MDIChildren[DocFormID] as TcwEdit95).LoadInBrowser;
  end
  else begin
    if (DocFormID >= 0) and (MDIChildren[DocFormID] is TcwEdit) then
        (MDIChildren[DocFormID] as TcwEdit).LoadInBrowser;
  end;
end;

procedure TfrmMain.Compile(DocName: string);
var
  DocFormID: integer;
begin
  OpenProjectFile(DocName);
  DocFormID := getDocForm(DocName);
  if USEWIN95 then begin
    if (DocFormID >= 0) and (MDIChildren[DocFormID] is TcwEdit95) then
        (MDIChildren[DocFormID] as TcwEdit95).Compile;
  end
  else begin
    if (DocFormID >= 0) and (MDIChildren[DocFormID] is TcwEdit) then
        (MDIChildren[DocFormID] as TcwEdit).Compile;
  end;
end;

function TfrmMain.GetBrowser: boolean;
var
  Registry: TRegistry;
  BrowserKeyName: string;
  DefBrowserCommand: string;
  OrigBrowser: string;
  i: integer;
begin

  {find default Html Viewer in registry}
  Result := False;
  Registry := TRegistry.Create;
  OrigBrowser := PATH_BROWSER;
  try
    with Registry do begin
      RootKey := HKEY_CLASSES_ROOT;
      if not OpenKey('.html', False) then
        exit;
      BrowserKeyName := ReadString('');
      if length(BrowserKeyName) = 0 then
        exit;
      CloseKey;
      if not OpenKey(BrowserKeyName, False) then
        exit;
      if not OpenKey('shell', False) then
        exit;
      if not OpenKey('open', False) then
        exit;
      if OpenKey('command', False) then
        DefBrowserCommand := ReadString('');
      if Length(DefBrowserCommand) = 0 then
        exit;
      {set PATH_BROWSER}
      i := pos('%1',DefBrowserCommand);
      if i > 0 then
        PATH_BROWSER := copy(DefBrowserCommand,1,i-2)
      else PATH_BROWSER := DefBrowserCommand;
      if not FileExists(PATH_BROWSER) then
        PATH_BROWSER := OrigBrowser;
      Result := True;
    end;
  finally
    Registry.Free;
  end;
end;

function TfrmMain.DoSaveDocDialog(DocType: TDocumentType): Boolean;
var
  tmpFilter: TDocFilter;
  Filter: string;
  i: integer;
begin
  tmpFilter := TDocFilter(FDocTypes.Objects[ord(DocType)]);
{  dlgSave.DefaultExt := tmpFilter.Extension;}
  dlgSave.DefaultExt := '';
  Filter := tmpFilter.Filter;
  for i := 0 to FDocTypes.Count - 1 do
    if i <> ord(DocType) then begin
      tmpFilter := TDocFilter(FDocTypes.Objects[i]);
      Filter := Filter + '|' + tmpFilter.Filter;
    end;
  dlgSave.Filter := Filter;
{  dlgSave.FilterIndex := ord(DocType);}
  dlgSave.FilterIndex := 1;
  dlgSave.FileName := '';
  Result := dlgSave.Execute;
  if result then begin
    dlgSave.InitialDir := ExtractFilePath(dlgSave.FileName);
    dlgOpen.InitialDir := dlgSave.InitialDir;
  end;

end;

function TFrmMain.doSaveProjectDialog: Boolean;
begin
  dlgSave.Filter := 'Java Editor Project (*.jpr)|*.jpr';
  dlgSave.DefaultExt := 'jpr';
  Result := dlgSave.Execute;
  if result then begin
    dlgSave.InitialDir := ExtractFilePath(dlgSave.FileName);
    dlgOpen.InitialDir := dlgSave.InitialDir;
  end;
end;

procedure TFrmMain.GoToLine(Line: integer; FileName: string);
var
  i: integer;
begin
  for i := MDIChildCount - 1 downto 0 do begin
    if MDIChildren[I] is TcwEdit then begin
      if (MDIChildren[I] as TcwEdit).FileName = FileName then begin
        MDIChildren[I].BringToFront;
        MDIChildren[I].SetFocus;
        (MDIChildren[I] as TcwEdit).GoToLine(Line);
        break;
      end;
    end
    else if MDIChildren[I] is TcwEdit95 then begin
      if (MDIChildren[I] as TcwEdit95).FileName = FileName then begin
        MDIChildren[I].BringToFront;
        MDIChildren[I].SetFocus;
        (MDIChildren[I] as TcwEdit95).GoToLine(Line);
        break;
      end;
    end;
  end;
end;

{**********************************************}
{*            Form Methods                    *}
{**********************************************}

procedure TfrmMain.FormCreate(Sender: TObject);
begin

  if (Printer.Printers.Count = 0) then
    FdlgPrint := nil
  else
    try
      FdlgPrint := TPrintDialog.Create(Self);
    except
      FdlgPrint := nil;
    end;

  FOptionDlgOpen := False;
  cOptions95 := nil;
  cOptions := nil;
  FDocTypes := nil;
  FLastProjects := nil;
  FLastDocs := nil;
  PATH_BROWSER := '';
  JAVAC_OPTIONS := '';
  JAVAC_CLASSPATH := '';
  JAVAC_DIRECTORY := '';
  NETSCAPEWINDOW := '0';
  NETSCAPEOPEN := False;
  USEDDE := True;
  TABSET := 4;
  AUTOINDENT := True;
  USEWIN95 := IsWin95Shell;
{  USEWIN95 := True;}
  EDITCOLOR := clWindow;
  DOCTABS := True;
  FProject := nil;
  FLastChild := 0;
  FDocTypes := TDocTypeList.Create;
  FLastFileType := 1;
  FLastX := 0;
  FLastY := 0;
  FLastWindowState := wsNormal;
  FLastProjects := TStringList.Create;
  FLastDocs := TStringList.Create;
  DocTabsChanging := False;
  tcWindows.Tabs.Clear;
  tcWindows.Visible := False;
  DragAcceptFiles(Handle, True);
{
  cmbDocType.Items.clear;
  for i := 0 to FDocTypes.Count - 1 do
    cmbDocType.Items.Add(FDocTypes[i]);
}
  doIni(dLoad);
  if length(PATH_BROWSER) = 0 then
    GetBrowser;
  doIni(dSave);
  Application.OnHint := ShowHint;
  Screen.OnActiveFormChange := UpdateMenuItems;
  dlgOpen.FilterIndex := FLastFileType;
  dlgOpen.InitialDir := ExtractFilePath(ParamStr(0));
  dlgSave.FilterIndex := dlgOpen.FilterIndex;
  dlgSave.InitialDir := dlgOpen.InitialDir;
  SetReopenList;
{
  for I := 1 to ParamCount do begin
    if UpperCase(ExtractFileExt(ParamStr(i))) = '.JPR' then begin
      FProject := TProject.CreateOpen(Self, ParamStr(i));
      dlgOpen.InitialDir := ExtractFilePath(ParamStr(i));
      break;
    end;
  end;

  if FProject = nil then
    for I := 1 to ParamCount do begin
      if FileExists(ParamStr(i)) then begin
        TcwEdit.CreateOpen(Application, ParamStr(i));
        dlgOpen.InitialDir := ExtractFilePath(ParamStr(i));
      end;
    end;

  dlgSave.InitialDir := dlgOpen.InitialDir;

  if FProject <> nil then
    Caption := JPR_NAMEVER + ': ' + FProject.Name
  else Caption := JPR_NAMEVER;
}
end;

procedure TfrmMain.SetReopenList;
var
  i: integer;
  FileIndex: integer;
  tmpItem: TFileMenuItem;
begin
{Clear old}
  While mnuFileReopen.Count > 0 do begin
    tmpItem := TFileMenuItem(mnuFileReopen.Items[mnuFileReopen.Count-1]);
    mnuFileReopen.Remove(mnuFileReopen.Items[mnuFileReopen.Count-1]);
    tmpItem.Free;
  end;
{Add New}
  FileIndex := 0;
  for i := 0 to FLastProjects.Count -1 do begin
    tmpItem := TFileMenuItem.CreateFileItem(mnuFileReopen,FLastProjects[i],FileIndex);
    tmpItem.OnClick := mnuFileReopenProjClick;
    mnuFileReopen.Add(tmpItem);
    Inc(FileIndex)
  end;
  if (FLastProjects.Count + FLastDocs.Count) > 0 then begin
    tmpItem := TFileMenuItem(TMenuItem.Create(mnuFileReopen));
    tmpItem.Caption := '-';
    mnuFileReopen.Add(tmpItem);
  end;
  FileIndex := 5;
  for i := 0 to FLastDocs.Count -1 do begin
    tmpItem := TFileMenuItem.CreateFileItem(mnuFileReopen,FLastDocs[i],FileIndex);
    tmpItem.OnClick := mnuFileReopenDocClick;
    mnuFileReopen.Add(tmpItem);
    Inc(FileIndex)
  end;
end;

procedure TfrmMain.FormDestroy(Sender: TObject);
begin
  if assigned(FDocTypes) then
    FDocTypes.Free;
  if Assigned(FLastProjects) then
    FLastProjects.Free;
  if Assigned(FLastDocs) Then;
    FLastDocs.Free;
  Screen.OnActiveFormChange := nil;
end;

procedure TfrmMain.ShowHint(Sender: TObject);
begin
  StatusBar.SimpleText := Application.Hint;
end;

procedure TfrmMain.doIni(Direction: TDirection);
var
  Registry: TRegistry;
  i: integer;

begin

  Registry := TRegistry.Create;
  try
    with Registry do begin
      RootKey := HKEY_CURRENT_USER;
      OpenRegistryAppKey(Registry);
      OpenKey(KEY_PRODUCT_DISPLAY, True);

      { this is determined at startup now - don't need to store
        if not ValueExists(INI_ITEM_WIN95) then
          WriteBool(INI_ITEM_WIN95, USEWIN95);
        if Direction = dLoad then
          USEWIN95 := ReadBool(INI_ITEM_WIN95)
        else WriteBool(INI_ITEM_WIN95, USEWIN95);
      }
        if not ValueExists(INI_ITEM_LASTX) then
          Writeinteger(INI_ITEM_LASTX, FLastX);
        if Direction = dLoad then
          FLastX := ReadInteger(INI_ITEM_LASTX)
        else WriteInteger(INI_ITEM_LASTX, FLastX);

        if not ValueExists(INI_ITEM_LASTY) then
          Writeinteger(INI_ITEM_LASTY, FLastY);
        if Direction = dLoad then
          FLastY := ReadInteger(INI_ITEM_LASTY)
        else WriteInteger(INI_ITEM_LASTY, FLastY);

        if not ValueExists(INI_ITEM_LASTWINDOWSTATE) then
          Writeinteger(INI_ITEM_LASTWINDOWSTATE, Ord(FLastWindowState));
        if Direction = dLoad then
          FLastWindowState := TWindowState(ReadInteger(INI_ITEM_LASTWINDOWSTATE))
        else WriteInteger(INI_ITEM_LASTWINDOWSTATE, Ord(FLastWindowState));

        if not ValueExists(INI_ITEM_DOCTABS) then
          WriteBool(INI_ITEM_DOCTABS, DOCTABS);
        if Direction = dLoad then
          DOCTABS := ReadBool(INI_ITEM_DOCTABS)
        else WriteBool(INI_ITEM_DOCTABS, DOCTABS);

        OpenKey(KEY_PRODUCT_DISPLAY_FONT, True);
          if not ValueExists(INI_ITEM_FONT_NAME) then
            WriteString(INI_ITEM_FONT_NAME, Font.Name);
          if Direction = dLoad then
            Font.Name := ReadString(INI_ITEM_FONT_NAME)
          else WriteString(INI_ITEM_FONT_NAME, Font.Name);

          if not ValueExists(INI_ITEM_FONT_SIZE) then
            WriteInteger(INI_ITEM_FONT_SIZE, Font.Size);
          if Direction = dLoad then
            Font.Size := ReadInteger(INI_ITEM_FONT_SIZE)
          else WriteInteger(INI_ITEM_FONT_SIZE, Font.Size);

          if not ValueExists(INI_ITEM_FONT_COLOR) then
            WriteString(INI_ITEM_FONT_COLOR, ColorToString(Font.Color));
          if Direction = dLoad then
            Font.Color := StringToColor(ReadString(INI_ITEM_FONT_COLOR))
          else WriteString(INI_ITEM_FONT_COLOR, ColorToString(Font.Color));

      OpenRegistryAppKey(Registry);
      OpenKey(KEY_PRODUCT_EDITOR, True);
        if not ValueExists(INI_ITEM_TABSET) then
          WriteInteger(INI_ITEM_TABSET, TABSET);
        if Direction = dLoad then
          TABSET := ReadInteger(INI_ITEM_TABSET)
        else WriteInteger(INI_ITEM_TABSET, TABSET);

        if not ValueExists(INI_ITEM_AUTOINDENT) then
          WriteBool(INI_ITEM_AUTOINDENT, AUTOINDENT);
        if Direction = dLoad then
          AUTOINDENT := ReadBool(INI_ITEM_AUTOINDENT)
        else WriteBool(INI_ITEM_AUTOINDENT, AUTOINDENT);

        if not ValueExists(INI_ITEM_COLOR) then
          WriteString(INI_ITEM_COLOR, ColorToString(EDITCOLOR));
        if Direction = dLoad then
          EDITCOLOR := StringToColor(ReadString(INI_ITEM_COLOR))
        else WriteString(INI_ITEM_COLOR, ColorToString(EDITCOLOR));

        if not ValueExists(INI_ITEM_LASTFILETYPE) then
          WriteInteger(INI_ITEM_LASTFILETYPE, FLastFileType);
        if Direction = dLoad then
          FLastFileType := ReadInteger(INI_ITEM_LASTFILETYPE)
        else WriteInteger(INI_ITEM_LASTFILETYPE, FLastFileType);

      OpenRegistryAppKey(Registry);
      OpenKey(KEY_PRODUCT_JAVAC,True);
        if Direction = dLoad then begin
          PATH_JAVAC := ReadString('');
          if length(PATH_JAVAC) > 0 then begin
            PATH_JAVA := copy(PATH_JAVAC,0,length(PATH_JAVAC) - length(EXE_JAVAC))
                         + EXE_JAVA;
            if not FileExists(PATH_JAVA) then
              PATH_JAVA := '';
          end
          else PATH_JAVA := '';
        end
        else begin
          WriteString('', PATH_JAVAC);
        end;

      OpenRegistryAppKey(Registry);
      OpenKey(KEY_PRODUCT_BROWSER,True);

        if Direction = dLoad then begin
          PATH_BROWSER := ReadString('');
        end else begin
          WriteString('', PATH_BROWSER);
        end;

        if not ValueExists(INI_ITEM_USEDDE) then
          WriteBool(INI_ITEM_USEDDE, USEDDE);
        if Direction = dLoad then
          USEDDE := ReadBool(INI_ITEM_USEDDE)
        else WriteBool(INI_ITEM_USEDDE, USEDDE);

      OpenRegistryAppKey(Registry);
      OpenKey(KEY_PRODUCT_FILES,True);
        if not ValueExists(INI_ITEM_FILES_PROJ) then
          WriteString(INI_ITEM_FILES_PROJ, FLastProjects.Text);
        if Direction = dLoad then
          FLastProjects.Text := ReadString(INI_ITEM_FILES_PROJ)
        else WriteString(INI_ITEM_FILES_PROJ, FLastProjects.Text);

        if not ValueExists(INI_ITEM_FILES_DOC) then
          WriteString(INI_ITEM_FILES_DOC, FLastDocs.Text);
        if Direction = dLoad then
          FLastDocs.Text := ReadString(INI_ITEM_FILES_DOC)
        else WriteString(INI_ITEM_FILES_DOC, FLastDocs.Text);

      CloseKey;

    end;

  finally
    Registry.Free;
  end;

  for i := MDIChildCount - 1 downto 0 do begin
    if USEWIN95 then
        if MDIChildren[I] is TcwEdit95 then begin
          (MDIChildren[I] as TcwEdit95).Font := Font;
          (MDIChildren[I] as TcwEdit95).reText.Color := EDITCOLOR;
        end
    else begin
        if MDIChildren[I] is TcwEdit then begin
          (MDIChildren[I] as TcwEdit).Font := Font;
          (MDIChildren[I] as TcwEdit).memText.Color := EDITCOLOR;
        end;
    end;
  end;

  tcWindows.Visible := DOCTABS and (tcWindows.Tabs.Count > 0);

end;

procedure TfrmMain.SaveIni;
begin
  doIni(dSave);
end;

{**********************************************}
{*            Menu/button actions             *}
{**********************************************}

{--- File Operations }
procedure TFrmMain.NewDoc(DocType: TDocumentType);
begin
  inc(FLastChild);
  if USEWIN95 then
    TcwEdit95.CreateNew(Application,FLastChild, DocType)
  else TcwEdit.CreateNew(Application,FLastChild, DocType);
end;

procedure TfrmMain.SetProjList(FileName: string);
var
  i: integer;
  iMnuUbound: integer;
  inList: Boolean;
begin
  {If project is already in the lasprojects list, move it to first position}
  imnuUbound := -1;
  InList := False;
  if FLastProjects.Count > 0 then
    imnuUBound := FLastProjects.Count - 1;
  for i := 0 to imnuUbound do begin
    if (mnuFileReopen.Items[i] is TFileMenuItem) then begin
      if UpperCase(TFileMenuItem(mnuFileReopen.Items[i]).FileName) = UpperCase(FileName) then begin
        InList := True;
        FLastProjects.Move(i, 0);
        break;
      end;
    end;
  end;
  {Otherwise, add it to the list}
  if not InList then begin
    if FLastProjects.Count >= MAXFILELIST then
      FLastProjects.Delete(FLastProjects.Count -1); {remove last one}
    FLastProjects.Insert(0,FileName);
  end;
  SetReopenList;

end;

procedure TfrmMain.SetDocList(FileName: string);
var
  imnuUBound: integer;
  imnuLBound: integer;
  InList: Boolean;
  i: integer;
begin

  imnuUbound := -1;
  InList := False;
  imnuLBound := FLastProjects.Count;
  {get lower bound in menu item list: Projects + Seperator (if any)}
  if (FLastProjects.Count > 0) and (FLastDocs.Count > 0) then
    imnuLBound := imnuLBound + 1 {compensate for seperator}
  else imnuLBound := FLastProjects.Count;
  {get upper bound of menu item list}
  if FLastDocs.Count > 0 then
    imnuUBound := FLastDocs.Count - 1 + imnuLBound;
  for i := imnuLBound to imnuUbound do begin
    if (mnuFileReopen.Items[i] is TFileMenuItem) then begin
      if UpperCase(TFileMenuItem(mnuFileReopen.Items[i]).FileName) = UpperCase(FileName) then begin
        InList := True;
        FLastDocs.Move(i - imnuLBound, 0);
        break;
      end;
    end;
  end;
  {Otherwise, add it to the list}
  if not InList then begin
    if FLastDocs.Count >= MAXFILELIST then
      FLastDocs.Delete(FLastDocs.Count -1); {remove last one}
    FLastDocs.Insert(0,FileName);
  end;
  SetReopenList;

end;

function TfrmMain.DocAlreadyOpen(FileName: string): Integer;
var
  i: integer;
begin
  result := -1;
  {go through open windows and see if doc is open}
  {return mdichild # or -1}
  for i := MDIChildCount - 1 downto 0 do begin
    if MDIChildren[I] is TcwEdit then begin
      if UpperCase((MDIChildren[I] as TcwEdit).FileName) = UpperCase(FileName) then
        Result := i;
    end
    else if MDIChildren[I] is TcwEdit95 then begin
      if UpperCase((MDIChildren[I] as TcwEdit95).FileName) = UpperCase(FileName) then
        Result := i;
    end;
  end;
end;

procedure TfrmMain.OpenDocClick(Sender: TObject);
var
  DocID: integer;
  i: integer;
begin

  if not doOpenDoc then
    exit;
  for i := 0 to dlgOpen.Files.count-1 do begin
  DocID := DocAlreadyOpen(dlgOpen.Files[i]);
  if  DocID < 0 then begin
    if USEWIN95 then
      TcwEdit95.CreateOpen(Application, dlgOpen.Files[i])
    else TcwEdit.CreateOpen(Application, dlgOpen.Files[i]);
    SetDocList(dlgOpen.Files[i]);
  end
  else begin
    MDIChildren[DocID].BringToFront;
    MDIChildren[DocID].SetFocus;
  end;
  end;
  UpdateMenuItems(Self);

end;

function TfrmMain.doOpenDoc: Boolean;
var
  tmpFilter: TDocFilter;
  Filter: string;
  i: integer;
begin
  Filter := '';
  for i := 0 to FDocTypes.Count - 1 do begin
    tmpFilter := TDocFilter(FDocTypes.Objects[i]);
    if i = 0 then
      Filter := tmpFilter.Filter
    else Filter := Filter + '|' + tmpFilter.Filter;
  end;
  dlgOpen.Filter := Filter;
  dlgOpen.FileName := '';
  dlgOpen.Options := [ofOverwritePrompt,ofPathMustExist,ofAllowMultiSelect];
  Result := dlgOpen.Execute;
  if result then begin
    dlgOpen.InitialDir := ExtractFilePath(dlgOpen.FileName);
    dlgSave.InitialDir := dlgOpen.InitialDir;
  end;
end;

procedure TfrmMain.CloseProjectFile(DocName: string);
var
  DocFormID: integer;
begin
  DocFormID := getDocForm(DocName);
  if DocFormID > -1 then begin
    if USEWIN95 then
      (MDIChildren[getDocForm(DocName)] as TcwEdit95).CloseNoSave
    else (MDIChildren[getDocForm(DocName)] as TcwEdit).CloseNoSave;
  end;
end;

procedure TfrmMain.OpenProjectFile(DocName: string);
var
  d: TDocument;
  AlreadyOpen: Boolean;
begin
  if FProject = nil then
    Exit;
  d := FProject.Retrieve(DocName);
  if d = nil then
    exit;

  AlreadyOpen := (getDocForm(DocName) > -1);

  if not AlreadyOpen then begin
    if USEWIN95 then
      TcwEdit95.CreateDoc(Application, d)
    else TcwEdit.CreateDoc(Application, d);
  end
  else begin
    MDIChildren[getDocForm(DocName)].BringToFront;
    MDIChildren[getDocForm(DocName)].SetFocus;
  end;

end;

procedure TfrmMain.CloseDoc(Sender: TObject);
begin
  if ActiveMDIChild <> nil then
    ActiveMDIChild.Close;
end;

procedure TfrmMain.SaveDoc(Sender: TObject);
begin
  { save current file (ActiveMDIChild points to the window) }
  if USEWIN95 then begin
    if (ActiveMDIChild <> nil) and (ActiveMDIChild is TcwEdit95) then begin
      (ActiveMDIChild as TcwEdit95).doSave;
    end;
  end
  else
    if (ActiveMDIChild <> nil) and (ActiveMDIChild is TcwEdit) then begin
      (ActiveMDIChild as TcwEdit).doSave;
    end;
{    SetDocList((ActiveMDIChild as TcwEdit).FileName);}

end;

procedure TfrmMain.SaveDocAs(Sender: TObject);
begin
  { save current file under new name }
  if USEWIN95 then begin
    if (ActiveMDIChild <> nil) and (ActiveMDIChild is TcwEdit95) then begin
      (ActiveMDIChild as TcwEdit95).doSaveAs;
    end;
  end
  else
    if (ActiveMDIChild <> nil) and (ActiveMDIChild is TcwEdit) then begin
      (ActiveMDIChild as TcwEdit).doSaveAs;
    end;
end;

procedure TfrmMain.ExitApp(Sender: TObject);
begin
  Close;
end;

{----- Edit Operations}
procedure TfrmMain.EditUndo(Sender: TObject);
begin
  if USEWIN95 then begin
    if (ActiveMDIChild <> nil) and (ActiveMDIChild is TcwEdit95) then begin
      (ActiveMDIChild as TcwEdit95).doUndo;
    end;
  end
  else
    if (ActiveMDIChild <> nil) and (ActiveMDIChild is TcwEdit) then begin
      (ActiveMDIChild as TcwEdit).doUndo;
    end;
end;

procedure TfrmMain.EditCut(Sender: TObject);
begin
  {cut selection to clipboard}
  if (ActiveMDIChild <> nil) then begin
    if (ActiveMDIChild is TcwEdit) then
      (ActiveMDIChild as TcwEdit).doCut(nil);
    if (ActiveMDIChild is TcwEdit95) then
      (ActiveMDIChild as TcwEdit95).doCut(nil);
    if (ActiveMDIChild is TdlgOptions95) then
      (ActiveMDIChild as TdlgOptions95).doCut(nil);
    if (ActiveMDIChild is TdlgOptions) then
      (ActiveMDIChild as TdlgOptions).doCut(nil);
  end;
end;

procedure TfrmMain.EditCopy(Sender: TObject);
begin
  {copy selection to clipboard}
  if (ActiveMDIChild <> nil) then begin
    if (ActiveMDIChild is TcwEdit) then
      (ActiveMDIChild as TcwEdit).doCopy(nil);
    if (ActiveMDIChild is TcwEdit95) then
      (ActiveMDIChild as TcwEdit95).doCopy(nil);
    if (ActiveMDIChild is TdlgOptions95) then
      (ActiveMDIChild as TdlgOptions95).doCopy(nil);
    if (ActiveMDIChild is TdlgOptions) then
      (ActiveMDIChild as TdlgOptions).doCopy(nil);
  end;
end;

procedure TfrmMain.EditPaste(Sender: TObject);
begin
  {paste from clipboard}
  if (ActiveMDIChild <> nil) then begin
    if (ActiveMDIChild is TcwEdit) then
      (ActiveMDIChild as TcwEdit).doPaste(nil);
    if (ActiveMDIChild is TcwEdit95) then
      (ActiveMDIChild as TcwEdit95).doPaste(nil);
    if (ActiveMDIChild is TdlgOptions95) then
      (ActiveMDIChild as TdlgOptions95).doPaste(nil);
    if (ActiveMDIChild is TdlgOptions) then
      (ActiveMDIChild as TdlgOptions).doPaste(nil);
  end;
end;

procedure TfrmMain.mnuEditDeleteClick(Sender: TObject);
begin
  if (ActiveMDIChild <> nil) then begin
    if (ActiveMDIChild is TcwEdit) then
      (ActiveMDIChild as TcwEdit).doDelete(nil);
    if (ActiveMDIChild is TcwEdit95) then
      (ActiveMDIChild as TcwEdit95).doDelete(nil);
    if (ActiveMDIChild is TdlgOptions95) then
      (ActiveMDIChild as TdlgOptions95).doDelete(nil);
    if (ActiveMDIChild is TdlgOptions) then
      (ActiveMDIChild as TdlgOptions).doDelete(nil);
  end;
end;

{----- Search Operations}
procedure TfrmMain.SearchFind(Sender: TObject);
begin
  if USEWIN95 then begin
    if (ActiveMDIChild <> nil) and (ActiveMDIChild is TcwEdit95) then begin
      (ActiveMDIChild as TcwEdit95).initFind;
      dlgFind.Execute;
    end;
  end
  else
    if (ActiveMDIChild <> nil) and (ActiveMDIChild is TcwEdit) then begin
      (ActiveMDIChild as TcwEdit).initFind;
      dlgFind.Execute;
    end;
end;

procedure TfrmMain.SearchFindNext(Sender: TObject);
begin
  if USEWIN95 then begin
    if (ActiveMDIChild <> nil) and (ActiveMDIChild is TcwEdit95)
      and (Length(dlgFind.FindText) > 0) then
      (ActiveMDIChild as TcwEdit95).doFind;
  end
  else
    if (ActiveMDIChild <> nil) and (ActiveMDIChild is TcwEdit)
      and (Length(dlgFind.FindText) > 0) then
      (ActiveMDIChild as TcwEdit).doFind;
end;

procedure TfrmMain.SearchReplace(Sender: TObject);
begin
  if USEWIN95 then begin
    if (ActiveMDIChild <> nil) and (ActiveMDIChild is TcwEdit95) then begin
      (ActiveMDIChild as TcwEdit95).initFind;
      dlgReplace.Execute;
    end;
  end
  else
    if (ActiveMDIChild <> nil) and (ActiveMDIChild is TcwEdit) then begin
      (ActiveMDIChild as TcwEdit).initFind;
      dlgReplace.Execute;
    end;

end;

procedure TfrmMain.dlgFindFind(Sender: TObject);
begin
  if USEWIN95 then begin
    if (ActiveMDIChild <> nil) and (ActiveMDIChild is TcwEdit95)
      and (Length(dlgFind.FindText) > 0) then begin
      dlgReplace.FindText := dlgFind.FindText;
      dlgReplace.Options := dlgFind.Options;
      (ActiveMDIChild as TcwEdit95).doFind;
    end;
  end
  else
    if (ActiveMDIChild <> nil) and (ActiveMDIChild is TcwEdit)
      and (Length(dlgFind.FindText) > 0) then begin
      dlgReplace.FindText := dlgFind.FindText;
      dlgReplace.Options := dlgFind.Options;
      (ActiveMDIChild as TcwEdit).doFind;
    end;
end;

procedure TfrmMain.dlgReplaceFind(Sender: TObject);
begin
  dlgFind. FindText := dlgReplace.FindText;
  dlgFind.Options := dlgReplace.Options;
  dlgFindFind(Sender);
  dlgFind.Options := dlgFind.Options;
end;

procedure TfrmMain.dlgReplaceReplace(Sender: TObject);
begin
  if USEWIN95 then begin
    if (ActiveMDIChild <> nil) and (ActiveMDIChild is TcwEdit95)
      and (Length(dlgReplace.FindText) > 0) then begin
      dlgFind. FindText := dlgReplace.FindText;
      dlgFind.Options := dlgReplace.Options;
      (ActiveMDIChild as TcwEdit95).doReplace;
      dlgFind.Options := dlgFind.Options;
    end;
  end
  else
    if (ActiveMDIChild <> nil) and (ActiveMDIChild is TcwEdit)
      and (Length(dlgReplace.FindText) > 0) then begin
      dlgFind. FindText := dlgReplace.FindText;
      dlgFind.Options := dlgReplace.Options;
      (ActiveMDIChild as TcwEdit).doReplace;
      dlgFind.Options := dlgFind.Options;
    end;
end;

{----- Window Operations}
procedure TfrmMain.mnuWindowCascadeClick(Sender: TObject);
begin
  Cascade;
end;

procedure TfrmMain.mnuWindowTileClick(Sender: TObject);
begin
  Tile;
end;

procedure TfrmMain.mnuWindowArrangeClick(Sender: TObject);
begin
  ArrangeIcons;
end;

procedure TfrmMain.mnuWindowMinimizeClick(Sender: TObject);
var
  I: Integer;
begin
  { Must be done backwards through the MDIChildren array }
  for I := MDIChildCount - 1 downto 0 do
    MDIChildren[I].WindowState := wsMinimized;
end;

procedure TfrmMain.ActivateFileTab;
begin

  if DocTabsChanging then
    exit;

  DocTabsChanging := True;
  try
    tcWindows.TabIndex := tcWindows.Tabs.Indexof(ActiveMDIChild.Caption);
  finally
    DocTabsChanging := False;
  end;

end;

procedure TfrmMain.RemoveFileTab(WinName: string);
var
  i: integer;
begin

  i := tcWindows.Tabs.Indexof(WinName);
  if i >= 0 then
    tcWindows.Tabs.delete(i);

  if DOCTABS then
    tcWindows.visible := tcWindows.Tabs.Count > 0;

end;

procedure TfrmMain.UpdateFileTab(OldName, NewName: string);
var
  i: integer;
begin

  i := tcWindows.Tabs.IndexOf(OldName);
  if i >= 0 then
    tcWindows.Tabs[i] := NewName
  else tcWindows.Tabs.Add(NewName);

  if DOCTABS then
    tcWindows.visible := tcWindows.Tabs.Count > 0;

end;

procedure TfrmMain.UpdateMenuItems(Sender: TObject);
var
  i: integer;
  ActiveIsEdit: Boolean;
begin
  if USEWIN95 then
    ActiveIsEdit := (ActiveMDIChild <> nil) and (ActiveMdiChild is TcwEdit95)
  else ActiveIsEdit := (ActiveMDIChild <> nil) and (ActiveMdiChild is TcwEdit);
  mnuFileReopen.Enabled := (FLastProjects.Count + FLastDocs.Count) > 0;
  mnuFileSave.Enabled := ActiveIsEdit;
  mnuFileSaveAll.Enabled := ActiveIsEdit
                            or ((FProject <> nil) and FProject.IsDirty);
  cmdSaveProject.Enabled := FProject <> nil;
  mnuFileSaveAs.Enabled := ActiveIsEdit;
  mnuFileSaveProjectAs.Enabled := FProject <> nil;
  mnuFileClose.Enabled := ActiveMDIChild <> nil;
  mnuFileCloseAll.Enabled := ActiveMDIChild <> nil;
  mnuProject.Enabled := (FProject <> nil);
  mnuProjectAddDoc.Enabled := (FProject <> nil);

  mnuProjectAddAllDoc.Enabled := (FProject <> nil) and (MDIChildCount > 0);
  if mnuProjectAddAllDoc.Enabled and (MDIChildCount = 1) then
    mnuProjectAddAllDoc.Enabled := (not (ActiveMDIChild is TdlgOptions95))
                                   and (not (ActiveMDIChild is TdlgOptions));

  mnuProjectRemoveDoc.Enabled := (FProject <> nil)
                                 and (FProject.DocCount > 0)
                                 and (ActiveMDIChild <> nil);
  if mnuProjectRemoveDoc.Enabled then begin
    if (ActiveMDIChild is TcwEdit95) or (ActiveMDIChild is TcwEdit) then
      {enable if active doc is in project}
      mnuProjectRemoveDoc.Enabled := FProject.InProject(ActiveMDIChild.Caption)
    else if (ActiveMDIChild is TdlgOptions95) then
      {enable if a doc is selected}
      mnuProjectRemoveDoc.Enabled := (ActiveMDIChild as TdlgOptions95).isSelection
    else if (ActiveMDIChild is TdlgOptions) then
      {enable if a doc is selected}
      mnuProjectRemoveDoc.Enabled := (ActiveMDIChild as TdlgOptions).isSelection;
  end;

  if USEWIN95 then
    mnuFilePrint.Enabled :=
      (dlgPrint <> nil)
      and ActiveIsEdit
      and ((ActiveMDIChild as TcwEdit95).reText.Lines.Count > 0)
  else
    mnuFilePrint.Enabled :=
      (dlgPrint <> nil)
      and ActiveIsEdit
      and ((ActiveMDIChild as TcwEdit).memText.Lines.Count > 0);

  mnuEditUndo.Enabled := ActiveIsEdit;

  mnuEditCut.Enabled := ActiveMDIChild <> nil;
  if mnuEditCut.Enabled then begin
{    if (ActiveMDIChild is TcwEdit) then
      mnuEditCut.Enabled := ((ActiveMDIChild as TcwEdit).memText.SelLength > 0);}
    if (ActiveMDIChild is TdlgOptions95) then
      mnuEditCut.Enabled := (ActiveMDIChild as TdlgOptions95).isSelection;
    if (ActiveMDIChild is TdlgOptions) then
      mnuEditCut.Enabled := (ActiveMDIChild as TdlgOptions).isSelection;
  end;

  mnuEditCopy.Enabled := mnuEditCut.Enabled;

  mnuEditPaste.Enabled := ActiveMDIChild <> nil;
  if mnuEditCut.Enabled then begin
    if (ActiveMDIChild is TcwEdit) or (ActiveMDIChild is TcwEdit95) then
      mnuEditPaste.Enabled := Clipboard.HasFormat(CF_TEXT);
    if (ActiveMDIChild is TdlgOptions95) or (ActiveMDIChild is TdlgOptions) then
      mnuEditPaste.Enabled := Clipboard.HasFormat(CF_TEXT)
                                  and FileExists(Clipboard.AsText);
  end;

  mnuEditDelete.Enabled := mnuEditCut.Enabled;

  if USEWIN95 then
    mnuSearchFind.Enabled :=
      ActiveIsEdit
      and ((ActiveMDIChild as TcwEdit95).reText.Lines.Count > 0)
  else
    mnuSearchFind.Enabled :=
      ActiveIsEdit
      and ((ActiveMDIChild as TcwEdit).memText.Lines.Count > 0);
  mnuSearchFindNext.Enabled := mnuSearchFind.Enabled;
  mnuSearchReplace.Enabled := mnuSearchFind.Enabled;
  mnuSearchGotoLine.Enabled := mnuSearchFind.Enabled;

  if USEWIN95 then
    mnuRunCompileDocument.Enabled := mnuSearchFind.Enabled and (ActiveMDIChild as TcwEdit95).HasDoc
      and (length(PATH_JAVAC) > 0) and FileExists(PATH_JAVAC)
      and ((ActiveMDIChild as TcwEdit95).DocumentType = dtJava)
  else
    mnuRunCompileDocument.Enabled := mnuSearchFind.Enabled and (ActiveMDIChild as TcwEdit).HasDoc
      and (length(PATH_JAVAC) > 0) and FileExists(PATH_JAVAC)
      and ((ActiveMDIChild as TcwEdit).DocumentType = dtJava);
  if USEWIN95 then
    mnuRunLoadBrowser.Enabled := mnuSearchFind.Enabled and (ActiveMDIChild as TcwEdit95).HasDoc
      and (length(PATH_BROWSER) > 0) and FileExists(PATH_BROWSER)
      and ((ActiveMDIChild as TcwEdit95).DocumentType = dtHtml)
  else
    mnuRunLoadBrowser.Enabled := mnuSearchFind.Enabled and (ActiveMDIChild as TcwEdit).HasDoc
      and (length(PATH_BROWSER) > 0) and FileExists(PATH_BROWSER)
      and ((ActiveMDIChild as TcwEdit).DocumentType = dtHtml);

  mnuRunJava.Enabled := (length(PATH_JAVA) > 0) and FileExists(PATH_JAVA);

  mnuWindowCascade.Enabled := MDIChildCount > 0;
  mnuWindowTile.Enabled := MDIChildCount > 0;
  mnuWindowArrange.Enabled := MDIChildCount > 0;
  mnuWindowMinimize.Enabled := MDIChildCount > 0;

  for I := 0 to MDIChildCount - 1 do begin
    if (MDIChildren[I] is TcwEdit) then
      (MDIChildren[I] as TcwEdit).UpdateToolbar
    else if (MDIChildren[I] is TcwEdit95) then
      (MDIChildren[I] as TcwEdit95).UpdateToolbar;
  end;

  ActivateFileTab;
{  UpdateFileTab;}

end;

procedure TfrmMain.Configure(Sender: TObject);
var
  Settings: TdlgSettings;
begin
  Settings := TdlgSettings.Create(Self);
  try
    Settings.ShowModal;
    if Settings.ModalResult = mrOK then begin
      SaveIni;
    end;
  finally
    Settings.Free;
  end;
end;

procedure TfrmMain.mnuFileNewClick(Sender: TObject);
begin
  if (Sender is TMenuItem) then
  NewDoc(TDocumentType((Sender as TMenuItem).Tag));
end;

procedure TfrmMain.cmdNewClick(Sender: TObject);
var
  P, Q : TPoint;
begin
  P.X := cmdNew.Left;                          { P is the TPoint record for the form}
  P.Y := cmdNew.Top;
  Q := ClientToScreen(P);            { Q is the TPoint for the screen }
  mnpFileNew.Popup(Q.X,Q.Y);
end;

procedure TfrmMain.mnuHelpAboutClick(Sender: TObject);
var
  dlgAbout: TdlgAbout;
begin
  dlgAbout := TdlgAbout.Create(Application);
  try
    dlgAbout.ShowModal;
  finally
    dlgAbout.Free;
  end;
end;

procedure TfrmMain.cmdCompileClick(Sender: TObject);
begin

  if USEWIN95 then begin
    if (ActiveMDIChild = nil) or (not (ActiveMDIChild is TcwEdit95))
       or ((ActiveMDIChild as TcwEdit95).reText.Lines.Count = 0)
       or (Length(PATH_JAVAC) = 0) then
      exit;
    (ActiveMDIChild as TcwEdit95).Compile;
  end
  else begin
    if (ActiveMDIChild = nil) or (not (ActiveMDIChild is TcwEdit))
       or ((ActiveMDIChild as TcwEdit).memText.Lines.Count = 0)
       or (Length(PATH_JAVAC) = 0) then
      exit;
    (ActiveMDIChild as TcwEdit).Compile;
  end;

end;

procedure TfrmMain.mnuFilePrintClick(Sender: TObject);
begin
  if (frmMain.dlgPrint = nil) then
    exit;
  if (ActiveMDIChild <> nil) then begin
    if (ActiveMDIChild is TcwEdit) then
      (ActiveMDIChild as TcwEdit).doPrint(nil)
    else if (ActiveMDIChild is TcwEdit95) then
      (ActiveMDIChild as TcwEdit95).doPrint(nil);
  end
end;

procedure TfrmMain.CloseProjectEditor;
var
  i: integer;
begin
  for i := 0 to MDIChildCount do begin
    if (MDIChildren[i] is TdlgOptions) then begin
      (MDIChildren[i] as TdlgOptions).Project := nil;
      (MDIChildren[i] as TdlgOptions).Close;
    end
    else if (MDIChildren[i] is TdlgOptions95) then begin
      (MDIChildren[i] as TdlgOptions95).Project := nil;
      (MDIChildren[i] as TdlgOptions95).Close;
    end;
  end;
  OptionDlgOpen := False;
{
  If OptionDlgOpen then begin
    if USEWIN95 then
      cOptions95.Close
    else cOptions.Close;
    OptionDlgOpen := False;
  end;
}
end;

procedure TfrmMain.mnuProjectViewProjectManagerClick(Sender: TObject);
begin
  if OptionDlgOpen then
    CloseProjectEditor
  else begin
  if USEWIN95 Then begin
    if not OptionDlgOpen then
      cOptions95 := TdlgOptions95.Create(Application)
    else begin
      cOptions95.BringToFront;
      cOptions95.SetFocus;
    end;
    OptionDlgOpen := True;
    cOptions95.Project := FProject;
  end
  else begin
    if not OptionDlgOpen then
      cOptions := TdlgOptions.Create(Application)
    else begin
      cOptions.BringToFront;
      cOptions.SetFocus;
    end;
    OptionDlgOpen := True;
    cOptions.Project := FProject;
  end;
  end;
end;

procedure TfrmMain.cmdOpenProjectClick(Sender: TObject);
var
  OrigDlgFile: string;
  OrigDlgFilter: string;
begin

  OrigDlgFile := dlgOpen.Filename;
  OrigDlgFilter := dlgOpen.Filter;
  dlgOpen.Filter := 'Java Editor Project (*.jpr)|*.jpr';
  dlgOpen.FileName := '';
  dlgOpen.Options := [ofOverwritePrompt,ofPathMustExist];
  if not dlgOpen.Execute then begin
    dlgOpen.Options := [ofOverwritePrompt,ofPathMustExist,ofAllowMultiSelect];
    dlgOpen.Filter := OrigDlgFilter;
    dlgOpen.Filename := OrigDlgFile;
    exit;
  end;

  if FProject <> nil then begin
    if not CloseProject then
      exit;
  end;

  dlgOpen.InitialDir := ExtractFilePath(dlgOpen.FileName);
  dlgSave.InitialDir := dlgOpen.InitialDir;

  FProject := TProject.CreateOpen(Self,dlgOpen.FileName);
  if length(FProject.FileName) = 0 then
    Caption := JPR_NAMEVER + ': ' + FProject.Name
  else Caption := JPR_NAMEVER + ': ' + FProject.Name + ' (' + FProject.FileName + ')';

  SetProjList(dlgOpen.FileName);

{  UpdateMenuItems(nil);}
  mnuProjectViewProjectManagerClick(nil);

end;

procedure TfrmMain.mnuFileSaveProjectAsClick(Sender: TObject);
begin
  SaveProjectAs;
end;

procedure TfrmMain.NewProject(Sender: TObject);
begin
  if FProject <> nil then begin
    if not CloseProject then
      exit;
  end;
  FProject := TProject.Create(Self);
  if length(FProject.FileName) = 0 then
    Caption := JPR_NAMEVER + ': ' + FProject.Name
  else Caption := JPR_NAMEVER + ': ' + FProject.Name + ' (' + FProject.FileName + ')';
  UpdateMenuItems(nil);
  mnuProjectViewProjectManagerClick(nil);

end;

procedure TfrmMain.CloseAllDocs;
var
  i: integer;
begin

  for i := MDIChildCount - 1 downto 0 do
    if (MDIChildren[i] is TcwEdit) then
      (MDIChildren[i] as TcwEdit).CloseNoSave
    else if (MDIChildren[i] is TcwEdit95) then
      (MDIChildren[i] as TcwEdit95).CloseNoSave;

  application.processmessages;

end;

function TfrmMain.CloseProject: Boolean;
var
  SaveResp: Integer;
  tmpProject: TProject;
begin
  Result := True;
  if FProject = nil then
    exit;
  {Try to close any open docs}
  result := (SaveChildren <> srCancel);
  application.processmessages;
  If result then
    CloseAllDocs
  else exit;
  if FProject.IsDirty then begin
    SaveResp := MessageDlg(Format(' Save project ''' + '%s' + '''?',
                [FProject.Name]),
                mtConfirmation, mbYesNoCancel, 0);
    case SaveResp of
      idYes: {Nothing};
      idNo: Exit;
      idCancel: begin
        Result := False;
        Exit;
      end;
    end;
    Result := SaveProject;
  end;
  application.processmessages;
  if result then begin
    CloseProjectEditor;
    application.processmessages;
    tmpProject := FProject;
    FProject := nil;
    tmpProject.Free;
{    if OptionDlgOpen then begin
      if USEWIN95 then
        cOptions95.Project := nil
      else cOptions.Project := nil;
    end;}
    Caption := JPR_NAMEVER;
  end;
  application.processmessages;

end;

function TfrmMain.SaveProjectAs: Boolean;
begin
  Result := False;
  if (FProject = nil) or (not doSaveProjectDialog) then
    exit;
  FProject.FileName := dlgSave.FileName;
  FProject.Save;
  if length(FProject.FileName) = 0 then
    Caption := JPR_NAMEVER + ': ' + FProject.Name
  else Caption := JPR_NAMEVER + ': ' + FProject.Name + ' (' + FProject.FileName + ')';
  SetProjList(dlgSave.FileName);
  Result := True;
{  if SaveChildren = srCancel then
    Result := False;}
end;

function TfrmMain.SaveChildren: TMultiSaveResult;
var
  i: integer;
  d: TdlgMultiSave;
begin
  d := TdlgMultiSave.Create(Application);
  try
  d.Caption := 'Save Project';
  result := srYes;
  for I := MDIChildCount - 1 downto 0 do
    if (MDIChildren[I] is TcwEdit) and (result <> srNoAll) then
      if (not (MDIChildren[I] as TcwEdit).isSaved) then begin
        if (result <> srYesAll) then begin
          d.DisplayMessage := 'Save changes to ' + (MDIChildren[I] as TcwEdit).Caption + '?';
          d.ShowModal;
          Result := d.SaveResult;
        end;
        if (result = srYes) or (result = srYesAll) then
          (MDIChildren[I] as TcwEdit).doSave;
      end
    else if (MDIChildren[I] is TcwEdit95) and (result <> srNoAll) then
      if (not (MDIChildren[I] as TcwEdit95).isSaved) then begin
        if (result <> srYesAll) then begin
          d.DisplayMessage := 'Save changes to ' + (MDIChildren[I] as TcwEdit95).Caption + '?';
          d.ShowModal;
          Result := d.SaveResult;
        end;
        if (result = srYes) or (result = srYesAll) then
          (MDIChildren[I] as TcwEdit95).doSave;
      end;

  finally
    d.Free;
  end;
end;

function TfrmMain.SaveProject: Boolean;
begin
  Result := True;
  if FProject <> nil then
    if FProject.IsNew then
      Result := SaveProjectAs
    else begin
      FProject.Save;
      if length(FProject.FileName) = 0 then
        Caption := JPR_NAMEVER + ': ' + FProject.Name
      else Caption := JPR_NAMEVER + ': ' + FProject.Name + ' (' + FProject.FileName + ')';
      SetProjList(FProject.FileName);
{      SaveChildren;}
    end;
end;

procedure TfrmMain.SaveProjectClick(Sender: TObject);
begin
  SaveProject;
  UpdateMenuItems(nil);
end;

procedure TfrmMain.mnuFileCloseAllClick(Sender: TObject);
begin

  CloseAllDocs;
{
  if CloseProject and FOptionDlgOpen then begin
    if USEWIN95 then
      cOptions95.Project := FProject
    else cOptions.Project := FProject;
  end;
}
end;

procedure TfrmMain.mnuRunLoadBrowserClick(Sender: TObject);
begin

  if USEWIN95 then begin
    if (ActiveMDIChild = nil) or (not (ActiveMDIChild is TcwEdit95))
       or ((ActiveMDIChild as TcwEdit95).reText.Lines.Count = 0)
       or (Length(PATH_BROWSER) = 0) then
      exit;
    LoadInBrowser((ActiveMDIChild as TcwEdit95).DocName);
  end
  else begin
    if (ActiveMDIChild = nil) or (not (ActiveMDIChild is TcwEdit))
       or ((ActiveMDIChild as TcwEdit).memText.Lines.Count = 0)
       or (Length(PATH_BROWSER) = 0) then
      exit;
    LoadInBrowser((ActiveMDIChild as TcwEdit).DocName);
  end;


end;

procedure TfrmMain.mnuRunJavaClick(Sender: TObject);
begin
  if (length(PATH_JAVA) > 0) and FileExists(PATH_JAVA) then
    dlgRunJava.Show;
end;

procedure TfrmMain.DdeClientConvClose(Sender: TObject);
begin
  NetscapeOpen := False;
  NETSCAPEWINDOW := '0';
end;

procedure TfrmMain.FormShow(Sender: TObject);
var
  I: Word;
  s: string;
begin

  for I := 1 to ParamCount do begin
    s := GetProperFileName(ParamStr(i));
    if UpperCase(ExtractFileExt(s)) = '.JPR' then begin
      FProject := TProject.CreateOpen(Self, s);
      dlgOpen.InitialDir := ExtractFilePath(s);
      break;
    end;
  end;

  if FProject = nil then begin
    for I := 1 to ParamCount do begin
      s := GetProperFileName(ParamStr(i));
      if FileExists(s) then begin
        if USEWIN95 then
          TcwEdit95.CreateOpen(Application, s)
        else TcwEdit.CreateOpen(Application, s);
        dlgOpen.InitialDir := ExtractFilePath(s);
      end;
    end;
    NewProject(Self);
  end;

  dlgSave.InitialDir := dlgOpen.InitialDir;

  if FProject <> nil then begin
    if length(FProject.FileName) = 0 then
      Caption := JPR_NAMEVER + ': ' + FProject.Name
    else Caption := JPR_NAMEVER + ': ' + FProject.Name + ' (' + FProject.FileName + ')';
    mnuProjectViewProjectManagerClick(sender);
  end
  else Caption := JPR_NAMEVER;

  Top := FLastY;
  Left := FLastX;
  WindowState := FLastWindowState;

end;

procedure TfrmMain.WMDROPFILES(var Message: TWMDropFiles);
var
  i, DropCount, BufSize: integer;
  FileName: pChar;
  FileList: TStrings;
  Point: TPoint;
begin
  BufSize := 0;
  DropCount := DragQueryFile(Message.Drop, $FFFFFFFF, nil, BufSize);
  FileList := TStringList.Create;
  try
  for i := 0 to DropCount - 1 do begin
    BufSize := DragQueryFile(Message.Drop, i, nil, BufSize) + 1;
    FileName := StrAlloc(BufSize + 1);
    try
      DragQueryFile(Message.Drop, i, FileName, BufSize);
      FileList.Add(GetProperFileName(FileName));
      DragQueryPoint(Message.Drop, Point);
    finally
      StrDispose(FileName);
    end;
  end;
  DragFinish(Message.Drop);
  FileDropped(FileList, Point.X, Point.Y)
  finally
    FileList.Free;
  end;
end;

procedure TFrmMain.FileDropped(Files: Tstrings; X, Y: Integer);
var
  I: Word;
  isProject: Boolean;
  DocID: integer;
begin
  isProject := False;

  for I := 0 to Files.Count - 1 do begin
    if UpperCase(ExtractFileExt(Files[i])) = '.JPR' then begin
      if FProject <> nil then begin
        if not CloseProject then
          exit;
      end;
      isProject := True;
      FProject := TProject.CreateOpen(Self, Files[i]);
      dlgOpen.InitialDir := ExtractFilePath(Files[i]);
      break;
    end;
  end;

  if not isProject then
    for I := 0 to Files.Count - 1 do begin
{      tmpFile := GetProperFileName(Files[i]);}
      DocID := DocAlreadyOpen(Files[i]);
      if  DocID < 0 then begin
        if FileExists(Files[i]) then begin
          if USEWIN95 then
            TcwEdit95.CreateOpen(Application, Files[i])
          else TcwEdit.CreateOpen(Application, Files[i]);
          dlgOpen.InitialDir := ExtractFilePath(Files[i]);
        end;
        SetDocList(Files[i]);
        UpdateMenuItems(Self);
      end
      else begin
        MDIChildren[DocID].BringToFront;
        MDIChildren[DocID].SetFocus;
      end;

    end;

  dlgSave.InitialDir := dlgOpen.InitialDir;

  if isProject then begin
    if length(FProject.FileName) = 0 then
      Caption := JPR_NAMEVER + ': ' + FProject.Name
    else Caption := JPR_NAMEVER + ': ' + FProject.Name + ' (' + FProject.FileName + ')';
    UpdateMenuItems(nil);
    mnuProjectViewProjectManagerClick(nil);
  end;

end;

procedure TfrmMain.FormClose(Sender: TObject; var Action: TCloseAction);
begin
  FLastFileType := dlgOpen.FilterIndex;
  FLastWindowState := WindowState;
  FLastX := Left;
  FLastY := Top;
  SaveIni;
end;

procedure TfrmMain.mnuFileReopenDocClick(Sender: TObject);
var
  tmpItem: TFileMenuItem;
  OpenName: String;
  tmpFilter: TDocFilter;
  Filter: string;
  i: integer;
  DocID: Integer;
begin

  if not (Sender is TFileMenuItem) then
    exit;

  tmpItem := TFileMenuItem(Sender);
  OpenName := tmpItem.FileName;

  if length(OpenName) = 0 then
    exit;

  if not FileExists(OpenName) then
    raise Exception.Create('Can''' + 't find ''' + OpenName + '''');

  Filter := '';
  for i := 0 to FDocTypes.Count - 1 do begin
    tmpFilter := TDocFilter(FDocTypes.Objects[i]);
    if i = 0 then
      Filter := tmpFilter.Filter
    else Filter := Filter + '|' + tmpFilter.Filter;
  end;
  dlgOpen.Filter := Filter;
  dlgOpen.FileName := OpenName;
  dlgOpen.InitialDir := ExtractFilePath(dlgOpen.FileName);
  dlgSave.InitialDir := dlgOpen.InitialDir;

  DocID := DocAlreadyOpen(dlgOpen.FileName);
  if  DocID < 0 then begin
    if USEWIN95 then
      TcwEdit95.CreateOpen(Application, dlgOpen.FileName)
    else TcwEdit.CreateOpen(Application, dlgOpen.FileName);
    SetDocList(dlgOpen.FileName);
  end
  else begin
    MDIChildren[DocID].BringToFront;
    MDIChildren[DocID].SetFocus;
  end;

  SetDocList(dlgOpen.FileName);

end;

procedure TfrmMain.mnuFileReopenProjClick(Sender: TObject);
var
  tmpItem: TFileMenuItem;
  OpenName: string;
begin

  if not (Sender is TFileMenuItem) then
    exit;

  tmpItem := TFileMenuItem(Sender);
  OpenName := tmpItem.FileName;

  if length(OpenName) = 0 then
    exit;

  if not FileExists(OpenName) then
    raise Exception.Create('Can''' + 't find ''' + OpenName + '''');

  if FProject <> nil then begin
    if not CloseProject then
      exit;
  end;

  dlgOpen.Filter := 'Java Editor Project (*.jpr)|*.jpr';
  dlgOpen.FileName := OpenName;
  dlgOpen.InitialDir := ExtractFilePath(dlgOpen.FileName);
  dlgSave.InitialDir := dlgOpen.InitialDir;

  FProject := TProject.CreateOpen(Self,dlgOpen.FileName);
  if length(FProject.FileName) = 0 then
    Caption := JPR_NAMEVER + ': ' + FProject.Name
  else Caption := JPR_NAMEVER + ': ' + FProject.Name + ' (' + FProject.FileName + ')';

  SetProjList(dlgOpen.FileName);

{  UpdateMenuItems(nil);}

  mnuProjectViewProjectManagerClick(nil);

end;

procedure TfrmMain.tcWindowsChange(Sender: TObject);
var
  i: integer;
begin

  if DocTabsChanging then
    Exit;
  DocTabsChanging := True;
  try
    if ActiveMDIChild.Caption <> tcWindows.Tabs[tcWindows.TabIndex] then begin
      for i := 0 to MDIChildCount - 1 do begin
        if MDIChildren[i].Caption = tcWindows.Tabs[tcWindows.TabIndex] then
          MDIChildren[I].BringToFront;
          MDIChildren[i].SetFocus;
      end;
    end;
  finally
    DocTabsChanging := False;
  end;

end;

procedure TfrmMain.SetOptionDlgOpen(Value: Boolean);
begin
  mnuProjectViewProjectManager.Checked := Value;
  FOptionDlgOpen := Value
end;

procedure TfrmMain.mnuProjectAddDocClick(Sender: TObject);
var
  i: integer;
begin
  if doOpenDoc then begin
    for i := 0 to dlgOpen.Files.Count - 1 do begin
      FProject.AddLoad(ExpandFileName(dlgOpen.Files[i]));
      if OptionDlgOpen then begin
        if USEWIN95 then
          cOptions95.DisplayDocs
        else cOptions.DisplayDocs;
      end;
      OpenProjectFile(ExtractFileName(dlgOpen.Files[i]));
    end;
    UpdateMenuItems(nil);
  end;
end;

procedure TfrmMain.mnuProjectRemoveDocClick(Sender: TObject);
begin

  if (FProject = nil) or (FProject.DocCount = 0) or (ActiveMDIChild = nil) then
    exit;

  if (ActiveMDIChild is TcwEdit95) or (ActiveMDIChild is TcwEdit) then
    FProject.Remove(ActiveMDIChild.Caption)
  else if (ActiveMDIChild is TdlgOptions95) then
    (ActiveMDIChild as TdlgOptions95).doDelete(self)
  else if (ActiveMDIChild is TdlgOptions) then
    (ActiveMDIChild as TdlgOptions).doDelete(self);

end;

procedure TfrmMain.mnuProjectAddAllDocClick(Sender: TObject);
var
  i: integer;
begin
  for i := 0 to MDIChildCount - 1 do
    if (ActiveMDIChild is TcwEdit) then
      FProject.AddLoad((ActiveMDIChild as TcwEdit).FileName)
    else if (ActiveMDIChild is TcwEdit95) then
      FProject.AddLoad((ActiveMDIChild as TcwEdit95).FileName);
end;

procedure TfrmMain.mnuProjectClick(Sender: TObject);
begin
  mnuProjectAddAllDoc.Enabled := (FProject <> nil) and (MDIChildCount > 0);
  if mnuProjectAddAllDoc.Enabled and (MDIChildCount = 1) then
    mnuProjectAddAllDoc.Enabled := (not (ActiveMDIChild is TdlgOptions95))
                                   and (not (ActiveMDIChild is TdlgOptions));
  mnuProjectAddActiveDoc.Enabled := mnuProjectAddAllDoc.Enabled;

  mnuProjectRemoveDoc.Enabled := (FProject <> nil)
                                 and (FProject.DocCount > 0)
                                 and (ActiveMDIChild <> nil);
  if mnuProjectRemoveDoc.Enabled then begin
    if (ActiveMDIChild is TcwEdit95) or (ActiveMDIChild is TcwEdit) then
      {enable if active doc is in project}
      mnuProjectRemoveDoc.Enabled := FProject.InProject(ActiveMDIChild.Caption)
    else if (ActiveMDIChild is TdlgOptions95) then
      {enable if a doc is selected}
      mnuProjectRemoveDoc.Enabled := (ActiveMDIChild as TdlgOptions95).isSelection
    else if (ActiveMDIChild is TdlgOptions) then
      {enable if a doc is selected}
      mnuProjectRemoveDoc.Enabled := (ActiveMDIChild as TdlgOptions).isSelection;
  end;
end;

procedure TfrmMain.mnuProjectAddActiveDocClick(Sender: TObject);
begin
  if (ActiveMDIChild is TcwEdit) then
    FProject.AddLoad((ActiveMDIChild as TcwEdit).FileName)
  else if (ActiveMDIChild is TcwEdit95) then
    FProject.AddLoad((ActiveMDIChild as TcwEdit95).FileName)
end;

procedure TfrmMain.FormCloseQuery(Sender: TObject; var CanClose: Boolean);
var
  SaveResp: Integer;
begin
  CanClose := True;
  if FProject = nil then
    exit;
  if FProject.IsDirty then begin
    SaveResp := MessageDlg(Format(' Save project ''' + '%s' + '''?',
                [FProject.Name]),
                mtConfirmation, mbYesNoCancel, 0);
    case SaveResp of
      idYes: {Nothing};
      idNo: Exit;
      idCancel: begin
        CanClose := False;
        Exit;
      end;
    end;
    CanClose := SaveProject;
  end;
end;

procedure TfrmMain.mnuSearchGotoLineClick(Sender: TObject);
var
  dlgGotoLine: TdlgGoToLine;
begin
  if (ActiveMDIChild <> nil) then begin
    if (ActiveMDIChild is TcwEdit) then begin
      dlgGoToLine := TdlgGoToLine.Create(Self);
      try
        dlgGoToLine.ShowModal;
        if dlgGoToLine.ModalResult = mrOK then begin
          (ActiveMDIChild as TcwEdit).GoToLine(dlgGoToLine.Line);
        end;
      finally
        dlgGoToLine.Free;
      end;
    end
    else
    if (ActiveMDIChild is TcwEdit95) then begin
      dlgGoToLine := TdlgGoToLine.Create(Self);
      try
        dlgGoToLine.ShowModal;
        if dlgGoToLine.ModalResult = mrOK then begin
          (ActiveMDIChild as TcwEdit95).GoToLine(dlgGoToLine.Line);
        end;
      finally
        dlgGoToLine.Free;
      end;
    end;
  end;
end;

end.
