//////////////////////////////////////////////////////////////////
// mysql JDBC Driver Testing class
//
// Version : 0.9.2
//
// JDBC : 1.22
//
// LastModified: 12.03.1997
//
// Copyright (c) 1997 GWE Technologies Ltd. All rights reserved
// See http://gwe.co.uk/mysql/jdbc/copyright.html for full details

import java.net.URL;
import java.sql.*;
import gwe.sql.*;

class testSelect {
  public static void main(String argv[]) {
    try {
	
		// Load the gweMysqlDriver JDBC Driver

        Class.forName("gwe.sql.gweMysqlDriver");

		// The url of the database we wish to connect to
		// jdbc:mysql://host:port/database

        String url = "jdbc:mysql://sql.server.com:3333/test";

		// Set up a connection, as user and password (both as
		// clear text here - the password is encrypted by the
		// driver
		// An empty username is changed to "nobody" in mysql

        Connection con = DriverManager.getConnection(url, "monty", "greatsqldb");

		// Create statement
        Statement stmt = con.createStatement();

		// Execute query
	    String query = "select * from jdbc";

		// Obtain the result set
        ResultSet rs = stmt.executeQuery(query);

        System.out.println("JDBC SQL Query : "+query);
	    System.out.println("\nResults : \n");


		// Loop through each result row
        while(rs.next()) {

			// Print out each field as a string	
			for (int i=1; i<=15; i++) 
				System.out.print(rs.getString(i)+" : ");
			System.out.println("\n");

			// Print out each field as it's type
			byte r1 = rs.getByte(1); System.out.println("r1 : "+r1);
			short r2 = rs.getShort(2); System.out.println("r2 : "+r2);
			int r3 = rs.getInt(3); System.out.println("r3 : "+r3);
			int r4 = rs.getInt(4); System.out.println("r4 : "+r4);
			long r5 = rs.getLong(5); System.out.println("r5 : "+r5);
			float r6 = rs.getFloat(6); System.out.println("r6 : "+r6);
			double r7 = rs.getDouble(7); System.out.println("r7 : "+r7);
			boolean r8 = rs.getBoolean(8); System.out.println("r8 : "+r8);
			Date r9d = rs.getDate(9); System.out.println("r9d : "+r9d);
			Time r9t = rs.getTime(9); System.out.println("r9t : "+r9t);
			Timestamp r9ts = rs.getTimestamp(9); System.out.println("r9ts : "+r9ts);
			String r10 = rs.getString(10); System.out.println("r10 : "+r10);
			String r11 = rs.getString(11); System.out.println("r11 : "+r11);
			String r12 = rs.getString(12); System.out.println("r12 : "+r12);
			String r13 = rs.getString(13); System.out.println("r13 : "+r13);
			String r14 = rs.getString(14); System.out.println("r14 : "+r14);
			String r15 = rs.getString(15); System.out.println("r15 : "+r15);
			byte[] b = rs.getBytes(15); System.out.print("r15 as byte array : ");
			for (int i=0; i<b.length; i++) System.out.print((char)b[i]);

			// Print delimeter - note that here we're calling by
			// column name rather than column index, just for variety.
			System.out.println("\n\n---------------"+rs.getString("r1")+"--------------\n");
		}

		// Close result set
		rs.close();


        String maxQuery = "select max(r1), r2 from jdbc";
        rs = stmt.executeQuery(maxQuery);
        while(rs.next()) {
			System.out.println("max(r1)="+rs.getString(1));
			System.out.println("r2="+rs.getString(2));
		}

		rs.close();

		// Close statement
		stmt.close();

		// Close connection
		con.close();
    }
    catch( Exception e ) {
      System.out.println(e.getMessage());
      e.printStackTrace();
    }
  }
}
  
