/**
 * Example 1: An MVCTextField and Its Model
 *
 * This example shows how you can interact directly with a model
 * and have a view reflect the contents.
 *
 * There are two components in the applet: an MVCTextField and a
 * button.  Enter any String in the text field, press enter, and
 * then press the button to print out the current value of the
 * model.  If you are running this in Netscape, make sure you
 * open the Java console or watch the status bar.
 */

import java.awt.*;
import com.bdnm.mvc.*;

public class Example1 extends java.applet.Applet {

    /**
     * This is the model behind the text field we'll create.
     */
    ValueModel model;

    /**
     * This is the only method we really need.  It is
     * called when the applet is starting up.  This is
     * where we layout the panel.
     */
    public void init() {
        // Just give the examples a distinctive background
        setBackground(new Color(128,128,192));

        // First, create the widget, providing the number of
        // columns just like a TextField.
        MVCTextField field = new MVCTextField(15);

        // Add it to the panel
        add(field);

        // Also add the "Print Value" button
        add(new Button("Print Value"));

        // If there's a tricky part of this example, this is it.
        // Get the model behind the text field and keep track of
        // it.  Since we haven't provided a model, the text field
        // will create a default one for us: a ValueHolder on a
        // String.
        model = field.getModel();

        // Just to show that the field reflects the model, let's
        // set an initial value for the model.
        model.setValue("Initial");
    }

    /**
     * If the button is pressed, print the current value of the
     * model to the console and the status bar.
     */
    public boolean action(Event evt, Object what) {
        if (evt.target instanceof Button) {
            // Just ask the model for its value
            displayText("The current value is " + model.getValue());
            return true;
        }
        return false;
    }

    /**
     * I have something I want to say to the user.  Put it both on
     * the console and the status bar.
     */
    private void displayText(String text) {
        System.out.println(text);
        showStatus(text);
    }

    /**
     * This is just a method to make this run standalone.
     */
    public static void main(String args[]) {
	    Frame f = new Frame("Example 1");
	    Example1 applet = new Example1();

	    applet.init();

	    f.add("Center", applet);
	    f.pack();
    	f.resize(f.preferredSize());
	    f.show();
    }
}