/**
 * Example 2: Two MVCTextFields with the Same Model
 *
 * This example shows how a model can have multiple views
 * associated with it.
 *
 * There are two components in the applet, both MVCTextFields.  If you
 * enter any String in one text field and press enter, the value should
 * appear in the other field.
 */

import java.awt.*;
import com.bdnm.mvc.*;

public class Example2 extends java.applet.Applet {

    /**
     * This is the only method we really need.  It is
     * called when the applet is starting up.  This is
     * where we layout the panel.
     *
     * Note that we don't need to hold onto the model like
     * we did in the last example.  We can hook everything
     * together in this method.
     */
    public void init() {
        // Just give the examples a distinctive background
        setBackground(new Color(128,128,192));

        // First, create the widget, providing the number of
        // columns just like a TextField.  Stick a label out
        // there, too.
        add(new Label("Field 1: "));
        MVCTextField field1 = new MVCTextField(15);
        add(field1);

        // Now add the second text field.
        add(new Label("Field 2: "));
        MVCTextField field2 = new MVCTextField(15);
        add(field2);

        // Watch closely: this is where the magic happens.
        // Just tell field2 to use field1's model.  We could
        // have just as easily told field1 to use field2's or told
        // both of them to use some other model - it doesn't matter
        // as long as they both use the same instance.
        field2.setModel(field1.getModel());
    }

    /**
     * This is just a method to make this run standalone.
     */
    public static void main(String args[]) {
	    Frame f = new Frame("Example 2");
	    Example2 applet = new Example2();

	    applet.init();

	    f.add("Center", applet);
	    f.pack();
    	f.resize(f.preferredSize());
	    f.show();
    }
}