/**
 * Example 3: Two MVCTextFields, Different Applets, Same Model
 *
 * This example shows how a model can span applets.
 *
 * There is just one component in this example: an MVCTextField.
 * It will get the model behind the text field in Example1, so that
 * the contents are matched.
 */

import java.awt.*;
import java.applet.*;
import com.bdnm.mvc.*;

public class Example3 extends Applet {

    /**
     * This is the only method we really need.  It is
     * called when the applet is starting up.  This is
     * where we layout the panel.
     *
     * If I can't find an applet named "Example1", this
     * will not work.
     */
    public void init() {
        // Just give the examples a distinctive background
        setBackground(new Color(128,128,192));

        // Go get the instance of Example1 that's running
        Applet example1 = getAppletContext().getApplet("Example1");

        // For some reason, I may not be able to find it with the
        // above method, so try a different way.
        if (example1 == null) {
            for (java.util.Enumeration e = getAppletContext().getApplets(); e.hasMoreElements(); ) {
                Applet anApplet = (Applet) e.nextElement();
                if (anApplet.getClass().getName().equals("Example1")) {
                    example1 = anApplet;
                    break;
                }
            }
            // If I still haven't found it, "bomb".
            if (example1 == null) {
                add(new Label("Can't find Example1!"));
                return;
            }
        }

        // Okay, now add the text field
        MVCTextField field = new MVCTextField(15);
        add(field);

        // Just like the last example, give field a new model.
        // In this case, just give it the model we are holding
        // on to in Example1.  I just need to make sure that
        // Example1 has finished starting up.
        while (((Example1) example1).model == null) {
            try {
                Thread.sleep(50);
            } catch (InterruptedException e) {
                return;
            }
        }
        field.setModel(((Example1) example1).model);
    }

    // Sorry, no main this time!
}