'From VisualWorks(R), Release 2.5 of September 26, 1995 on May 1, 1996 at 8:33:50 pm'!

ApplicationModel subclass: #Example4
	instanceVariableNames: 'model '
	classVariableNames: ''
	poolDictionaries: ''
	category: 'MVC Examples'!


!Example4 methodsFor: 'actions'!

newValue
	"*** changed April 23, 1996 at 1:26:44 pm by EML (Eric Lunt) ***"

	"If this button is pressed, give the model a new value"

	self model value: Random new next! !

!Example4 methodsFor: 'aspects'!

model
	"*** changed April 23, 1996 at 1:22:57 pm by EML (Eric Lunt) ***"

	"This is a model on a float value. Give it an initial value."

	^model isNil
		ifTrue: [model := Float pi asValue]
		ifFalse: [model]! !

!Example4 methodsFor: 'initialize-release'!

initialize
	"*** created April 23, 1996 at 1:24:34 pm by EML (Eric Lunt) ***"

	"Become a dependent of the model, so we are notified (via the #update: method) when it changes."

	self model addDependent: self! !

!Example4 methodsFor: 'updating'!

update: anAspect
	"*** changed April 23, 1996 at 1:29:45 pm by EML (Eric Lunt) ***"

	"My model has changed. Display two times the new value."

	| newValue |
	newValue := self model value.
	Transcript show: 'Two times the new value is '; show: (2.0 * newValue) printString; cr! !
"-- -- -- -- -- -- -- -- -- -- -- -- -- -- -- -- -- -- "!

Example4 class
	instanceVariableNames: ''!


!Example4 class methodsFor: 'interface specs'!

windowSpec
	"UIPainter new openOnClass: self andSelector: #windowSpec"

	<resource: #canvas>
	^#(#FullSpec 
		#window: 
		#(#WindowSpec 
			#label: 'Example 4' 
			#bounds: #(#Rectangle 412 197 651 249 ) 
			#colors: 
			#(#LookPreferences 
				#setBackgroundColor: #(#ColorValue 6143 6143 8191 ) ) 
			#isEventDriven: true ) 
		#component: 
		#(#SpecCollection 
			#collection: #(
				#(#InputFieldSpec 
					#layout: #(#Rectangle 12 9 112 34 ) 
					#name: #field 
					#model: #model 
					#numChars: 15 
					#type: #number ) 
				#(#ActionButtonSpec 
					#layout: #(#Rectangle 134 9 221 34 ) 
					#name: #newValue 
					#model: #newValue 
					#label: 'New Value' 
					#defaultable: true ) ) ) )! !
