'From VisualWorks(R), Release 2.5 of September 26, 1995 on May 1, 1996 at 8:33:52 pm'!

ApplicationModel subclass: #Example5
	instanceVariableNames: 'timesTwoModel baseModel '
	classVariableNames: ''
	poolDictionaries: ''
	category: 'MVC Examples'!


!Example5 methodsFor: 'aspects'!

baseModel
	"*** changed April 23, 1996 at 1:33:57 pm by EML (Eric Lunt) ***"

	"This is the base model. Give it an initial value"

	^baseModel isNil
		ifTrue: [baseModel := Float pi asValue]
		ifFalse: [baseModel]!

timesTwoModel
	"*** changed April 23, 1996 at 1:37:01 pm by EML (Eric Lunt) ***"

	"This is responsible for being two-times the base model.  Use a handy-dandy PluggableAdaptor."

	^timesTwoModel isNil
		ifTrue: [timesTwoModel := (PluggableAdaptor on: self baseModel)
						getBlock: [:m | m value * 2.0]
						putBlock: [:m :v | m value: v * 0.5]
						updateBlock: [:m :a :p | true]]
		ifFalse: [timesTwoModel]! !
"-- -- -- -- -- -- -- -- -- -- -- -- -- -- -- -- -- -- "!

Example5 class
	instanceVariableNames: ''!


!Example5 class methodsFor: 'interface specs'!

windowSpec
	"UIPainter new openOnClass: self andSelector: #windowSpec"

	<resource: #canvas>
	^#(#FullSpec 
		#window: 
		#(#WindowSpec 
			#label: 'Example 5' 
			#bounds: #(#Rectangle 324 250 563 342 ) 
			#colors: 
			#(#LookPreferences 
				#setBackgroundColor: #(#ColorValue 6143 6143 8191 ) ) 
			#isEventDriven: true ) 
		#component: 
		#(#SpecCollection 
			#collection: #(
				#(#InputFieldSpec 
					#layout: #(#Rectangle 119 9 219 34 ) 
					#name: #baseValue 
					#model: #baseModel 
					#numChars: 15 
					#type: #number ) 
				#(#LabelSpec 
					#layout: #(#Point 16 10 ) 
					#label: 'Base Value:' ) 
				#(#LabelSpec 
					#layout: #(#Point 14 48 ) 
					#label: 'Times Two:' ) 
				#(#InputFieldSpec 
					#layout: #(#Rectangle 119 47 219 72 ) 
					#name: #timesTwo 
					#model: #timesTwoModel 
					#isReadOnly: true 
					#numChars: 15 
					#type: #number ) ) ) )! !
