/**
 * Example 6: An MVCList of Strings
 *
 * This example shows how the list model behind an MVCList
 * works.
 *
 * There are three components in this application: an MVCList
 * which will hold the list of players, and two buttons which
 * change the model behind the list.
 */

import java.awt.*;
import java.util.Vector;
import com.bdnm.mvc.*;

public class Example6 extends java.applet.Applet {

    /**
     * This the is model behind the list which holds
     * onto both the list and the selections.
     */
    SelectionInList listModel;

    /**
     * Hold onto the instances of the buttons - I like
     * this model to figure out what button has been pressed.
     */
    Button bullsButton, magicButton;

    /**
     * Layout the panel here and hold onto the model
     * behind the list.
     */
    public void init() {
        // Just give the examples a distinctive background
        setBackground(new Color(128,128,192));

        // Make sure we have a border layout for this applet.
        // This layout is simple enough that we can use it.
        setLayout(new BorderLayout());

        // Create the MVCList, add it to the center
        MVCList playerList = new MVCList();
        add("Center",playerList);

        // Now add the two buttons
        add("North", bullsButton = new Button("The Bulls"));
        add("South", magicButton = new Button("The Magic"));

        // Now just hold onto the list's model so we can
        // modify it later.
        listModel = playerList.getModel();
    }

    /**
     * If one of our buttons was pressed, fill out the list.
     */
    public boolean action(Event evt, Object what) {
        if (evt.target == bullsButton) {
            populateListWithBulls();
        } else if (evt.target == magicButton) {
            populateListWithMagic();
        } else {
            return false;
        }
        return true;
    }

    /**
     * Make the list have Strings which represent Bulls players
     */
    private void populateListWithBulls() {
        Vector newList = new Vector(5);
        newList.addElement("Scottie Pippen");
        newList.addElement("Dennis Rodman");
        newList.addElement("Luc Longley");
        newList.addElement("Ron Harper");
        newList.addElement("Micheal Jordan");
        listModel.list(newList);
    }

    /**
     * Make the list have Strings which represent Magic players
     */
    private void populateListWithMagic() {
        Vector newList = new Vector(5);
        newList.addElement("Dennis Scott");
        newList.addElement("Shaquille O'Neal");
        newList.addElement("Anfernee Hardaway");
        newList.addElement("Nick Andersen");
        newList.addElement("Horace Grant");
        listModel.list(newList);
    }

    /**
     * This is just a method to make this run standalone.
     */
    public static void main(String args[]) {
	    Frame f = new Frame("Example 6");
	    Example6 applet = new Example6();

	    applet.init();

	    f.add("Center", applet);
	    f.pack();
    	f.resize(f.preferredSize());
	    f.show();
    }
}
