'From VisualWorks(R), Release 2.5 of September 26, 1995 on May 5, 1996 at 10:06:38 pm'!

ApplicationModel subclass: #Example7
	instanceVariableNames: 'listModel '
	classVariableNames: ''
	poolDictionaries: ''
	category: 'MVC Examples'!


!Example7 methodsFor: 'private'!

populateListFromTeam: aTeam
	"*** created May 3, 1996 at 1:10:53 pm by EML (Eric Lunt) ***"

	"Put the team's players in the list"

	self listModel list: aTeam players!

setupList: widgetID withObjectPrinter: printBlock
	"*** created May 3, 1996 at 1:19:26 pm by EML (Eric Lunt) ***"

	"Tell the list to display the elements using the printBlock"

	((self builder componentAt: widgetID) widget)
		selectedVisualBlock: 
			[:view :index | 
			| rw |
			rw := ReversingWrapper on: (Label
							with: (printBlock value: (view sequence at: index))
							attributes: view textStyle
							offset: 2 @ 0).
			rw reverse setValue: true.
			BoundedWrapper on: rw]; visualBlock: [:view :index | BoundedWrapper on: (Label
				with: (printBlock value: (view sequence at: index))
				attributes: view textStyle
				offset: 2 @ 0)]! !

!Example7 methodsFor: 'actions'!

populateListWithBulls
	"*** changed May 3, 1996 at 1:10:19 pm by EML (Eric Lunt) ***"

	"Give the list a new list"

	self populateListFromTeam: Team bulls!

populateListWithMagic
	"*** changed May 3, 1996 at 1:10:26 pm by EML (Eric Lunt) ***"

	"Give the list a new list"

	self populateListFromTeam: Team magic! !

!Example7 methodsFor: 'aspects'!

listModel
	"This method was generated by UIDefiner.  Any edits made here
	may be lost whenever methods are automatically defined.  The
	initialization provided below may have been preempted by an
	initialize method."

	^listModel isNil
		ifTrue:
			[listModel := SelectionInList new]
		ifFalse:
			[listModel]! !

!Example7 methodsFor: 'interface opening'!

postBuildWith: aBuilder
	"*** created May 3, 1996 at 1:16:26 pm by EML (Eric Lunt) ***"

	"This is actually much more complicated than it is in the Java version. I need to tell my right hand list 
	to display the elements differently."

	super postBuildWith: aBuilder.
	self setupList: #rightPlayerList withObjectPrinter: [:player | player lastName , ', ' , player firstName]! !
"-- -- -- -- -- -- -- -- -- -- -- -- -- -- -- -- -- -- "!

Example7 class
	instanceVariableNames: ''!


!Example7 class methodsFor: 'interface specs'!

windowSpec
	"UIPainter new openOnClass: self andSelector: #windowSpec"

	<resource: #canvas>
	^#(#FullSpec 
		#window: 
		#(#WindowSpec 
			#label: 'Example 7' 
			#bounds: #(#Rectangle 293 221 604 437 ) 
			#colors: 
			#(#LookPreferences 
				#setBackgroundColor: #(#ColorValue 6143 6143 8191 ) ) 
			#isEventDriven: true ) 
		#component: 
		#(#SpecCollection 
			#collection: #(
				#(#SequenceViewSpec 
					#layout: #(#LayoutFrame 0 0 25 0 0 0.5 -25 1 ) 
					#name: #leftPlayerList 
					#model: #listModel 
					#useModifierKeys: true 
					#selectionType: #highlight ) 
				#(#ActionButtonSpec 
					#layout: #(#LayoutFrame 0 0 0 0 0 1 25 0 ) 
					#name: #bullsButton 
					#model: #populateListWithBulls 
					#label: 'The Bulls' 
					#defaultable: true ) 
				#(#ActionButtonSpec 
					#layout: #(#LayoutFrame 0 0 -25 1 0 1 0 1 ) 
					#name: #magicButton 
					#model: #populateListWithMagic 
					#label: 'The Magic' 
					#defaultable: true ) 
				#(#SequenceViewSpec 
					#layout: #(#LayoutFrame 0 0.5 25 0 0 1 -25 1 ) 
					#name: #rightPlayerList 
					#model: #listModel 
					#useModifierKeys: true 
					#selectionType: #highlight ) ) ) )! !
