'From VisualWorks(R), Release 2.5 of September 26, 1995 on May 5, 1996 at 10:06:40 pm'!

ApplicationModel subclass: #Example8
	instanceVariableNames: 'player listModel shootingPercentage '
	classVariableNames: ''
	poolDictionaries: ''
	category: 'MVC Examples'!


!Example8 methodsFor: 'actions'!

populateListWithBulls
	"*** changed May 3, 1996 at 1:10:19 pm by EML (Eric Lunt) ***"

	"Give the list a new list"

	self populateListFromTeam: Team bulls!

populateListWithMagic
	"*** changed May 3, 1996 at 1:10:26 pm by EML (Eric Lunt) ***"

	"Give the list a new list"

	self populateListFromTeam: Team magic! !

!Example8 methodsFor: 'aspects'!

listModel
	"This method was generated by UIDefiner.  Any edits made here
	may be lost whenever methods are automatically defined.  The
	initialization provided below may have been preempted by an
	initialize method."

	^listModel isNil
		ifTrue:
			[listModel := SelectionInList new]
		ifFalse:
			[listModel]!

player
	"*** created May 3, 1996 at 2:09:45 pm by EML (Eric Lunt) ***"

	"Usually in VisualWorks you'd change this method to return the player's name. But for kicks and to 
	remain consistent with the Java example, I instead have set the printConverter to send #displayString 
	to the object."

	^player isNil
		ifTrue: [player := self listModel selectionHolder]
		ifFalse: [player]!

shootingPercentage
	"*** changed May 3, 1996 at 2:13:14 pm by EML (Eric Lunt) ***"

	"This takes the place of the ShootingPercentageValueAdaptor Java class.  Smalltalk is definitely nicer than Java here!!"

	^shootingPercentage isNil
		ifTrue: [shootingPercentage := (AspectAdaptor subjectChannel: self player)
						forAspect: #shootingPercentage]
		ifFalse: [shootingPercentage]! !

!Example8 methodsFor: 'private'!

populateListFromTeam: aTeam
	"*** created May 3, 1996 at 1:10:53 pm by EML (Eric Lunt) ***"

	"Put the team's players in the list"

	self listModel list: aTeam players! !
"-- -- -- -- -- -- -- -- -- -- -- -- -- -- -- -- -- -- "!

Example8 class
	instanceVariableNames: ''!


!Example8 class methodsFor: 'interface specs'!

windowSpec
	"UIPainter new openOnClass: self andSelector: #windowSpec"

	<resource: #canvas>
	^#(#FullSpec 
		#window: 
		#(#WindowSpec 
			#label: 'Example 8' 
			#bounds: #(#Rectangle 292 221 709 472 ) 
			#colors: 
			#(#LookPreferences 
				#setBackgroundColor: #(#ColorValue 6143 6143 8191 ) ) 
			#isEventDriven: true ) 
		#component: 
		#(#SpecCollection 
			#collection: #(
				#(#SequenceViewSpec 
					#layout: #(#LayoutFrame 0 0 0 0 0 0.5 -30 1 ) 
					#name: #leftPlayerList 
					#model: #listModel 
					#useModifierKeys: true 
					#selectionType: #highlight ) 
				#(#ActionButtonSpec 
					#layout: #(#LayoutFrame 0 0 -30 1 0 0.25 0 1 ) 
					#name: #bullsButton 
					#model: #populateListWithBulls 
					#label: 'The Bulls' 
					#defaultable: true ) 
				#(#ActionButtonSpec 
					#layout: #(#LayoutFrame 0 0.25 -30 1 0 0.5 0 1 ) 
					#name: #magicButton 
					#model: #populateListWithMagic 
					#label: 'The Magic' 
					#defaultable: true ) 
				#(#InputFieldSpec 
					#layout: #(#LayoutFrame 10 0.5 10 0 -10 1 30 0 ) 
					#name: #playerName 
					#model: #player 
					#isReadOnly: true 
					#type: #object ) 
				#(#LabelSpec 
					#layout: #(#LayoutFrame 10 0.5 40 0 -5 0.75 60 0 ) 
					#label: 'Shooting %:' ) 
				#(#InputFieldSpec 
					#layout: #(#LayoutFrame 5 0.75 40 0 -10 1 60 0 ) 
					#name: #shootingPercentage 
					#model: #shootingPercentage 
					#type: #number ) ) ) )! !
