'From VisualWorks(R), Release 2.5 of September 26, 1995 on May 5, 1996 at 10:06:44 pm'!

ApplicationModel subclass: #Example9
	instanceVariableNames: 'shootingPercentage playerList player teamList '
	classVariableNames: ''
	poolDictionaries: ''
	category: 'MVC Examples'!


!Example9 methodsFor: 'private'!

playersAdaptor
	"*** changed May 3, 1996 at 2:31:01 pm by EML (Eric Lunt) ***"

	"This serves the purpose of the PlayersValueAdaptor class in the Java example."

	^(PluggableAdaptor on: self teamList selectionHolder)
		getBlock: [:m | m value isNil
				ifTrue: [OrderedCollection new]
				ifFalse: [m value players]]
		putBlock: [:m :v | self error: 'Should not be setting players!!']
		updateBlock: [:m :a :p | true]! !

!Example9 methodsFor: 'aspects'!

player
	"*** changed May 3, 1996 at 2:31:37 pm by EML (Eric Lunt) ***"

	"Make this be whatever the current selection is in the playerList"

	^player isNil
		ifTrue:
			[player := self playerList selectionHolder]
		ifFalse:
			[player]!

playerList
	"*** changed May 3, 1996 at 2:28:23 pm by EML (Eric Lunt) ***"

	"Wire the player list to the team list"

	^playerList isNil
		ifTrue:
			[playerList := SelectionInList new listHolder: self playersAdaptor]
		ifFalse:
			[playerList]!

shootingPercentage
	"*** changed May 3, 1996 at 2:31:52 pm by EML (Eric Lunt) ***"

	"This takes the place of the ShootingPercentageValueAdaptor Java class. Smalltalk is definitely nicer 
	than Java here!!"

	^shootingPercentage isNil
		ifTrue: [shootingPercentage := (AspectAdaptor subjectChannel: self player)
						forAspect: #shootingPercentage]
		ifFalse: [shootingPercentage]!

teamList
	"*** changed May 3, 1996 at 2:27:24 pm by EML (Eric Lunt) ***"

	"Set the initial contents of the team."

	^teamList isNil
		ifTrue:
			[teamList := SelectionInList new list: (OrderedCollection with: Team bulls with: Team magic)]
		ifFalse:
			[teamList]! !
"-- -- -- -- -- -- -- -- -- -- -- -- -- -- -- -- -- -- "!

Example9 class
	instanceVariableNames: ''!


!Example9 class methodsFor: 'interface specs'!

windowSpec
	"UIPainter new openOnClass: self andSelector: #windowSpec"

	<resource: #canvas>
	^#(#FullSpec 
		#window: 
		#(#WindowSpec 
			#label: 'Example 9' 
			#bounds: #(#Rectangle 277 226 694 477 ) 
			#colors: 
			#(#LookPreferences 
				#setBackgroundColor: #(#ColorValue 6143 6143 8191 ) ) 
			#isEventDriven: true ) 
		#component: 
		#(#SpecCollection 
			#collection: #(
				#(#SequenceViewSpec 
					#layout: #(#LayoutFrame 0 0 0 0 0 0.5 0 0.3 ) 
					#name: #teamList 
					#model: #teamList 
					#useModifierKeys: true 
					#selectionType: #highlight ) 
				#(#InputFieldSpec 
					#layout: #(#LayoutFrame 10 0.5 10 0 -10 1 30 0 ) 
					#name: #playerName 
					#model: #player 
					#isReadOnly: true 
					#type: #object ) 
				#(#LabelSpec 
					#layout: #(#LayoutFrame 10 0.5 40 0 -5 0.75 60 0 ) 
					#label: 'Shooting %:' ) 
				#(#InputFieldSpec 
					#layout: #(#LayoutFrame 5 0.75 40 0 -10 1 60 0 ) 
					#name: #shootingPercentage 
					#model: #shootingPercentage 
					#type: #number ) 
				#(#SequenceViewSpec 
					#layout: #(#LayoutFrame 0 0 0 0.3 0 0.5 0 1 ) 
					#name: #playerList 
					#model: #playerList 
					#useModifierKeys: true 
					#selectionType: #highlight ) ) ) )! !
