'From VisualWorks(R), Release 2.5 of September 26, 1995 on May 5, 1996 at 10:06:46 pm'!

Model subclass: #Player
	instanceVariableNames: 'lastName firstName birthdate shootingPercentage '
	classVariableNames: ''
	poolDictionaries: ''
	category: 'MVC Examples'!


!Player methodsFor: 'accessing'!

birthdate
	"*** created May 2, 1996 at 10:58:16 am by EML (Eric Lunt) ***"

	"The getter for the player's birthdate. Note that there is no setter."

	^birthdate!

firstName
	"*** created May 2, 1996 at 10:57:05 am by EML (Eric Lunt) ***"

	"The getter for the player's first name. Note that there is no setter."

	^firstName!

lastName
	"*** created May 2, 1996 at 10:57:35 am by EML (Eric Lunt) ***"

	"The getter for the player's last name. Note that there is no setter."

	^lastName!

shootingPercentage
	"*** created May 2, 1996 at 5:05:53 pm by EML (Eric Lunt) ***"

	"The getter for the shooting percentage"

	^shootingPercentage!

shootingPercentage: newPercentage
	"*** changed May 2, 1996 at 5:08:02 pm by EML (Eric Lunt) ***"

	"The setter for the shooting percentage. Validate the argument so it only takes values from 0.0 to 1.0. 
	Also announce the change."

	(newPercentage between: 0.0 and: 1.0)
		ifTrue: [shootingPercentage := newPercentage].
	self changed: #shootingPercentage! !

!Player methodsFor: 'initialize-release'!

lastName: aLastName firstName: aFirstName birthdate: aBirthdate
	"*** changed May 2, 1996 at 10:57:21 am by EML (Eric Lunt) ***"

	"This is an initialization method. Do not call directly."

	lastName := aLastName.
	firstName := aFirstName.
	birthdate := aBirthdate.
	shootingPercentage := 0.0! !

!Player methodsFor: 'printing'!

displayString
	"*** created May 2, 1996 at 5:12:41 pm by EML (Eric Lunt) ***"

	"Create a resonable print representation: the player's first name, a space, and the last name."

	^self firstName , ' ' , self lastName! !

!Player methodsFor: 'operations'!

age
	"*** created May 2, 1996 at 5:11:47 pm by EML (Eric Lunt) ***"

	"Here's a sample function that calculates the age of the player."

	^((Date today subtractDate: self birthdate)
		/ 365) ceiling! !
"-- -- -- -- -- -- -- -- -- -- -- -- -- -- -- -- -- -- "!

Player class
	instanceVariableNames: ''!


!Player class methodsFor: 'instance creation'!

lastName: lastName firstName: firstName birthdate: birthdate
	"*** created May 2, 1996 at 10:53:37 am by EML (Eric Lunt) ***"

	"The minimum information you need to construct a player is the first name, last name, and birthdate. 
	These are not changeable after the player is created."

	^self new
		lastName: lastName
		firstName: firstName
		birthdate: birthdate!

lastName: lastName firstName: firstName birthdate: birthdate shootingPercentage: shootingPercentage
	"*** created May 2, 1996 at 10:54:51 am by EML (Eric Lunt) ***"

	"This is a convenience constructor to completely set up a player at construction time. Note this is not 
	a 'normal' style of instance creation in Smalltalk, but it mirrors the Java code."

	^(self
		lastName: lastName
		firstName: firstName
		birthdate: birthdate)
		shootingPercentage: shootingPercentage! !
