'From VisualWorks(R), Release 2.5 of September 26, 1995 on May 5, 1996 at 10:06:48 pm'!

Model subclass: #Team
	instanceVariableNames: 'name wins losses players '
	classVariableNames: ''
	poolDictionaries: ''
	category: 'MVC Examples'!


!Team methodsFor: 'accessing'!

losses
	"*** created May 2, 1996 at 10:48:28 am by EML (Eric Lunt) ***"

	"The getter for the number of losses"

	^losses!

losses: newLosses
	"*** created May 2, 1996 at 10:48:49 am by EML (Eric Lunt) ***"

	"The setter for the number of losses"

	losses := newLosses.
	self changed: #losses!

name
	"*** created May 2, 1996 at 10:46:33 am by EML (Eric Lunt) ***"

	"The getter for the team's name"

	^name!

players
	"*** created May 2, 1996 at 10:49:33 am by EML (Eric Lunt) ***"

	"The getter for the players.  Just return the entire collection."

	^players!

players: newPlayers
	"*** created May 2, 1996 at 10:50:19 am by EML (Eric Lunt) ***"

	"The setter for players. Note that we're not getting cute and allowing users of this class to add and 
	delete individual players."

	players := newPlayers.
	self changed: #players!

wins
	"*** created May 2, 1996 at 10:46:56 am by EML (Eric Lunt) ***"

	"The getter for the number of wins"

	^wins!

wins: newWins
	"*** created May 2, 1996 at 10:47:41 am by EML (Eric Lunt) ***"

	"The setter for the number of wins"

	wins := newWins.
	self changed: #wins! !

!Team methodsFor: 'initialize-release'!

setName: aName
	"*** changed May 2, 1996 at 10:48:14 am by EML (Eric Lunt) ***"

	"This is an initialization method, not a mutator. In Smalltalk, however, there is no way to enforce this 
	distinction. Although we don't want consumers calling this method, there is nothing the will prevent 
	them from doing so."

	name := aName.
	wins := losses := 0.
	players := OrderedCollection new.! !

!Team methodsFor: 'printing'!

displayString
	"*** created May 2, 1996 at 10:51:04 am by EML (Eric Lunt) ***"

	"Return the team name as a default String representation."

	^self name! !
"-- -- -- -- -- -- -- -- -- -- -- -- -- -- -- -- -- -- "!

Team class
	instanceVariableNames: ''!


!Team class methodsFor: 'instance creation'!

named: aName
	"*** created May 2, 1996 at 10:19:59 am by EML (Eric Lunt) ***"

	"In order to construct a team, we need to provide the name"

	^self new setName: aName! !

!Team class methodsFor: 'utility'!

bulls
	"*** created May 3, 1996 at 1:01:52 pm by EML (Eric Lunt) ***"

	"This creates a Team object which represents the '95-'96 Chicago Bulls."

	| team players |
	team := self named: 'Chicago Bulls'.
	team wins: 72; losses: 10.
	players := OrderedCollection new: 5.
	players add: (Player
			lastName: 'Pippen'
			firstName: 'Scottie'
			birthdate: (Date
					newDay: 25
					monthNumber: 9
					year: 1965)
			shootingPercentage: 0.463); add: (Player
			lastName: 'Rodman'
			firstName: 'Dennis'
			birthdate: (Date
					newDay: 13
					monthNumber: 5
					year: 1961)
			shootingPercentage: 0.48); add: (Player
			lastName: 'Longley'
			firstName: 'Luc'
			birthdate: (Date
					newDay: 19
					monthNumber: 1
					year: 1969)
			shootingPercentage: 0.482); add: (Player
			lastName: 'Harper'
			firstName: 'Ron'
			birthdate: (Date
					newDay: 20
					monthNumber: 1
					year: 1964)
			shootingPercentage: 0.467); add: (Player
			lastName: 'Jordan'
			firstName: 'Micheal'
			birthdate: (Date
					newDay: 17
					monthNumber: 2
					year: 1963)
			shootingPercentage: 0.495).
	team players: players.
	^team!

magic
	"*** created May 3, 1996 at 1:04:57 pm by EML (Eric Lunt) ***"

	"This creates a Team object which represents the '95-'96 Orlando Magic."

	| team players |
	team := self named: 'Orlando Magic'.
	team wins: 60; losses: 22.
	players := OrderedCollection new: 5.
	players add: (Player
			lastName: 'Scott'
			firstName: 'Dennis'
			birthdate: (Date
					newDay: 5
					monthNumber: 9
					year: 1968)
			shootingPercentage: 0.440); add: (Player
			lastName: 'O''Neal'
			firstName: 'Shaquille'
			birthdate: (Date
					newDay: 6
					monthNumber: 3
					year: 1972)
			shootingPercentage: 0.573); add: (Player
			lastName: 'Hardaway'
			firstName: 'Anfernee'
			birthdate: (Date
					newDay: 18
					monthNumber: 7
					year: 1972)
			shootingPercentage: 0.513); add: (Player
			lastName: 'Andersen'
			firstName: 'Nick'
			birthdate: (Date
					newDay: 20
					monthNumber: 1
					year: 1968)
			shootingPercentage: 0.442); add: (Player
			lastName: 'Grant'
			firstName: 'Horace'
			birthdate: (Date
					newDay: 4
					monthNumber: 7
					year: 1965)
			shootingPercentage: 0.513).
	team players: players.
	^team! !
