/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.cs.dennisc.alice;

import edu.cmu.cs.dennisc.alice.Version;
import edu.cmu.cs.dennisc.alice.ast.AbstractType;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import org.alice.virtualmachine.Resource;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Project {
    public static final UUID GROUP_UUID = UUID.fromString("a89d2513-6d9a-4378-a08b-4d773618244d");
    private Set<Resource> resources = Collections.synchronizedSet(new HashSet());
    private AbstractType programType = null;
    private Properties properties = new Properties();

    private static int readInt(BufferedInputStream bis) throws IOException {
        byte[] lengthArray = new byte[4];
        bis.read(lengthArray);
        ByteBuffer buffer = ByteBuffer.wrap(lengthArray);
        return buffer.getInt();
    }

    private static String readString(BufferedInputStream bis) throws IOException {
        int length = Project.readInt(bis);
        byte[] stringArray = new byte[length];
        bis.read(stringArray);
        return new String(stringArray);
    }

    private static void writeInt(BufferedOutputStream bos, int i) throws IOException {
        byte[] array = new byte[4];
        ByteBuffer buffer = ByteBuffer.wrap(array);
        buffer.putInt(i);
        bos.write(array);
    }

    private static void writeString(BufferedOutputStream bos, String s) throws IOException {
        Project.writeInt(bos, s.length());
        bos.write(s.getBytes());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Project(AbstractType programType, Set<Resource> resources) {
        this(programType);
        Set<Resource> set = this.resources;
        synchronized (set) {
            this.resources.addAll(resources);
        }
    }

    public Project(AbstractType programType) {
        this.setProgramType(programType);
    }

    public AbstractType getProgramType() {
        return this.programType;
    }

    private void setProgramType(AbstractType programType) {
        this.programType = programType;
    }

    public Properties getProperties() {
        return this.properties;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addResource(Resource resource) {
        Set<Resource> set = this.resources;
        synchronized (set) {
            if (!this.resources.contains(resource)) {
                this.resources.add(resource);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeResource(Resource resource) {
        Set<Resource> set = this.resources;
        synchronized (set) {
            this.resources.remove(resource);
        }
    }

    public Set<Resource> getResources() {
        return this.resources;
    }

    public class Properties {
        private Map<String, String> map = new HashMap<String, String>();

        public void read(BufferedInputStream bis) {
            if (bis != null) {
                try {
                    String version = Project.readString(bis);
                    int count = Project.readInt(bis);
                    for (int i = 0; i < count; ++i) {
                        String key = Project.readString(bis);
                        String value = Project.readString(bis);
                        this.map.put(key, value);
                    }
                }
                catch (Throwable t) {
                    this.map.clear();
                    t.printStackTrace();
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void write(BufferedOutputStream bos) throws IOException {
            String version = Version.getCurrentVersionText();
            Project.writeString(bos, version);
            Map<String, String> map = this.map;
            synchronized (map) {
                Project.writeInt(bos, this.map.size());
                for (String key : this.map.keySet()) {
                    String value = this.map.get(key);
                    Project.writeString(bos, key);
                    Project.writeString(bos, value);
                }
            }
            bos.flush();
        }

        public String getString(String key, String def) {
            String value = this.map.get(key);
            String rv = value != null ? value : def;
            return rv;
        }

        public boolean getBoolean(String key, boolean def) {
            String value = this.map.get(key);
            boolean rv = value != null ? Boolean.valueOf(value) : def;
            return rv;
        }

        public int getInteger(String key, int def) {
            String value = this.map.get(key);
            int rv = value != null ? Integer.valueOf(value) : def;
            return rv;
        }

        public long getLong(String key, long def) {
            String value = this.map.get(key);
            long rv = value != null ? Long.valueOf(value) : def;
            return rv;
        }

        public float getFloat(String key, float def) {
            String value = this.map.get(key);
            float rv = value != null ? Float.valueOf(value).floatValue() : def;
            return rv;
        }

        public double getDouble(String key, double def) {
            String value = this.map.get(key);
            double rv = value != null ? Double.valueOf(value) : def;
            return rv;
        }

        public byte[] getByteArray(String key, byte[] def) {
            String value = this.map.get(key);
            byte[] rv = value != null ? value.getBytes() : def;
            return rv;
        }

        public void putString(String key, String value) {
            this.map.put(key, value);
        }

        public void putBoolean(String key, boolean value) {
            this.map.put(key, Boolean.toString(value));
        }

        public void putInteger(String key, int value) {
            this.map.put(key, Integer.toString(value));
        }

        public void putLong(String key, long value) {
            this.map.put(key, Long.toString(value));
        }

        public void putFloat(String key, float value) {
            this.map.put(key, Float.toString(value));
        }

        public void putDouble(String key, double value) {
            this.map.put(key, Double.toString(value));
        }

        public void putByteArray(String key, byte[] value) {
            this.map.put(key, new String(value));
        }
    }
}

