/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.cs.dennisc.alice.ast;

import edu.cmu.cs.dennisc.alice.ast.AbstractAccessibleDeclaration;
import edu.cmu.cs.dennisc.alice.ast.AbstractConstructor;
import edu.cmu.cs.dennisc.alice.ast.AbstractField;
import edu.cmu.cs.dennisc.alice.ast.AbstractMethod;
import edu.cmu.cs.dennisc.alice.ast.AbstractPackage;
import edu.cmu.cs.dennisc.alice.ast.AbstractParameter;
import edu.cmu.cs.dennisc.alice.ast.TypeDeclaredInJava;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractType
extends AbstractAccessibleDeclaration {
    private static Map<Class<?>, Class<?>> s_mapPrimitiveToWrapper = new HashMap();

    private static Class<?> getClsWrapperIfNecessary(TypeDeclaredInJava typeDeclaredInJava) {
        Class<?> rv = (Class<?>)typeDeclaredInJava.getClassReflectionProxy().getReification();
        assert (rv != null) : typeDeclaredInJava;
        if (rv.isPrimitive()) {
            rv = s_mapPrimitiveToWrapper.get(rv);
            assert (rv != null);
        }
        return rv;
    }

    public TypeDeclaredInJava getFirstTypeEncounteredDeclaredInJava() {
        AbstractType type = this;
        while (!(type instanceof TypeDeclaredInJava)) {
            type = type.getSuperType();
        }
        return (TypeDeclaredInJava)type;
    }

    public boolean isAssignableFrom(AbstractType other) {
        if (other != null) {
            TypeDeclaredInJava thisTypeDeclaredInJava = this.getFirstTypeEncounteredDeclaredInJava();
            TypeDeclaredInJava otherTypeDeclaredInJava = other.getFirstTypeEncounteredDeclaredInJava();
            return AbstractType.getClsWrapperIfNecessary(thisTypeDeclaredInJava).isAssignableFrom(AbstractType.getClsWrapperIfNecessary(otherTypeDeclaredInJava));
        }
        return false;
    }

    public boolean isAssignableFrom(Class<?> other) {
        return this.isAssignableFrom(TypeDeclaredInJava.get(other));
    }

    public boolean isAssignableTo(AbstractType other) {
        return other.isAssignableFrom(this);
    }

    public boolean isAssignableTo(Class<?> other) {
        return this.isAssignableTo(TypeDeclaredInJava.get(other));
    }

    public abstract boolean isFollowToSuperClassDesired();

    public abstract boolean isConsumptionBySubClassDesired();

    public abstract AbstractPackage getPackage();

    public abstract AbstractType getSuperType();

    public abstract ArrayList<? extends AbstractConstructor> getDeclaredConstructors();

    public abstract ArrayList<? extends AbstractMethod> getDeclaredMethods();

    public abstract ArrayList<? extends AbstractField> getDeclaredFields();

    public abstract boolean isInterface();

    public abstract boolean isStatic();

    public abstract boolean isAbstract();

    public abstract boolean isFinal();

    public abstract boolean isStrictFloatingPoint();

    public abstract boolean isArray();

    public abstract AbstractType getComponentType();

    public AbstractConstructor getDeclaredConstructor() {
        return this.getDeclaredConstructor(new AbstractType[0]);
    }

    public AbstractConstructor getDeclaredConstructor(AbstractType ... parameterTypes) {
        AbstractConstructor rv = null;
        Iterator<? extends AbstractConstructor> i$ = this.getDeclaredConstructors().iterator();
        while (i$.hasNext()) {
            AbstractConstructor constructor;
            rv = constructor = i$.next();
            ArrayList<? extends AbstractParameter> parameters = constructor.getParameters();
            for (int i = 0; i < parameterTypes.length; ++i) {
                AbstractType parameterType = parameterTypes[i];
                if (parameterType.equals(parameters.get(i).getValueType())) continue;
                rv = null;
                break;
            }
            if (rv == null) continue;
            break;
        }
        return rv;
    }

    public AbstractConstructor getDeclaredConstructor(Class<?> ... parameterClses) {
        return this.getDeclaredConstructor(TypeDeclaredInJava.get(parameterClses));
    }

    public AbstractMethod getDeclaredMethod(String name) {
        return this.getDeclaredMethod(name, new AbstractType[0]);
    }

    public AbstractMethod getDeclaredMethod(String name, AbstractType ... parameterTypes) {
        AbstractMethod rv = null;
        for (AbstractMethod abstractMethod : this.getDeclaredMethods()) {
            if (abstractMethod.getName().equals(name)) {
                ArrayList<? extends AbstractParameter> parameters = abstractMethod.getParameters();
                if (parameters.size() == parameterTypes.length) {
                    rv = abstractMethod;
                    for (int i = 0; i < parameterTypes.length; ++i) {
                        AbstractType parameterType = parameterTypes[i];
                        if (parameterType.equals(parameters.get(i).getValueType())) continue;
                        rv = null;
                        break;
                    }
                }
                if (rv == null) continue;
                break;
            }
            rv = null;
        }
        return rv;
    }

    public AbstractMethod getDeclaredMethod(String name, Class<?> ... parameterClses) {
        return this.getDeclaredMethod(name, TypeDeclaredInJava.get(parameterClses));
    }

    public AbstractField getDeclaredField(AbstractType valueType, String name) {
        AbstractField rv = null;
        for (AbstractField abstractField : this.getDeclaredFields()) {
            if (abstractField.getName().equals(name) && abstractField.getValueType().equals(valueType)) {
                rv = abstractField;
                break;
            }
            rv = null;
        }
        return rv;
    }

    public AbstractField getDeclaredField(Class<?> valueCls, String name) {
        return this.getDeclaredField(TypeDeclaredInJava.get(valueCls), name);
    }

    public abstract AbstractType getArrayType();

    public AbstractMethod findMethod(String name, AbstractType ... parameterTypes) {
        AbstractMethod rv = null;
        for (AbstractType type = this; type != null; type = type.getSuperType()) {
            AbstractMethod method = type.getDeclaredMethod(name, parameterTypes);
            if (method == null) continue;
            rv = method;
            break;
        }
        return rv;
    }

    static {
        s_mapPrimitiveToWrapper.put(Void.TYPE, Void.class);
        s_mapPrimitiveToWrapper.put(Boolean.TYPE, Boolean.class);
        s_mapPrimitiveToWrapper.put(Byte.TYPE, Byte.class);
        s_mapPrimitiveToWrapper.put(Character.TYPE, Character.class);
        s_mapPrimitiveToWrapper.put(Short.TYPE, Short.class);
        s_mapPrimitiveToWrapper.put(Integer.TYPE, Integer.class);
        s_mapPrimitiveToWrapper.put(Long.TYPE, Long.class);
        s_mapPrimitiveToWrapper.put(Float.TYPE, Float.class);
        s_mapPrimitiveToWrapper.put(Double.TYPE, Double.class);
    }
}

