/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.cs.dennisc.alice.ast;

import edu.cmu.cs.dennisc.alice.ast.AbstractType;
import edu.cmu.cs.dennisc.alice.ast.DeclarationProperty;
import edu.cmu.cs.dennisc.alice.ast.Expression;
import edu.cmu.cs.dennisc.alice.ast.InfixExpression;
import edu.cmu.cs.dennisc.alice.ast.TypeDeclaredInJava;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ArithmeticInfixExpression
extends InfixExpression<Operator> {
    public DeclarationProperty<AbstractType> expressionType = new DeclarationProperty(this);

    public ArithmeticInfixExpression() {
    }

    public ArithmeticInfixExpression(Expression leftOperand, Operator operator, Expression rightOperand, AbstractType expressionType) {
        super(leftOperand, operator, rightOperand);
        assert (TypeDeclaredInJava.get(Number.class).isAssignableFrom(expressionType) || TypeDeclaredInJava.get(Double.TYPE).isAssignableFrom(expressionType) || TypeDeclaredInJava.get(Integer.TYPE).isAssignableFrom(expressionType));
        this.expressionType.setValue(expressionType);
    }

    public ArithmeticInfixExpression(Expression leftOperand, Operator operator, Expression rightOperand, Class<?> expressionCls) {
        this(leftOperand, operator, rightOperand, TypeDeclaredInJava.get(expressionCls));
    }

    @Override
    protected AbstractType getLeftOperandType() {
        return (AbstractType)this.expressionType.getValue();
    }

    @Override
    protected AbstractType getRightOperandType() {
        return (AbstractType)this.expressionType.getValue();
    }

    @Override
    public AbstractType getType() {
        return (AbstractType)this.expressionType.getValue();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Operator {
        PLUS{

            public Number operate(Number leftOperand, Number rightOperand) {
                assert (leftOperand != null);
                assert (rightOperand != null);
                if (leftOperand instanceof Double || rightOperand instanceof Double) {
                    return leftOperand.doubleValue() + rightOperand.doubleValue();
                }
                if (leftOperand instanceof Float || rightOperand instanceof Float) {
                    return Float.valueOf(leftOperand.floatValue() + rightOperand.floatValue());
                }
                if (leftOperand instanceof Long || rightOperand instanceof Long) {
                    return leftOperand.longValue() + rightOperand.longValue();
                }
                if (leftOperand instanceof Integer || rightOperand instanceof Integer) {
                    return leftOperand.intValue() + rightOperand.intValue();
                }
                if (leftOperand instanceof Short || rightOperand instanceof Short) {
                    return leftOperand.shortValue() + rightOperand.shortValue();
                }
                if (leftOperand instanceof Byte || rightOperand instanceof Byte) {
                    return leftOperand.byteValue() + rightOperand.byteValue();
                }
                throw new RuntimeException();
            }
        }
        ,
        MINUS{

            public Number operate(Number leftOperand, Number rightOperand) {
                assert (leftOperand != null);
                assert (rightOperand != null);
                if (leftOperand instanceof Double || rightOperand instanceof Double) {
                    return leftOperand.doubleValue() - rightOperand.doubleValue();
                }
                if (leftOperand instanceof Float || rightOperand instanceof Float) {
                    return Float.valueOf(leftOperand.floatValue() - rightOperand.floatValue());
                }
                if (leftOperand instanceof Long || rightOperand instanceof Long) {
                    return leftOperand.longValue() - rightOperand.longValue();
                }
                if (leftOperand instanceof Integer || rightOperand instanceof Integer) {
                    return leftOperand.intValue() - rightOperand.intValue();
                }
                if (leftOperand instanceof Short || rightOperand instanceof Short) {
                    return leftOperand.shortValue() - rightOperand.shortValue();
                }
                if (leftOperand instanceof Byte || rightOperand instanceof Byte) {
                    return leftOperand.byteValue() - rightOperand.byteValue();
                }
                throw new RuntimeException();
            }
        }
        ,
        TIMES{

            public Number operate(Number leftOperand, Number rightOperand) {
                assert (leftOperand != null);
                assert (rightOperand != null);
                if (leftOperand instanceof Double || rightOperand instanceof Double) {
                    return leftOperand.doubleValue() * rightOperand.doubleValue();
                }
                if (leftOperand instanceof Float || rightOperand instanceof Float) {
                    return Float.valueOf(leftOperand.floatValue() * rightOperand.floatValue());
                }
                if (leftOperand instanceof Long || rightOperand instanceof Long) {
                    return leftOperand.longValue() * rightOperand.longValue();
                }
                if (leftOperand instanceof Integer || rightOperand instanceof Integer) {
                    return leftOperand.intValue() * rightOperand.intValue();
                }
                if (leftOperand instanceof Short || rightOperand instanceof Short) {
                    return leftOperand.shortValue() * rightOperand.shortValue();
                }
                if (leftOperand instanceof Byte || rightOperand instanceof Byte) {
                    return leftOperand.byteValue() * rightOperand.byteValue();
                }
                throw new RuntimeException();
            }
        }
        ,
        REAL_DIVIDE{

            public Number operate(Number leftOperand, Number rightOperand) {
                assert (leftOperand != null);
                assert (rightOperand != null);
                if (leftOperand instanceof Double || rightOperand instanceof Double) {
                    return leftOperand.doubleValue() / rightOperand.doubleValue();
                }
                if (leftOperand instanceof Float || rightOperand instanceof Float) {
                    return Float.valueOf(leftOperand.floatValue() / rightOperand.floatValue());
                }
                if (leftOperand instanceof Long || rightOperand instanceof Long) {
                    return (double)leftOperand.longValue() / (double)rightOperand.longValue();
                }
                if (leftOperand instanceof Integer || rightOperand instanceof Integer) {
                    return (double)leftOperand.intValue() / (double)rightOperand.intValue();
                }
                if (leftOperand instanceof Short || rightOperand instanceof Short) {
                    return (double)leftOperand.shortValue() / (double)rightOperand.shortValue();
                }
                if (leftOperand instanceof Byte || rightOperand instanceof Byte) {
                    return (double)leftOperand.byteValue() / (double)rightOperand.byteValue();
                }
                throw new RuntimeException();
            }
        }
        ,
        INTEGER_DIVIDE{

            public Number operate(Number leftOperand, Number rightOperand) {
                assert (leftOperand != null);
                assert (rightOperand != null);
                if (leftOperand instanceof Double || rightOperand instanceof Double) {
                    return (int)leftOperand.doubleValue() / (int)rightOperand.doubleValue();
                }
                if (leftOperand instanceof Float || rightOperand instanceof Float) {
                    return (int)leftOperand.floatValue() / (int)rightOperand.floatValue();
                }
                if (leftOperand instanceof Long || rightOperand instanceof Long) {
                    return leftOperand.longValue() / rightOperand.longValue();
                }
                if (leftOperand instanceof Integer || rightOperand instanceof Integer) {
                    return leftOperand.intValue() / rightOperand.intValue();
                }
                if (leftOperand instanceof Short || rightOperand instanceof Short) {
                    return leftOperand.shortValue() / rightOperand.shortValue();
                }
                if (leftOperand instanceof Byte || rightOperand instanceof Byte) {
                    return leftOperand.byteValue() / rightOperand.byteValue();
                }
                throw new RuntimeException();
            }
        }
        ,
        REAL_REMAINDER{

            public Number operate(Number leftOperand, Number rightOperand) {
                assert (leftOperand != null);
                assert (rightOperand != null);
                if (leftOperand instanceof Double || rightOperand instanceof Double) {
                    return leftOperand.doubleValue() % rightOperand.doubleValue();
                }
                if (leftOperand instanceof Float || rightOperand instanceof Float) {
                    return Float.valueOf(leftOperand.floatValue() % rightOperand.floatValue());
                }
                if (leftOperand instanceof Long || rightOperand instanceof Long) {
                    return (double)leftOperand.longValue() % (double)rightOperand.longValue();
                }
                if (leftOperand instanceof Integer || rightOperand instanceof Integer) {
                    return (double)leftOperand.intValue() % (double)rightOperand.intValue();
                }
                if (leftOperand instanceof Short || rightOperand instanceof Short) {
                    return (double)leftOperand.shortValue() % (double)rightOperand.shortValue();
                }
                if (leftOperand instanceof Byte || rightOperand instanceof Byte) {
                    return (double)leftOperand.byteValue() % (double)rightOperand.byteValue();
                }
                throw new RuntimeException();
            }
        }
        ,
        INTEGER_REMAINDER{

            public Number operate(Number leftOperand, Number rightOperand) {
                assert (leftOperand != null);
                assert (rightOperand != null);
                if (leftOperand instanceof Double || rightOperand instanceof Double) {
                    return (int)leftOperand.doubleValue() % (int)rightOperand.doubleValue();
                }
                if (leftOperand instanceof Float || rightOperand instanceof Float) {
                    return (int)leftOperand.floatValue() % (int)rightOperand.floatValue();
                }
                if (leftOperand instanceof Long || rightOperand instanceof Long) {
                    return leftOperand.longValue() % rightOperand.longValue();
                }
                if (leftOperand instanceof Integer || rightOperand instanceof Integer) {
                    return leftOperand.intValue() % rightOperand.intValue();
                }
                if (leftOperand instanceof Short || rightOperand instanceof Short) {
                    return leftOperand.shortValue() % rightOperand.shortValue();
                }
                if (leftOperand instanceof Byte || rightOperand instanceof Byte) {
                    return leftOperand.byteValue() % rightOperand.byteValue();
                }
                throw new RuntimeException();
            }
        };


        public abstract Number operate(Number var1, Number var2);
    }
}

