/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.cs.dennisc.alice.ast;

import edu.cmu.cs.dennisc.alice.ast.AbstractConstructor;
import edu.cmu.cs.dennisc.alice.ast.AbstractField;
import edu.cmu.cs.dennisc.alice.ast.AbstractMethod;
import edu.cmu.cs.dennisc.alice.ast.AbstractPackage;
import edu.cmu.cs.dennisc.alice.ast.AbstractType;
import edu.cmu.cs.dennisc.alice.ast.AbstractTypeDeclaredInAlice;
import edu.cmu.cs.dennisc.alice.ast.Access;
import edu.cmu.cs.dennisc.alice.ast.TypeDeclaredInJava;
import edu.cmu.cs.dennisc.lang.reflect.ReflectionUtilities;
import edu.cmu.cs.dennisc.map.MapToMap;
import edu.cmu.cs.dennisc.property.StringProperty;
import java.util.ArrayList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ArrayTypeDeclaredInAlice
extends AbstractType {
    private static MapToMap<AbstractTypeDeclaredInAlice, Integer, ArrayTypeDeclaredInAlice> s_map = new MapToMap();
    private AbstractTypeDeclaredInAlice m_leafType;
    private int m_dimensionCount;

    public static ArrayTypeDeclaredInAlice get(AbstractTypeDeclaredInAlice leafType, int dimensionCount) {
        ArrayTypeDeclaredInAlice rv = s_map.get(leafType, dimensionCount);
        if (rv == null) {
            rv = new ArrayTypeDeclaredInAlice(leafType, dimensionCount);
            s_map.put(leafType, dimensionCount, rv);
        }
        return rv;
    }

    private ArrayTypeDeclaredInAlice(AbstractTypeDeclaredInAlice leafType, int dimensionCount) {
        this.m_leafType = leafType;
        this.m_dimensionCount = dimensionCount;
    }

    public AbstractTypeDeclaredInAlice getLeafType() {
        return this.m_leafType;
    }

    public int getDimensionCount() {
        return this.m_dimensionCount;
    }

    @Override
    public String getName() {
        StringBuffer sb = new StringBuffer();
        sb.append(this.m_leafType.getName());
        for (int i = 0; i < this.m_dimensionCount; ++i) {
            sb.append("[]");
        }
        return sb.toString();
    }

    @Override
    public StringProperty getNamePropertyIfItExists() {
        return null;
    }

    @Override
    public boolean isArray() {
        return true;
    }

    @Override
    public AbstractType getComponentType() {
        if (this.m_dimensionCount == 1) {
            return this.m_leafType;
        }
        return ArrayTypeDeclaredInAlice.get(this.m_leafType, this.m_dimensionCount - 1);
    }

    @Override
    public boolean isDeclaredInAlice() {
        return true;
    }

    @Override
    public AbstractPackage getPackage() {
        return this.m_leafType.getPackage();
    }

    @Override
    public AbstractType getSuperType() {
        AbstractType superType = this.m_leafType.getSuperType();
        if (superType instanceof AbstractTypeDeclaredInAlice) {
            return ArrayTypeDeclaredInAlice.get((AbstractTypeDeclaredInAlice)superType, this.m_dimensionCount);
        }
        assert (superType instanceof TypeDeclaredInJava);
        return TypeDeclaredInJava.get(ReflectionUtilities.getArrayClass(superType.getClass(), this.m_dimensionCount));
    }

    @Override
    public boolean isFollowToSuperClassDesired() {
        return this.m_leafType.isFollowToSuperClassDesired();
    }

    @Override
    public boolean isConsumptionBySubClassDesired() {
        return this.m_leafType.isConsumptionBySubClassDesired();
    }

    @Override
    public ArrayList<? extends AbstractConstructor> getDeclaredConstructors() {
        return new ArrayList();
    }

    @Override
    public ArrayList<? extends AbstractField> getDeclaredFields() {
        return new ArrayList();
    }

    @Override
    public ArrayList<? extends AbstractMethod> getDeclaredMethods() {
        return new ArrayList();
    }

    @Override
    public Access getAccess() {
        return this.m_leafType.getAccess();
    }

    @Override
    public boolean isInterface() {
        return this.m_leafType.isInterface();
    }

    @Override
    public boolean isAbstract() {
        return this.m_leafType.isAbstract();
    }

    @Override
    public boolean isFinal() {
        return this.m_leafType.isFinal();
    }

    @Override
    public boolean isStatic() {
        return this.m_leafType.isStatic();
    }

    @Override
    public boolean isStrictFloatingPoint() {
        return this.m_leafType.isStrictFloatingPoint();
    }

    @Override
    public AbstractType getArrayType() {
        return ArrayTypeDeclaredInAlice.get(this.m_leafType, this.m_dimensionCount + 1);
    }
}

