/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.cs.dennisc.alice.ast;

import edu.cmu.cs.dennisc.alice.Version;
import edu.cmu.cs.dennisc.alice.ast.AbstractDeclaration;
import edu.cmu.cs.dennisc.alice.ast.AnonymousConstructor;
import edu.cmu.cs.dennisc.alice.ast.ArrayTypeDeclaredInAlice;
import edu.cmu.cs.dennisc.alice.ast.ClassReflectionProxy;
import edu.cmu.cs.dennisc.alice.ast.ConstructorDeclaredInJava;
import edu.cmu.cs.dennisc.alice.ast.ConstructorReflectionProxy;
import edu.cmu.cs.dennisc.alice.ast.DeclarationProperty;
import edu.cmu.cs.dennisc.alice.ast.Decoder;
import edu.cmu.cs.dennisc.alice.ast.FieldDeclaredInJavaWithField;
import edu.cmu.cs.dennisc.alice.ast.FieldDeclaredInJavaWithGetterAndSetter;
import edu.cmu.cs.dennisc.alice.ast.FieldReflectionProxy;
import edu.cmu.cs.dennisc.alice.ast.MemberReflectionProxy;
import edu.cmu.cs.dennisc.alice.ast.MethodDeclaredInJava;
import edu.cmu.cs.dennisc.alice.ast.MethodReflectionProxy;
import edu.cmu.cs.dennisc.alice.ast.NodeListProperty;
import edu.cmu.cs.dennisc.alice.ast.NodeProperty;
import edu.cmu.cs.dennisc.alice.ast.ParameterDeclaredInJavaConstructor;
import edu.cmu.cs.dennisc.alice.ast.ParameterDeclaredInJavaMethod;
import edu.cmu.cs.dennisc.alice.ast.TypeDeclaredInJava;
import edu.cmu.cs.dennisc.pattern.Crawlable;
import edu.cmu.cs.dennisc.pattern.Crawler;
import edu.cmu.cs.dennisc.pattern.DefaultInstancePropertyOwner;
import edu.cmu.cs.dennisc.print.PrintUtilities;
import edu.cmu.cs.dennisc.property.ListProperty;
import edu.cmu.cs.dennisc.property.Property;
import edu.cmu.cs.dennisc.property.event.AddListPropertyEvent;
import edu.cmu.cs.dennisc.property.event.ClearListPropertyEvent;
import edu.cmu.cs.dennisc.property.event.PropertyEvent;
import edu.cmu.cs.dennisc.property.event.RemoveListPropertyEvent;
import edu.cmu.cs.dennisc.property.event.SetListPropertyEvent;
import edu.cmu.cs.dennisc.xml.XMLUtilities;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import org.alice.virtualmachine.Resource;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class Node
extends DefaultInstancePropertyOwner
implements Crawlable {
    private UUID m_uuid = UUID.randomUUID();
    private Node parent;
    private static boolean isReferencedDeclarationPropertyInclusionDesired = false;
    private static final double VERSION = 3.0;

    public UUID getUUID() {
        return this.m_uuid;
    }

    void setUUID(UUID uuid) {
        this.m_uuid = uuid;
    }

    public Node getParent() {
        return this.parent;
    }

    private void setParent(Node parent) {
        if (this.parent != parent) {
            if (this.parent != null && parent != null) {
                PrintUtilities.println("WARNING: setOwner previous not null", this);
            }
            this.parent = parent;
        }
    }

    public <E extends Node> E getFirstAncestorAssignableTo(Class<E> cls, boolean isThisIncludedInSearch) {
        Node rv;
        for (rv = isThisIncludedInSearch ? this : this.getParent(); rv != null && !cls.isAssignableFrom(rv.getClass()); rv = rv.getParent()) {
        }
        return (E)rv;
    }

    public final <E extends Node> E getFirstAncestorAssignableTo(Class<E> cls) {
        return this.getFirstAncestorAssignableTo(cls, false);
    }

    @Override
    public void firePropertyChanging(PropertyEvent e) {
        Node node;
        NodeProperty nodeProperty;
        boolean isReference;
        super.firePropertyChanging(e);
        Property property = (Property)e.getTypedSource();
        if (property instanceof NodeProperty && !(isReference = (nodeProperty = (NodeProperty)property) instanceof DeclarationProperty ? ((DeclarationProperty)nodeProperty).isReference() : false) && (node = (Node)nodeProperty.getValue()) != null) {
            node.setParent(null);
        }
    }

    @Override
    public void firePropertyChanged(PropertyEvent e) {
        Node node;
        NodeProperty nodeProperty;
        boolean isReference;
        super.firePropertyChanged(e);
        Property property = (Property)e.getTypedSource();
        if (property instanceof NodeProperty && !(isReference = (nodeProperty = (NodeProperty)property) instanceof DeclarationProperty ? ((DeclarationProperty)nodeProperty).isReference() : false) && (node = (Node)nodeProperty.getValue()) != null) {
            node.setParent(this);
        }
    }

    @Override
    public void fireClearing(ClearListPropertyEvent e) {
        super.fireClearing(e);
        ListProperty listProperty = (ListProperty)e.getSource();
        if (listProperty instanceof NodeListProperty) {
            NodeListProperty nodeListProperty = (NodeListProperty)listProperty;
            for (Node node : nodeListProperty) {
                if (node == null) continue;
                node.setParent(null);
            }
        }
    }

    @Override
    public void fireRemoving(RemoveListPropertyEvent e) {
        super.fireRemoving(e);
        ListProperty listProperty = (ListProperty)e.getSource();
        if (listProperty instanceof NodeListProperty) {
            for (Object o : e.getElements()) {
                if (!(o instanceof Node)) continue;
                ((Node)o).setParent(null);
            }
        }
    }

    @Override
    public void fireSetting(SetListPropertyEvent e) {
        super.fireSetting(e);
        ListProperty listProperty = (ListProperty)e.getSource();
        if (listProperty instanceof NodeListProperty) {
            for (Object o : e.getElements()) {
                if (!(o instanceof Node)) continue;
                ((Node)o).setParent(null);
            }
        }
    }

    @Override
    public void fireSet(SetListPropertyEvent e) {
        super.fireSet(e);
        ListProperty listProperty = (ListProperty)e.getSource();
        if (listProperty instanceof NodeListProperty) {
            for (Object o : e.getElements()) {
                if (!(o instanceof Node)) continue;
                ((Node)o).setParent(this);
            }
        }
    }

    @Override
    public void fireAdded(AddListPropertyEvent e) {
        super.fireAdded(e);
        ListProperty listProperty = (ListProperty)e.getSource();
        if (listProperty instanceof NodeListProperty) {
            for (Object o : e.getElements()) {
                if (!(o instanceof Node)) continue;
                ((Node)o).setParent(this);
            }
        }
    }

    @Override
    public boolean isComposedOfGetterAndSetterProperties() {
        return false;
    }

    private static void acceptIfCrawlable(Set<Crawlable> alreadyVisited, Object value, Crawler crawler) {
        if (value instanceof Crawlable) {
            Crawlable crawlable = (Crawlable)value;
            crawlable.accept(alreadyVisited, crawler);
        }
    }

    @Override
    public void accept(Set<Crawlable> alreadyVisited, Crawler crawler) {
        if (!alreadyVisited.contains(this)) {
            alreadyVisited.add(this);
            crawler.visit(this);
            for (Property<?> property : this.getProperties()) {
                DeclarationProperty declarationProperty;
                if (!isReferencedDeclarationPropertyInclusionDesired && property instanceof DeclarationProperty && (declarationProperty = (DeclarationProperty)property).isReference()) continue;
                Object value = property.getValue(this);
                if (value instanceof Iterable) {
                    Iterable iterable = (Iterable)value;
                    for (Object item : iterable) {
                        Node.acceptIfCrawlable(alreadyVisited, item, crawler);
                    }
                    continue;
                }
                if (value instanceof Object[]) {
                    Object[] array;
                    for (Object item : array = (Object[])value) {
                        Node.acceptIfCrawlable(alreadyVisited, item, crawler);
                    }
                    continue;
                }
                Node.acceptIfCrawlable(alreadyVisited, value, crawler);
            }
        }
    }

    public final synchronized void crawl(Crawler crawler, boolean isReferencedDeclarationPropertyInclusionDesired) {
        Node.isReferencedDeclarationPropertyInclusionDesired = isReferencedDeclarationPropertyInclusionDesired;
        this.accept(new HashSet<Crawlable>(), crawler);
    }

    private static Element encodeValue(Object value, Document xmlDocument, Set<AbstractDeclaration> set) {
        Element rv;
        if (value instanceof Node) {
            Node node = (Node)value;
            rv = node.encode(xmlDocument, set);
        } else if (value instanceof Collection) {
            rv = xmlDocument.createElement("collection");
            rv.setAttribute("type", value.getClass().getName());
            Collection collection = (Collection)value;
            for (Object item : collection) {
                rv.appendChild(Node.encodeValue(item, xmlDocument, set));
            }
        } else {
            rv = xmlDocument.createElement("value");
            if (value != null) {
                String text;
                rv.setAttribute("type", value.getClass().getName());
                if (value instanceof Resource) {
                    Resource resource = (Resource)value;
                    text = resource.getUUID().toString();
                } else {
                    text = value.toString();
                }
                rv.appendChild(xmlDocument.createTextNode(text));
            } else {
                rv.setAttribute("isNull", "true");
            }
        }
        return rv;
    }

    protected final Element encodeProperty(Document xmlDocument, Property property, Set<AbstractDeclaration> set) {
        Element xmlProperty = xmlDocument.createElement("property");
        xmlProperty.setAttribute("name", property.getName());
        Object value = property.getValue(this);
        xmlProperty.appendChild(Node.encodeValue(value, xmlDocument, set));
        return xmlProperty;
    }

    private static Element encodeType(Document xmlDocument, String nodeName, ClassReflectionProxy classReflectionProxy) {
        Element rv = xmlDocument.createElement(nodeName);
        rv.setAttribute("name", classReflectionProxy.getName());
        return rv;
    }

    private static Element encodeDeclaringClass(Document xmlDocument, MemberReflectionProxy memberReflectionProxy) {
        return Node.encodeType(xmlDocument, "declaringClass", memberReflectionProxy.getDeclaringClassReflectionProxy());
    }

    private static Element encodeParameters(Document xmlDocument, ClassReflectionProxy[] parameterClassReflectionProxies) {
        Element rv = xmlDocument.createElement("parameters");
        for (ClassReflectionProxy parameterClassReflectionProxy : parameterClassReflectionProxies) {
            rv.appendChild(Node.encodeType(xmlDocument, "type", parameterClassReflectionProxy));
        }
        return rv;
    }

    private static Element encodeMember(Document xmlDocument, String nodeName, MemberReflectionProxy memberReflectionProxy) {
        Element rv = xmlDocument.createElement(nodeName);
        rv.appendChild(Node.encodeDeclaringClass(xmlDocument, memberReflectionProxy));
        return rv;
    }

    private static Element encodeField(Document xmlDocument, String nodeName, FieldReflectionProxy fieldReflectionProxy) {
        Element rv = Node.encodeMember(xmlDocument, nodeName, fieldReflectionProxy);
        rv.setAttribute("name", fieldReflectionProxy.getName());
        return rv;
    }

    private static Element encodeConstructor(Document xmlDocument, String nodeName, ConstructorReflectionProxy constructorReflectionProxy) {
        Element rv = Node.encodeMember(xmlDocument, nodeName, constructorReflectionProxy);
        rv.appendChild(Node.encodeParameters(xmlDocument, constructorReflectionProxy.getParameterClassReflectionProxies()));
        return rv;
    }

    private static Element encodeMethod(Document xmlDocument, String nodeName, MethodReflectionProxy methodReflectionProxy) {
        Element rv = Node.encodeMember(xmlDocument, nodeName, methodReflectionProxy);
        rv.setAttribute("name", methodReflectionProxy.getName());
        rv.appendChild(Node.encodeParameters(xmlDocument, methodReflectionProxy.getParameterClassReflectionProxies()));
        return rv;
    }

    public Element encode(Document xmlDocument, Set<AbstractDeclaration> set) {
        Element xmlIndex;
        Element rv = xmlDocument.createElement("node");
        if (this instanceof AbstractDeclaration) {
            AbstractDeclaration abstractDeclaration = (AbstractDeclaration)this;
            rv.setAttribute("key", Integer.toHexString(abstractDeclaration.hashCode()));
            if (set.contains(this)) {
                return rv;
            }
            set.add(abstractDeclaration);
        }
        rv.setAttribute("uuid", this.m_uuid.toString());
        rv.setAttribute("type", this.getClass().getName());
        if (this instanceof TypeDeclaredInJava) {
            TypeDeclaredInJava typeDeclaredInJava = (TypeDeclaredInJava)this;
            rv.appendChild(Node.encodeType(xmlDocument, "type", typeDeclaredInJava.getClassReflectionProxy()));
        } else if (this instanceof ArrayTypeDeclaredInAlice) {
            ArrayTypeDeclaredInAlice arrayTypeDeclaredInAlice = (ArrayTypeDeclaredInAlice)this;
            Element xmlLeafType = xmlDocument.createElement("leafType");
            xmlLeafType.appendChild(Node.encodeValue(arrayTypeDeclaredInAlice.getLeafType(), xmlDocument, set));
            rv.appendChild(xmlLeafType);
            Element xmlDimensionCount = xmlDocument.createElement("dimensionCount");
            xmlDimensionCount.appendChild(xmlDocument.createTextNode(Integer.toString(arrayTypeDeclaredInAlice.getDimensionCount())));
            rv.appendChild(xmlDimensionCount);
        } else if (this instanceof ConstructorDeclaredInJava) {
            ConstructorDeclaredInJava constructorDeclaredInJava = (ConstructorDeclaredInJava)this;
            rv.appendChild(Node.encodeConstructor(xmlDocument, "constructor", constructorDeclaredInJava.getConstructorReflectionProxy()));
        } else if (this instanceof MethodDeclaredInJava) {
            MethodDeclaredInJava methodDeclaredInJava = (MethodDeclaredInJava)this;
            rv.appendChild(Node.encodeMethod(xmlDocument, "method", methodDeclaredInJava.getMethodReflectionProxy()));
        } else if (this instanceof FieldDeclaredInJavaWithField) {
            FieldDeclaredInJavaWithField fieldDeclaredInJavaWithField = (FieldDeclaredInJavaWithField)this;
            rv.appendChild(Node.encodeField(xmlDocument, "field", fieldDeclaredInJavaWithField.getFieldReflectionProxy()));
        } else if (this instanceof FieldDeclaredInJavaWithGetterAndSetter) {
            FieldDeclaredInJavaWithGetterAndSetter fieldDeclaredInJavaWithGetterAndSetter = (FieldDeclaredInJavaWithGetterAndSetter)this;
            rv.appendChild(Node.encodeMethod(xmlDocument, "getter", fieldDeclaredInJavaWithGetterAndSetter.getGetterReflectionProxy()));
            rv.appendChild(Node.encodeMethod(xmlDocument, "setter", fieldDeclaredInJavaWithGetterAndSetter.getSetterReflectionProxy()));
        } else if (this instanceof AnonymousConstructor) {
            AnonymousConstructor anonymousConstructor = (AnonymousConstructor)this;
            Element xmlType = xmlDocument.createElement("anonymousType");
            xmlType.appendChild(Node.encodeValue(anonymousConstructor.getDeclaringType(), xmlDocument, set));
            rv.appendChild(xmlType);
        } else if (this instanceof ParameterDeclaredInJavaConstructor) {
            ParameterDeclaredInJavaConstructor parameterDeclaredInJavaConstructor = (ParameterDeclaredInJavaConstructor)this;
            ConstructorDeclaredInJava constructor = parameterDeclaredInJavaConstructor.getConstructor();
            rv.appendChild(Node.encodeValue(constructor, xmlDocument, set));
            xmlIndex = xmlDocument.createElement("index");
            xmlIndex.appendChild(xmlDocument.createTextNode(Integer.toString(parameterDeclaredInJavaConstructor.getIndex())));
            rv.appendChild(xmlIndex);
        } else if (this instanceof ParameterDeclaredInJavaMethod) {
            ParameterDeclaredInJavaMethod parameterDeclaredInJavaMethod = (ParameterDeclaredInJavaMethod)this;
            MethodDeclaredInJava method = parameterDeclaredInJavaMethod.getMethod();
            rv.appendChild(Node.encodeValue(method, xmlDocument, set));
            xmlIndex = xmlDocument.createElement("index");
            xmlIndex.appendChild(xmlDocument.createTextNode(Integer.toString(parameterDeclaredInJavaMethod.getIndex())));
            rv.appendChild(xmlIndex);
        }
        for (Property<?> property : this.getProperties()) {
            rv.appendChild(this.encodeProperty(xmlDocument, property, set));
        }
        return rv;
    }

    public final Document encode(Set<AbstractDeclaration> set) {
        Document rv = XMLUtilities.createDocument();
        Element xmlElement = this.encode(rv, set);
        xmlElement.setAttribute("version", Double.toString(3.0));
        rv.appendChild(xmlElement);
        return rv;
    }

    public final Document encode() {
        return this.encode(new HashSet<AbstractDeclaration>());
    }

    protected Set<AbstractDeclaration> fillInDeclarationSet(Set<AbstractDeclaration> rv, Set<Node> nodes) {
        nodes.add(this);
        for (Property<?> property : this.getProperties()) {
            Object value = property.getValue(this);
            if (value instanceof Node) {
                if (nodes.contains(value)) continue;
                ((Node)value).fillInDeclarationSet(rv, nodes);
                continue;
            }
            if (!(value instanceof Iterable)) continue;
            for (Object item : (Iterable)value) {
                if (!(item instanceof Node) || nodes.contains(item)) continue;
                ((Node)item).fillInDeclarationSet(rv, nodes);
            }
        }
        return rv;
    }

    public Set<AbstractDeclaration> createDeclarationSet() {
        HashSet<AbstractDeclaration> rv = new HashSet<AbstractDeclaration>();
        this.fillInDeclarationSet(rv, new HashSet<Node>());
        return rv;
    }

    private Set<AbstractDeclaration> removeDeclarationsThatNeedToBeCopied(Set<AbstractDeclaration> rv, Set<Node> nodes) {
        nodes.add(this);
        for (Property<?> property : this.getProperties()) {
            Object value;
            DeclarationProperty declarationProperty;
            if (property instanceof DeclarationProperty && !(declarationProperty = (DeclarationProperty)property).isReference()) {
                rv.remove(declarationProperty.getValue());
            }
            if ((value = property.getValue(this)) instanceof Node) {
                if (nodes.contains(value)) continue;
                ((Node)value).removeDeclarationsThatNeedToBeCopied(rv, nodes);
                continue;
            }
            if (!(value instanceof Iterable)) continue;
            for (Object item : (Iterable)value) {
                if (!(item instanceof Node) || nodes.contains(item)) continue;
                ((Node)item).removeDeclarationsThatNeedToBeCopied(rv, nodes);
            }
        }
        return rv;
    }

    public Set<AbstractDeclaration> removeDeclarationsThatNeedToBeCopied(Set<AbstractDeclaration> rv) {
        return this.removeDeclarationsThatNeedToBeCopied(rv, new HashSet<Node>());
    }

    public static Map<Integer, AbstractDeclaration> createMapOfDeclarationsThatShouldNotBeCopied(Set<AbstractDeclaration> set) {
        HashMap<Integer, AbstractDeclaration> rv = new HashMap<Integer, AbstractDeclaration>();
        for (AbstractDeclaration abstractDeclaration : set) {
            rv.put(abstractDeclaration.hashCode(), abstractDeclaration);
        }
        return rv;
    }

    protected void handleMissingProperty(String propertyName, Object value) {
        throw new RuntimeException(propertyName);
    }

    protected final void decodeNode(Decoder decoder, Element xmlElement, Map<Integer, AbstractDeclaration> map) {
        NodeList nodeList = xmlElement.getChildNodes();
        for (int i = 0; i < nodeList.getLength(); ++i) {
            org.w3c.dom.Node xmlNode = nodeList.item(i);
            assert (xmlNode instanceof Element) : xmlNode;
            Element xmlProperty = (Element)xmlNode;
            if (!xmlProperty.getTagName().equals("property")) continue;
            String propertyName = xmlProperty.getAttribute("name");
            Property<?> property = this.getPropertyNamed(propertyName);
            Object value = decoder.decodeValue((Element)xmlProperty.getFirstChild(), map);
            if (property != null) {
                property.setValue(this, value);
                continue;
            }
            this.handleMissingProperty(propertyName, value);
        }
        this.postDecode();
    }

    protected void postDecode() {
    }

    public static Node decode(Document xmlDocument, String projectVersion, Map<Integer, AbstractDeclaration> map, boolean isUUIDDecodingDesired) {
        Element xmlElement = xmlDocument.getDocumentElement();
        double xmlVersion = Double.parseDouble(xmlElement.getAttribute("version"));
        assert (xmlVersion == 3.0);
        Decoder decoder = new Decoder(projectVersion, Version.getCurrentVersionText(), isUUIDDecodingDesired);
        return decoder.decode(xmlElement, map);
    }

    public static Node decode(Document xmlDocument, String projectVersion, Map<Integer, AbstractDeclaration> map) {
        return Node.decode(xmlDocument, projectVersion, map, true);
    }

    public static Node decode(Document xmlDocument, String projectVersion) {
        return Node.decode(xmlDocument, projectVersion, new HashMap<Integer, AbstractDeclaration>());
    }

    public void assignUUIDs(Map<Integer, AbstractDeclaration> map) {
    }

    public static StringBuffer safeAppendRepr(StringBuffer rv, Node node, Locale locale) {
        if (node != null) {
            node.appendRepr(rv, locale);
        }
        return rv;
    }

    protected StringBuffer appendRepr(StringBuffer rv, Locale locale) {
        rv.append(this.getClass().getSimpleName());
        return rv;
    }

    public final String getRepr(Locale locale) {
        StringBuffer sb = new StringBuffer();
        this.appendRepr(sb, locale);
        return sb.toString();
    }
}

