/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.cs.dennisc.alice.ast;

import edu.cmu.cs.dennisc.alice.ast.AbstractType;
import edu.cmu.cs.dennisc.alice.ast.DeclarationProperty;
import edu.cmu.cs.dennisc.alice.ast.Expression;
import edu.cmu.cs.dennisc.alice.ast.ExpressionProperty;
import edu.cmu.cs.dennisc.alice.ast.TypeDeclaredInJava;
import edu.cmu.cs.dennisc.property.InstanceProperty;

public class ShiftInfixExpression
extends Expression {
    public DeclarationProperty<AbstractType> expressionType = new DeclarationProperty(this);
    public ExpressionProperty leftOperand = new ExpressionProperty(this){

        public AbstractType getExpressionType() {
            return (AbstractType)ShiftInfixExpression.this.expressionType.getValue();
        }
    };
    public InstanceProperty<Operator> operator = new InstanceProperty<Object>(this, null);
    public ExpressionProperty rightOperand = new ExpressionProperty(this){

        public AbstractType getExpressionType() {
            return (AbstractType)ShiftInfixExpression.this.expressionType.getValue();
        }
    };

    public ShiftInfixExpression() {
    }

    public ShiftInfixExpression(AbstractType expressionType, Expression leftOperand, Operator operator, Expression rightOperand) {
        assert (TypeDeclaredInJava.get(Long.class).isAssignableFrom(expressionType) || TypeDeclaredInJava.get(Integer.class).isAssignableFrom(expressionType) || TypeDeclaredInJava.get(Short.class).isAssignableFrom(expressionType) || TypeDeclaredInJava.get(Byte.class).isAssignableFrom(expressionType) || TypeDeclaredInJava.get(Character.class).isAssignableFrom(expressionType));
        this.expressionType.setValue(expressionType);
        this.leftOperand.setValue(leftOperand);
        this.operator.setValue(operator);
        this.rightOperand.setValue(rightOperand);
    }

    public AbstractType getType() {
        return (AbstractType)this.expressionType.getValue();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Operator {
        LEFT_SHIFT{

            public Object operate(Object leftOperand, Object rightOperand) {
                if (leftOperand instanceof Long || rightOperand instanceof Long) {
                    return (Long)leftOperand << (int)((Long)rightOperand).longValue();
                }
                if (leftOperand instanceof Integer || rightOperand instanceof Integer) {
                    return (Integer)leftOperand << (Integer)rightOperand;
                }
                if (leftOperand instanceof Short || rightOperand instanceof Short) {
                    return (Short)leftOperand << (Short)rightOperand;
                }
                if (leftOperand instanceof Byte || rightOperand instanceof Byte) {
                    return (Byte)leftOperand << (Byte)rightOperand;
                }
                if (leftOperand instanceof Character || rightOperand instanceof Character) {
                    return ((Character)leftOperand).charValue() << ((Character)rightOperand).charValue();
                }
                throw new RuntimeException();
            }
        }
        ,
        RIGHT_SHIFT_SIGNED{

            public Object operate(Object leftOperand, Object rightOperand) {
                if (leftOperand instanceof Long || rightOperand instanceof Long) {
                    return (Long)leftOperand >> (int)((Long)rightOperand).longValue();
                }
                if (leftOperand instanceof Integer || rightOperand instanceof Integer) {
                    return (Integer)leftOperand >> (Integer)rightOperand;
                }
                if (leftOperand instanceof Short || rightOperand instanceof Short) {
                    return (Short)leftOperand >> (Short)rightOperand;
                }
                if (leftOperand instanceof Byte || rightOperand instanceof Byte) {
                    return (Byte)leftOperand >> (Byte)rightOperand;
                }
                if (leftOperand instanceof Character || rightOperand instanceof Character) {
                    return ((Character)leftOperand).charValue() >> ((Character)rightOperand).charValue();
                }
                throw new RuntimeException();
            }
        }
        ,
        RIGHT_SHIFT_UNSIGNED{

            public Object operate(Object leftOperand, Object rightOperand) {
                if (leftOperand instanceof Long || rightOperand instanceof Long) {
                    return (Long)leftOperand >>> (int)((Long)rightOperand).longValue();
                }
                if (leftOperand instanceof Integer || rightOperand instanceof Integer) {
                    return (Integer)leftOperand >>> (Integer)rightOperand;
                }
                if (leftOperand instanceof Short || rightOperand instanceof Short) {
                    return (Short)leftOperand >>> (Short)rightOperand;
                }
                if (leftOperand instanceof Byte || rightOperand instanceof Byte) {
                    return (Byte)leftOperand >>> (Byte)rightOperand;
                }
                if (leftOperand instanceof Character || rightOperand instanceof Character) {
                    return ((Character)leftOperand).charValue() >>> ((Character)rightOperand).charValue();
                }
                throw new RuntimeException();
            }
        };


        public abstract Object operate(Object var1, Object var2);
    }
}

