/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.cs.dennisc.alice.ast;

import edu.cmu.cs.dennisc.alice.annotations.ClassTemplate;
import edu.cmu.cs.dennisc.alice.annotations.Visibility;
import edu.cmu.cs.dennisc.alice.ast.AbstractConstructor;
import edu.cmu.cs.dennisc.alice.ast.AbstractField;
import edu.cmu.cs.dennisc.alice.ast.AbstractMethod;
import edu.cmu.cs.dennisc.alice.ast.AbstractPackage;
import edu.cmu.cs.dennisc.alice.ast.AbstractType;
import edu.cmu.cs.dennisc.alice.ast.Access;
import edu.cmu.cs.dennisc.alice.ast.ClassReflectionProxy;
import edu.cmu.cs.dennisc.alice.ast.ConstructorDeclaredInJava;
import edu.cmu.cs.dennisc.alice.ast.FieldDeclaredInJava;
import edu.cmu.cs.dennisc.alice.ast.FieldDeclaredInJavaWithField;
import edu.cmu.cs.dennisc.alice.ast.FieldDeclaredInJavaWithGetterAndSetter;
import edu.cmu.cs.dennisc.alice.ast.MethodDeclaredInJava;
import edu.cmu.cs.dennisc.alice.ast.PackageDeclaredInJava;
import edu.cmu.cs.dennisc.alice.reflect.ClassInfoManager;
import edu.cmu.cs.dennisc.alice.reflect.MethodInfo;
import edu.cmu.cs.dennisc.lang.reflect.ReflectionUtilities;
import edu.cmu.cs.dennisc.property.PropertyUtilities;
import edu.cmu.cs.dennisc.property.StringProperty;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TypeDeclaredInJava
extends AbstractType {
    private static Map<ClassReflectionProxy, TypeDeclaredInJava> s_mapReflectionProxyToJava = new HashMap<ClassReflectionProxy, TypeDeclaredInJava>();
    public static final TypeDeclaredInJava VOID_TYPE = TypeDeclaredInJava.get(Void.TYPE);
    public static final TypeDeclaredInJava BOOLEAN_PRIMITIVE_TYPE = TypeDeclaredInJava.get(Boolean.TYPE);
    public static final TypeDeclaredInJava BOOLEAN_OBJECT_TYPE = TypeDeclaredInJava.get(Boolean.class);
    public static final TypeDeclaredInJava NUMBER_OBJECT_TYPE = TypeDeclaredInJava.get(Number.class);
    public static final TypeDeclaredInJava INTEGER_PRIMITIVE_TYPE = TypeDeclaredInJava.get(Integer.TYPE);
    public static final TypeDeclaredInJava INTEGER_OBJECT_TYPE = TypeDeclaredInJava.get(Integer.class);
    public static final TypeDeclaredInJava DOUBLE_PRIMITIVE_TYPE = TypeDeclaredInJava.get(Double.TYPE);
    public static final TypeDeclaredInJava DOUBLE_OBJECT_TYPE = TypeDeclaredInJava.get(Double.class);
    public static final TypeDeclaredInJava[] BOOLEAN_TYPES = new TypeDeclaredInJava[]{BOOLEAN_PRIMITIVE_TYPE, BOOLEAN_OBJECT_TYPE};
    public static final TypeDeclaredInJava[] INTEGER_TYPES = new TypeDeclaredInJava[]{INTEGER_PRIMITIVE_TYPE, INTEGER_OBJECT_TYPE};
    public static final TypeDeclaredInJava[] DOUBLE_TYPES = new TypeDeclaredInJava[]{DOUBLE_PRIMITIVE_TYPE, DOUBLE_OBJECT_TYPE};
    public static final TypeDeclaredInJava OBJECT_TYPE = TypeDeclaredInJava.get(Object.class);
    private ClassReflectionProxy classReflectionProxy;
    private ArrayList<ConstructorDeclaredInJava> constructors = new ArrayList();
    private ArrayList<MethodDeclaredInJava> methods = new ArrayList();
    private ArrayList<FieldDeclaredInJava> fields = new ArrayList();

    public static TypeDeclaredInJava get(ClassReflectionProxy classReflectionProxy) {
        if (classReflectionProxy != null) {
            TypeDeclaredInJava rv = s_mapReflectionProxyToJava.get(classReflectionProxy);
            if (rv == null) {
                rv = new TypeDeclaredInJava(classReflectionProxy);
                s_mapReflectionProxyToJava.put(classReflectionProxy, rv);
                Class cls = (Class)classReflectionProxy.getReification();
                if (cls != null) {
                    for (Constructor<?> constructor : cls.getDeclaredConstructors()) {
                        rv.constructors.add(ConstructorDeclaredInJava.get(constructor));
                    }
                    for (AccessibleObject accessibleObject : cls.getDeclaredFields()) {
                        rv.fields.add(FieldDeclaredInJavaWithField.get((Field)accessibleObject));
                    }
                    HashSet<Method> methodSet = null;
                    Iterable<MethodInfo> methodInfos = ClassInfoManager.getMethodInfos(cls);
                    if (methodInfos != null) {
                        methodSet = new HashSet<Method>();
                        for (MethodInfo methodInfo : methodInfos) {
                            try {
                                Method mthd = methodInfo.getMthd();
                                if (mthd == null) continue;
                                rv.handleMthd(mthd);
                                methodSet.add(mthd);
                            }
                            catch (RuntimeException re) {}
                        }
                    }
                    for (Method mthd : cls.getDeclaredMethods()) {
                        if (methodSet != null && methodSet.contains(mthd)) continue;
                        rv.handleMthd(mthd);
                    }
                }
            }
            return rv;
        }
        return null;
    }

    public static TypeDeclaredInJava get(Class<?> cls) {
        if (cls != null) {
            return TypeDeclaredInJava.get(new ClassReflectionProxy(cls));
        }
        return null;
    }

    public static TypeDeclaredInJava[] get(Class<?>[] clses) {
        TypeDeclaredInJava[] rv = new TypeDeclaredInJava[clses.length];
        for (int i = 0; i < clses.length; ++i) {
            rv[i] = TypeDeclaredInJava.get(clses[i]);
        }
        return rv;
    }

    public static TypeDeclaredInJava[] get(ClassReflectionProxy[] classReflectionProxies) {
        TypeDeclaredInJava[] rv = new TypeDeclaredInJava[classReflectionProxies.length];
        for (int i = 0; i < classReflectionProxies.length; ++i) {
            rv[i] = TypeDeclaredInJava.get(classReflectionProxies[i]);
        }
        return rv;
    }

    private static boolean isMask(int modifiers, int required) {
        return (modifiers & required) != 0;
    }

    private static boolean isNotMask(int modifiers, int prohibited) {
        return (modifiers & prohibited) == 0;
    }

    private TypeDeclaredInJava(ClassReflectionProxy classReflectionProxy) {
        this.classReflectionProxy = classReflectionProxy;
    }

    @Override
    public boolean isFollowToSuperClassDesired() {
        Class cls = (Class)this.classReflectionProxy.getReification();
        if (cls != null) {
            if (cls.isAnnotationPresent(ClassTemplate.class)) {
                ClassTemplate classTemplate = cls.getAnnotation(ClassTemplate.class);
                return classTemplate.isFollowToSuperClassDesired();
            }
            return true;
        }
        return false;
    }

    @Override
    public boolean isConsumptionBySubClassDesired() {
        Class cls = (Class)this.classReflectionProxy.getReification();
        if (cls != null) {
            if (cls.isAnnotationPresent(ClassTemplate.class)) {
                ClassTemplate classTemplate = cls.getAnnotation(ClassTemplate.class);
                return classTemplate.isConsumptionBySubClassDesired();
            }
            return false;
        }
        return false;
    }

    @Override
    public String getName() {
        return this.classReflectionProxy.getSimpleName();
    }

    @Override
    public StringProperty getNamePropertyIfItExists() {
        return null;
    }

    @Override
    public AbstractPackage getPackage() {
        return PackageDeclaredInJava.get(this.classReflectionProxy.getPackageReflectionProxy());
    }

    @Override
    public AbstractType getSuperType() {
        Class cls = (Class)this.classReflectionProxy.getReification();
        if (cls != null) {
            return TypeDeclaredInJava.get(cls.getSuperclass());
        }
        return null;
    }

    @Override
    public ArrayList<? extends AbstractConstructor> getDeclaredConstructors() {
        return this.constructors;
    }

    @Override
    public ArrayList<? extends AbstractMethod> getDeclaredMethods() {
        return this.methods;
    }

    @Override
    public ArrayList<? extends AbstractField> getDeclaredFields() {
        return this.fields;
    }

    private static Class<?>[] trimLast(Class<?>[] src) {
        Class[] rv = new Class[src.length - 1];
        System.arraycopy(src, 0, rv, 0, rv.length);
        return rv;
    }

    private static Method getNextShorterInChain(Method src) {
        Method rv;
        Class<?> srcReturnCls = src.getReturnType();
        String name = src.getName();
        Class<?>[] srcParameterClses = src.getParameterTypes();
        if (srcParameterClses.length > 0) {
            Class<?>[] dstParameterClses = TypeDeclaredInJava.trimLast(srcParameterClses);
            try {
                rv = ReflectionUtilities.getMethod(src.getDeclaringClass(), name, dstParameterClses);
                if (rv.getReturnType() != srcReturnCls) {
                    rv = null;
                }
            }
            catch (RuntimeException re) {
                rv = null;
            }
        } else {
            rv = null;
        }
        return rv;
    }

    private void handleMthd(Method mthd) {
        int modifiers = mthd.getModifiers();
        if (TypeDeclaredInJava.isMask(modifiers, 1)) {
            if (PropertyUtilities.isGetterAndSetterExists(mthd)) {
                Method sttr = PropertyUtilities.getSetterForGetter(mthd);
                this.fields.add(FieldDeclaredInJavaWithGetterAndSetter.get(mthd, sttr));
            } else if (!PropertyUtilities.isSetterAndGetterExists(mthd) && !PropertyUtilities.isSetterWithExtraParametersAndGetterExists(mthd)) {
                MethodDeclaredInJava methodDeclaredInJava = MethodDeclaredInJava.get(mthd);
                Visibility visibility = methodDeclaredInJava.getVisibility();
                if (visibility == Visibility.PRIME_TIME) {
                    MethodDeclaredInJava shorter;
                    MethodDeclaredInJava longer = methodDeclaredInJava;
                    Method _mthd = mthd;
                    while ((_mthd = TypeDeclaredInJava.getNextShorterInChain(_mthd)) != null && (shorter = MethodDeclaredInJava.get(_mthd)).getVisibility() == Visibility.CHAINED) {
                        longer.setNextShorterInChain(shorter);
                        shorter.setNextLongerInChain(longer);
                        longer = shorter;
                    }
                }
                this.methods.add(methodDeclaredInJava);
            }
        }
    }

    public ClassReflectionProxy getClassReflectionProxy() {
        return this.classReflectionProxy;
    }

    @Override
    public boolean isDeclaredInAlice() {
        return false;
    }

    @Override
    public Access getAccess() {
        Class cls = (Class)this.classReflectionProxy.getReification();
        assert (cls != null);
        return Access.get(cls.getModifiers());
    }

    @Override
    public boolean isInterface() {
        Class cls = (Class)this.classReflectionProxy.getReification();
        assert (cls != null);
        return cls.isInterface();
    }

    @Override
    public boolean isStatic() {
        Class cls = (Class)this.classReflectionProxy.getReification();
        assert (cls != null);
        return Modifier.isStatic(cls.getModifiers());
    }

    @Override
    public boolean isAbstract() {
        Class cls = (Class)this.classReflectionProxy.getReification();
        assert (cls != null);
        return Modifier.isAbstract(cls.getModifiers());
    }

    @Override
    public boolean isFinal() {
        Class cls = (Class)this.classReflectionProxy.getReification();
        assert (cls != null);
        return Modifier.isFinal(cls.getModifiers());
    }

    @Override
    public boolean isStrictFloatingPoint() {
        Class cls = (Class)this.classReflectionProxy.getReification();
        assert (cls != null);
        return Modifier.isStrict(cls.getModifiers());
    }

    @Override
    public boolean isArray() {
        return this.classReflectionProxy.isArray();
    }

    @Override
    public AbstractType getComponentType() {
        return TypeDeclaredInJava.get(this.classReflectionProxy.getComponentClassReflectionProxy());
    }

    @Override
    public AbstractType getArrayType() {
        Class cls = (Class)this.classReflectionProxy.getReification();
        assert (cls != null);
        return TypeDeclaredInJava.get(ReflectionUtilities.getArrayClass(cls));
    }

    @Override
    public boolean isEquivalentTo(Object other) {
        if (other instanceof TypeDeclaredInJava) {
            return this.classReflectionProxy.equals(((TypeDeclaredInJava)other).classReflectionProxy);
        }
        return false;
    }

    public String toString() {
        return this.getClass() + "[cls=" + this.classReflectionProxy.getName() + "]";
    }
}

