/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.cs.dennisc.alice.reflect;

import edu.cmu.cs.dennisc.alice.reflect.ConstructorInfo;
import edu.cmu.cs.dennisc.alice.reflect.MethodInfo;
import edu.cmu.cs.dennisc.codec.BinaryDecoder;
import edu.cmu.cs.dennisc.codec.BinaryEncodableAndDecodable;
import edu.cmu.cs.dennisc.codec.BinaryEncoder;
import edu.cmu.cs.dennisc.lang.reflect.ReflectionUtilities;
import edu.cmu.cs.dennisc.print.PrintUtilities;
import edu.cmu.cs.dennisc.util.CollectionUtilities;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ClassInfo
implements BinaryEncodableAndDecodable {
    private transient boolean isGetClassForNamAlreadyAttempted = false;
    private String clsName;
    private transient Class<?> cls;
    private List<ConstructorInfo> constructorInfos = new LinkedList<ConstructorInfo>();
    private List<MethodInfo> methodInfos = new LinkedList<MethodInfo>();
    private static Map<String, ClassInfo> map = new HashMap<String, ClassInfo>();
    private Set<MethodInfo> outOfDateMethodInfos = new HashSet<MethodInfo>();

    public static ClassInfo forName(String clsName) {
        ClassInfo rv = map.get(clsName);
        if (rv == null) {
            rv = new ClassInfo(clsName);
        }
        return rv;
    }

    private ClassInfo(String clsName) {
        this.clsName = clsName;
    }

    public ClassInfo(BinaryDecoder binaryDecoder) {
        this.decode(binaryDecoder);
    }

    public String getClsName() {
        return this.clsName;
    }

    @Override
    public void encode(BinaryEncoder binaryEncoder) {
        binaryEncoder.encode(this.clsName);
        binaryEncoder.encode(CollectionUtilities.createArray(this.constructorInfos, ConstructorInfo.class));
        binaryEncoder.encode(CollectionUtilities.createArray(this.methodInfos, MethodInfo.class));
    }

    @Override
    public void decode(BinaryDecoder binaryDecoder) {
        this.clsName = binaryDecoder.decodeString();
        CollectionUtilities.set(this.constructorInfos, binaryDecoder.decodeBinaryEncodableAndDecodableArray(ConstructorInfo.class));
        CollectionUtilities.set(this.methodInfos, binaryDecoder.decodeBinaryEncodableAndDecodableArray(MethodInfo.class));
    }

    protected Class<?> getCls() {
        if (!this.isGetClassForNamAlreadyAttempted) {
            this.isGetClassForNamAlreadyAttempted = true;
            try {
                this.cls = ReflectionUtilities.getClassForName(this.clsName);
                assert (this.cls != null) : this.clsName;
            }
            catch (Throwable t) {
                PrintUtilities.println(t, this.clsName);
            }
        }
        return this.cls;
    }

    public void addConstructorInfo(String[] parameterClassNames, String[] parameterNames) {
        ConstructorInfo constructorInfo = new ConstructorInfo(this, parameterClassNames, parameterNames);
        this.constructorInfos.add(constructorInfo);
    }

    public void addMethodInfo(String name, String[] parameterClassNames, String[] parameterNames) {
        MethodInfo methodInfo = new MethodInfo(this, name, parameterClassNames, parameterNames);
        this.methodInfos.add(methodInfo);
    }

    public Iterable<ConstructorInfo> getConstructorInfos() {
        return this.constructorInfos;
    }

    public Iterable<MethodInfo> getMethodInfos() {
        return this.methodInfos;
    }

    public MethodInfo lookupInfo(Method mthd) {
        for (MethodInfo methodInfo : this.getMethodInfos()) {
            if (this.outOfDateMethodInfos.contains(methodInfo)) continue;
            try {
                Method m = methodInfo.getMthd();
                if (!m.equals(mthd)) continue;
                return methodInfo;
            }
            catch (RuntimeException re) {
                this.outOfDateMethodInfos.add(methodInfo);
            }
        }
        return null;
    }

    public ConstructorInfo lookupInfo(Constructor cnstrctr) {
        for (ConstructorInfo constructorInfo : this.getConstructorInfos()) {
            if (!constructorInfo.getCnstrctr().equals(cnstrctr)) continue;
            return constructorInfo;
        }
        return null;
    }
}

