/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.cs.dennisc.alice.virtualmachine;

import edu.cmu.cs.dennisc.alice.ast.AbstractParameter;
import edu.cmu.cs.dennisc.alice.ast.LocalDeclaredInAlice;
import edu.cmu.cs.dennisc.alice.virtualmachine.InstanceInAlice;
import edu.cmu.cs.dennisc.alice.virtualmachine.VirtualMachine;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ReleaseVirtualMachine
extends VirtualMachine {
    private Map<Thread, AbstractFrame> m_mapThreadToFrame = new ConcurrentHashMap<Thread, AbstractFrame>();

    private AbstractFrame getCurrentFrame() {
        AbstractFrame rv = this.m_mapThreadToFrame.get(Thread.currentThread());
        assert (rv != null);
        return rv;
    }

    private void setCurrentFrame(AbstractFrame currentFrame) {
        this.m_mapThreadToFrame.put(Thread.currentThread(), currentFrame);
    }

    @Override
    protected Object getThis() {
        return this.getCurrentFrame().getThis();
    }

    @Override
    protected void pushFrame(InstanceInAlice instance, Map<AbstractParameter, Object> map) {
        AbstractFrame owner = this.getCurrentFrame();
        this.setCurrentFrame(new InvocationFrame(owner, instance, map));
    }

    @Override
    protected void pushLocal(LocalDeclaredInAlice local, Object value) {
        this.getCurrentFrame().push(local, value);
    }

    @Override
    protected void setLocal(LocalDeclaredInAlice local, Object value) {
        this.getCurrentFrame().set(local, value);
    }

    @Override
    protected Object getLocal(LocalDeclaredInAlice local) {
        return this.getCurrentFrame().get(local);
    }

    @Override
    protected void popLocal(LocalDeclaredInAlice local) {
        this.getCurrentFrame().pop(local);
    }

    @Override
    protected void popFrame() {
        AbstractFrame frame = this.getCurrentFrame();
        this.setCurrentFrame(frame.getOwner());
    }

    @Override
    protected Object lookup(AbstractParameter parameter) {
        return this.getCurrentFrame().lookup(parameter);
    }

    @Override
    protected void pushCurrentThread(Thread parentThread) {
        AbstractFrame owner = parentThread != null ? this.m_mapThreadToFrame.get(parentThread) : null;
        this.setCurrentFrame(new ThreadFrame(owner));
    }

    @Override
    protected void popCurrentThread() {
        this.m_mapThreadToFrame.remove(Thread.currentThread());
    }

    protected abstract class AbstractFrame {
        private AbstractFrame m_owner = null;
        private Map<LocalDeclaredInAlice, Object> m_mapLocalToValue = new ConcurrentHashMap<LocalDeclaredInAlice, Object>();

        public AbstractFrame(AbstractFrame owner) {
            this.m_owner = owner;
        }

        public AbstractFrame getOwner() {
            return this.m_owner;
        }

        private boolean contains(LocalDeclaredInAlice local) {
            return this.m_mapLocalToValue.containsKey(local);
        }

        public void push(LocalDeclaredInAlice local, Object value) {
            this.m_mapLocalToValue.put(local, value);
        }

        public Object get(LocalDeclaredInAlice local) {
            if (this.contains(local)) {
                return this.m_mapLocalToValue.get(local);
            }
            if (this.m_owner != null) {
                return this.m_owner.get(local);
            }
            throw new RuntimeException("cannot find local: " + local.toString());
        }

        public void set(LocalDeclaredInAlice local, Object value) {
            if (this.contains(local)) {
                this.m_mapLocalToValue.put(local, value);
            } else {
                this.m_owner.set(local, value);
            }
        }

        public void pop(LocalDeclaredInAlice local) {
            assert (this.contains(local));
            this.m_mapLocalToValue.remove(local);
        }

        public abstract Object getThis();

        public abstract Object lookup(AbstractParameter var1);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected class InvocationFrame
    extends AbstractFrame {
        private InstanceInAlice m_instance;
        private Map<AbstractParameter, Object> m_mapParameterToValue;

        public InvocationFrame(AbstractFrame owner, InstanceInAlice instance, Map<AbstractParameter, Object> mapParameterToValue) {
            super(owner);
            this.m_instance = instance;
            this.m_mapParameterToValue = mapParameterToValue;
        }

        @Override
        public Object getThis() {
            return this.m_instance;
        }

        @Override
        public Object lookup(AbstractParameter parameter) {
            return this.m_mapParameterToValue.get(parameter);
        }
    }

    protected class ThreadFrame
    extends AbstractFrame {
        public ThreadFrame(AbstractFrame owner) {
            super(owner);
        }

        public Object getThis() {
            return this.getOwner().getThis();
        }

        public Object lookup(AbstractParameter parameter) {
            return this.getOwner().lookup(parameter);
        }
    }
}

