/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.cs.dennisc.alice.virtualmachine;

import edu.cmu.cs.dennisc.alice.ProgramClosedException;
import edu.cmu.cs.dennisc.alice.ast.AbstractConstructor;
import edu.cmu.cs.dennisc.alice.ast.AbstractEachInTogether;
import edu.cmu.cs.dennisc.alice.ast.AbstractField;
import edu.cmu.cs.dennisc.alice.ast.AbstractForEachLoop;
import edu.cmu.cs.dennisc.alice.ast.AbstractMethod;
import edu.cmu.cs.dennisc.alice.ast.AbstractParameter;
import edu.cmu.cs.dennisc.alice.ast.AbstractType;
import edu.cmu.cs.dennisc.alice.ast.AnonymousConstructor;
import edu.cmu.cs.dennisc.alice.ast.AnonymousInnerTypeDeclaredInAlice;
import edu.cmu.cs.dennisc.alice.ast.Argument;
import edu.cmu.cs.dennisc.alice.ast.ArithmeticInfixExpression;
import edu.cmu.cs.dennisc.alice.ast.ArrayAccess;
import edu.cmu.cs.dennisc.alice.ast.ArrayInstanceCreation;
import edu.cmu.cs.dennisc.alice.ast.ArrayLength;
import edu.cmu.cs.dennisc.alice.ast.ArrayTypeDeclaredInAlice;
import edu.cmu.cs.dennisc.alice.ast.AssertStatement;
import edu.cmu.cs.dennisc.alice.ast.AssignmentExpression;
import edu.cmu.cs.dennisc.alice.ast.BitwiseInfixExpression;
import edu.cmu.cs.dennisc.alice.ast.BlockStatement;
import edu.cmu.cs.dennisc.alice.ast.BooleanExpressionBodyPair;
import edu.cmu.cs.dennisc.alice.ast.BooleanLiteral;
import edu.cmu.cs.dennisc.alice.ast.Comment;
import edu.cmu.cs.dennisc.alice.ast.ConditionalInfixExpression;
import edu.cmu.cs.dennisc.alice.ast.ConditionalStatement;
import edu.cmu.cs.dennisc.alice.ast.ConstantAccess;
import edu.cmu.cs.dennisc.alice.ast.ConstantDeclarationStatement;
import edu.cmu.cs.dennisc.alice.ast.ConstantDeclaredInAlice;
import edu.cmu.cs.dennisc.alice.ast.ConstructorDeclaredInAlice;
import edu.cmu.cs.dennisc.alice.ast.ConstructorDeclaredInJava;
import edu.cmu.cs.dennisc.alice.ast.CountLoop;
import edu.cmu.cs.dennisc.alice.ast.DoInOrder;
import edu.cmu.cs.dennisc.alice.ast.DoInThread;
import edu.cmu.cs.dennisc.alice.ast.DoubleLiteral;
import edu.cmu.cs.dennisc.alice.ast.EachInArrayTogether;
import edu.cmu.cs.dennisc.alice.ast.EachInIterableTogether;
import edu.cmu.cs.dennisc.alice.ast.EntryPointTypeExpression;
import edu.cmu.cs.dennisc.alice.ast.Expression;
import edu.cmu.cs.dennisc.alice.ast.ExpressionStatement;
import edu.cmu.cs.dennisc.alice.ast.FieldAccess;
import edu.cmu.cs.dennisc.alice.ast.FieldDeclaredInAlice;
import edu.cmu.cs.dennisc.alice.ast.FieldDeclaredInJavaWithField;
import edu.cmu.cs.dennisc.alice.ast.FieldDeclaredInJavaWithGetterAndSetter;
import edu.cmu.cs.dennisc.alice.ast.FloatLiteral;
import edu.cmu.cs.dennisc.alice.ast.ForEachInArrayLoop;
import edu.cmu.cs.dennisc.alice.ast.ForEachInIterableLoop;
import edu.cmu.cs.dennisc.alice.ast.InstanceCreation;
import edu.cmu.cs.dennisc.alice.ast.IntegerLiteral;
import edu.cmu.cs.dennisc.alice.ast.LocalDeclaredInAlice;
import edu.cmu.cs.dennisc.alice.ast.LogicalComplement;
import edu.cmu.cs.dennisc.alice.ast.MethodDeclaredInAlice;
import edu.cmu.cs.dennisc.alice.ast.MethodDeclaredInJava;
import edu.cmu.cs.dennisc.alice.ast.MethodInvocation;
import edu.cmu.cs.dennisc.alice.ast.NodeListProperty;
import edu.cmu.cs.dennisc.alice.ast.NullLiteral;
import edu.cmu.cs.dennisc.alice.ast.NumberLiteral;
import edu.cmu.cs.dennisc.alice.ast.ParameterAccess;
import edu.cmu.cs.dennisc.alice.ast.RelationalInfixExpression;
import edu.cmu.cs.dennisc.alice.ast.ResourceExpression;
import edu.cmu.cs.dennisc.alice.ast.ReturnStatement;
import edu.cmu.cs.dennisc.alice.ast.ShiftInfixExpression;
import edu.cmu.cs.dennisc.alice.ast.Statement;
import edu.cmu.cs.dennisc.alice.ast.StringConcatenation;
import edu.cmu.cs.dennisc.alice.ast.StringLiteral;
import edu.cmu.cs.dennisc.alice.ast.ThisExpression;
import edu.cmu.cs.dennisc.alice.ast.TypeDeclaredInJava;
import edu.cmu.cs.dennisc.alice.ast.TypeExpression;
import edu.cmu.cs.dennisc.alice.ast.TypeLiteral;
import edu.cmu.cs.dennisc.alice.ast.VariableAccess;
import edu.cmu.cs.dennisc.alice.ast.VariableDeclarationStatement;
import edu.cmu.cs.dennisc.alice.ast.VariableDeclaredInAlice;
import edu.cmu.cs.dennisc.alice.ast.WhileLoop;
import edu.cmu.cs.dennisc.alice.virtualmachine.Context;
import edu.cmu.cs.dennisc.alice.virtualmachine.InstanceInAlice;
import edu.cmu.cs.dennisc.alice.virtualmachine.ReturnException;
import edu.cmu.cs.dennisc.lang.IterableUtilities;
import edu.cmu.cs.dennisc.lang.ThreadWithRevealingToString;
import edu.cmu.cs.dennisc.lang.reflect.ReflectionUtilities;
import edu.cmu.cs.dennisc.print.PrintUtilities;
import java.lang.reflect.Array;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import javax.swing.JOptionPane;
import org.alice.virtualmachine.DoTogether;
import org.alice.virtualmachine.ForEachRunnable;
import org.alice.virtualmachine.ForEachTogether;
import org.alice.virtualmachine.ThreadGroupUtilities;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class VirtualMachine {
    private AbstractType entryPointType;
    private boolean isConstructorBodyExecutionDesired = true;
    private Map<Class<?>, Class<?>> mapAnonymousClsToAdapterCls = new HashMap();
    private static int threadCount = 0;

    @Deprecated
    public Object getAccessForSceneEditor(AbstractField field, Object instance) {
        return this.get(field, instance);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Deprecated
    public Object createInstanceForSceneEditor(AbstractType entryPointType) {
        this.pushCurrentThread(null);
        try {
            Object object = this.createInstance(this.entryPointType.getDeclaredConstructor(), new Object[0]);
            return object;
        }
        finally {
            this.popCurrentThread();
        }
    }

    protected abstract Object getThis();

    protected abstract void pushFrame(InstanceInAlice var1, Map<AbstractParameter, Object> var2);

    protected abstract void popFrame();

    protected abstract Object lookup(AbstractParameter var1);

    protected abstract void pushLocal(LocalDeclaredInAlice var1, Object var2);

    protected abstract Object getLocal(LocalDeclaredInAlice var1);

    protected abstract void setLocal(LocalDeclaredInAlice var1, Object var2);

    protected abstract void popLocal(LocalDeclaredInAlice var1);

    protected abstract void pushCurrentThread(Thread var1);

    protected abstract void popCurrentThread();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void invokeEntryPoint(AbstractMethod method, Object instance, Object ... arguments) {
        this.pushCurrentThread(null);
        try {
            this.invoke(method, instance, arguments);
        }
        finally {
            this.popCurrentThread();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object createInstanceEntryPoint(AbstractType entryPointType) {
        assert (entryPointType != null);
        this.setEntryPointType(entryPointType);
        this.pushCurrentThread(null);
        try {
            Object object = this.createInstance(this.entryPointType.getDeclaredConstructor(), new Object[0]);
            return object;
        }
        finally {
            this.popCurrentThread();
        }
    }

    public void setEntryPointType(AbstractType entryPointType) {
        this.entryPointType = entryPointType;
    }

    public boolean isConstructorBodyExecutionDesired() {
        return this.isConstructorBodyExecutionDesired;
    }

    public void setConstructorBodyExecutionDesired(boolean isConstructorBodyExecutionDesired) {
        this.isConstructorBodyExecutionDesired = isConstructorBodyExecutionDesired;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Object createInstanceFromConstructorDeclaredInAlice(ConstructorDeclaredInAlice constructor, Object[] arguments) {
        InstanceInAlice instanceInAlice;
        block6: {
            instanceInAlice = new InstanceInAlice();
            HashMap<AbstractParameter, Object> map = new HashMap<AbstractParameter, Object>();
            for (int i = 0; i < arguments.length; ++i) {
                map.put((AbstractParameter)constructor.parameters.get(i), arguments[i]);
            }
            this.pushFrame(instanceInAlice, map);
            try {
                instanceInAlice.initialize(this, constructor, arguments);
                if (!this.isConstructorBodyExecutionDesired) break block6;
                try {
                    this.executeBlockStatement((BlockStatement)constructor.body.getValue());
                }
                catch (ReturnException re) {
                    throw new RuntimeException(re);
                }
            }
            finally {
                this.popFrame();
            }
        }
        return instanceInAlice;
    }

    protected Object createInstanceFromConstructorDeclaredInJava(ConstructorDeclaredInJava constructor, Object[] arguments) {
        for (int i = 0; i < arguments.length; ++i) {
            Object value = arguments[i];
            if (!(value instanceof InstanceInAlice)) continue;
            InstanceInAlice valueInAlice = (InstanceInAlice)value;
            arguments[i] = valueInAlice.getInstanceInJava();
        }
        return ReflectionUtilities.newInstance((Constructor)constructor.getConstructorReflectionProxy().getReification(), arguments);
    }

    public void registerAnonymousAdapter(Class<?> anonymousCls, Class<?> adapterCls) {
        this.mapAnonymousClsToAdapterCls.put(anonymousCls, adapterCls);
    }

    protected Object createInstanceFromAnonymousConstructor(AnonymousConstructor constructor, Object[] arguments) {
        AbstractType type = constructor.getDeclaringType();
        if (type instanceof AnonymousInnerTypeDeclaredInAlice) {
            AnonymousInnerTypeDeclaredInAlice anonymousType = (AnonymousInnerTypeDeclaredInAlice)type;
            AbstractType superType = anonymousType.getSuperType();
            if (superType instanceof TypeDeclaredInJava) {
                Class anonymousCls = (Class)((TypeDeclaredInJava)superType).getClassReflectionProxy().getReification();
                Class<?> adapterCls = this.mapAnonymousClsToAdapterCls.get(anonymousCls);
                if (adapterCls != null) {
                    final Object instance = this.getThis();
                    Context context = new Context(){

                        public void invokeEntryPoint(AbstractMethod method, Object ... arguments) {
                            VirtualMachine.this.invokeEntryPoint(method, instance, arguments);
                        }
                    };
                    Class[] parameterTypes = new Class[]{Context.class, AnonymousInnerTypeDeclaredInAlice.class, Object[].class};
                    Object[] args = new Object[]{context, anonymousType, arguments};
                    return ReflectionUtilities.newInstance(adapterCls, parameterTypes, args);
                }
                throw new RuntimeException();
            }
            throw new RuntimeException();
        }
        throw new RuntimeException();
    }

    protected Object createInstance(AbstractConstructor constructor, Object ... arguments) {
        assert (constructor != null);
        if (constructor instanceof ConstructorDeclaredInAlice) {
            return this.createInstanceFromConstructorDeclaredInAlice((ConstructorDeclaredInAlice)constructor, arguments);
        }
        if (constructor instanceof ConstructorDeclaredInJava) {
            return this.createInstanceFromConstructorDeclaredInJava((ConstructorDeclaredInJava)constructor, arguments);
        }
        if (constructor instanceof AnonymousConstructor) {
            return this.createInstanceFromAnonymousConstructor((AnonymousConstructor)constructor, arguments);
        }
        throw new RuntimeException();
    }

    protected Object createArrayInstanceFromTypeDeclaredInAlice(ArrayTypeDeclaredInAlice type, int[] lengths, Object[] arguments) {
        Object rv = Array.newInstance(Object.class, lengths);
        for (int i = 0; i < arguments.length; ++i) {
            Array.set(rv, i, arguments[i]);
        }
        return rv;
    }

    protected Object createArrayInstanceFromTypeDeclaredInJava(TypeDeclaredInJava type, int[] lengths, Object[] arguments) {
        Class cls = (Class)type.getClassReflectionProxy().getReification();
        assert (cls != null);
        Class<?> componentCls = cls.getComponentType();
        assert (componentCls != null);
        Object rv = Array.newInstance(componentCls, lengths);
        for (int i = 0; i < arguments.length; ++i) {
            if (arguments[i] instanceof InstanceInAlice) {
                InstanceInAlice valueInAlice = (InstanceInAlice)arguments[i];
                arguments[i] = valueInAlice.getInstanceInJava();
            }
            Array.set(rv, i, arguments[i]);
        }
        return rv;
    }

    protected Object createArrayInstance(AbstractType type, int[] lengths, Object ... arguments) {
        assert (type != null);
        if (type instanceof ArrayTypeDeclaredInAlice) {
            return this.createArrayInstanceFromTypeDeclaredInAlice((ArrayTypeDeclaredInAlice)type, lengths, arguments);
        }
        if (type instanceof TypeDeclaredInJava) {
            return this.createArrayInstanceFromTypeDeclaredInJava((TypeDeclaredInJava)type, lengths, arguments);
        }
        throw new RuntimeException();
    }

    private Object evaluate(Argument argument) {
        assert (argument != null);
        Expression expression = (Expression)argument.expression.getValue();
        assert (expression != null);
        return this.evaluate(expression);
    }

    protected Object[] evaluateArguments(ArrayList<? extends AbstractParameter> parameters, NodeListProperty<Argument> arguments) {
        int N = parameters.size();
        int M = arguments.size();
        Object[] rv = new Object[N];
        if (N > 0) {
            for (int i = 0; i < N - 1; ++i) {
                rv[i] = this.evaluate((Argument)arguments.get(i));
            }
            AbstractParameter paramLast = parameters.get(N - 1);
            if (paramLast.isVariableLength()) {
                Class arrayCls = (Class)paramLast.getValueType().getFirstTypeEncounteredDeclaredInJava().getClassReflectionProxy().getReification();
                assert (arrayCls != null);
                Class<?> componentCls = arrayCls.getComponentType();
                assert (componentCls != null);
                rv[N - 1] = Array.newInstance(componentCls, M);
                for (int j = 0; j < M - (N - 1); ++j) {
                    Argument argumentJ = (Argument)arguments.get(N - 1 + j);
                    assert (argumentJ != null);
                    Object valueJ = this.evaluate(argumentJ);
                    assert (valueJ != null);
                    Array.set(rv[N - 1], j, valueJ);
                }
            } else {
                rv[N - 1] = this.evaluate((Argument)arguments.get(N - 1));
            }
        }
        return rv;
    }

    protected Integer getArrayLength(Object array) {
        if (array != null) {
            return Array.getLength(array);
        }
        throw new NullPointerException();
    }

    protected Object getFieldDeclaredInAlice(FieldDeclaredInAlice field, Object instance) {
        assert (instance instanceof InstanceInAlice);
        InstanceInAlice instanceInAlice = (InstanceInAlice)instance;
        return instanceInAlice.get(field);
    }

    protected void setFieldDeclaredInAlice(FieldDeclaredInAlice field, Object instance, Object value) {
        assert (instance instanceof InstanceInAlice);
        InstanceInAlice instanceInAlice = (InstanceInAlice)instance;
        instanceInAlice.set(field, value);
    }

    protected Object getFieldDeclaredInJavaWithField(FieldDeclaredInJavaWithField field, Object instance) {
        if (instance instanceof InstanceInAlice) {
            InstanceInAlice instanceInAlice = (InstanceInAlice)instance;
            instance = instanceInAlice.getInstanceInJava();
        }
        return ReflectionUtilities.get((Field)field.getFieldReflectionProxy().getReification(), instance);
    }

    protected void setFieldDeclaredInJavaWithField(FieldDeclaredInJavaWithField field, Object instance, Object value) {
        if (value instanceof InstanceInAlice) {
            InstanceInAlice valueInAlice = (InstanceInAlice)value;
            value = valueInAlice.getInstanceInJava();
        }
        ReflectionUtilities.set((Field)field.getFieldReflectionProxy().getReification(), instance, value);
    }

    protected Object getFieldDeclaredInJavaWithGetterAndSetter(FieldDeclaredInJavaWithGetterAndSetter field, Object instance) {
        if (instance instanceof InstanceInAlice) {
            InstanceInAlice instanceInAlice = (InstanceInAlice)instance;
            instance = instanceInAlice.getInstanceInJava();
        }
        if (instance != null) {
            return ReflectionUtilities.invoke(instance, (Method)field.getGetterReflectionProxy().getReification(), new Object[0]);
        }
        throw new NullPointerException();
    }

    protected void setFieldDeclaredInJavaWithGetterAndSetter(FieldDeclaredInJavaWithGetterAndSetter field, Object instance, Object value) {
        if (instance instanceof InstanceInAlice) {
            InstanceInAlice instanceInAlice = (InstanceInAlice)instance;
            instance = instanceInAlice.getInstanceInJava();
        }
        if (value instanceof InstanceInAlice) {
            InstanceInAlice valueInAlice = (InstanceInAlice)value;
            value = valueInAlice.getInstanceInJava();
        }
        if (instance == null) {
            throw new NullPointerException();
        }
        ReflectionUtilities.invoke(instance, (Method)field.getSetterReflectionProxy().getReification(), value);
    }

    protected Object get(AbstractField field, Object instance) {
        assert (field != null);
        if (field instanceof FieldDeclaredInAlice) {
            return this.getFieldDeclaredInAlice((FieldDeclaredInAlice)field, instance);
        }
        if (field instanceof FieldDeclaredInJavaWithField) {
            return this.getFieldDeclaredInJavaWithField((FieldDeclaredInJavaWithField)field, instance);
        }
        if (field instanceof FieldDeclaredInJavaWithGetterAndSetter) {
            return this.getFieldDeclaredInJavaWithGetterAndSetter((FieldDeclaredInJavaWithGetterAndSetter)field, instance);
        }
        throw new RuntimeException();
    }

    protected void set(AbstractField field, Object instance, Object value) {
        assert (field != null);
        if (field instanceof FieldDeclaredInAlice) {
            this.setFieldDeclaredInAlice((FieldDeclaredInAlice)field, instance, value);
        } else if (field instanceof FieldDeclaredInJavaWithField) {
            this.setFieldDeclaredInJavaWithField((FieldDeclaredInJavaWithField)field, instance, value);
        } else if (field instanceof FieldDeclaredInJavaWithGetterAndSetter) {
            this.setFieldDeclaredInJavaWithGetterAndSetter((FieldDeclaredInJavaWithGetterAndSetter)field, instance, value);
        } else {
            throw new RuntimeException();
        }
    }

    protected Object getItemAtIndex(AbstractType arrayType, Object array, Integer index) {
        assert (arrayType != null);
        assert (arrayType.isArray());
        return Array.get(array, index);
    }

    protected void setItemAtIndex(AbstractType arrayType, Object array, Integer index, Object value) {
        assert (arrayType != null);
        assert (arrayType.isArray());
        Array.set(array, index, value);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Object invokeMethodDeclaredInAlice(MethodDeclaredInAlice method, Object instance, Object ... arguments) {
        assert (instance instanceof InstanceInAlice);
        InstanceInAlice instanceInAlice = (InstanceInAlice)instance;
        HashMap<AbstractParameter, Object> map = new HashMap<AbstractParameter, Object>();
        for (int i = 0; i < arguments.length; ++i) {
            map.put((AbstractParameter)method.parameters.get(i), arguments[i]);
        }
        this.pushFrame(instanceInAlice, map);
        try {
            this.execute((Statement)method.body.getValue());
            if (method.isProcedure()) {
                Object i = null;
                return i;
            }
            try {
                throw new RuntimeException("no return value");
            }
            catch (ReturnException re) {
                Object object = re.getValue();
                return object;
            }
        }
        finally {
            this.popFrame();
        }
    }

    protected Object invokeMethodDeclaredInJava(MethodDeclaredInJava method, Object instance, Object ... arguments) {
        if (instance instanceof InstanceInAlice) {
            InstanceInAlice instanceInAlice = (InstanceInAlice)instance;
            instance = instanceInAlice.getInstanceInJava();
        }
        for (int i = 0; i < arguments.length; ++i) {
            if (!(arguments[i] instanceof InstanceInAlice)) continue;
            InstanceInAlice valueInAlice = (InstanceInAlice)arguments[i];
            arguments[i] = valueInAlice.getInstanceInJava();
        }
        return ReflectionUtilities.invoke(instance, (Method)method.getMethodReflectionProxy().getReification(), arguments);
    }

    protected Object invoke(AbstractMethod method, Object instance, Object ... arguments) {
        assert (method != null);
        if (method instanceof MethodDeclaredInAlice) {
            return this.invokeMethodDeclaredInAlice((MethodDeclaredInAlice)method, instance, arguments);
        }
        if (method instanceof MethodDeclaredInJava) {
            return this.invokeMethodDeclaredInJava((MethodDeclaredInJava)method, instance, arguments);
        }
        throw new RuntimeException();
    }

    protected Object evaluateAssignmentExpression(AssignmentExpression assignmentExpression) {
        Expression leftHandExpression = (Expression)assignmentExpression.leftHandSide.getValue();
        Expression rightHandExpression = (Expression)assignmentExpression.rightHandSide.getValue();
        Object rightHandValue = this.evaluate(rightHandExpression);
        if (assignmentExpression.operator.getValue() == AssignmentExpression.Operator.ASSIGN) {
            if (leftHandExpression instanceof FieldAccess) {
                FieldAccess fieldAccess = (FieldAccess)leftHandExpression;
                this.set((AbstractField)fieldAccess.field.getValue(), this.evaluate((Expression)fieldAccess.expression.getValue()), rightHandValue);
            } else if (leftHandExpression instanceof VariableAccess) {
                VariableAccess variableAccess = (VariableAccess)leftHandExpression;
                this.setLocal((LocalDeclaredInAlice)variableAccess.variable.getValue(), rightHandValue);
            } else if (leftHandExpression instanceof ArrayAccess) {
                ArrayAccess arrayAccess = (ArrayAccess)leftHandExpression;
                this.setItemAtIndex((AbstractType)arrayAccess.arrayType.getValue(), this.evaluate((Expression)arrayAccess.array.getValue()), this.evaluate((Expression)arrayAccess.index.getValue(), Integer.class), rightHandValue);
            } else {
                PrintUtilities.println("todo: evaluateActual", assignmentExpression.leftHandSide.getValue(), rightHandValue);
            }
        } else {
            PrintUtilities.println("todo: evaluateActual", assignmentExpression);
        }
        return null;
    }

    protected Object evaluateBooleanLiteral(BooleanLiteral booleanLiteral) {
        return booleanLiteral.value.getValue();
    }

    protected Object evaluateInstanceCreation(InstanceCreation classInstanceCreation) {
        Object[] arguments = this.evaluateArguments(((AbstractConstructor)classInstanceCreation.constructor.getValue()).getParameters(), classInstanceCreation.arguments);
        return this.createInstance((AbstractConstructor)classInstanceCreation.constructor.getValue(), arguments);
    }

    protected Object evaluateArrayInstanceCreation(ArrayInstanceCreation arrayInstanceCreation) {
        Object[] values = new Object[arrayInstanceCreation.expressions.size()];
        for (int i = 0; i < values.length; ++i) {
            values[i] = this.evaluate((Expression)arrayInstanceCreation.expressions.get(i));
        }
        int[] lengths = new int[arrayInstanceCreation.lengths.size()];
        for (int i = 0; i < lengths.length; ++i) {
            lengths[i] = arrayInstanceCreation.lengths.get(i);
        }
        return this.createArrayInstance((AbstractType)arrayInstanceCreation.arrayType.getValue(), lengths, values);
    }

    protected Object evaluateArrayAccess(ArrayAccess arrayAccess) {
        return this.getItemAtIndex((AbstractType)arrayAccess.arrayType.getValue(), this.evaluate((Expression)arrayAccess.array.getValue()), this.evaluate((Expression)arrayAccess.index.getValue(), Integer.class));
    }

    protected Integer evaluateArrayLength(ArrayLength arrayLength) {
        return this.getArrayLength(this.evaluate((Expression)arrayLength.array.getValue()));
    }

    protected Object evaluateFieldAccess(FieldAccess fieldAccess) {
        return this.get((AbstractField)fieldAccess.field.getValue(), this.evaluate((Expression)fieldAccess.expression.getValue()));
    }

    protected Object evaluateVariableAccess(VariableAccess variableAccess) {
        return this.getLocal((LocalDeclaredInAlice)variableAccess.variable.getValue());
    }

    protected Object evaluateConstantAccess(ConstantAccess constantAccess) {
        return this.getLocal((LocalDeclaredInAlice)constantAccess.constant.getValue());
    }

    protected Object evaluateArithmeticInfixExpression(ArithmeticInfixExpression arithmeticInfixExpression) {
        Number leftOperand = (Number)this.evaluate((Expression)arithmeticInfixExpression.leftOperand.getValue());
        Number rightOperand = (Number)this.evaluate((Expression)arithmeticInfixExpression.rightOperand.getValue());
        return ((ArithmeticInfixExpression.Operator)((Object)arithmeticInfixExpression.operator.getValue())).operate(leftOperand, rightOperand);
    }

    protected Object evaluateBitwiseInfixExpression(BitwiseInfixExpression bitwiseInfixExpression) {
        Object leftOperand = this.evaluate((Expression)bitwiseInfixExpression.leftOperand.getValue());
        Object rightOperand = this.evaluate((Expression)bitwiseInfixExpression.rightOperand.getValue());
        return bitwiseInfixExpression.operator.getValue().operate(leftOperand, rightOperand);
    }

    protected Boolean evaluateConditionalInfixExpression(ConditionalInfixExpression conditionalInfixExpression) {
        ConditionalInfixExpression.Operator operator = (ConditionalInfixExpression.Operator)((Object)conditionalInfixExpression.operator.getValue());
        Boolean leftOperand = (Boolean)this.evaluate((Expression)conditionalInfixExpression.leftOperand.getValue());
        if (operator == ConditionalInfixExpression.Operator.AND) {
            if (leftOperand.booleanValue()) {
                return (Boolean)this.evaluate((Expression)conditionalInfixExpression.rightOperand.getValue());
            }
            return false;
        }
        if (operator == ConditionalInfixExpression.Operator.OR) {
            if (leftOperand.booleanValue()) {
                return true;
            }
            return (Boolean)this.evaluate((Expression)conditionalInfixExpression.rightOperand.getValue());
        }
        return false;
    }

    protected Boolean evaluateRelationalInfixExpression(RelationalInfixExpression relationalInfixExpression) {
        Object leftOperand = this.evaluate((Expression)relationalInfixExpression.leftOperand.getValue());
        Object rightOperand = this.evaluate((Expression)relationalInfixExpression.rightOperand.getValue());
        return ((RelationalInfixExpression.Operator)((Object)relationalInfixExpression.operator.getValue())).operate(leftOperand, rightOperand);
    }

    protected Object evaluateShiftInfixExpression(ShiftInfixExpression shiftInfixExpression) {
        Object leftOperand = this.evaluate((Expression)shiftInfixExpression.leftOperand.getValue());
        Object rightOperand = this.evaluate((Expression)shiftInfixExpression.rightOperand.getValue());
        return shiftInfixExpression.operator.getValue().operate(leftOperand, rightOperand);
    }

    protected Object evaluateLogicalComplement(LogicalComplement logicalComplement) {
        Boolean operand = this.evaluate((Expression)logicalComplement.operand.getValue(), Boolean.class);
        return operand == false;
    }

    protected String evaluateStringConcatenation(StringConcatenation stringConcatenation) {
        StringBuffer sb = new StringBuffer();
        Object leftOperand = this.evaluate((Expression)stringConcatenation.leftOperand.getValue());
        Object rightOperand = this.evaluate((Expression)stringConcatenation.rightOperand.getValue());
        sb.append(leftOperand);
        sb.append(rightOperand);
        return sb.toString();
    }

    protected Object evaluateMethodInvocation(MethodInvocation methodInvocation) {
        if (methodInvocation.isValid()) {
            return this.invoke((AbstractMethod)methodInvocation.method.getValue(), this.evaluate((Expression)methodInvocation.expression.getValue()), this.evaluateArguments(((AbstractMethod)methodInvocation.method.getValue()).getParameters(), methodInvocation.arguments));
        }
        JOptionPane.showMessageDialog(null, "skipping invalid methodInvocation: " + ((AbstractMethod)methodInvocation.method.getValue()).getName());
        return null;
    }

    protected Object evaluateNullLiteral(NullLiteral nullLiteral) {
        return null;
    }

    protected Object evaluateNumberLiteral(NumberLiteral numberLiteral) {
        return numberLiteral.value.getValue();
    }

    protected Object evaluateDoubleLiteral(DoubleLiteral doubleLiteral) {
        return doubleLiteral.value.getValue();
    }

    protected Object evaluateFloatLiteral(FloatLiteral floatLiteral) {
        return floatLiteral.value.getValue();
    }

    protected Object evaluateIntegerLiteral(IntegerLiteral integerLiteral) {
        return integerLiteral.value.getValue();
    }

    protected Object evaluateParameterAccess(ParameterAccess parameterAccess) {
        return this.lookup((AbstractParameter)parameterAccess.parameter.getValue());
    }

    protected Object evaluateStringLiteral(StringLiteral stringLiteral) {
        return stringLiteral.value.getValue();
    }

    protected Object evaluateThisExpression(ThisExpression thisExpression) {
        return this.getThis();
    }

    protected Object evaluateTypeExpression(TypeExpression typeExpression) {
        return typeExpression.value.getValue();
    }

    protected Object evaluateTypeLiteral(TypeLiteral typeLiteral) {
        return typeLiteral.value.getValue();
    }

    protected Object evaluateResourceExpression(ResourceExpression resourceExpression) {
        return resourceExpression.resource.getValue();
    }

    protected Object evaluateEntryPointTypeExpression(EntryPointTypeExpression entryPointTypeExpression) {
        return this.entryPointType;
    }

    protected Object evaluate(Expression expression) {
        if (expression != null) {
            if (expression instanceof AssignmentExpression) {
                return this.evaluateAssignmentExpression((AssignmentExpression)expression);
            }
            if (expression instanceof BooleanLiteral) {
                return this.evaluateBooleanLiteral((BooleanLiteral)expression);
            }
            if (expression instanceof InstanceCreation) {
                return this.evaluateInstanceCreation((InstanceCreation)expression);
            }
            if (expression instanceof ArrayInstanceCreation) {
                return this.evaluateArrayInstanceCreation((ArrayInstanceCreation)expression);
            }
            if (expression instanceof ArrayLength) {
                return this.evaluateArrayLength((ArrayLength)expression);
            }
            if (expression instanceof ArrayAccess) {
                return this.evaluateArrayAccess((ArrayAccess)expression);
            }
            if (expression instanceof FieldAccess) {
                return this.evaluateFieldAccess((FieldAccess)expression);
            }
            if (expression instanceof ConstantAccess) {
                return this.evaluateConstantAccess((ConstantAccess)expression);
            }
            if (expression instanceof VariableAccess) {
                return this.evaluateVariableAccess((VariableAccess)expression);
            }
            if (expression instanceof ArithmeticInfixExpression) {
                return this.evaluateArithmeticInfixExpression((ArithmeticInfixExpression)expression);
            }
            if (expression instanceof BitwiseInfixExpression) {
                return this.evaluateBitwiseInfixExpression((BitwiseInfixExpression)expression);
            }
            if (expression instanceof ConditionalInfixExpression) {
                return this.evaluateConditionalInfixExpression((ConditionalInfixExpression)expression);
            }
            if (expression instanceof RelationalInfixExpression) {
                return this.evaluateRelationalInfixExpression((RelationalInfixExpression)expression);
            }
            if (expression instanceof ShiftInfixExpression) {
                return this.evaluateShiftInfixExpression((ShiftInfixExpression)expression);
            }
            if (expression instanceof LogicalComplement) {
                return this.evaluateLogicalComplement((LogicalComplement)expression);
            }
            if (expression instanceof MethodInvocation) {
                return this.evaluateMethodInvocation((MethodInvocation)expression);
            }
            if (expression instanceof NullLiteral) {
                return this.evaluateNullLiteral((NullLiteral)expression);
            }
            if (expression instanceof StringConcatenation) {
                return this.evaluateStringConcatenation((StringConcatenation)expression);
            }
            if (expression instanceof NumberLiteral) {
                return this.evaluateNumberLiteral((NumberLiteral)expression);
            }
            if (expression instanceof DoubleLiteral) {
                return this.evaluateDoubleLiteral((DoubleLiteral)expression);
            }
            if (expression instanceof FloatLiteral) {
                return this.evaluateFloatLiteral((FloatLiteral)expression);
            }
            if (expression instanceof IntegerLiteral) {
                return this.evaluateIntegerLiteral((IntegerLiteral)expression);
            }
            if (expression instanceof ParameterAccess) {
                return this.evaluateParameterAccess((ParameterAccess)expression);
            }
            if (expression instanceof StringLiteral) {
                return this.evaluateStringLiteral((StringLiteral)expression);
            }
            if (expression instanceof ThisExpression) {
                return this.evaluateThisExpression((ThisExpression)expression);
            }
            if (expression instanceof TypeExpression) {
                return this.evaluateTypeExpression((TypeExpression)expression);
            }
            if (expression instanceof TypeLiteral) {
                return this.evaluateTypeLiteral((TypeLiteral)expression);
            }
            if (expression instanceof ResourceExpression) {
                return this.evaluateResourceExpression((ResourceExpression)expression);
            }
            if (expression instanceof EntryPointTypeExpression) {
                return this.evaluateEntryPointTypeExpression((EntryPointTypeExpression)expression);
            }
            throw new RuntimeException(expression.getClass().getName());
        }
        throw new NullPointerException();
    }

    protected final <E> E evaluate(Expression expression, Class<E> cls) {
        return (E)this.evaluate(expression);
    }

    protected void executeAssertStatement(AssertStatement assertStatement) {
        assert (this.evaluate((Expression)assertStatement.expression.getValue(), Boolean.class).booleanValue()) : this.evaluate((Expression)assertStatement.message.getValue());
    }

    protected void executeBlockStatement(BlockStatement blockStatement) throws ReturnException {
        Statement[] array = new Statement[blockStatement.statements.size()];
        blockStatement.statements.toArray(array);
        for (Statement statement : array) {
            this.execute(statement);
        }
    }

    protected void executeConditionalStatement(ConditionalStatement conditionalStatement) throws ReturnException {
        for (BooleanExpressionBodyPair booleanExpressionBodyPair : conditionalStatement.booleanExpressionBodyPairs) {
            if (!this.evaluate((Expression)booleanExpressionBodyPair.expression.getValue(), Boolean.class).booleanValue()) continue;
            this.execute((Statement)booleanExpressionBodyPair.body.getValue());
            return;
        }
        this.execute((Statement)conditionalStatement.elseBody.getValue());
    }

    protected void executeComment(Comment comment) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void executeCountLoop(CountLoop countLoop) throws ReturnException {
        VariableDeclaredInAlice variable = (VariableDeclaredInAlice)countLoop.variable.getValue();
        ConstantDeclaredInAlice constant = (ConstantDeclaredInAlice)countLoop.constant.getValue();
        this.pushLocal(variable, -1);
        try {
            int n = this.evaluate((Expression)countLoop.count.getValue(), Integer.class);
            this.pushLocal(constant, n);
            try {
                for (int i = 0; i < n; ++i) {
                    this.setLocal(variable, i);
                    this.execute((Statement)countLoop.body.getValue());
                }
            }
            finally {
                this.popLocal(constant);
            }
        }
        finally {
            this.popLocal(variable);
        }
    }

    protected void executeDoInOrder(DoInOrder doInOrder) throws ReturnException {
        this.executeBlockStatement((BlockStatement)doInOrder.body.getValue());
    }

    protected void executeDoInThread(final DoInThread doInThread) throws ReturnException {
        final Thread parentThread = Thread.currentThread();
        new ThreadWithRevealingToString(ThreadGroupUtilities.getThreadGroup(), "DoInThread-" + threadCount++){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run() {
                VirtualMachine.this.pushCurrentThread(parentThread);
                try {
                    ProgramClosedException.invokeAndCatchProgramClosedException(new Runnable(){

                        public void run() {
                            try {
                                VirtualMachine.this.execute((Statement)doInThread.body.getValue());
                            }
                            catch (ReturnException returnException) {
                                // empty catch block
                            }
                        }
                    });
                }
                finally {
                    VirtualMachine.this.popCurrentThread();
                }
            }
        }.start();
    }

    protected void executeDoTogether(edu.cmu.cs.dennisc.alice.ast.DoTogether doTogether) throws ReturnException {
        BlockStatement blockStatement = (BlockStatement)doTogether.body.getValue();
        switch (blockStatement.statements.size()) {
            case 0: {
                break;
            }
            case 1: {
                this.execute((Statement)blockStatement.statements.get(0));
                break;
            }
            default: {
                Runnable[] runnables = new Runnable[blockStatement.statements.size()];
                final Thread parentThread = Thread.currentThread();
                for (int i = 0; i < runnables.length; ++i) {
                    final Statement statementI = (Statement)blockStatement.statements.get(i);
                    runnables[i] = new Runnable(){

                        /*
                         * WARNING - Removed try catching itself - possible behaviour change.
                         */
                        public void run() {
                            VirtualMachine.this.pushCurrentThread(parentThread);
                            try {
                                VirtualMachine.this.execute(statementI);
                            }
                            catch (ReturnException returnException) {
                            }
                            finally {
                                VirtualMachine.this.popCurrentThread();
                            }
                        }
                    };
                }
                DoTogether.invokeAndWait(runnables);
            }
        }
    }

    protected void executeExpressionStatement(ExpressionStatement expressionStatement) {
        Object unused = this.evaluate((Expression)expressionStatement.expression.getValue());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void excecuteForEachLoop(AbstractForEachLoop forEachInLoop, Object[] array) throws ReturnException {
        VariableDeclaredInAlice variable = (VariableDeclaredInAlice)forEachInLoop.variable.getValue();
        BlockStatement blockStatement = (BlockStatement)forEachInLoop.body.getValue();
        this.pushLocal(variable, -1);
        try {
            for (Object o : array) {
                this.setLocal(variable, o);
                this.execute(blockStatement);
            }
        }
        finally {
            this.popLocal(variable);
        }
    }

    protected void executeForEachInArrayLoop(ForEachInArrayLoop forEachInArrayLoop) throws ReturnException {
        Object[] array = this.evaluate((Expression)forEachInArrayLoop.array.getValue(), Object[].class);
        this.excecuteForEachLoop(forEachInArrayLoop, array);
    }

    protected void executeForEachInIterableLoop(ForEachInIterableLoop forEachInIterableLoop) throws ReturnException {
        Iterable iterable = this.evaluate((Expression)forEachInIterableLoop.iterable.getValue(), Iterable.class);
        this.excecuteForEachLoop(forEachInIterableLoop, IterableUtilities.toArray(iterable));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void excecuteForEachTogether(AbstractEachInTogether forEachInTogether, Object[] array) throws ReturnException {
        final VariableDeclaredInAlice variable = (VariableDeclaredInAlice)forEachInTogether.variable.getValue();
        final BlockStatement blockStatement = (BlockStatement)forEachInTogether.body.getValue();
        switch (array.length) {
            case 0: {
                break;
            }
            case 1: {
                this.pushLocal(variable, array[0]);
                try {
                    this.execute(blockStatement);
                    break;
                }
                finally {
                    this.popLocal(variable);
                }
            }
            default: {
                final Thread parentThread = Thread.currentThread();
                ForEachTogether.invokeAndWait(array, new ForEachRunnable<Object>(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     * Enabled aggressive block sorting
                     * Enabled unnecessary exception pruning
                     * Enabled aggressive exception aggregation
                     */
                    @Override
                    public void run(Object value) {
                        VirtualMachine.this.pushCurrentThread(parentThread);
                        try {
                            VirtualMachine.this.pushLocal(variable, value);
                            try {
                                VirtualMachine.this.execute(blockStatement);
                                VirtualMachine.this.popLocal(variable);
                                return;
                            }
                            catch (ReturnException returnException) {
                                return;
                            }
                            finally {
                                VirtualMachine.this.popLocal(variable);
                            }
                        }
                        finally {
                            VirtualMachine.this.popCurrentThread();
                        }
                    }
                });
            }
        }
    }

    protected void executeEachInArrayTogether(EachInArrayTogether eachInArrayTogether) throws ReturnException {
        Object[] array = this.evaluate((Expression)eachInArrayTogether.array.getValue(), Object[].class);
        this.excecuteForEachTogether(eachInArrayTogether, array);
    }

    protected void executeEachInIterableTogether(EachInIterableTogether eachInIterableTogether) throws ReturnException {
        Iterable iterable = this.evaluate((Expression)eachInIterableTogether.iterable.getValue(), Iterable.class);
        this.excecuteForEachTogether(eachInIterableTogether, IterableUtilities.toArray(iterable));
    }

    protected void executeReturnStatement(ReturnStatement returnStatement) throws ReturnException {
        Object returnValue = this.evaluate((Expression)returnStatement.expression.getValue());
        throw new ReturnException(returnValue);
    }

    protected void executeWhileLoop(WhileLoop whileLoop) throws ReturnException {
        while (this.evaluate((Expression)whileLoop.conditional.getValue(), Boolean.class).booleanValue()) {
            this.execute((Statement)whileLoop.body.getValue());
        }
    }

    protected void executeVariableDeclarationStatement(VariableDeclarationStatement variableDeclarationStatement) {
        this.pushLocal((LocalDeclaredInAlice)variableDeclarationStatement.variable.getValue(), this.evaluate((Expression)variableDeclarationStatement.initializer.getValue()));
    }

    protected void executeConstantDeclarationStatement(ConstantDeclarationStatement constantDeclarationStatement) {
        this.pushLocal((LocalDeclaredInAlice)constantDeclarationStatement.constant.getValue(), this.evaluate((Expression)constantDeclarationStatement.initializer.getValue()));
    }

    protected void execute(Statement statement) throws ReturnException {
        assert (statement != null);
        if (((Boolean)statement.isEnabled.getValue()).booleanValue()) {
            if (statement instanceof AssertStatement) {
                this.executeAssertStatement((AssertStatement)statement);
            } else if (statement instanceof BlockStatement) {
                this.executeBlockStatement((BlockStatement)statement);
            } else if (statement instanceof ConditionalStatement) {
                this.executeConditionalStatement((ConditionalStatement)statement);
            } else if (statement instanceof Comment) {
                this.executeComment((Comment)statement);
            } else if (statement instanceof CountLoop) {
                this.executeCountLoop((CountLoop)statement);
            } else if (statement instanceof edu.cmu.cs.dennisc.alice.ast.DoTogether) {
                this.executeDoTogether((edu.cmu.cs.dennisc.alice.ast.DoTogether)statement);
            } else if (statement instanceof DoInOrder) {
                this.executeDoInOrder((DoInOrder)statement);
            } else if (statement instanceof DoInThread) {
                this.executeDoInThread((DoInThread)statement);
            } else if (statement instanceof ExpressionStatement) {
                this.executeExpressionStatement((ExpressionStatement)statement);
            } else if (statement instanceof ForEachInArrayLoop) {
                this.executeForEachInArrayLoop((ForEachInArrayLoop)statement);
            } else if (statement instanceof ForEachInIterableLoop) {
                this.executeForEachInIterableLoop((ForEachInIterableLoop)statement);
            } else if (statement instanceof EachInArrayTogether) {
                this.executeEachInArrayTogether((EachInArrayTogether)statement);
            } else if (statement instanceof EachInIterableTogether) {
                this.executeEachInIterableTogether((EachInIterableTogether)statement);
            } else if (statement instanceof ReturnStatement) {
                this.executeReturnStatement((ReturnStatement)statement);
            } else if (statement instanceof WhileLoop) {
                this.executeWhileLoop((WhileLoop)statement);
            } else if (statement instanceof ConstantDeclarationStatement) {
                this.executeConstantDeclarationStatement((ConstantDeclarationStatement)statement);
            } else if (statement instanceof VariableDeclarationStatement) {
                this.executeVariableDeclarationStatement((VariableDeclarationStatement)statement);
            } else {
                throw new RuntimeException();
            }
        }
    }
}

