/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.cs.dennisc.animation;

import edu.cmu.cs.dennisc.animation.Program;
import edu.cmu.cs.dennisc.awt.DimensionUtilties;
import edu.cmu.cs.dennisc.swing.SwingUtilities;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSlider;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class ControlPanel
extends JPanel {
    private static final String PAUSE_TEXT = "pause";
    private static final String RESUME_TEXT = "resume";
    private JButton pauseResume = new JButton("pause");
    private JLabel feedback = new JLabel("speed: 1x");
    private JSlider speed = new JSlider(){

        public Dimension getMaximumSize() {
            Dimension rv = super.getMaximumSize();
            DimensionUtilties.constrainToMaximumWidth(rv, 400);
            return rv;
        }
    };
    private JButton restart = new JButton("restart");

    public ControlPanel(final Program program) {
        this.speed.setMinimum(1);
        this.speed.setValue(1);
        this.speed.setMaximum(10);
        this.restart.setEnabled(program.isRestartSupported());
        this.pauseResume.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                boolean isPaused = ControlPanel.this.isPaused();
                if (isPaused) {
                    ControlPanel.this.pauseResume.setText(ControlPanel.PAUSE_TEXT);
                    program.handleSpeedChange(ControlPanel.this.speed.getValue());
                } else {
                    ControlPanel.this.pauseResume.setText(ControlPanel.RESUME_TEXT);
                    program.handleSpeedChange(0.0);
                }
                ControlPanel.this.speed.setEnabled(isPaused);
                ControlPanel.this.feedback.setEnabled(isPaused);
                ControlPanel.this.updateFeedback();
            }
        });
        this.restart.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                program.restart(e);
            }
        });
        this.speed.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent e) {
                ControlPanel.this.updateFeedback();
                program.handleSpeedChange(ControlPanel.this.speed.getValue());
            }
        });
        this.speed.addMouseListener(new MouseListener(){

            public void mousePressed(MouseEvent e) {
            }

            public void mouseReleased(MouseEvent e) {
                if (!SwingUtilities.isQuoteControlUnquoteDown(e)) {
                    ControlPanel.this.speed.setValue(1);
                }
            }

            public void mouseClicked(MouseEvent e) {
            }

            public void mouseEntered(MouseEvent e) {
            }

            public void mouseExited(MouseEvent e) {
            }
        });
        Box box = Box.createHorizontalBox();
        box.add(this.speed);
        this.setLayout(new GridBagLayout());
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.fill = 1;
        this.add((Component)this.pauseResume, gbc);
        this.add((Component)this.feedback, gbc);
        gbc.weightx = 1.0;
        this.add((Component)box, gbc);
        gbc.weightx = 0.0;
        this.add((Component)this.restart, gbc);
    }

    private boolean isPaused() {
        return this.pauseResume.getText().equals(RESUME_TEXT);
    }

    private void updateFeedback() {
        if (this.isPaused()) {
            this.feedback.setText("speed: 0x");
        } else {
            this.feedback.setText("speed: " + this.speed.getValue() + "x");
        }
    }
}

