/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.cs.dennisc.animation;

import edu.cmu.cs.dennisc.animation.AbstractAnimator;

public class FrameBasedAnimator
extends AbstractAnimator {
    private double m_framesPerSecond;
    private double m_tDelta;
    private double m_tPrevious = Double.NaN;

    public FrameBasedAnimator() {
        this(30.0);
    }

    public FrameBasedAnimator(double framesPerSecond) {
        this.setFramesPerSecond(framesPerSecond);
    }

    public double getFramesPerSecond() {
        return this.m_framesPerSecond;
    }

    public void setFramesPerSecond(double framesPerSecond) {
        this.m_framesPerSecond = framesPerSecond;
        this.m_tDelta = 1.0 / this.m_framesPerSecond;
    }

    protected void updateCurrentTime(boolean isPaused) {
        double tCurrent = Double.isNaN(this.m_tPrevious) ? 0.0 : (isPaused ? this.m_tPrevious : this.m_tPrevious + this.m_tDelta * this.getSpeedFactor());
        this.m_tPrevious = tCurrent;
        this.setCurrentTime(tCurrent);
    }
}

