/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.cs.dennisc.animation;

import edu.cmu.cs.dennisc.alice.ProgramClosedException;
import edu.cmu.cs.dennisc.animation.Animation;
import edu.cmu.cs.dennisc.animation.AnimationObserver;
import edu.cmu.cs.dennisc.animation.Animator;
import edu.cmu.cs.dennisc.animation.ClockBasedAnimator;
import edu.cmu.cs.dennisc.animation.ControlPanel;
import edu.cmu.cs.dennisc.animation.FrameBasedAnimator;
import edu.cmu.cs.dennisc.lookingglass.DefaultProgram;
import edu.cmu.cs.dennisc.lookingglass.OnscreenLookingGlass;
import edu.cmu.cs.dennisc.lookingglass.event.AutomaticDisplayEvent;
import edu.cmu.cs.dennisc.lookingglass.event.AutomaticDisplayListener;
import edu.cmu.cs.dennisc.movie.MovieEncoder;
import edu.cmu.cs.dennisc.movie.seriesofimages.SeriesOfImagesMovieEncoder;
import java.awt.Component;
import java.awt.Container;
import java.awt.event.WindowEvent;
import java.awt.image.BufferedImage;
import java.util.EventObject;

public abstract class Program
extends DefaultProgram {
    private Animator animator;
    private MovieEncoder movieEncoder = null;
    private Object monitor = new Object();
    private BufferedImage reusableImage = null;

    protected void handleSpeedChange(double speed) {
        if (this.animator != null) {
            this.animator.setSpeedFactor(speed);
        }
    }

    public Animator getAnimator() {
        return this.animator;
    }

    protected void setAnimator(Animator animator) {
        this.animator = animator;
    }

    protected Animator createAnimator() {
        if (this.movieEncoder != null) {
            return new FrameBasedAnimator();
        }
        return new ClockBasedAnimator();
    }

    protected abstract boolean isRestartSupported();

    protected void restart(EventObject e) {
        this.animator.complete(null);
    }

    public MovieEncoder getMovieEncoder() {
        return this.movieEncoder;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setMovieEncoder(MovieEncoder movieEncoder) {
        Object object = this.monitor;
        synchronized (object) {
            if (this.movieEncoder != null) {
                this.movieEncoder.stop();
            }
            this.movieEncoder = movieEncoder;
            if (this.movieEncoder != null) {
                this.movieEncoder.start();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void updateAnimator() {
        if (this.animator != null) {
            Object object = this.monitor;
            synchronized (object) {
                OnscreenLookingGlass lg;
                if (this.movieEncoder != null && (lg = this.getOnscreenLookingGlass()).getWidth() > 0 && lg.getHeight() > 0) {
                    if (this.reusableImage == null || this.reusableImage.getWidth() != lg.getWidth() || this.reusableImage.getHeight() != lg.getHeight()) {
                        this.reusableImage = lg.createBufferedImageForUseAsColorBuffer();
                    }
                    if (this.reusableImage != null) {
                        lg.getColorBuffer(this.reusableImage);
                        this.movieEncoder.addBufferedImage(this.reusableImage);
                    }
                }
            }
            this.animator.update();
        }
    }

    protected Component createSpeedMultiplierControlPanel() {
        return new ControlPanel(this);
    }

    protected void initializeAWT(Container container, OnscreenLookingGlass onscreenLookingGlass) {
        super.initializeAWT(container, onscreenLookingGlass);
        Component speedMultiplierControlPanel = this.createSpeedMultiplierControlPanel();
        if (speedMultiplierControlPanel != null) {
            this.add(speedMultiplierControlPanel, "North");
        }
    }

    protected void preInitialize() {
        super.preInitialize();
        this.getLookingGlassFactory().addAutomaticDisplayListener(new AutomaticDisplayListener(){

            public void automaticDisplayCompleted(AutomaticDisplayEvent e) {
                Program.this.updateAnimator();
            }
        });
    }

    protected void preRun() {
        super.preRun();
        String movieEncoderDirectoryPath = System.getProperty(Program.class.getName() + ".movieEncoderDirectoryPath");
        if (movieEncoderDirectoryPath != null) {
            this.setMovieEncoder(new SeriesOfImagesMovieEncoder(movieEncoderDirectoryPath, "capture", "000", "bmp"));
        }
        if (this.animator == null) {
            this.setAnimator(this.createAnimator());
        }
    }

    protected void postRun() {
        super.postRun();
        this.setMovieEncoder(null);
    }

    protected void handleWindowClosed(WindowEvent e) {
        super.handleWindowClosed(e);
        this.animator.complete(null);
    }

    public void perform(Animation animation, AnimationObserver animationObserver) {
        if (this.isClosed()) {
            throw new ProgramClosedException();
        }
        if (this.animator != null) {
            this.animator.invokeAndWait_ThrowRuntimeExceptionsIfNecessary(animation, animationObserver);
        } else {
            animation.complete(animationObserver);
        }
    }
}

