/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.cs.dennisc.animation;

import edu.cmu.cs.dennisc.animation.Style;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public enum TraditionalStyle implements Style
{
    BEGIN_AND_END_ABRUPTLY(false, false),
    BEGIN_GENTLY_AND_END_ABRUPTLY(true, false),
    BEGIN_ABRUPTLY_AND_END_GENTLY(false, true),
    BEGIN_AND_END_GENTLY(true, true);

    private boolean m_isSlowInDesired;
    private boolean m_isSlowOutDesired;

    private TraditionalStyle(boolean isSlowInDesired, boolean isSlowOutDesired) {
        this.m_isSlowInDesired = isSlowInDesired;
        this.m_isSlowOutDesired = isSlowOutDesired;
    }

    private static double gently(double x, double A, double B) {
        double y;
        if (x < A) {
            y = (B - 1.0) / (A * (B * B - A * B + A - 1.0)) * x * x;
        } else if (x > B) {
            double a3 = 1.0 / (B * B - A * B + A - 1.0);
            double b3 = -2.0 * a3;
            double c3 = 1.0 + a3;
            y = a3 * x * x + b3 * x + c3;
        } else {
            double m = 2.0 * (B - 1.0) / (B * B - A * B + A - 1.0);
            double b2 = -m * A / 2.0;
            y = m * x + b2;
        }
        return y;
    }

    @Override
    public double calculatePortion(double timeElapsed, double timeTotal) {
        if (timeTotal != 0.0) {
            double portion = timeElapsed / timeTotal;
            if (this.m_isSlowInDesired) {
                if (this.m_isSlowOutDesired) {
                    return TraditionalStyle.gently(portion, 0.3, 0.8);
                }
                return TraditionalStyle.gently(portion, 0.99, 0.999);
            }
            if (this.m_isSlowOutDesired) {
                return TraditionalStyle.gently(portion, 0.001, 0.01);
            }
            return portion;
        }
        return 1.0;
    }
}

