/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.cs.dennisc.animation.affine;

import edu.cmu.cs.dennisc.animation.affine.AffineAnimation;
import edu.cmu.cs.dennisc.math.Angle;
import edu.cmu.cs.dennisc.math.AngleInRadians;
import edu.cmu.cs.dennisc.scenegraph.AbstractTransformable;
import edu.cmu.cs.dennisc.scenegraph.ReferenceFrame;

public abstract class AbstractApplyRotationAnimation
extends AffineAnimation {
    private double m_angleInRadians;
    private double m_sumInRadians;

    public AbstractApplyRotationAnimation() {
        this.m_angleInRadians = Double.NaN;
        this.m_sumInRadians = Double.NaN;
    }

    public AbstractApplyRotationAnimation(AbstractTransformable sgSubject, ReferenceFrame sgAsSeenBy, Angle angle) {
        super(sgSubject, sgAsSeenBy);
        this.setAngle(angle);
        this.m_sumInRadians = Double.NaN;
    }

    public Angle getAngle() {
        return new AngleInRadians(this.m_angleInRadians);
    }

    public void setAngle(Angle angle) {
        this.m_angleInRadians = angle.getAsRadians();
    }

    protected abstract void applyRotationInRadians(double var1);

    public void prologue() {
        this.m_sumInRadians = 0.0;
    }

    public void setPortion(double portion) {
        double interpInRadians = this.m_angleInRadians * portion;
        double deltaInRadians = interpInRadians - this.m_sumInRadians;
        this.applyRotationInRadians(deltaInRadians);
        this.m_sumInRadians = interpInRadians;
    }

    public void epilogue() {
        this.m_sumInRadians = Double.NaN;
    }
}

