/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.cs.dennisc.animation.affine;

import edu.cmu.cs.dennisc.animation.affine.AffineAnimation;
import edu.cmu.cs.dennisc.math.InterpolationUtilities;
import edu.cmu.cs.dennisc.math.Point3;
import edu.cmu.cs.dennisc.scenegraph.AbstractTransformable;
import edu.cmu.cs.dennisc.scenegraph.ReferenceFrame;

public class ApplyTranslationAnimation
extends AffineAnimation {
    private Point3 m_translation = new Point3();
    private Point3 m_sum = new Point3();
    private Point3 m_interp = new Point3();
    private Point3 m_delta = new Point3();

    public ApplyTranslationAnimation() {
        this.m_translation.setNaN();
        this.m_sum.setNaN();
    }

    public ApplyTranslationAnimation(AbstractTransformable sgSubject, ReferenceFrame sgAsSeenBy, Point3 translation) {
        super(sgSubject, sgAsSeenBy);
        this.setTranslation(translation);
        this.m_sum.setNaN();
    }

    public Point3 accessTranslation() {
        return this.m_translation;
    }

    public Point3 getTranslation(Point3 rv) {
        rv.set(this.m_translation);
        return rv;
    }

    public Point3 getTranslation() {
        return this.getTranslation(new Point3());
    }

    public void setTranslation(Point3 translation) {
        this.m_translation.set(translation);
    }

    public void prologue() {
        this.m_sum.set(0.0, 0.0, 0.0);
    }

    public void setPortion(double portion) {
        InterpolationUtilities.interpolate(this.m_interp, this.m_translation, portion);
        this.m_delta.setToSubtraction(this.m_interp, this.m_sum);
        this.getSubject().applyTranslation(this.m_delta, this.getAsSeenBy());
        this.m_sum.set(this.m_interp);
    }

    public void epilogue() {
        this.m_sum.setNaN();
    }
}

