/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.cs.dennisc.animation.affine;

import edu.cmu.cs.dennisc.animation.affine.AffineAnimation;
import edu.cmu.cs.dennisc.math.AffineMatrix4x4;
import edu.cmu.cs.dennisc.math.Point3;
import edu.cmu.cs.dennisc.math.UnitQuaternion;
import edu.cmu.cs.dennisc.scenegraph.AbstractTransformable;
import edu.cmu.cs.dennisc.scenegraph.ReferenceFrame;

public class PointOfViewAnimation
extends AffineAnimation {
    public static final AffineMatrix4x4 USE_EXISTING_VALUE_AT_RUN_TIME = null;
    private AffineMatrix4x4 m_povBegin = AffineMatrix4x4.createNaN();
    private AffineMatrix4x4 m_povEnd = AffineMatrix4x4.createNaN();
    private AffineMatrix4x4 m_pov0Runtime = AffineMatrix4x4.createNaN();
    private AffineMatrix4x4 m_povRuntime = AffineMatrix4x4.createNaN();
    private UnitQuaternion m_q0 = UnitQuaternion.createNaN();
    private UnitQuaternion m_q1 = UnitQuaternion.createNaN();
    private UnitQuaternion m_q = UnitQuaternion.createNaN();
    private Point3 m_t0 = new Point3();
    private Point3 m_t1 = new Point3();
    private Point3 m_t = new Point3();

    public PointOfViewAnimation() {
        this(null, null, null, null);
    }

    public PointOfViewAnimation(AbstractTransformable sgSubject, ReferenceFrame sgAsSeenBy, AffineMatrix4x4 povBegin, AffineMatrix4x4 povEnd) {
        super(sgSubject, sgAsSeenBy);
        this.setPointOfViewBegin(povBegin);
        this.setPointOfViewEnd(povEnd);
        this.m_pov0Runtime.setNaN();
        this.m_povRuntime.setNaN();
        this.m_q0.setNaN();
        this.m_q1.setNaN();
        this.m_q.setNaN();
        this.m_t0.setNaN();
        this.m_t1.setNaN();
        this.m_t.setNaN();
    }

    public AffineMatrix4x4 accessPointOfViewBeginUsedAtRuntime() {
        return this.m_pov0Runtime;
    }

    public AffineMatrix4x4 getPointOfViewBeginUsedAtRuntime(AffineMatrix4x4 rv) {
        rv.set(this.m_pov0Runtime);
        return rv;
    }

    public AffineMatrix4x4 getPointOfViewBeginUsedAtRuntime() {
        return this.getPointOfViewBeginUsedAtRuntime(AffineMatrix4x4.createNaN());
    }

    public AffineMatrix4x4 accessPointOfViewBegin() {
        return this.m_povBegin;
    }

    public AffineMatrix4x4 getPointOfViewBegin(AffineMatrix4x4 rv) {
        rv.set(this.m_povBegin);
        return rv;
    }

    public AffineMatrix4x4 getPointOfViewBegin() {
        return this.getPointOfViewBegin(AffineMatrix4x4.createNaN());
    }

    public void setPointOfViewBegin(AffineMatrix4x4 povBegin) {
        if (povBegin != USE_EXISTING_VALUE_AT_RUN_TIME) {
            this.m_povBegin.set(povBegin);
        } else {
            this.m_povBegin.setNaN();
        }
    }

    public AffineMatrix4x4 accessPointOfViewEnd() {
        return this.m_povEnd;
    }

    public AffineMatrix4x4 getPointOfViewEnd(AffineMatrix4x4 rv) {
        rv.set(this.m_povEnd);
        return rv;
    }

    public AffineMatrix4x4 getPointOfViewEnd() {
        return this.getPointOfViewEnd(AffineMatrix4x4.createNaN());
    }

    public void setPointOfViewEnd(AffineMatrix4x4 povEnd) {
        if (povEnd != null) {
            this.m_povEnd.set(povEnd);
        } else {
            this.m_povEnd.setNaN();
        }
    }

    protected void prologue() {
        if (this.m_povBegin.isNaN()) {
            this.getSubject().getTransformation(this.m_pov0Runtime, this.getAsSeenBy());
        } else {
            this.m_pov0Runtime.set(this.m_povBegin);
        }
        this.m_q0.setValue(this.m_pov0Runtime.orientation);
        this.m_q1.setValue(this.m_povEnd.orientation);
        this.m_t0.set(this.m_pov0Runtime.translation);
        this.m_t1.set(this.m_povEnd.translation);
        this.m_povRuntime.set(this.m_pov0Runtime);
        this.m_q.setValue(this.m_q0);
        this.m_t.set(this.m_t0);
    }

    protected void setPortion(double portion) {
        this.m_q.setToInterpolation(this.m_q0, this.m_q1, portion);
        this.m_t.setToInterpolation(this.m_t0, this.m_t1, portion);
        this.m_povRuntime.set(this.m_q, this.m_t);
        this.getSubject().setTransformation(this.m_povRuntime, this.getAsSeenBy());
    }

    protected void epilogue() {
        this.getSubject().setTransformation(this.m_povEnd, this.getAsSeenBy());
        this.m_pov0Runtime.setNaN();
        this.m_povRuntime.setNaN();
    }
}

