/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.cs.dennisc.animation.affine;

import edu.cmu.cs.dennisc.animation.affine.AffineAnimation;
import edu.cmu.cs.dennisc.math.InterpolationUtilities;
import edu.cmu.cs.dennisc.math.Point3;
import edu.cmu.cs.dennisc.scenegraph.AbstractTransformable;
import edu.cmu.cs.dennisc.scenegraph.ReferenceFrame;

public class PositionAnimation
extends AffineAnimation {
    public static final Point3 USE_EXISTING_VALUE_AT_RUN_TIME = null;
    private Point3 m_posBegin = new Point3();
    private Point3 m_posEnd = new Point3();
    private Point3 m_posBeginUsedAtRuntime = new Point3();

    public PositionAnimation() {
        this.m_posBeginUsedAtRuntime.setNaN();
        this.m_posBegin.setNaN();
        this.m_posEnd.setNaN();
    }

    public PositionAnimation(AbstractTransformable sgSubject, ReferenceFrame sgAsSeenBy, Point3 posBegin, Point3 posEnd) {
        super(sgSubject, sgAsSeenBy);
        this.m_posBeginUsedAtRuntime.setNaN();
        this.setPositionBegin(posBegin);
        this.setPositionEnd(posEnd);
    }

    public Point3 accessPositionBeginUsedAtRuntime() {
        return this.m_posBeginUsedAtRuntime;
    }

    public Point3 getPositionBeginUsedAtRuntime(Point3 rv) {
        rv.set(this.m_posBeginUsedAtRuntime);
        return rv;
    }

    public Point3 getPositionBeginUsedAtRuntime() {
        return this.getPositionBeginUsedAtRuntime(new Point3());
    }

    public Point3 accessPositionBegin() {
        return this.m_posBegin;
    }

    public Point3 getPositionBegin(Point3 rv) {
        rv.set(this.m_posBegin);
        return rv;
    }

    public Point3 getPositionBegin() {
        return this.getPositionBegin(new Point3());
    }

    public void setPositionBegin(Point3 posBegin) {
        if (posBegin != USE_EXISTING_VALUE_AT_RUN_TIME) {
            this.m_posBegin.set(posBegin);
        } else {
            this.m_posBegin.setNaN();
        }
    }

    public Point3 accessPositionEnd() {
        return this.m_posEnd;
    }

    public Point3 getPositionEnd(Point3 rv) {
        rv.set(this.m_posEnd);
        return rv;
    }

    public Point3 getPositionEnd() {
        return this.getPositionEnd(new Point3());
    }

    public void setPositionEnd(Point3 posEnd) {
        this.m_posEnd.set(posEnd);
    }

    public void prologue() {
        if (this.m_posBegin.isNaN()) {
            this.m_posBeginUsedAtRuntime.set(this.getSubject().getTranslation(this.getAsSeenBy()));
        } else {
            this.m_posBeginUsedAtRuntime.set(this.m_posBegin);
        }
    }

    public void setPortion(double portion) {
        this.getSubject().setTranslationOnly(InterpolationUtilities.interpolate(this.m_posBeginUsedAtRuntime, this.m_posEnd, portion), this.getAsSeenBy());
    }

    public void epilogue() {
        this.getSubject().setTranslationOnly(this.m_posEnd, this.getAsSeenBy());
        this.m_posBeginUsedAtRuntime.setNaN();
    }
}

