/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.cs.dennisc.animation.rigidbody;

import edu.cmu.cs.dennisc.animation.Animation;
import edu.cmu.cs.dennisc.animation.AnimationObserver;
import edu.cmu.cs.dennisc.math.AffineMatrix4x4;
import edu.cmu.cs.dennisc.math.Point3;
import edu.cmu.cs.dennisc.math.UnitQuaternion;
import edu.cmu.cs.dennisc.math.Vector3;
import edu.cmu.cs.dennisc.math.rigidbody.TranslationAndOrientationFunction;
import edu.cmu.cs.dennisc.math.rungekutta.RungeKuttaUtilities;
import edu.cmu.cs.dennisc.scenegraph.Transformable;

public class RigidBodyAnimation
implements Animation {
    private Function m_function = new Function();
    private Transformable m_sgTransformable;
    private Point3 m_translation1 = Point3.createNaN();
    private UnitQuaternion m_orientation1 = UnitQuaternion.createNaN();
    private double m_tPrev;

    public RigidBodyAnimation(Transformable sgTransformable, AffineMatrix4x4 m1) {
        this.m_sgTransformable = sgTransformable;
        this.m_translation1.set(m1.translation);
        this.m_orientation1.setValue(m1.orientation);
        this.reset();
    }

    public void reset() {
        this.m_tPrev = Double.NaN;
    }

    public double update(double tCurrent, AnimationObserver animationObserver) {
        if (Double.isNaN(this.m_tPrev)) {
            this.m_function.initialize(this.m_sgTransformable.getLocalTransformation());
        } else {
            double tDelta = this.m_tPrev - tCurrent;
            RungeKuttaUtilities.rk4(this.m_function, this.m_tPrev, tDelta);
            this.m_sgTransformable.setLocalTransformation(this.m_function.getTransformation());
        }
        this.m_tPrev = tCurrent;
        return this.m_function.getEstimatedTimeRemaining();
    }

    public void complete(AnimationObserver animationObserver) {
        this.m_sgTransformable.setLocalTransformation(new AffineMatrix4x4(this.m_orientation1, this.m_translation1));
    }

    class Function
    extends TranslationAndOrientationFunction {
        private static final double TARGET_VELOCITY_MAGINITUDE = 2.0;
        private static final double FORCE_FOR_ACCELERATION = 4.0;
        private static final double FORCE_FOR_DECELERATION = -6.0;
        private static final double THRESHOLD_AT_WHICH_TO_BEGIN_DECELERATING = 1.0;
        private double m_tRemainingEstimate = Double.POSITIVE_INFINITY;

        Function() {
        }

        protected Vector3 getForce(Vector3 rv, double t) {
            Point3 translation = this.accessTranslation();
            Vector3 velocity = this.accessVelocity();
            double dx = ((RigidBodyAnimation)RigidBodyAnimation.this).m_translation1.x - translation.x;
            double dy = ((RigidBodyAnimation)RigidBodyAnimation.this).m_translation1.y - translation.y;
            double dz = ((RigidBodyAnimation)RigidBodyAnimation.this).m_translation1.z - translation.z;
            double velocityMagnitude = velocity.calculateMagnitude();
            double distanceSquared = dx * dx + dy * dy + dz * dz;
            double distance = Math.sqrt(distanceSquared);
            this.m_tRemainingEstimate = velocityMagnitude / distance;
            if (this.m_tRemainingEstimate < 1.0) {
                rv.x = -6.0 * dx / distance;
                rv.y = -6.0 * dy / distance;
                rv.z = -6.0 * dz / distance;
            } else if (velocityMagnitude < 2.0) {
                rv.x = 4.0 * dx / distance;
                rv.y = 4.0 * dy / distance;
                rv.z = 4.0 * dz / distance;
            } else {
                rv.set(0.0, 0.0, 0.0);
            }
            return rv;
        }

        protected Vector3 getTorque(Vector3 rv, double t) {
            return rv;
        }

        public void initialize(AffineMatrix4x4 m) {
            this.setTransformation(m);
            this.setMomentum(0.0, 0.0, 0.0);
            this.setVelocity(0.0, 0.0, 0.0);
            this.setAngularMomentum(0.0, 0.0, 0.0);
            this.setSpin(0.0, 0.0, 0.0, 0.0);
            this.setAngularVelocity(0.0, 0.0, 0.0);
        }

        public double getEstimatedTimeRemaining() {
            return 1.0;
        }
    }
}

