/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.cs.dennisc.awt;

import edu.cmu.cs.dennisc.awt.BevelState;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Paint;
import java.awt.Shape;
import java.awt.Stroke;
import java.awt.geom.GeneralPath;

public class BeveledShape {
    private static final Paint HIGHLIGHT_PAINT = Color.LIGHT_GRAY;
    private static final Paint NEUTRAL_PAINT = Color.GRAY;
    private static final Paint SHADOW_PAINT = Color.BLACK;
    private static final int CAP = 1;
    private static final int JOIN = 1;
    protected Shape m_base;
    protected GeneralPath m_highlightForRaised;
    protected GeneralPath m_neutralForRaised;
    protected GeneralPath m_shadowForRaised;
    protected GeneralPath m_highlightForSunken;
    protected GeneralPath m_neutralForSunken;
    protected GeneralPath m_shadowForSunken;

    public BeveledShape() {
    }

    public BeveledShape(Shape base, GeneralPath highlightForRaised, GeneralPath neutralForRaised, GeneralPath shadowForRaised, GeneralPath highlightForSunken, GeneralPath neutralForSunken, GeneralPath shadowForSunken) {
        this.initialize(base, highlightForRaised, neutralForRaised, shadowForRaised, highlightForSunken, neutralForSunken, shadowForSunken);
    }

    public BeveledShape(Shape base, GeneralPath highlightForRaised, GeneralPath neutralForRaised, GeneralPath shadowForRaised) {
        this.initialize(base, highlightForRaised, neutralForRaised, shadowForRaised);
    }

    public Shape getBaseShape() {
        return this.m_base;
    }

    protected GeneralPath getPathForRaisedHighlight() {
        return this.m_highlightForRaised;
    }

    protected GeneralPath getPathForRaisedNeutral() {
        return this.m_neutralForRaised;
    }

    protected GeneralPath getPathForRaisedShadow() {
        return this.m_shadowForRaised;
    }

    protected GeneralPath getPathForSunkenHighlight() {
        return this.m_highlightForSunken;
    }

    protected GeneralPath getPathForSunkenNeutral() {
        return this.m_neutralForSunken;
    }

    protected GeneralPath getPathForSunkenShadow() {
        return this.m_shadowForSunken;
    }

    protected void initialize(Shape base, GeneralPath highlightForRaised, GeneralPath neutralForRaised, GeneralPath shadowForRaised, GeneralPath highlightForSunken, GeneralPath neutralForSunken, GeneralPath shadowForSunken) {
        this.m_base = base;
        this.m_highlightForRaised = highlightForRaised;
        this.m_neutralForRaised = neutralForRaised;
        this.m_shadowForRaised = shadowForRaised;
        this.m_highlightForSunken = highlightForSunken;
        this.m_neutralForSunken = neutralForSunken;
        this.m_shadowForSunken = shadowForSunken;
    }

    protected void initialize(Shape base, GeneralPath highlightForRaised, GeneralPath neutralForRaised, GeneralPath shadowForRaised) {
        this.initialize(base, highlightForRaised, neutralForRaised, shadowForRaised, shadowForRaised, neutralForRaised, highlightForRaised);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void draw(Graphics2D g2, BevelState bevelState, float raisedStrokeWidth, float flushStrokeWidth, float sunkenStrokeWidth) {
        Stroke prevStroke = g2.getStroke();
        Paint prevPaint = g2.getPaint();
        try {
            if (bevelState == BevelState.FLUSH) {
                g2.setStroke(new BasicStroke(flushStrokeWidth, 1, 1));
                g2.setPaint(NEUTRAL_PAINT);
                g2.draw(this.m_base);
            } else {
                GeneralPath shadow;
                GeneralPath neutral;
                GeneralPath highlight;
                BasicStroke currStroke;
                if (bevelState == BevelState.RAISED) {
                    currStroke = new BasicStroke(raisedStrokeWidth, 1, 1);
                    highlight = this.m_highlightForRaised;
                    neutral = this.m_neutralForRaised;
                    shadow = this.m_shadowForRaised;
                } else if (bevelState == BevelState.SUNKEN) {
                    currStroke = new BasicStroke(sunkenStrokeWidth, 1, 1);
                    highlight = this.m_highlightForSunken;
                    neutral = this.m_neutralForSunken;
                    shadow = this.m_shadowForSunken;
                } else {
                    throw new RuntimeException();
                }
                g2.setStroke(currStroke);
                if (shadow != null) {
                    g2.setPaint(SHADOW_PAINT);
                    g2.draw(shadow);
                }
                if (neutral != null) {
                    g2.setPaint(NEUTRAL_PAINT);
                    g2.draw(neutral);
                }
                if (highlight != null) {
                    g2.setPaint(HIGHLIGHT_PAINT);
                    g2.draw(highlight);
                }
            }
        }
        finally {
            g2.setPaint(prevPaint);
            g2.setStroke(prevStroke);
        }
    }

    public void fill(Graphics2D g2) {
        g2.fill(this.m_base);
    }

    public void paint(Graphics2D g2, BevelState bevelState, float raisedStrokeWidth, float flushStrokeWidth, float sunkenStrokeWidth) {
        this.fill(g2);
        this.draw(g2, bevelState, raisedStrokeWidth, flushStrokeWidth, sunkenStrokeWidth);
    }
}

