/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.cs.dennisc.awt;

import java.awt.Color;

public class ColorUtilities {
    public static final Color GARISH_COLOR = Color.MAGENTA;
    private static float[] s_aBuffer = new float[4];
    private static float[] s_bBuffer = new float[4];
    private static float[] s_rvBuffer = new float[4];
    private static float[] s_hsbBuffer = new float[3];

    public static Color createGray(int grayscale) {
        return new Color(grayscale, grayscale, grayscale);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Color interpolate(Color a, Color b, float portion) {
        float[] fArray = s_rvBuffer;
        synchronized (s_rvBuffer) {
            a.getComponents(s_aBuffer);
            b.getComponents(s_bBuffer);
            for (int i = 0; i < 4; ++i) {
                ColorUtilities.s_rvBuffer[i] = s_aBuffer[i] * (1.0f - portion) + s_bBuffer[i] * portion;
            }
            // ** MonitorExit[var3_3] (shouldn't be in output)
            return new Color(s_rvBuffer[0], s_rvBuffer[1], s_rvBuffer[2], s_rvBuffer[3]);
        }
    }

    private static Color constructColor(int rgb, int alpha) {
        Color c = new Color(rgb);
        return new Color(c.getRed(), c.getGreen(), c.getBlue(), alpha);
    }

    private static Color constructColor(float[] hsb, int alpha) {
        return ColorUtilities.constructColor(Color.HSBtoRGB(ColorUtilities.bound(hsb[0]), ColorUtilities.bound(hsb[1]), ColorUtilities.bound(hsb[2])), alpha);
    }

    private static float bound(float f) {
        return Math.max(Math.min(f, 1.0f), 0.0f);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Color shiftHSB(Color color, double hueDelta, double saturationDelta, double brightnessDelta) {
        float[] fArray = s_hsbBuffer;
        synchronized (s_hsbBuffer) {
            Color.RGBtoHSB(color.getRed(), color.getGreen(), color.getBlue(), s_hsbBuffer);
            s_hsbBuffer[0] = (float)((double)s_hsbBuffer[0] + hueDelta);
            s_hsbBuffer[1] = (float)((double)s_hsbBuffer[1] + saturationDelta);
            s_hsbBuffer[2] = (float)((double)s_hsbBuffer[2] + brightnessDelta);
            // ** MonitorExit[var7_4] (shouldn't be in output)
            return ColorUtilities.constructColor(s_hsbBuffer, color.getAlpha());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static synchronized Color scaleHSB(Color color, double hueScale, double saturationScale, double brightnessScale) {
        float[] fArray = s_hsbBuffer;
        synchronized (s_hsbBuffer) {
            Color.RGBtoHSB(color.getRed(), color.getGreen(), color.getBlue(), s_hsbBuffer);
            s_hsbBuffer[0] = (float)((double)s_hsbBuffer[0] * hueScale);
            s_hsbBuffer[1] = (float)((double)s_hsbBuffer[1] * saturationScale);
            s_hsbBuffer[2] = (float)((double)s_hsbBuffer[2] * brightnessScale);
            // ** MonitorExit[var7_4] (shouldn't be in output)
            return ColorUtilities.constructColor(s_hsbBuffer, color.getAlpha());
        }
    }

    public static synchronized Color setAlpha(Color color, int alpha) {
        return new Color(color.getRed(), color.getGreen(), color.getBlue(), alpha);
    }
}

