/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.cs.dennisc.awt;

import edu.cmu.cs.dennisc.pattern.Criterion;
import edu.cmu.cs.dennisc.pattern.HowMuch;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.util.LinkedList;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.JComponent;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ComponentUtilities {
    public static final HowMuch DEFAULT_HOW_MUCH = HowMuch.COMPONENT_AND_DESCENDANTS;

    public static void makeStandOut(Component component) {
        if (component instanceof JComponent) {
            JComponent jComponent = (JComponent)component;
            jComponent.setBorder(BorderFactory.createLineBorder(Color.RED, 4));
            jComponent.setOpaque(true);
        }
        component.setBackground(Color.GREEN);
    }

    private static <E extends Component> E getFirstToAccept(boolean isComponentACandidate, boolean isChildACandidate, boolean isGrandchildAndBeyondACandidate, Component component, Class<E> cls, Criterion<?> ... criterions) {
        boolean isAcceptedByAll;
        assert (component != null);
        Component rv = null;
        if (isComponentACandidate) {
            if (cls == null || cls.isAssignableFrom(component.getClass())) {
                isAcceptedByAll = true;
                if (criterions != null) {
                    for (Criterion<?> criterion : criterions) {
                        if (criterion.accept(component)) continue;
                        isAcceptedByAll = false;
                        break;
                    }
                }
            } else {
                isAcceptedByAll = false;
            }
        } else {
            isAcceptedByAll = false;
        }
        if (isAcceptedByAll) {
            rv = component;
        } else if (isChildACandidate && component instanceof Container) {
            Object componentI;
            Object[] arr$ = ((Container)component).getComponents();
            int len$ = arr$.length;
            for (int i$ = 0; i$ < len$ && (rv = ComponentUtilities.getFirstToAccept(isChildACandidate, isGrandchildAndBeyondACandidate, isGrandchildAndBeyondACandidate, (Component)(componentI = arr$[i$]), cls, criterions)) == null; ++i$) {
            }
        }
        return (E)rv;
    }

    private static <E extends Component> void updateAllToAccept(boolean isComponentACandidate, boolean isChildACandidate, boolean isGrandchildAndBeyondACandidate, List<E> list, Component component, Class<E> cls, Criterion<?> ... criterions) {
        assert (component != null);
        if (isComponentACandidate && (cls == null || cls.isAssignableFrom(component.getClass()))) {
            boolean isAcceptedByAll = true;
            if (criterions != null) {
                for (Criterion<?> criterion : criterions) {
                    if (criterion.accept(component)) continue;
                    isAcceptedByAll = false;
                    break;
                }
            }
            if (isAcceptedByAll) {
                list.add(component);
            }
        }
        if (isChildACandidate && component instanceof Container) {
            for (Component componentI : ((Container)component).getComponents()) {
                ComponentUtilities.updateAllToAccept(isChildACandidate, isGrandchildAndBeyondACandidate, isGrandchildAndBeyondACandidate, list, componentI, cls, criterions);
            }
        }
    }

    private static <E extends Component> E getFirstToAccept(HowMuch candidateMask, Component component, Class<E> cls, Criterion<?> ... criterions) {
        return ComponentUtilities.getFirstToAccept(candidateMask.isComponentACandidate(), candidateMask.isChildACandidate(), candidateMask.isGrandchildAndBeyondACandidate(), component, cls, criterions);
    }

    private static <E extends Component> void updateAllToAccept(HowMuch candidateMask, List<E> list, Component component, Class<E> cls, Criterion<?> ... criterions) {
        ComponentUtilities.updateAllToAccept(candidateMask.isComponentACandidate(), candidateMask.isChildACandidate(), candidateMask.isGrandchildAndBeyondACandidate(), list, component, cls, criterions);
    }

    public static <E extends Component> E findFirstMatch(Component component, HowMuch howMuch, Class<E> cls, Criterion<?> ... criterions) {
        return ComponentUtilities.getFirstToAccept(howMuch, component, cls, criterions);
    }

    public static <E extends Component> E findFirstMatch(Component component, Class<E> cls, Criterion<?> ... criterions) {
        return ComponentUtilities.findFirstMatch(component, DEFAULT_HOW_MUCH, cls, criterions);
    }

    public static <E extends Component> E findFirstMatch(Component component, Class<E> cls) {
        return ComponentUtilities.findFirstMatch(component, cls, (Criterion[])null);
    }

    public static Component findFirstMatch(Component component, Criterion<?> ... criterions) {
        return ComponentUtilities.findFirstMatch(component, null, criterions);
    }

    public static <E extends Component> List<E> findAllMatches(Component component, HowMuch howMuch, Class<E> cls, Criterion<?> ... criterions) {
        LinkedList list = new LinkedList();
        ComponentUtilities.updateAllToAccept(howMuch, list, component, cls, criterions);
        return list;
    }

    public static <E extends Component> List<E> findAllMatches(Component component, Class<E> cls, Criterion<?> ... criterions) {
        return ComponentUtilities.findAllMatches(component, DEFAULT_HOW_MUCH, cls, criterions);
    }

    public static <E extends Component> List<E> findAllMatches(Component component, Class<E> cls) {
        return ComponentUtilities.findAllMatches(component, cls, (Criterion[])null);
    }

    public static List<Component> findAllMatches(Component component, Criterion<?> ... criterions) {
        return ComponentUtilities.findAllMatches(component, null, criterions);
    }

    public static List<Component> findAllMatches(Component component) {
        return ComponentUtilities.findAllMatches(component, null, (Criterion[])null);
    }

    public static <E extends Component> E findFirstAncestor(Component component, boolean isComponentIncludedInSearch, Class<E> cls, Criterion<?> ... criterions) {
        for (Component c = isComponentIncludedInSearch ? component : component.getParent(); c != null; c = c.getParent()) {
            boolean isAcceptedByAll;
            if (cls == null || cls.isAssignableFrom(c.getClass())) {
                isAcceptedByAll = true;
                if (criterions != null) {
                    for (Criterion<?> criterion : criterions) {
                        if (criterion.accept(component)) continue;
                        isAcceptedByAll = false;
                        break;
                    }
                }
            } else {
                isAcceptedByAll = false;
            }
            if (!isAcceptedByAll) continue;
            return (E)c;
        }
        return null;
    }

    public static <E extends Component> E findFirstAncestor(Component component, boolean isComponentIncludedInSearch, Class<E> cls) {
        return ComponentUtilities.findFirstAncestor(component, isComponentIncludedInSearch, cls, (Criterion[])null);
    }

    public static Component findFirstAncestor(Component component, boolean isComponentIncludedInSearch, Criterion<?> ... criterions) {
        return ComponentUtilities.findFirstAncestor(component, isComponentIncludedInSearch, null, criterions);
    }
}

