/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.cs.dennisc.awt;

import edu.cmu.cs.dennisc.zoot.font.ZTextAttribute;
import java.awt.Component;
import java.awt.Font;
import java.awt.font.TextAttribute;
import java.util.HashMap;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FontUtilities {
    private FontUtilities() {
        throw new AssertionError();
    }

    public static void setFontToDerivedFont(Component component, Map<? extends TextAttribute, Object> map) {
        Font font = component.getFont();
        component.setFont(font.deriveFont(map));
    }

    public static void setFontToDerivedFont(Component component, TextAttribute attribute, Object value) {
        HashMap<TextAttribute, Object> map = new HashMap<TextAttribute, Object>();
        map.put(attribute, value);
        FontUtilities.setFontToDerivedFont(component, map);
    }

    public static void setFontToDerivedFont(Component component, TextAttribute attributeA, Object valueA, TextAttribute attributeB, Object valueB) {
        HashMap<TextAttribute, Object> map = new HashMap<TextAttribute, Object>();
        map.put(attributeA, valueA);
        map.put(attributeB, valueB);
        FontUtilities.setFontToDerivedFont(component, map);
    }

    public static void setFontToDerivedFont(Component component, TextAttribute attributeA, Object valueA, TextAttribute attributeB, Object valueB, TextAttribute attributeC, Object valueC) {
        HashMap<TextAttribute, Object> map = new HashMap<TextAttribute, Object>();
        map.put(attributeA, valueA);
        map.put(attributeB, valueB);
        map.put(attributeC, valueC);
        FontUtilities.setFontToDerivedFont(component, map);
    }

    public static void setFontToDerivedFont(Component component, ZTextAttribute<?> ... textAttributes) {
        Font font = component.getFont();
        HashMap map = new HashMap();
        for (ZTextAttribute<?> textAttribute : textAttributes) {
            map.put(textAttribute.getKey(), textAttribute.getValue());
        }
        component.setFont(font.deriveFont(map));
    }

    public static void setFontToScaledFont(Component component, float scaleFactor) {
        Font font = component.getFont();
        component.setFont(font.deriveFont(font.getSize2D() * scaleFactor));
    }
}

