/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.cs.dennisc.awt;

import edu.cmu.cs.dennisc.swing.SwingUtilities;
import java.awt.AWTEvent;
import java.awt.Component;
import java.awt.EventQueue;
import java.awt.Toolkit;
import java.awt.event.MouseEvent;

public class MouseFocusEventQueue
extends EventQueue {
    private Component componentWithMouseFocus = null;
    private static MouseFocusEventQueue singleton;

    public static MouseFocusEventQueue getSingleton() {
        if (singleton == null) {
            singleton = new MouseFocusEventQueue();
            Toolkit.getDefaultToolkit().getSystemEventQueue().push(singleton);
        }
        return singleton;
    }

    public Component getComponentWithMouseFocus() {
        return this.componentWithMouseFocus;
    }

    public void setComponentWithMouseFocus(Component componentWithMouseFocus) {
        this.componentWithMouseFocus = componentWithMouseFocus;
    }

    protected void dispatchEvent(AWTEvent e) {
        MouseEvent me;
        Component curr;
        if (this.componentWithMouseFocus != null && e instanceof MouseEvent && (curr = (me = (MouseEvent)e).getComponent()) != this.componentWithMouseFocus) {
            e = SwingUtilities.convertMouseEvent(curr, me, this.componentWithMouseFocus);
        }
        super.dispatchEvent(e);
    }
}

