/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.cs.dennisc.awt;

import edu.cmu.cs.dennisc.awt.TextAlignment;
import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.font.FontRenderContext;
import java.awt.font.LineBreakMeasurer;
import java.awt.font.TextAttribute;
import java.awt.font.TextLayout;
import java.awt.geom.Dimension2D;
import java.awt.geom.Rectangle2D;
import java.text.AttributedCharacterIterator;
import java.text.AttributedString;
import java.util.LinkedList;
import java.util.List;

public class MultilineText {
    private String text;
    private String[] paragraphs;
    private FontMetrics fm;
    private float wrapWidth;
    private List<Line> lines;
    private Dimension2D aggregateSize;

    public MultilineText(String text) {
        assert (text != null);
        this.text = text;
        this.paragraphs = this.text.split("\r\n|\r|\n");
    }

    public String getText() {
        return this.text;
    }

    private void updateBoundsIfNecessary(Graphics g, float wrapWidth) {
        assert (!Float.isNaN(wrapWidth));
        Graphics2D g2 = (Graphics2D)g;
        FontRenderContext frc = g2.getFontRenderContext();
        FontMetrics fm = g.getFontMetrics();
        if (this.lines == null || this.aggregateSize == null || this.fm != fm || this.wrapWidth != wrapWidth) {
            this.lines = new LinkedList<Line>();
            for (String paragraph : this.paragraphs) {
                AttributedString as = new AttributedString(paragraph);
                as.addAttribute(TextAttribute.FONT, g.getFont());
                AttributedCharacterIterator aci = as.getIterator();
                LineBreakMeasurer lineBreakMeasurer = new LineBreakMeasurer(aci, frc);
                while (lineBreakMeasurer.getPosition() < paragraph.length()) {
                    int start = lineBreakMeasurer.getPosition();
                    TextLayout textLayout = lineBreakMeasurer.nextLayout(wrapWidth);
                    int end = lineBreakMeasurer.getPosition();
                    this.lines.add(new Line(paragraph, textLayout, start, end));
                }
            }
            assert (this.lines.size() > 0);
            this.aggregateSize = new Dimension(0, 0);
            for (Line line : this.lines) {
                Rectangle2D rect = line.textLayout.getBounds();
                double width = Math.max(this.aggregateSize.getWidth(), rect.getWidth());
                double height = this.aggregateSize.getHeight() + (double)line.textLayout.getAscent() + (double)line.textLayout.getDescent() + (double)line.textLayout.getLeading();
                this.aggregateSize.setSize(width, height);
            }
            this.fm = fm;
            this.wrapWidth = wrapWidth;
        }
    }

    public Dimension2D getDimension(Graphics g, float wrapWidth) {
        this.updateBoundsIfNecessary(g, wrapWidth);
        return this.aggregateSize;
    }

    public void paint(Graphics g, float wrapWidth, TextAlignment alignment, double xBound, double yBound, double widthBound, double heightBound) {
        this.updateBoundsIfNecessary(g, wrapWidth);
        Dimension2D size = this.getDimension(g, wrapWidth);
        Graphics2D g2 = (Graphics2D)g;
        float x = (float)xBound;
        float y = (float)(yBound + (heightBound - size.getHeight()) * 0.5);
        for (Line line : this.lines) {
            Rectangle2D rect = line.textLayout.getBounds();
            float xPixel = x;
            float yPixel = y += line.textLayout.getAscent();
            if (alignment == TextAlignment.CENTER) {
                xPixel = (float)((double)xPixel + (widthBound * 0.5 - (double)((float)rect.getWidth() * 0.5f)));
            } else if (alignment == TextAlignment.TRAILING) {
                xPixel = (float)((double)xPixel + (widthBound - (double)((float)rect.getWidth())));
            }
            line.draw(g2, xPixel, yPixel);
            y += line.textLayout.getDescent() + line.textLayout.getLeading();
        }
        assert (alignment != null);
    }

    public void paint(Graphics g, float wrapWidth, TextAlignment alignment, Rectangle2D bounds) {
        double height;
        double width;
        double y;
        double x;
        if (bounds != null) {
            x = bounds.getX();
            y = bounds.getY();
            width = bounds.getWidth();
            height = bounds.getHeight();
        } else {
            x = 0.0;
            y = 0.0;
            Dimension2D size = this.getDimension(g, wrapWidth);
            width = size.getWidth();
            height = size.getHeight();
        }
        this.paint(g, wrapWidth, alignment, x, y, width, height);
    }

    private class Line {
        private String paragraph;
        private TextLayout textLayout;
        private int startIndex;
        private int endIndex;

        public Line(String paragraph, TextLayout textLayout, int startIndex, int endIndex) {
            this.paragraph = paragraph;
            this.textLayout = textLayout;
            this.startIndex = startIndex;
            this.endIndex = endIndex;
        }

        public void draw(Graphics2D g2, float x, float y) {
            g2.drawString(this.paragraph.substring(this.startIndex, this.endIndex), x, y);
        }
    }
}

