/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.cs.dennisc.awt;

import edu.cmu.cs.dennisc.swing.SwingUtilities;
import java.awt.AWTEvent;
import java.awt.Component;
import java.awt.EventQueue;
import java.awt.event.MouseEvent;

public class RedirectingEventQueue
extends EventQueue {
    private Component src;
    private Component dst;
    private Component last;

    public RedirectingEventQueue(Component src, Component dst) {
        this.src = src;
        this.dst = dst;
        this.last = null;
    }

    private static Component getDeepestMouseListener(Component dst, Component descendant) {
        Component rv;
        for (rv = descendant; rv != null && rv.getMouseListeners().length <= 0 && rv.getMouseMotionListeners().length <= 0; rv = rv.getParent()) {
            if (rv != dst) continue;
            rv = null;
            break;
        }
        return rv;
    }

    protected void dispatchEvent(AWTEvent e) {
        if (e instanceof MouseEvent) {
            MouseEvent me = (MouseEvent)e;
            Component curr = me.getComponent();
            int id = me.getID();
            if (curr == this.src) {
                if (id == 504 || id == 505) {
                    e = SwingUtilities.convertMouseEvent(this.src, me, this.dst);
                } else if (id == 503) {
                    me = SwingUtilities.convertMouseEvent(this.src, me, this.dst);
                    Component descendant = javax.swing.SwingUtilities.getDeepestComponentAt(this.dst, me.getX(), me.getY());
                    if (this.last != (descendant = RedirectingEventQueue.getDeepestMouseListener(this.dst, descendant))) {
                        Component exitComponent = this.last != null ? this.last : this.src;
                        MouseEvent exitEvent = new MouseEvent(exitComponent, 505, me.getWhen(), me.getModifiers(), me.getX(), me.getY(), me.getClickCount(), me.isPopupTrigger(), me.getButton());
                        exitEvent = SwingUtilities.convertMouseEvent(this.src, exitEvent, exitComponent);
                        super.dispatchEvent(exitEvent);
                    }
                    if (descendant != null) {
                        e = SwingUtilities.convertMouseEvent(this.dst, me, descendant);
                    }
                    if (this.last != descendant) {
                        Component enterComponent = descendant != null ? descendant : this.src;
                        MouseEvent enterEvent = new MouseEvent(enterComponent, 504, me.getWhen(), me.getModifiers(), me.getX(), me.getY(), me.getClickCount(), me.isPopupTrigger(), me.getButton());
                        enterEvent = SwingUtilities.convertMouseEvent(this.src, enterEvent, enterComponent);
                        super.dispatchEvent(enterEvent);
                        this.last = descendant;
                    }
                } else if ((id == 501 || id == 500 || id == 502 || id == 506) && this.last != null) {
                    e = SwingUtilities.convertMouseEvent(this.src, me, this.last);
                }
            }
        }
        super.dispatchEvent(e);
    }
}

