/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.cs.dennisc.awt;

import edu.cmu.cs.dennisc.print.PrintUtilities;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Window;
import javax.swing.SwingUtilities;

public class WindowUtilties {
    public static void setLocationOnScreenToCenteredWithin(Window window, Component root) {
        Rectangle boundsRoot;
        Dimension sizeDialog = window.getSize();
        if (root != null && root.isShowing()) {
            Point locationRoot = root.getLocationOnScreen();
            Dimension sizeRoot = root.getSize();
            boundsRoot = new Rectangle(locationRoot, sizeRoot);
        } else {
            boundsRoot = window.getGraphicsConfiguration().getBounds();
        }
        int x = boundsRoot.x + (boundsRoot.width - sizeDialog.width) / 2;
        int y = boundsRoot.y + (boundsRoot.height - sizeDialog.height) / 2;
        window.setLocation(x, y);
    }

    public static void ensureTopLeftCornerIsOnScreen(final Window window) {
        assert (window != null);
        if (window.isVisible()) {
            Point ptScreen = window.getLocationOnScreen();
            PrintUtilities.println(ptScreen);
            if (ptScreen.x < 0 || ptScreen.y < 0) {
                Point ptParent = window.getLocation();
                ptParent.x -= Math.min(ptScreen.x, 0);
                ptParent.y -= Math.min(ptScreen.y, 0);
                window.setLocation(ptParent);
            }
        } else {
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    WindowUtilties.ensureTopLeftCornerIsOnScreen(window);
                }
            });
        }
    }
}

